/*
THIS IS A GENERATED/BUNDLED FILE BY ROLLUP
if you want to view the source visit the plugins github repository
*/

'use strict';

var obsidian = require('obsidian');
var view = require('@codemirror/view');
var state = require('@codemirror/state');
var language = require('@codemirror/language');

/******************************************************************************
Copyright (c) Microsoft Corporation.

Permission to use, copy, modify, and/or distribute this software for any
purpose with or without fee is hereby granted.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH
REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,
INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
PERFORMANCE OF THIS SOFTWARE.
***************************************************************************** */

function __awaiter(thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
}

typeof SuppressedError === "function" ? SuppressedError : function (error, suppressed, message) {
    var e = new Error(message);
    return e.name = "SuppressedError", e.error = error, e.suppressed = suppressed, e;
};

// This library file does not include any other dependency and is a standalone file that
// only include utility functions for manipulating or extracting svg information.
/**
 * Extracts an SVG string from a given input string and returns a cleaned up and
 * formatted SVG string.
 * @param svgString SVG string to extract from.
 * @returns Cleaned up and formatted SVG string.
 */
const extract = (svgString) => {
    var _a, _b;
    // Removes unnecessary spaces and newlines.
    svgString = svgString.replace(/(\r\n|\n|\r)/gm, '');
    svgString = svgString.replace(/>\s+</gm, '><');
    // Create a parser for better parsing of HTML.
    const parser = new DOMParser();
    const svg = parser
        .parseFromString(svgString, 'text/html')
        .querySelector('svg');
    // Removes `width` and `height` from the `style` attribute.
    if (svg.hasAttribute('style')) {
        svg.style.width = '';
        svg.style.height = '';
    }
    // Add `viewbox`, if it is not already a attribute.
    if (svg.viewBox.baseVal.width === 0 && svg.viewBox.baseVal.height === 0) {
        const width = (_a = svg.width.baseVal.value) !== null && _a !== void 0 ? _a : 16;
        const height = (_b = svg.height.baseVal.value) !== null && _b !== void 0 ? _b : 16;
        svg.viewBox.baseVal.width = width;
        svg.viewBox.baseVal.height = height;
    }
    if (!svg.hasAttribute('fill')) {
        svg.setAttribute('fill', 'currentColor');
    }
    const possibleTitle = svg.querySelector('title');
    if (possibleTitle) {
        possibleTitle.remove();
    }
    svg.setAttribute('width', '16px');
    svg.setAttribute('height', '16px');
    return svg.outerHTML;
};
/**
 * Sets the font size of an SVG string by modifying its width and/or height attributes.
 * The font size will be always set in pixels.
 * @param svgString SVG string to modify.
 * @param fontSize Font size in pixels to set.
 * @returns Modified SVG string.
 */
const setFontSize = (svgString, fontSize) => {
    const widthRe = new RegExp(/width="[\d.]+(px)?"/);
    const heightRe = new RegExp(/height="[\d.]+(px)?"/);
    if (svgString.match(widthRe)) {
        svgString = svgString.replace(widthRe, `width="${fontSize}px"`);
    }
    if (svgString.match(heightRe)) {
        svgString = svgString.replace(heightRe, `height="${fontSize}px"`);
    }
    return svgString;
};
/**
 * Replaces the fill or stroke color of an SVG string with a given color.
 * @param svgString SVG string to modify.
 * @param color Color to set. Defaults to 'currentColor'.
 * @returns The modified SVG string.
 */
const colorize = (svgString, color) => {
    if (!color) {
        color = 'currentColor';
    }
    const parser = new DOMParser();
    // Tries to parse the string into a HTML node.
    const parsedNode = parser.parseFromString(svgString, 'text/html');
    const svg = parsedNode.querySelector('svg');
    if (svg) {
        if (svg.hasAttribute('fill') && svg.getAttribute('fill') !== 'none') {
            svg.setAttribute('fill', color);
        }
        else if (svg.hasAttribute('stroke') &&
            svg.getAttribute('stroke') !== 'none') {
            svg.setAttribute('stroke', color);
        }
        return svg.outerHTML;
    }
    return svgString;
};
var svg = {
    extract,
    colorize,
    setFontSize,
};

var commonjsGlobal = typeof globalThis !== 'undefined' ? globalThis : typeof window !== 'undefined' ? window : typeof global !== 'undefined' ? global : typeof self !== 'undefined' ? self : {};

function commonjsRequire(path) {
	throw new Error('Could not dynamically require "' + path + '". Please configure the dynamicRequireTargets or/and ignoreDynamicRequires option of @rollup/plugin-commonjs appropriately for this require call to work.');
}

var jszip_min = {exports: {}};

/*!

JSZip v3.10.1 - A JavaScript class for generating and reading zip files
<http://stuartk.com/jszip>

(c) 2009-2016 Stuart Knightley <stuart [at] stuartk.com>
Dual licenced under the MIT license or GPLv3. See https://raw.github.com/Stuk/jszip/main/LICENSE.markdown.

JSZip uses the library pako released under the MIT license :
https://github.com/nodeca/pako/blob/main/LICENSE
*/
jszip_min.exports;

(function (module, exports) {
	!function(e){module.exports=e();}(function(){return function s(a,o,h){function u(r,e){if(!o[r]){if(!a[r]){var t="function"==typeof commonjsRequire&&commonjsRequire;if(!e&&t)return t(r,!0);if(l)return l(r,!0);var n=new Error("Cannot find module '"+r+"'");throw n.code="MODULE_NOT_FOUND",n}var i=o[r]={exports:{}};a[r][0].call(i.exports,function(e){var t=a[r][1][e];return u(t||e)},i,i.exports,s,a,o,h);}return o[r].exports}for(var l="function"==typeof commonjsRequire&&commonjsRequire,e=0;e<h.length;e++)u(h[e]);return u}({1:[function(e,t,r){var d=e("./utils"),c=e("./support"),p="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";r.encode=function(e){for(var t,r,n,i,s,a,o,h=[],u=0,l=e.length,f=l,c="string"!==d.getTypeOf(e);u<e.length;)f=l-u,n=c?(t=e[u++],r=u<l?e[u++]:0,u<l?e[u++]:0):(t=e.charCodeAt(u++),r=u<l?e.charCodeAt(u++):0,u<l?e.charCodeAt(u++):0),i=t>>2,s=(3&t)<<4|r>>4,a=1<f?(15&r)<<2|n>>6:64,o=2<f?63&n:64,h.push(p.charAt(i)+p.charAt(s)+p.charAt(a)+p.charAt(o));return h.join("")},r.decode=function(e){var t,r,n,i,s,a,o=0,h=0,u="data:";if(e.substr(0,u.length)===u)throw new Error("Invalid base64 input, it looks like a data url.");var l,f=3*(e=e.replace(/[^A-Za-z0-9+/=]/g,"")).length/4;if(e.charAt(e.length-1)===p.charAt(64)&&f--,e.charAt(e.length-2)===p.charAt(64)&&f--,f%1!=0)throw new Error("Invalid base64 input, bad content length.");for(l=c.uint8array?new Uint8Array(0|f):new Array(0|f);o<e.length;)t=p.indexOf(e.charAt(o++))<<2|(i=p.indexOf(e.charAt(o++)))>>4,r=(15&i)<<4|(s=p.indexOf(e.charAt(o++)))>>2,n=(3&s)<<6|(a=p.indexOf(e.charAt(o++))),l[h++]=t,64!==s&&(l[h++]=r),64!==a&&(l[h++]=n);return l};},{"./support":30,"./utils":32}],2:[function(e,t,r){var n=e("./external"),i=e("./stream/DataWorker"),s=e("./stream/Crc32Probe"),a=e("./stream/DataLengthProbe");function o(e,t,r,n,i){this.compressedSize=e,this.uncompressedSize=t,this.crc32=r,this.compression=n,this.compressedContent=i;}o.prototype={getContentWorker:function(){var e=new i(n.Promise.resolve(this.compressedContent)).pipe(this.compression.uncompressWorker()).pipe(new a("data_length")),t=this;return e.on("end",function(){if(this.streamInfo.data_length!==t.uncompressedSize)throw new Error("Bug : uncompressed data size mismatch")}),e},getCompressedWorker:function(){return new i(n.Promise.resolve(this.compressedContent)).withStreamInfo("compressedSize",this.compressedSize).withStreamInfo("uncompressedSize",this.uncompressedSize).withStreamInfo("crc32",this.crc32).withStreamInfo("compression",this.compression)}},o.createWorkerFrom=function(e,t,r){return e.pipe(new s).pipe(new a("uncompressedSize")).pipe(t.compressWorker(r)).pipe(new a("compressedSize")).withStreamInfo("compression",t)},t.exports=o;},{"./external":6,"./stream/Crc32Probe":25,"./stream/DataLengthProbe":26,"./stream/DataWorker":27}],3:[function(e,t,r){var n=e("./stream/GenericWorker");r.STORE={magic:"\0\0",compressWorker:function(){return new n("STORE compression")},uncompressWorker:function(){return new n("STORE decompression")}},r.DEFLATE=e("./flate");},{"./flate":7,"./stream/GenericWorker":28}],4:[function(e,t,r){var n=e("./utils");var o=function(){for(var e,t=[],r=0;r<256;r++){e=r;for(var n=0;n<8;n++)e=1&e?3988292384^e>>>1:e>>>1;t[r]=e;}return t}();t.exports=function(e,t){return void 0!==e&&e.length?"string"!==n.getTypeOf(e)?function(e,t,r,n){var i=o,s=n+r;e^=-1;for(var a=n;a<s;a++)e=e>>>8^i[255&(e^t[a])];return -1^e}(0|t,e,e.length,0):function(e,t,r,n){var i=o,s=n+r;e^=-1;for(var a=n;a<s;a++)e=e>>>8^i[255&(e^t.charCodeAt(a))];return -1^e}(0|t,e,e.length,0):0};},{"./utils":32}],5:[function(e,t,r){r.base64=!1,r.binary=!1,r.dir=!1,r.createFolders=!0,r.date=null,r.compression=null,r.compressionOptions=null,r.comment=null,r.unixPermissions=null,r.dosPermissions=null;},{}],6:[function(e,t,r){var n=null;n="undefined"!=typeof Promise?Promise:e("lie"),t.exports={Promise:n};},{lie:37}],7:[function(e,t,r){var n="undefined"!=typeof Uint8Array&&"undefined"!=typeof Uint16Array&&"undefined"!=typeof Uint32Array,i=e("pako"),s=e("./utils"),a=e("./stream/GenericWorker"),o=n?"uint8array":"array";function h(e,t){a.call(this,"FlateWorker/"+e),this._pako=null,this._pakoAction=e,this._pakoOptions=t,this.meta={};}r.magic="\b\0",s.inherits(h,a),h.prototype.processChunk=function(e){this.meta=e.meta,null===this._pako&&this._createPako(),this._pako.push(s.transformTo(o,e.data),!1);},h.prototype.flush=function(){a.prototype.flush.call(this),null===this._pako&&this._createPako(),this._pako.push([],!0);},h.prototype.cleanUp=function(){a.prototype.cleanUp.call(this),this._pako=null;},h.prototype._createPako=function(){this._pako=new i[this._pakoAction]({raw:!0,level:this._pakoOptions.level||-1});var t=this;this._pako.onData=function(e){t.push({data:e,meta:t.meta});};},r.compressWorker=function(e){return new h("Deflate",e)},r.uncompressWorker=function(){return new h("Inflate",{})};},{"./stream/GenericWorker":28,"./utils":32,pako:38}],8:[function(e,t,r){function A(e,t){var r,n="";for(r=0;r<t;r++)n+=String.fromCharCode(255&e),e>>>=8;return n}function n(e,t,r,n,i,s){var a,o,h=e.file,u=e.compression,l=s!==O.utf8encode,f=I.transformTo("string",s(h.name)),c=I.transformTo("string",O.utf8encode(h.name)),d=h.comment,p=I.transformTo("string",s(d)),m=I.transformTo("string",O.utf8encode(d)),_=c.length!==h.name.length,g=m.length!==d.length,b="",v="",y="",w=h.dir,k=h.date,x={crc32:0,compressedSize:0,uncompressedSize:0};t&&!r||(x.crc32=e.crc32,x.compressedSize=e.compressedSize,x.uncompressedSize=e.uncompressedSize);var S=0;t&&(S|=8),l||!_&&!g||(S|=2048);var z=0,C=0;w&&(z|=16),"UNIX"===i?(C=798,z|=function(e,t){var r=e;return e||(r=t?16893:33204),(65535&r)<<16}(h.unixPermissions,w)):(C=20,z|=function(e){return 63&(e||0)}(h.dosPermissions)),a=k.getUTCHours(),a<<=6,a|=k.getUTCMinutes(),a<<=5,a|=k.getUTCSeconds()/2,o=k.getUTCFullYear()-1980,o<<=4,o|=k.getUTCMonth()+1,o<<=5,o|=k.getUTCDate(),_&&(v=A(1,1)+A(B(f),4)+c,b+="up"+A(v.length,2)+v),g&&(y=A(1,1)+A(B(p),4)+m,b+="uc"+A(y.length,2)+y);var E="";return E+="\n\0",E+=A(S,2),E+=u.magic,E+=A(a,2),E+=A(o,2),E+=A(x.crc32,4),E+=A(x.compressedSize,4),E+=A(x.uncompressedSize,4),E+=A(f.length,2),E+=A(b.length,2),{fileRecord:R.LOCAL_FILE_HEADER+E+f+b,dirRecord:R.CENTRAL_FILE_HEADER+A(C,2)+E+A(p.length,2)+"\0\0\0\0"+A(z,4)+A(n,4)+f+b+p}}var I=e("../utils"),i=e("../stream/GenericWorker"),O=e("../utf8"),B=e("../crc32"),R=e("../signature");function s(e,t,r,n){i.call(this,"ZipFileWorker"),this.bytesWritten=0,this.zipComment=t,this.zipPlatform=r,this.encodeFileName=n,this.streamFiles=e,this.accumulate=!1,this.contentBuffer=[],this.dirRecords=[],this.currentSourceOffset=0,this.entriesCount=0,this.currentFile=null,this._sources=[];}I.inherits(s,i),s.prototype.push=function(e){var t=e.meta.percent||0,r=this.entriesCount,n=this._sources.length;this.accumulate?this.contentBuffer.push(e):(this.bytesWritten+=e.data.length,i.prototype.push.call(this,{data:e.data,meta:{currentFile:this.currentFile,percent:r?(t+100*(r-n-1))/r:100}}));},s.prototype.openedSource=function(e){this.currentSourceOffset=this.bytesWritten,this.currentFile=e.file.name;var t=this.streamFiles&&!e.file.dir;if(t){var r=n(e,t,!1,this.currentSourceOffset,this.zipPlatform,this.encodeFileName);this.push({data:r.fileRecord,meta:{percent:0}});}else this.accumulate=!0;},s.prototype.closedSource=function(e){this.accumulate=!1;var t=this.streamFiles&&!e.file.dir,r=n(e,t,!0,this.currentSourceOffset,this.zipPlatform,this.encodeFileName);if(this.dirRecords.push(r.dirRecord),t)this.push({data:function(e){return R.DATA_DESCRIPTOR+A(e.crc32,4)+A(e.compressedSize,4)+A(e.uncompressedSize,4)}(e),meta:{percent:100}});else for(this.push({data:r.fileRecord,meta:{percent:0}});this.contentBuffer.length;)this.push(this.contentBuffer.shift());this.currentFile=null;},s.prototype.flush=function(){for(var e=this.bytesWritten,t=0;t<this.dirRecords.length;t++)this.push({data:this.dirRecords[t],meta:{percent:100}});var r=this.bytesWritten-e,n=function(e,t,r,n,i){var s=I.transformTo("string",i(n));return R.CENTRAL_DIRECTORY_END+"\0\0\0\0"+A(e,2)+A(e,2)+A(t,4)+A(r,4)+A(s.length,2)+s}(this.dirRecords.length,r,e,this.zipComment,this.encodeFileName);this.push({data:n,meta:{percent:100}});},s.prototype.prepareNextSource=function(){this.previous=this._sources.shift(),this.openedSource(this.previous.streamInfo),this.isPaused?this.previous.pause():this.previous.resume();},s.prototype.registerPrevious=function(e){this._sources.push(e);var t=this;return e.on("data",function(e){t.processChunk(e);}),e.on("end",function(){t.closedSource(t.previous.streamInfo),t._sources.length?t.prepareNextSource():t.end();}),e.on("error",function(e){t.error(e);}),this},s.prototype.resume=function(){return !!i.prototype.resume.call(this)&&(!this.previous&&this._sources.length?(this.prepareNextSource(),!0):this.previous||this._sources.length||this.generatedError?void 0:(this.end(),!0))},s.prototype.error=function(e){var t=this._sources;if(!i.prototype.error.call(this,e))return !1;for(var r=0;r<t.length;r++)try{t[r].error(e);}catch(e){}return !0},s.prototype.lock=function(){i.prototype.lock.call(this);for(var e=this._sources,t=0;t<e.length;t++)e[t].lock();},t.exports=s;},{"../crc32":4,"../signature":23,"../stream/GenericWorker":28,"../utf8":31,"../utils":32}],9:[function(e,t,r){var u=e("../compressions"),n=e("./ZipFileWorker");r.generateWorker=function(e,a,t){var o=new n(a.streamFiles,t,a.platform,a.encodeFileName),h=0;try{e.forEach(function(e,t){h++;var r=function(e,t){var r=e||t,n=u[r];if(!n)throw new Error(r+" is not a valid compression method !");return n}(t.options.compression,a.compression),n=t.options.compressionOptions||a.compressionOptions||{},i=t.dir,s=t.date;t._compressWorker(r,n).withStreamInfo("file",{name:e,dir:i,date:s,comment:t.comment||"",unixPermissions:t.unixPermissions,dosPermissions:t.dosPermissions}).pipe(o);}),o.entriesCount=h;}catch(e){o.error(e);}return o};},{"../compressions":3,"./ZipFileWorker":8}],10:[function(e,t,r){function n(){if(!(this instanceof n))return new n;if(arguments.length)throw new Error("The constructor with parameters has been removed in JSZip 3.0, please check the upgrade guide.");this.files=Object.create(null),this.comment=null,this.root="",this.clone=function(){var e=new n;for(var t in this)"function"!=typeof this[t]&&(e[t]=this[t]);return e};}(n.prototype=e("./object")).loadAsync=e("./load"),n.support=e("./support"),n.defaults=e("./defaults"),n.version="3.10.1",n.loadAsync=function(e,t){return (new n).loadAsync(e,t)},n.external=e("./external"),t.exports=n;},{"./defaults":5,"./external":6,"./load":11,"./object":15,"./support":30}],11:[function(e,t,r){var u=e("./utils"),i=e("./external"),n=e("./utf8"),s=e("./zipEntries"),a=e("./stream/Crc32Probe"),l=e("./nodejsUtils");function f(n){return new i.Promise(function(e,t){var r=n.decompressed.getContentWorker().pipe(new a);r.on("error",function(e){t(e);}).on("end",function(){r.streamInfo.crc32!==n.decompressed.crc32?t(new Error("Corrupted zip : CRC32 mismatch")):e();}).resume();})}t.exports=function(e,o){var h=this;return o=u.extend(o||{},{base64:!1,checkCRC32:!1,optimizedBinaryString:!1,createFolders:!1,decodeFileName:n.utf8decode}),l.isNode&&l.isStream(e)?i.Promise.reject(new Error("JSZip can't accept a stream when loading a zip file.")):u.prepareContent("the loaded zip file",e,!0,o.optimizedBinaryString,o.base64).then(function(e){var t=new s(o);return t.load(e),t}).then(function(e){var t=[i.Promise.resolve(e)],r=e.files;if(o.checkCRC32)for(var n=0;n<r.length;n++)t.push(f(r[n]));return i.Promise.all(t)}).then(function(e){for(var t=e.shift(),r=t.files,n=0;n<r.length;n++){var i=r[n],s=i.fileNameStr,a=u.resolve(i.fileNameStr);h.file(a,i.decompressed,{binary:!0,optimizedBinaryString:!0,date:i.date,dir:i.dir,comment:i.fileCommentStr.length?i.fileCommentStr:null,unixPermissions:i.unixPermissions,dosPermissions:i.dosPermissions,createFolders:o.createFolders}),i.dir||(h.file(a).unsafeOriginalName=s);}return t.zipComment.length&&(h.comment=t.zipComment),h})};},{"./external":6,"./nodejsUtils":14,"./stream/Crc32Probe":25,"./utf8":31,"./utils":32,"./zipEntries":33}],12:[function(e,t,r){var n=e("../utils"),i=e("../stream/GenericWorker");function s(e,t){i.call(this,"Nodejs stream input adapter for "+e),this._upstreamEnded=!1,this._bindStream(t);}n.inherits(s,i),s.prototype._bindStream=function(e){var t=this;(this._stream=e).pause(),e.on("data",function(e){t.push({data:e,meta:{percent:0}});}).on("error",function(e){t.isPaused?this.generatedError=e:t.error(e);}).on("end",function(){t.isPaused?t._upstreamEnded=!0:t.end();});},s.prototype.pause=function(){return !!i.prototype.pause.call(this)&&(this._stream.pause(),!0)},s.prototype.resume=function(){return !!i.prototype.resume.call(this)&&(this._upstreamEnded?this.end():this._stream.resume(),!0)},t.exports=s;},{"../stream/GenericWorker":28,"../utils":32}],13:[function(e,t,r){var i=e("readable-stream").Readable;function n(e,t,r){i.call(this,t),this._helper=e;var n=this;e.on("data",function(e,t){n.push(e)||n._helper.pause(),r&&r(t);}).on("error",function(e){n.emit("error",e);}).on("end",function(){n.push(null);});}e("../utils").inherits(n,i),n.prototype._read=function(){this._helper.resume();},t.exports=n;},{"../utils":32,"readable-stream":16}],14:[function(e,t,r){t.exports={isNode:"undefined"!=typeof Buffer,newBufferFrom:function(e,t){if(Buffer.from&&Buffer.from!==Uint8Array.from)return Buffer.from(e,t);if("number"==typeof e)throw new Error('The "data" argument must not be a number');return new Buffer(e,t)},allocBuffer:function(e){if(Buffer.alloc)return Buffer.alloc(e);var t=new Buffer(e);return t.fill(0),t},isBuffer:function(e){return Buffer.isBuffer(e)},isStream:function(e){return e&&"function"==typeof e.on&&"function"==typeof e.pause&&"function"==typeof e.resume}};},{}],15:[function(e,t,r){function s(e,t,r){var n,i=u.getTypeOf(t),s=u.extend(r||{},f);s.date=s.date||new Date,null!==s.compression&&(s.compression=s.compression.toUpperCase()),"string"==typeof s.unixPermissions&&(s.unixPermissions=parseInt(s.unixPermissions,8)),s.unixPermissions&&16384&s.unixPermissions&&(s.dir=!0),s.dosPermissions&&16&s.dosPermissions&&(s.dir=!0),s.dir&&(e=g(e)),s.createFolders&&(n=_(e))&&b.call(this,n,!0);var a="string"===i&&!1===s.binary&&!1===s.base64;r&&void 0!==r.binary||(s.binary=!a),(t instanceof c&&0===t.uncompressedSize||s.dir||!t||0===t.length)&&(s.base64=!1,s.binary=!0,t="",s.compression="STORE",i="string");var o=null;o=t instanceof c||t instanceof l?t:p.isNode&&p.isStream(t)?new m(e,t):u.prepareContent(e,t,s.binary,s.optimizedBinaryString,s.base64);var h=new d(e,o,s);this.files[e]=h;}var i=e("./utf8"),u=e("./utils"),l=e("./stream/GenericWorker"),a=e("./stream/StreamHelper"),f=e("./defaults"),c=e("./compressedObject"),d=e("./zipObject"),o=e("./generate"),p=e("./nodejsUtils"),m=e("./nodejs/NodejsStreamInputAdapter"),_=function(e){"/"===e.slice(-1)&&(e=e.substring(0,e.length-1));var t=e.lastIndexOf("/");return 0<t?e.substring(0,t):""},g=function(e){return "/"!==e.slice(-1)&&(e+="/"),e},b=function(e,t){return t=void 0!==t?t:f.createFolders,e=g(e),this.files[e]||s.call(this,e,null,{dir:!0,createFolders:t}),this.files[e]};function h(e){return "[object RegExp]"===Object.prototype.toString.call(e)}var n={load:function(){throw new Error("This method has been removed in JSZip 3.0, please check the upgrade guide.")},forEach:function(e){var t,r,n;for(t in this.files)n=this.files[t],(r=t.slice(this.root.length,t.length))&&t.slice(0,this.root.length)===this.root&&e(r,n);},filter:function(r){var n=[];return this.forEach(function(e,t){r(e,t)&&n.push(t);}),n},file:function(e,t,r){if(1!==arguments.length)return e=this.root+e,s.call(this,e,t,r),this;if(h(e)){var n=e;return this.filter(function(e,t){return !t.dir&&n.test(e)})}var i=this.files[this.root+e];return i&&!i.dir?i:null},folder:function(r){if(!r)return this;if(h(r))return this.filter(function(e,t){return t.dir&&r.test(e)});var e=this.root+r,t=b.call(this,e),n=this.clone();return n.root=t.name,n},remove:function(r){r=this.root+r;var e=this.files[r];if(e||("/"!==r.slice(-1)&&(r+="/"),e=this.files[r]),e&&!e.dir)delete this.files[r];else for(var t=this.filter(function(e,t){return t.name.slice(0,r.length)===r}),n=0;n<t.length;n++)delete this.files[t[n].name];return this},generate:function(){throw new Error("This method has been removed in JSZip 3.0, please check the upgrade guide.")},generateInternalStream:function(e){var t,r={};try{if((r=u.extend(e||{},{streamFiles:!1,compression:"STORE",compressionOptions:null,type:"",platform:"DOS",comment:null,mimeType:"application/zip",encodeFileName:i.utf8encode})).type=r.type.toLowerCase(),r.compression=r.compression.toUpperCase(),"binarystring"===r.type&&(r.type="string"),!r.type)throw new Error("No output type specified.");u.checkSupport(r.type),"darwin"!==r.platform&&"freebsd"!==r.platform&&"linux"!==r.platform&&"sunos"!==r.platform||(r.platform="UNIX"),"win32"===r.platform&&(r.platform="DOS");var n=r.comment||this.comment||"";t=o.generateWorker(this,r,n);}catch(e){(t=new l("error")).error(e);}return new a(t,r.type||"string",r.mimeType)},generateAsync:function(e,t){return this.generateInternalStream(e).accumulate(t)},generateNodeStream:function(e,t){return (e=e||{}).type||(e.type="nodebuffer"),this.generateInternalStream(e).toNodejsStream(t)}};t.exports=n;},{"./compressedObject":2,"./defaults":5,"./generate":9,"./nodejs/NodejsStreamInputAdapter":12,"./nodejsUtils":14,"./stream/GenericWorker":28,"./stream/StreamHelper":29,"./utf8":31,"./utils":32,"./zipObject":35}],16:[function(e,t,r){t.exports=e("stream");},{stream:void 0}],17:[function(e,t,r){var n=e("./DataReader");function i(e){n.call(this,e);for(var t=0;t<this.data.length;t++)e[t]=255&e[t];}e("../utils").inherits(i,n),i.prototype.byteAt=function(e){return this.data[this.zero+e]},i.prototype.lastIndexOfSignature=function(e){for(var t=e.charCodeAt(0),r=e.charCodeAt(1),n=e.charCodeAt(2),i=e.charCodeAt(3),s=this.length-4;0<=s;--s)if(this.data[s]===t&&this.data[s+1]===r&&this.data[s+2]===n&&this.data[s+3]===i)return s-this.zero;return -1},i.prototype.readAndCheckSignature=function(e){var t=e.charCodeAt(0),r=e.charCodeAt(1),n=e.charCodeAt(2),i=e.charCodeAt(3),s=this.readData(4);return t===s[0]&&r===s[1]&&n===s[2]&&i===s[3]},i.prototype.readData=function(e){if(this.checkOffset(e),0===e)return [];var t=this.data.slice(this.zero+this.index,this.zero+this.index+e);return this.index+=e,t},t.exports=i;},{"../utils":32,"./DataReader":18}],18:[function(e,t,r){var n=e("../utils");function i(e){this.data=e,this.length=e.length,this.index=0,this.zero=0;}i.prototype={checkOffset:function(e){this.checkIndex(this.index+e);},checkIndex:function(e){if(this.length<this.zero+e||e<0)throw new Error("End of data reached (data length = "+this.length+", asked index = "+e+"). Corrupted zip ?")},setIndex:function(e){this.checkIndex(e),this.index=e;},skip:function(e){this.setIndex(this.index+e);},byteAt:function(){},readInt:function(e){var t,r=0;for(this.checkOffset(e),t=this.index+e-1;t>=this.index;t--)r=(r<<8)+this.byteAt(t);return this.index+=e,r},readString:function(e){return n.transformTo("string",this.readData(e))},readData:function(){},lastIndexOfSignature:function(){},readAndCheckSignature:function(){},readDate:function(){var e=this.readInt(4);return new Date(Date.UTC(1980+(e>>25&127),(e>>21&15)-1,e>>16&31,e>>11&31,e>>5&63,(31&e)<<1))}},t.exports=i;},{"../utils":32}],19:[function(e,t,r){var n=e("./Uint8ArrayReader");function i(e){n.call(this,e);}e("../utils").inherits(i,n),i.prototype.readData=function(e){this.checkOffset(e);var t=this.data.slice(this.zero+this.index,this.zero+this.index+e);return this.index+=e,t},t.exports=i;},{"../utils":32,"./Uint8ArrayReader":21}],20:[function(e,t,r){var n=e("./DataReader");function i(e){n.call(this,e);}e("../utils").inherits(i,n),i.prototype.byteAt=function(e){return this.data.charCodeAt(this.zero+e)},i.prototype.lastIndexOfSignature=function(e){return this.data.lastIndexOf(e)-this.zero},i.prototype.readAndCheckSignature=function(e){return e===this.readData(4)},i.prototype.readData=function(e){this.checkOffset(e);var t=this.data.slice(this.zero+this.index,this.zero+this.index+e);return this.index+=e,t},t.exports=i;},{"../utils":32,"./DataReader":18}],21:[function(e,t,r){var n=e("./ArrayReader");function i(e){n.call(this,e);}e("../utils").inherits(i,n),i.prototype.readData=function(e){if(this.checkOffset(e),0===e)return new Uint8Array(0);var t=this.data.subarray(this.zero+this.index,this.zero+this.index+e);return this.index+=e,t},t.exports=i;},{"../utils":32,"./ArrayReader":17}],22:[function(e,t,r){var n=e("../utils"),i=e("../support"),s=e("./ArrayReader"),a=e("./StringReader"),o=e("./NodeBufferReader"),h=e("./Uint8ArrayReader");t.exports=function(e){var t=n.getTypeOf(e);return n.checkSupport(t),"string"!==t||i.uint8array?"nodebuffer"===t?new o(e):i.uint8array?new h(n.transformTo("uint8array",e)):new s(n.transformTo("array",e)):new a(e)};},{"../support":30,"../utils":32,"./ArrayReader":17,"./NodeBufferReader":19,"./StringReader":20,"./Uint8ArrayReader":21}],23:[function(e,t,r){r.LOCAL_FILE_HEADER="PK",r.CENTRAL_FILE_HEADER="PK",r.CENTRAL_DIRECTORY_END="PK",r.ZIP64_CENTRAL_DIRECTORY_LOCATOR="PK",r.ZIP64_CENTRAL_DIRECTORY_END="PK",r.DATA_DESCRIPTOR="PK\b";},{}],24:[function(e,t,r){var n=e("./GenericWorker"),i=e("../utils");function s(e){n.call(this,"ConvertWorker to "+e),this.destType=e;}i.inherits(s,n),s.prototype.processChunk=function(e){this.push({data:i.transformTo(this.destType,e.data),meta:e.meta});},t.exports=s;},{"../utils":32,"./GenericWorker":28}],25:[function(e,t,r){var n=e("./GenericWorker"),i=e("../crc32");function s(){n.call(this,"Crc32Probe"),this.withStreamInfo("crc32",0);}e("../utils").inherits(s,n),s.prototype.processChunk=function(e){this.streamInfo.crc32=i(e.data,this.streamInfo.crc32||0),this.push(e);},t.exports=s;},{"../crc32":4,"../utils":32,"./GenericWorker":28}],26:[function(e,t,r){var n=e("../utils"),i=e("./GenericWorker");function s(e){i.call(this,"DataLengthProbe for "+e),this.propName=e,this.withStreamInfo(e,0);}n.inherits(s,i),s.prototype.processChunk=function(e){if(e){var t=this.streamInfo[this.propName]||0;this.streamInfo[this.propName]=t+e.data.length;}i.prototype.processChunk.call(this,e);},t.exports=s;},{"../utils":32,"./GenericWorker":28}],27:[function(e,t,r){var n=e("../utils"),i=e("./GenericWorker");function s(e){i.call(this,"DataWorker");var t=this;this.dataIsReady=!1,this.index=0,this.max=0,this.data=null,this.type="",this._tickScheduled=!1,e.then(function(e){t.dataIsReady=!0,t.data=e,t.max=e&&e.length||0,t.type=n.getTypeOf(e),t.isPaused||t._tickAndRepeat();},function(e){t.error(e);});}n.inherits(s,i),s.prototype.cleanUp=function(){i.prototype.cleanUp.call(this),this.data=null;},s.prototype.resume=function(){return !!i.prototype.resume.call(this)&&(!this._tickScheduled&&this.dataIsReady&&(this._tickScheduled=!0,n.delay(this._tickAndRepeat,[],this)),!0)},s.prototype._tickAndRepeat=function(){this._tickScheduled=!1,this.isPaused||this.isFinished||(this._tick(),this.isFinished||(n.delay(this._tickAndRepeat,[],this),this._tickScheduled=!0));},s.prototype._tick=function(){if(this.isPaused||this.isFinished)return !1;var e=null,t=Math.min(this.max,this.index+16384);if(this.index>=this.max)return this.end();switch(this.type){case"string":e=this.data.substring(this.index,t);break;case"uint8array":e=this.data.subarray(this.index,t);break;case"array":case"nodebuffer":e=this.data.slice(this.index,t);}return this.index=t,this.push({data:e,meta:{percent:this.max?this.index/this.max*100:0}})},t.exports=s;},{"../utils":32,"./GenericWorker":28}],28:[function(e,t,r){function n(e){this.name=e||"default",this.streamInfo={},this.generatedError=null,this.extraStreamInfo={},this.isPaused=!0,this.isFinished=!1,this.isLocked=!1,this._listeners={data:[],end:[],error:[]},this.previous=null;}n.prototype={push:function(e){this.emit("data",e);},end:function(){if(this.isFinished)return !1;this.flush();try{this.emit("end"),this.cleanUp(),this.isFinished=!0;}catch(e){this.emit("error",e);}return !0},error:function(e){return !this.isFinished&&(this.isPaused?this.generatedError=e:(this.isFinished=!0,this.emit("error",e),this.previous&&this.previous.error(e),this.cleanUp()),!0)},on:function(e,t){return this._listeners[e].push(t),this},cleanUp:function(){this.streamInfo=this.generatedError=this.extraStreamInfo=null,this._listeners=[];},emit:function(e,t){if(this._listeners[e])for(var r=0;r<this._listeners[e].length;r++)this._listeners[e][r].call(this,t);},pipe:function(e){return e.registerPrevious(this)},registerPrevious:function(e){if(this.isLocked)throw new Error("The stream '"+this+"' has already been used.");this.streamInfo=e.streamInfo,this.mergeStreamInfo(),this.previous=e;var t=this;return e.on("data",function(e){t.processChunk(e);}),e.on("end",function(){t.end();}),e.on("error",function(e){t.error(e);}),this},pause:function(){return !this.isPaused&&!this.isFinished&&(this.isPaused=!0,this.previous&&this.previous.pause(),!0)},resume:function(){if(!this.isPaused||this.isFinished)return !1;var e=this.isPaused=!1;return this.generatedError&&(this.error(this.generatedError),e=!0),this.previous&&this.previous.resume(),!e},flush:function(){},processChunk:function(e){this.push(e);},withStreamInfo:function(e,t){return this.extraStreamInfo[e]=t,this.mergeStreamInfo(),this},mergeStreamInfo:function(){for(var e in this.extraStreamInfo)Object.prototype.hasOwnProperty.call(this.extraStreamInfo,e)&&(this.streamInfo[e]=this.extraStreamInfo[e]);},lock:function(){if(this.isLocked)throw new Error("The stream '"+this+"' has already been used.");this.isLocked=!0,this.previous&&this.previous.lock();},toString:function(){var e="Worker "+this.name;return this.previous?this.previous+" -> "+e:e}},t.exports=n;},{}],29:[function(e,t,r){var h=e("../utils"),i=e("./ConvertWorker"),s=e("./GenericWorker"),u=e("../base64"),n=e("../support"),a=e("../external"),o=null;if(n.nodestream)try{o=e("../nodejs/NodejsStreamOutputAdapter");}catch(e){}function l(e,o){return new a.Promise(function(t,r){var n=[],i=e._internalType,s=e._outputType,a=e._mimeType;e.on("data",function(e,t){n.push(e),o&&o(t);}).on("error",function(e){n=[],r(e);}).on("end",function(){try{var e=function(e,t,r){switch(e){case"blob":return h.newBlob(h.transformTo("arraybuffer",t),r);case"base64":return u.encode(t);default:return h.transformTo(e,t)}}(s,function(e,t){var r,n=0,i=null,s=0;for(r=0;r<t.length;r++)s+=t[r].length;switch(e){case"string":return t.join("");case"array":return Array.prototype.concat.apply([],t);case"uint8array":for(i=new Uint8Array(s),r=0;r<t.length;r++)i.set(t[r],n),n+=t[r].length;return i;case"nodebuffer":return Buffer.concat(t);default:throw new Error("concat : unsupported type '"+e+"'")}}(i,n),a);t(e);}catch(e){r(e);}n=[];}).resume();})}function f(e,t,r){var n=t;switch(t){case"blob":case"arraybuffer":n="uint8array";break;case"base64":n="string";}try{this._internalType=n,this._outputType=t,this._mimeType=r,h.checkSupport(n),this._worker=e.pipe(new i(n)),e.lock();}catch(e){this._worker=new s("error"),this._worker.error(e);}}f.prototype={accumulate:function(e){return l(this,e)},on:function(e,t){var r=this;return "data"===e?this._worker.on(e,function(e){t.call(r,e.data,e.meta);}):this._worker.on(e,function(){h.delay(t,arguments,r);}),this},resume:function(){return h.delay(this._worker.resume,[],this._worker),this},pause:function(){return this._worker.pause(),this},toNodejsStream:function(e){if(h.checkSupport("nodestream"),"nodebuffer"!==this._outputType)throw new Error(this._outputType+" is not supported by this method");return new o(this,{objectMode:"nodebuffer"!==this._outputType},e)}},t.exports=f;},{"../base64":1,"../external":6,"../nodejs/NodejsStreamOutputAdapter":13,"../support":30,"../utils":32,"./ConvertWorker":24,"./GenericWorker":28}],30:[function(e,t,r){if(r.base64=!0,r.array=!0,r.string=!0,r.arraybuffer="undefined"!=typeof ArrayBuffer&&"undefined"!=typeof Uint8Array,r.nodebuffer="undefined"!=typeof Buffer,r.uint8array="undefined"!=typeof Uint8Array,"undefined"==typeof ArrayBuffer)r.blob=!1;else {var n=new ArrayBuffer(0);try{r.blob=0===new Blob([n],{type:"application/zip"}).size;}catch(e){try{var i=new(self.BlobBuilder||self.WebKitBlobBuilder||self.MozBlobBuilder||self.MSBlobBuilder);i.append(n),r.blob=0===i.getBlob("application/zip").size;}catch(e){r.blob=!1;}}}try{r.nodestream=!!e("readable-stream").Readable;}catch(e){r.nodestream=!1;}},{"readable-stream":16}],31:[function(e,t,s){for(var o=e("./utils"),h=e("./support"),r=e("./nodejsUtils"),n=e("./stream/GenericWorker"),u=new Array(256),i=0;i<256;i++)u[i]=252<=i?6:248<=i?5:240<=i?4:224<=i?3:192<=i?2:1;u[254]=u[254]=1;function a(){n.call(this,"utf-8 decode"),this.leftOver=null;}function l(){n.call(this,"utf-8 encode");}s.utf8encode=function(e){return h.nodebuffer?r.newBufferFrom(e,"utf-8"):function(e){var t,r,n,i,s,a=e.length,o=0;for(i=0;i<a;i++)55296==(64512&(r=e.charCodeAt(i)))&&i+1<a&&56320==(64512&(n=e.charCodeAt(i+1)))&&(r=65536+(r-55296<<10)+(n-56320),i++),o+=r<128?1:r<2048?2:r<65536?3:4;for(t=h.uint8array?new Uint8Array(o):new Array(o),i=s=0;s<o;i++)55296==(64512&(r=e.charCodeAt(i)))&&i+1<a&&56320==(64512&(n=e.charCodeAt(i+1)))&&(r=65536+(r-55296<<10)+(n-56320),i++),r<128?t[s++]=r:(r<2048?t[s++]=192|r>>>6:(r<65536?t[s++]=224|r>>>12:(t[s++]=240|r>>>18,t[s++]=128|r>>>12&63),t[s++]=128|r>>>6&63),t[s++]=128|63&r);return t}(e)},s.utf8decode=function(e){return h.nodebuffer?o.transformTo("nodebuffer",e).toString("utf-8"):function(e){var t,r,n,i,s=e.length,a=new Array(2*s);for(t=r=0;t<s;)if((n=e[t++])<128)a[r++]=n;else if(4<(i=u[n]))a[r++]=65533,t+=i-1;else {for(n&=2===i?31:3===i?15:7;1<i&&t<s;)n=n<<6|63&e[t++],i--;1<i?a[r++]=65533:n<65536?a[r++]=n:(n-=65536,a[r++]=55296|n>>10&1023,a[r++]=56320|1023&n);}return a.length!==r&&(a.subarray?a=a.subarray(0,r):a.length=r),o.applyFromCharCode(a)}(e=o.transformTo(h.uint8array?"uint8array":"array",e))},o.inherits(a,n),a.prototype.processChunk=function(e){var t=o.transformTo(h.uint8array?"uint8array":"array",e.data);if(this.leftOver&&this.leftOver.length){if(h.uint8array){var r=t;(t=new Uint8Array(r.length+this.leftOver.length)).set(this.leftOver,0),t.set(r,this.leftOver.length);}else t=this.leftOver.concat(t);this.leftOver=null;}var n=function(e,t){var r;for((t=t||e.length)>e.length&&(t=e.length),r=t-1;0<=r&&128==(192&e[r]);)r--;return r<0?t:0===r?t:r+u[e[r]]>t?r:t}(t),i=t;n!==t.length&&(h.uint8array?(i=t.subarray(0,n),this.leftOver=t.subarray(n,t.length)):(i=t.slice(0,n),this.leftOver=t.slice(n,t.length))),this.push({data:s.utf8decode(i),meta:e.meta});},a.prototype.flush=function(){this.leftOver&&this.leftOver.length&&(this.push({data:s.utf8decode(this.leftOver),meta:{}}),this.leftOver=null);},s.Utf8DecodeWorker=a,o.inherits(l,n),l.prototype.processChunk=function(e){this.push({data:s.utf8encode(e.data),meta:e.meta});},s.Utf8EncodeWorker=l;},{"./nodejsUtils":14,"./stream/GenericWorker":28,"./support":30,"./utils":32}],32:[function(e,t,a){var o=e("./support"),h=e("./base64"),r=e("./nodejsUtils"),u=e("./external");function n(e){return e}function l(e,t){for(var r=0;r<e.length;++r)t[r]=255&e.charCodeAt(r);return t}e("setimmediate"),a.newBlob=function(t,r){a.checkSupport("blob");try{return new Blob([t],{type:r})}catch(e){try{var n=new(self.BlobBuilder||self.WebKitBlobBuilder||self.MozBlobBuilder||self.MSBlobBuilder);return n.append(t),n.getBlob(r)}catch(e){throw new Error("Bug : can't construct the Blob.")}}};var i={stringifyByChunk:function(e,t,r){var n=[],i=0,s=e.length;if(s<=r)return String.fromCharCode.apply(null,e);for(;i<s;)"array"===t||"nodebuffer"===t?n.push(String.fromCharCode.apply(null,e.slice(i,Math.min(i+r,s)))):n.push(String.fromCharCode.apply(null,e.subarray(i,Math.min(i+r,s)))),i+=r;return n.join("")},stringifyByChar:function(e){for(var t="",r=0;r<e.length;r++)t+=String.fromCharCode(e[r]);return t},applyCanBeUsed:{uint8array:function(){try{return o.uint8array&&1===String.fromCharCode.apply(null,new Uint8Array(1)).length}catch(e){return !1}}(),nodebuffer:function(){try{return o.nodebuffer&&1===String.fromCharCode.apply(null,r.allocBuffer(1)).length}catch(e){return !1}}()}};function s(e){var t=65536,r=a.getTypeOf(e),n=!0;if("uint8array"===r?n=i.applyCanBeUsed.uint8array:"nodebuffer"===r&&(n=i.applyCanBeUsed.nodebuffer),n)for(;1<t;)try{return i.stringifyByChunk(e,r,t)}catch(e){t=Math.floor(t/2);}return i.stringifyByChar(e)}function f(e,t){for(var r=0;r<e.length;r++)t[r]=e[r];return t}a.applyFromCharCode=s;var c={};c.string={string:n,array:function(e){return l(e,new Array(e.length))},arraybuffer:function(e){return c.string.uint8array(e).buffer},uint8array:function(e){return l(e,new Uint8Array(e.length))},nodebuffer:function(e){return l(e,r.allocBuffer(e.length))}},c.array={string:s,array:n,arraybuffer:function(e){return new Uint8Array(e).buffer},uint8array:function(e){return new Uint8Array(e)},nodebuffer:function(e){return r.newBufferFrom(e)}},c.arraybuffer={string:function(e){return s(new Uint8Array(e))},array:function(e){return f(new Uint8Array(e),new Array(e.byteLength))},arraybuffer:n,uint8array:function(e){return new Uint8Array(e)},nodebuffer:function(e){return r.newBufferFrom(new Uint8Array(e))}},c.uint8array={string:s,array:function(e){return f(e,new Array(e.length))},arraybuffer:function(e){return e.buffer},uint8array:n,nodebuffer:function(e){return r.newBufferFrom(e)}},c.nodebuffer={string:s,array:function(e){return f(e,new Array(e.length))},arraybuffer:function(e){return c.nodebuffer.uint8array(e).buffer},uint8array:function(e){return f(e,new Uint8Array(e.length))},nodebuffer:n},a.transformTo=function(e,t){if(t=t||"",!e)return t;a.checkSupport(e);var r=a.getTypeOf(t);return c[r][e](t)},a.resolve=function(e){for(var t=e.split("/"),r=[],n=0;n<t.length;n++){var i=t[n];"."===i||""===i&&0!==n&&n!==t.length-1||(".."===i?r.pop():r.push(i));}return r.join("/")},a.getTypeOf=function(e){return "string"==typeof e?"string":"[object Array]"===Object.prototype.toString.call(e)?"array":o.nodebuffer&&r.isBuffer(e)?"nodebuffer":o.uint8array&&e instanceof Uint8Array?"uint8array":o.arraybuffer&&e instanceof ArrayBuffer?"arraybuffer":void 0},a.checkSupport=function(e){if(!o[e.toLowerCase()])throw new Error(e+" is not supported by this platform")},a.MAX_VALUE_16BITS=65535,a.MAX_VALUE_32BITS=-1,a.pretty=function(e){var t,r,n="";for(r=0;r<(e||"").length;r++)n+="\\x"+((t=e.charCodeAt(r))<16?"0":"")+t.toString(16).toUpperCase();return n},a.delay=function(e,t,r){setImmediate(function(){e.apply(r||null,t||[]);});},a.inherits=function(e,t){function r(){}r.prototype=t.prototype,e.prototype=new r;},a.extend=function(){var e,t,r={};for(e=0;e<arguments.length;e++)for(t in arguments[e])Object.prototype.hasOwnProperty.call(arguments[e],t)&&void 0===r[t]&&(r[t]=arguments[e][t]);return r},a.prepareContent=function(r,e,n,i,s){return u.Promise.resolve(e).then(function(n){return o.blob&&(n instanceof Blob||-1!==["[object File]","[object Blob]"].indexOf(Object.prototype.toString.call(n)))&&"undefined"!=typeof FileReader?new u.Promise(function(t,r){var e=new FileReader;e.onload=function(e){t(e.target.result);},e.onerror=function(e){r(e.target.error);},e.readAsArrayBuffer(n);}):n}).then(function(e){var t=a.getTypeOf(e);return t?("arraybuffer"===t?e=a.transformTo("uint8array",e):"string"===t&&(s?e=h.decode(e):n&&!0!==i&&(e=function(e){return l(e,o.uint8array?new Uint8Array(e.length):new Array(e.length))}(e))),e):u.Promise.reject(new Error("Can't read the data of '"+r+"'. Is it in a supported JavaScript type (String, Blob, ArrayBuffer, etc) ?"))})};},{"./base64":1,"./external":6,"./nodejsUtils":14,"./support":30,setimmediate:54}],33:[function(e,t,r){var n=e("./reader/readerFor"),i=e("./utils"),s=e("./signature"),a=e("./zipEntry"),o=e("./support");function h(e){this.files=[],this.loadOptions=e;}h.prototype={checkSignature:function(e){if(!this.reader.readAndCheckSignature(e)){this.reader.index-=4;var t=this.reader.readString(4);throw new Error("Corrupted zip or bug: unexpected signature ("+i.pretty(t)+", expected "+i.pretty(e)+")")}},isSignature:function(e,t){var r=this.reader.index;this.reader.setIndex(e);var n=this.reader.readString(4)===t;return this.reader.setIndex(r),n},readBlockEndOfCentral:function(){this.diskNumber=this.reader.readInt(2),this.diskWithCentralDirStart=this.reader.readInt(2),this.centralDirRecordsOnThisDisk=this.reader.readInt(2),this.centralDirRecords=this.reader.readInt(2),this.centralDirSize=this.reader.readInt(4),this.centralDirOffset=this.reader.readInt(4),this.zipCommentLength=this.reader.readInt(2);var e=this.reader.readData(this.zipCommentLength),t=o.uint8array?"uint8array":"array",r=i.transformTo(t,e);this.zipComment=this.loadOptions.decodeFileName(r);},readBlockZip64EndOfCentral:function(){this.zip64EndOfCentralSize=this.reader.readInt(8),this.reader.skip(4),this.diskNumber=this.reader.readInt(4),this.diskWithCentralDirStart=this.reader.readInt(4),this.centralDirRecordsOnThisDisk=this.reader.readInt(8),this.centralDirRecords=this.reader.readInt(8),this.centralDirSize=this.reader.readInt(8),this.centralDirOffset=this.reader.readInt(8),this.zip64ExtensibleData={};for(var e,t,r,n=this.zip64EndOfCentralSize-44;0<n;)e=this.reader.readInt(2),t=this.reader.readInt(4),r=this.reader.readData(t),this.zip64ExtensibleData[e]={id:e,length:t,value:r};},readBlockZip64EndOfCentralLocator:function(){if(this.diskWithZip64CentralDirStart=this.reader.readInt(4),this.relativeOffsetEndOfZip64CentralDir=this.reader.readInt(8),this.disksCount=this.reader.readInt(4),1<this.disksCount)throw new Error("Multi-volumes zip are not supported")},readLocalFiles:function(){var e,t;for(e=0;e<this.files.length;e++)t=this.files[e],this.reader.setIndex(t.localHeaderOffset),this.checkSignature(s.LOCAL_FILE_HEADER),t.readLocalPart(this.reader),t.handleUTF8(),t.processAttributes();},readCentralDir:function(){var e;for(this.reader.setIndex(this.centralDirOffset);this.reader.readAndCheckSignature(s.CENTRAL_FILE_HEADER);)(e=new a({zip64:this.zip64},this.loadOptions)).readCentralPart(this.reader),this.files.push(e);if(this.centralDirRecords!==this.files.length&&0!==this.centralDirRecords&&0===this.files.length)throw new Error("Corrupted zip or bug: expected "+this.centralDirRecords+" records in central dir, got "+this.files.length)},readEndOfCentral:function(){var e=this.reader.lastIndexOfSignature(s.CENTRAL_DIRECTORY_END);if(e<0)throw !this.isSignature(0,s.LOCAL_FILE_HEADER)?new Error("Can't find end of central directory : is this a zip file ? If it is, see https://stuk.github.io/jszip/documentation/howto/read_zip.html"):new Error("Corrupted zip: can't find end of central directory");this.reader.setIndex(e);var t=e;if(this.checkSignature(s.CENTRAL_DIRECTORY_END),this.readBlockEndOfCentral(),this.diskNumber===i.MAX_VALUE_16BITS||this.diskWithCentralDirStart===i.MAX_VALUE_16BITS||this.centralDirRecordsOnThisDisk===i.MAX_VALUE_16BITS||this.centralDirRecords===i.MAX_VALUE_16BITS||this.centralDirSize===i.MAX_VALUE_32BITS||this.centralDirOffset===i.MAX_VALUE_32BITS){if(this.zip64=!0,(e=this.reader.lastIndexOfSignature(s.ZIP64_CENTRAL_DIRECTORY_LOCATOR))<0)throw new Error("Corrupted zip: can't find the ZIP64 end of central directory locator");if(this.reader.setIndex(e),this.checkSignature(s.ZIP64_CENTRAL_DIRECTORY_LOCATOR),this.readBlockZip64EndOfCentralLocator(),!this.isSignature(this.relativeOffsetEndOfZip64CentralDir,s.ZIP64_CENTRAL_DIRECTORY_END)&&(this.relativeOffsetEndOfZip64CentralDir=this.reader.lastIndexOfSignature(s.ZIP64_CENTRAL_DIRECTORY_END),this.relativeOffsetEndOfZip64CentralDir<0))throw new Error("Corrupted zip: can't find the ZIP64 end of central directory");this.reader.setIndex(this.relativeOffsetEndOfZip64CentralDir),this.checkSignature(s.ZIP64_CENTRAL_DIRECTORY_END),this.readBlockZip64EndOfCentral();}var r=this.centralDirOffset+this.centralDirSize;this.zip64&&(r+=20,r+=12+this.zip64EndOfCentralSize);var n=t-r;if(0<n)this.isSignature(t,s.CENTRAL_FILE_HEADER)||(this.reader.zero=n);else if(n<0)throw new Error("Corrupted zip: missing "+Math.abs(n)+" bytes.")},prepareReader:function(e){this.reader=n(e);},load:function(e){this.prepareReader(e),this.readEndOfCentral(),this.readCentralDir(),this.readLocalFiles();}},t.exports=h;},{"./reader/readerFor":22,"./signature":23,"./support":30,"./utils":32,"./zipEntry":34}],34:[function(e,t,r){var n=e("./reader/readerFor"),s=e("./utils"),i=e("./compressedObject"),a=e("./crc32"),o=e("./utf8"),h=e("./compressions"),u=e("./support");function l(e,t){this.options=e,this.loadOptions=t;}l.prototype={isEncrypted:function(){return 1==(1&this.bitFlag)},useUTF8:function(){return 2048==(2048&this.bitFlag)},readLocalPart:function(e){var t,r;if(e.skip(22),this.fileNameLength=e.readInt(2),r=e.readInt(2),this.fileName=e.readData(this.fileNameLength),e.skip(r),-1===this.compressedSize||-1===this.uncompressedSize)throw new Error("Bug or corrupted zip : didn't get enough information from the central directory (compressedSize === -1 || uncompressedSize === -1)");if(null===(t=function(e){for(var t in h)if(Object.prototype.hasOwnProperty.call(h,t)&&h[t].magic===e)return h[t];return null}(this.compressionMethod)))throw new Error("Corrupted zip : compression "+s.pretty(this.compressionMethod)+" unknown (inner file : "+s.transformTo("string",this.fileName)+")");this.decompressed=new i(this.compressedSize,this.uncompressedSize,this.crc32,t,e.readData(this.compressedSize));},readCentralPart:function(e){this.versionMadeBy=e.readInt(2),e.skip(2),this.bitFlag=e.readInt(2),this.compressionMethod=e.readString(2),this.date=e.readDate(),this.crc32=e.readInt(4),this.compressedSize=e.readInt(4),this.uncompressedSize=e.readInt(4);var t=e.readInt(2);if(this.extraFieldsLength=e.readInt(2),this.fileCommentLength=e.readInt(2),this.diskNumberStart=e.readInt(2),this.internalFileAttributes=e.readInt(2),this.externalFileAttributes=e.readInt(4),this.localHeaderOffset=e.readInt(4),this.isEncrypted())throw new Error("Encrypted zip are not supported");e.skip(t),this.readExtraFields(e),this.parseZIP64ExtraField(e),this.fileComment=e.readData(this.fileCommentLength);},processAttributes:function(){this.unixPermissions=null,this.dosPermissions=null;var e=this.versionMadeBy>>8;this.dir=!!(16&this.externalFileAttributes),0==e&&(this.dosPermissions=63&this.externalFileAttributes),3==e&&(this.unixPermissions=this.externalFileAttributes>>16&65535),this.dir||"/"!==this.fileNameStr.slice(-1)||(this.dir=!0);},parseZIP64ExtraField:function(){if(this.extraFields[1]){var e=n(this.extraFields[1].value);this.uncompressedSize===s.MAX_VALUE_32BITS&&(this.uncompressedSize=e.readInt(8)),this.compressedSize===s.MAX_VALUE_32BITS&&(this.compressedSize=e.readInt(8)),this.localHeaderOffset===s.MAX_VALUE_32BITS&&(this.localHeaderOffset=e.readInt(8)),this.diskNumberStart===s.MAX_VALUE_32BITS&&(this.diskNumberStart=e.readInt(4));}},readExtraFields:function(e){var t,r,n,i=e.index+this.extraFieldsLength;for(this.extraFields||(this.extraFields={});e.index+4<i;)t=e.readInt(2),r=e.readInt(2),n=e.readData(r),this.extraFields[t]={id:t,length:r,value:n};e.setIndex(i);},handleUTF8:function(){var e=u.uint8array?"uint8array":"array";if(this.useUTF8())this.fileNameStr=o.utf8decode(this.fileName),this.fileCommentStr=o.utf8decode(this.fileComment);else {var t=this.findExtraFieldUnicodePath();if(null!==t)this.fileNameStr=t;else {var r=s.transformTo(e,this.fileName);this.fileNameStr=this.loadOptions.decodeFileName(r);}var n=this.findExtraFieldUnicodeComment();if(null!==n)this.fileCommentStr=n;else {var i=s.transformTo(e,this.fileComment);this.fileCommentStr=this.loadOptions.decodeFileName(i);}}},findExtraFieldUnicodePath:function(){var e=this.extraFields[28789];if(e){var t=n(e.value);return 1!==t.readInt(1)?null:a(this.fileName)!==t.readInt(4)?null:o.utf8decode(t.readData(e.length-5))}return null},findExtraFieldUnicodeComment:function(){var e=this.extraFields[25461];if(e){var t=n(e.value);return 1!==t.readInt(1)?null:a(this.fileComment)!==t.readInt(4)?null:o.utf8decode(t.readData(e.length-5))}return null}},t.exports=l;},{"./compressedObject":2,"./compressions":3,"./crc32":4,"./reader/readerFor":22,"./support":30,"./utf8":31,"./utils":32}],35:[function(e,t,r){function n(e,t,r){this.name=e,this.dir=r.dir,this.date=r.date,this.comment=r.comment,this.unixPermissions=r.unixPermissions,this.dosPermissions=r.dosPermissions,this._data=t,this._dataBinary=r.binary,this.options={compression:r.compression,compressionOptions:r.compressionOptions};}var s=e("./stream/StreamHelper"),i=e("./stream/DataWorker"),a=e("./utf8"),o=e("./compressedObject"),h=e("./stream/GenericWorker");n.prototype={internalStream:function(e){var t=null,r="string";try{if(!e)throw new Error("No output type specified.");var n="string"===(r=e.toLowerCase())||"text"===r;"binarystring"!==r&&"text"!==r||(r="string"),t=this._decompressWorker();var i=!this._dataBinary;i&&!n&&(t=t.pipe(new a.Utf8EncodeWorker)),!i&&n&&(t=t.pipe(new a.Utf8DecodeWorker));}catch(e){(t=new h("error")).error(e);}return new s(t,r,"")},async:function(e,t){return this.internalStream(e).accumulate(t)},nodeStream:function(e,t){return this.internalStream(e||"nodebuffer").toNodejsStream(t)},_compressWorker:function(e,t){if(this._data instanceof o&&this._data.compression.magic===e.magic)return this._data.getCompressedWorker();var r=this._decompressWorker();return this._dataBinary||(r=r.pipe(new a.Utf8EncodeWorker)),o.createWorkerFrom(r,e,t)},_decompressWorker:function(){return this._data instanceof o?this._data.getContentWorker():this._data instanceof h?this._data:new i(this._data)}};for(var u=["asText","asBinary","asNodeBuffer","asUint8Array","asArrayBuffer"],l=function(){throw new Error("This method has been removed in JSZip 3.0, please check the upgrade guide.")},f=0;f<u.length;f++)n.prototype[u[f]]=l;t.exports=n;},{"./compressedObject":2,"./stream/DataWorker":27,"./stream/GenericWorker":28,"./stream/StreamHelper":29,"./utf8":31}],36:[function(e,l,t){(function(t){var r,n,e=t.MutationObserver||t.WebKitMutationObserver;if(e){var i=0,s=new e(u),a=t.document.createTextNode("");s.observe(a,{characterData:!0}),r=function(){a.data=i=++i%2;};}else if(t.setImmediate||void 0===t.MessageChannel)r="document"in t&&"onreadystatechange"in t.document.createElement("script")?function(){var e=t.document.createElement("script");e.onreadystatechange=function(){u(),e.onreadystatechange=null,e.parentNode.removeChild(e),e=null;},t.document.documentElement.appendChild(e);}:function(){setTimeout(u,0);};else {var o=new t.MessageChannel;o.port1.onmessage=u,r=function(){o.port2.postMessage(0);};}var h=[];function u(){var e,t;n=!0;for(var r=h.length;r;){for(t=h,h=[],e=-1;++e<r;)t[e]();r=h.length;}n=!1;}l.exports=function(e){1!==h.push(e)||n||r();};}).call(this,"undefined"!=typeof commonjsGlobal?commonjsGlobal:"undefined"!=typeof self?self:"undefined"!=typeof window?window:{});},{}],37:[function(e,t,r){var i=e("immediate");function u(){}var l={},s=["REJECTED"],a=["FULFILLED"],n=["PENDING"];function o(e){if("function"!=typeof e)throw new TypeError("resolver must be a function");this.state=n,this.queue=[],this.outcome=void 0,e!==u&&d(this,e);}function h(e,t,r){this.promise=e,"function"==typeof t&&(this.onFulfilled=t,this.callFulfilled=this.otherCallFulfilled),"function"==typeof r&&(this.onRejected=r,this.callRejected=this.otherCallRejected);}function f(t,r,n){i(function(){var e;try{e=r(n);}catch(e){return l.reject(t,e)}e===t?l.reject(t,new TypeError("Cannot resolve promise with itself")):l.resolve(t,e);});}function c(e){var t=e&&e.then;if(e&&("object"==typeof e||"function"==typeof e)&&"function"==typeof t)return function(){t.apply(e,arguments);}}function d(t,e){var r=!1;function n(e){r||(r=!0,l.reject(t,e));}function i(e){r||(r=!0,l.resolve(t,e));}var s=p(function(){e(i,n);});"error"===s.status&&n(s.value);}function p(e,t){var r={};try{r.value=e(t),r.status="success";}catch(e){r.status="error",r.value=e;}return r}(t.exports=o).prototype.finally=function(t){if("function"!=typeof t)return this;var r=this.constructor;return this.then(function(e){return r.resolve(t()).then(function(){return e})},function(e){return r.resolve(t()).then(function(){throw e})})},o.prototype.catch=function(e){return this.then(null,e)},o.prototype.then=function(e,t){if("function"!=typeof e&&this.state===a||"function"!=typeof t&&this.state===s)return this;var r=new this.constructor(u);this.state!==n?f(r,this.state===a?e:t,this.outcome):this.queue.push(new h(r,e,t));return r},h.prototype.callFulfilled=function(e){l.resolve(this.promise,e);},h.prototype.otherCallFulfilled=function(e){f(this.promise,this.onFulfilled,e);},h.prototype.callRejected=function(e){l.reject(this.promise,e);},h.prototype.otherCallRejected=function(e){f(this.promise,this.onRejected,e);},l.resolve=function(e,t){var r=p(c,t);if("error"===r.status)return l.reject(e,r.value);var n=r.value;if(n)d(e,n);else {e.state=a,e.outcome=t;for(var i=-1,s=e.queue.length;++i<s;)e.queue[i].callFulfilled(t);}return e},l.reject=function(e,t){e.state=s,e.outcome=t;for(var r=-1,n=e.queue.length;++r<n;)e.queue[r].callRejected(t);return e},o.resolve=function(e){if(e instanceof this)return e;return l.resolve(new this(u),e)},o.reject=function(e){var t=new this(u);return l.reject(t,e)},o.all=function(e){var r=this;if("[object Array]"!==Object.prototype.toString.call(e))return this.reject(new TypeError("must be an array"));var n=e.length,i=!1;if(!n)return this.resolve([]);var s=new Array(n),a=0,t=-1,o=new this(u);for(;++t<n;)h(e[t],t);return o;function h(e,t){r.resolve(e).then(function(e){s[t]=e,++a!==n||i||(i=!0,l.resolve(o,s));},function(e){i||(i=!0,l.reject(o,e));});}},o.race=function(e){var t=this;if("[object Array]"!==Object.prototype.toString.call(e))return this.reject(new TypeError("must be an array"));var r=e.length,n=!1;if(!r)return this.resolve([]);var i=-1,s=new this(u);for(;++i<r;)a=e[i],t.resolve(a).then(function(e){n||(n=!0,l.resolve(s,e));},function(e){n||(n=!0,l.reject(s,e));});var a;return s};},{immediate:36}],38:[function(e,t,r){var n={};(0, e("./lib/utils/common").assign)(n,e("./lib/deflate"),e("./lib/inflate"),e("./lib/zlib/constants")),t.exports=n;},{"./lib/deflate":39,"./lib/inflate":40,"./lib/utils/common":41,"./lib/zlib/constants":44}],39:[function(e,t,r){var a=e("./zlib/deflate"),o=e("./utils/common"),h=e("./utils/strings"),i=e("./zlib/messages"),s=e("./zlib/zstream"),u=Object.prototype.toString,l=0,f=-1,c=0,d=8;function p(e){if(!(this instanceof p))return new p(e);this.options=o.assign({level:f,method:d,chunkSize:16384,windowBits:15,memLevel:8,strategy:c,to:""},e||{});var t=this.options;t.raw&&0<t.windowBits?t.windowBits=-t.windowBits:t.gzip&&0<t.windowBits&&t.windowBits<16&&(t.windowBits+=16),this.err=0,this.msg="",this.ended=!1,this.chunks=[],this.strm=new s,this.strm.avail_out=0;var r=a.deflateInit2(this.strm,t.level,t.method,t.windowBits,t.memLevel,t.strategy);if(r!==l)throw new Error(i[r]);if(t.header&&a.deflateSetHeader(this.strm,t.header),t.dictionary){var n;if(n="string"==typeof t.dictionary?h.string2buf(t.dictionary):"[object ArrayBuffer]"===u.call(t.dictionary)?new Uint8Array(t.dictionary):t.dictionary,(r=a.deflateSetDictionary(this.strm,n))!==l)throw new Error(i[r]);this._dict_set=!0;}}function n(e,t){var r=new p(t);if(r.push(e,!0),r.err)throw r.msg||i[r.err];return r.result}p.prototype.push=function(e,t){var r,n,i=this.strm,s=this.options.chunkSize;if(this.ended)return !1;n=t===~~t?t:!0===t?4:0,"string"==typeof e?i.input=h.string2buf(e):"[object ArrayBuffer]"===u.call(e)?i.input=new Uint8Array(e):i.input=e,i.next_in=0,i.avail_in=i.input.length;do{if(0===i.avail_out&&(i.output=new o.Buf8(s),i.next_out=0,i.avail_out=s),1!==(r=a.deflate(i,n))&&r!==l)return this.onEnd(r),!(this.ended=!0);0!==i.avail_out&&(0!==i.avail_in||4!==n&&2!==n)||("string"===this.options.to?this.onData(h.buf2binstring(o.shrinkBuf(i.output,i.next_out))):this.onData(o.shrinkBuf(i.output,i.next_out)));}while((0<i.avail_in||0===i.avail_out)&&1!==r);return 4===n?(r=a.deflateEnd(this.strm),this.onEnd(r),this.ended=!0,r===l):2!==n||(this.onEnd(l),!(i.avail_out=0))},p.prototype.onData=function(e){this.chunks.push(e);},p.prototype.onEnd=function(e){e===l&&("string"===this.options.to?this.result=this.chunks.join(""):this.result=o.flattenChunks(this.chunks)),this.chunks=[],this.err=e,this.msg=this.strm.msg;},r.Deflate=p,r.deflate=n,r.deflateRaw=function(e,t){return (t=t||{}).raw=!0,n(e,t)},r.gzip=function(e,t){return (t=t||{}).gzip=!0,n(e,t)};},{"./utils/common":41,"./utils/strings":42,"./zlib/deflate":46,"./zlib/messages":51,"./zlib/zstream":53}],40:[function(e,t,r){var c=e("./zlib/inflate"),d=e("./utils/common"),p=e("./utils/strings"),m=e("./zlib/constants"),n=e("./zlib/messages"),i=e("./zlib/zstream"),s=e("./zlib/gzheader"),_=Object.prototype.toString;function a(e){if(!(this instanceof a))return new a(e);this.options=d.assign({chunkSize:16384,windowBits:0,to:""},e||{});var t=this.options;t.raw&&0<=t.windowBits&&t.windowBits<16&&(t.windowBits=-t.windowBits,0===t.windowBits&&(t.windowBits=-15)),!(0<=t.windowBits&&t.windowBits<16)||e&&e.windowBits||(t.windowBits+=32),15<t.windowBits&&t.windowBits<48&&0==(15&t.windowBits)&&(t.windowBits|=15),this.err=0,this.msg="",this.ended=!1,this.chunks=[],this.strm=new i,this.strm.avail_out=0;var r=c.inflateInit2(this.strm,t.windowBits);if(r!==m.Z_OK)throw new Error(n[r]);this.header=new s,c.inflateGetHeader(this.strm,this.header);}function o(e,t){var r=new a(t);if(r.push(e,!0),r.err)throw r.msg||n[r.err];return r.result}a.prototype.push=function(e,t){var r,n,i,s,a,o,h=this.strm,u=this.options.chunkSize,l=this.options.dictionary,f=!1;if(this.ended)return !1;n=t===~~t?t:!0===t?m.Z_FINISH:m.Z_NO_FLUSH,"string"==typeof e?h.input=p.binstring2buf(e):"[object ArrayBuffer]"===_.call(e)?h.input=new Uint8Array(e):h.input=e,h.next_in=0,h.avail_in=h.input.length;do{if(0===h.avail_out&&(h.output=new d.Buf8(u),h.next_out=0,h.avail_out=u),(r=c.inflate(h,m.Z_NO_FLUSH))===m.Z_NEED_DICT&&l&&(o="string"==typeof l?p.string2buf(l):"[object ArrayBuffer]"===_.call(l)?new Uint8Array(l):l,r=c.inflateSetDictionary(this.strm,o)),r===m.Z_BUF_ERROR&&!0===f&&(r=m.Z_OK,f=!1),r!==m.Z_STREAM_END&&r!==m.Z_OK)return this.onEnd(r),!(this.ended=!0);h.next_out&&(0!==h.avail_out&&r!==m.Z_STREAM_END&&(0!==h.avail_in||n!==m.Z_FINISH&&n!==m.Z_SYNC_FLUSH)||("string"===this.options.to?(i=p.utf8border(h.output,h.next_out),s=h.next_out-i,a=p.buf2string(h.output,i),h.next_out=s,h.avail_out=u-s,s&&d.arraySet(h.output,h.output,i,s,0),this.onData(a)):this.onData(d.shrinkBuf(h.output,h.next_out)))),0===h.avail_in&&0===h.avail_out&&(f=!0);}while((0<h.avail_in||0===h.avail_out)&&r!==m.Z_STREAM_END);return r===m.Z_STREAM_END&&(n=m.Z_FINISH),n===m.Z_FINISH?(r=c.inflateEnd(this.strm),this.onEnd(r),this.ended=!0,r===m.Z_OK):n!==m.Z_SYNC_FLUSH||(this.onEnd(m.Z_OK),!(h.avail_out=0))},a.prototype.onData=function(e){this.chunks.push(e);},a.prototype.onEnd=function(e){e===m.Z_OK&&("string"===this.options.to?this.result=this.chunks.join(""):this.result=d.flattenChunks(this.chunks)),this.chunks=[],this.err=e,this.msg=this.strm.msg;},r.Inflate=a,r.inflate=o,r.inflateRaw=function(e,t){return (t=t||{}).raw=!0,o(e,t)},r.ungzip=o;},{"./utils/common":41,"./utils/strings":42,"./zlib/constants":44,"./zlib/gzheader":47,"./zlib/inflate":49,"./zlib/messages":51,"./zlib/zstream":53}],41:[function(e,t,r){var n="undefined"!=typeof Uint8Array&&"undefined"!=typeof Uint16Array&&"undefined"!=typeof Int32Array;r.assign=function(e){for(var t=Array.prototype.slice.call(arguments,1);t.length;){var r=t.shift();if(r){if("object"!=typeof r)throw new TypeError(r+"must be non-object");for(var n in r)r.hasOwnProperty(n)&&(e[n]=r[n]);}}return e},r.shrinkBuf=function(e,t){return e.length===t?e:e.subarray?e.subarray(0,t):(e.length=t,e)};var i={arraySet:function(e,t,r,n,i){if(t.subarray&&e.subarray)e.set(t.subarray(r,r+n),i);else for(var s=0;s<n;s++)e[i+s]=t[r+s];},flattenChunks:function(e){var t,r,n,i,s,a;for(t=n=0,r=e.length;t<r;t++)n+=e[t].length;for(a=new Uint8Array(n),t=i=0,r=e.length;t<r;t++)s=e[t],a.set(s,i),i+=s.length;return a}},s={arraySet:function(e,t,r,n,i){for(var s=0;s<n;s++)e[i+s]=t[r+s];},flattenChunks:function(e){return [].concat.apply([],e)}};r.setTyped=function(e){e?(r.Buf8=Uint8Array,r.Buf16=Uint16Array,r.Buf32=Int32Array,r.assign(r,i)):(r.Buf8=Array,r.Buf16=Array,r.Buf32=Array,r.assign(r,s));},r.setTyped(n);},{}],42:[function(e,t,r){var h=e("./common"),i=!0,s=!0;try{String.fromCharCode.apply(null,[0]);}catch(e){i=!1;}try{String.fromCharCode.apply(null,new Uint8Array(1));}catch(e){s=!1;}for(var u=new h.Buf8(256),n=0;n<256;n++)u[n]=252<=n?6:248<=n?5:240<=n?4:224<=n?3:192<=n?2:1;function l(e,t){if(t<65537&&(e.subarray&&s||!e.subarray&&i))return String.fromCharCode.apply(null,h.shrinkBuf(e,t));for(var r="",n=0;n<t;n++)r+=String.fromCharCode(e[n]);return r}u[254]=u[254]=1,r.string2buf=function(e){var t,r,n,i,s,a=e.length,o=0;for(i=0;i<a;i++)55296==(64512&(r=e.charCodeAt(i)))&&i+1<a&&56320==(64512&(n=e.charCodeAt(i+1)))&&(r=65536+(r-55296<<10)+(n-56320),i++),o+=r<128?1:r<2048?2:r<65536?3:4;for(t=new h.Buf8(o),i=s=0;s<o;i++)55296==(64512&(r=e.charCodeAt(i)))&&i+1<a&&56320==(64512&(n=e.charCodeAt(i+1)))&&(r=65536+(r-55296<<10)+(n-56320),i++),r<128?t[s++]=r:(r<2048?t[s++]=192|r>>>6:(r<65536?t[s++]=224|r>>>12:(t[s++]=240|r>>>18,t[s++]=128|r>>>12&63),t[s++]=128|r>>>6&63),t[s++]=128|63&r);return t},r.buf2binstring=function(e){return l(e,e.length)},r.binstring2buf=function(e){for(var t=new h.Buf8(e.length),r=0,n=t.length;r<n;r++)t[r]=e.charCodeAt(r);return t},r.buf2string=function(e,t){var r,n,i,s,a=t||e.length,o=new Array(2*a);for(r=n=0;r<a;)if((i=e[r++])<128)o[n++]=i;else if(4<(s=u[i]))o[n++]=65533,r+=s-1;else {for(i&=2===s?31:3===s?15:7;1<s&&r<a;)i=i<<6|63&e[r++],s--;1<s?o[n++]=65533:i<65536?o[n++]=i:(i-=65536,o[n++]=55296|i>>10&1023,o[n++]=56320|1023&i);}return l(o,n)},r.utf8border=function(e,t){var r;for((t=t||e.length)>e.length&&(t=e.length),r=t-1;0<=r&&128==(192&e[r]);)r--;return r<0?t:0===r?t:r+u[e[r]]>t?r:t};},{"./common":41}],43:[function(e,t,r){t.exports=function(e,t,r,n){for(var i=65535&e|0,s=e>>>16&65535|0,a=0;0!==r;){for(r-=a=2e3<r?2e3:r;s=s+(i=i+t[n++]|0)|0,--a;);i%=65521,s%=65521;}return i|s<<16|0};},{}],44:[function(e,t,r){t.exports={Z_NO_FLUSH:0,Z_PARTIAL_FLUSH:1,Z_SYNC_FLUSH:2,Z_FULL_FLUSH:3,Z_FINISH:4,Z_BLOCK:5,Z_TREES:6,Z_OK:0,Z_STREAM_END:1,Z_NEED_DICT:2,Z_ERRNO:-1,Z_STREAM_ERROR:-2,Z_DATA_ERROR:-3,Z_BUF_ERROR:-5,Z_NO_COMPRESSION:0,Z_BEST_SPEED:1,Z_BEST_COMPRESSION:9,Z_DEFAULT_COMPRESSION:-1,Z_FILTERED:1,Z_HUFFMAN_ONLY:2,Z_RLE:3,Z_FIXED:4,Z_DEFAULT_STRATEGY:0,Z_BINARY:0,Z_TEXT:1,Z_UNKNOWN:2,Z_DEFLATED:8};},{}],45:[function(e,t,r){var o=function(){for(var e,t=[],r=0;r<256;r++){e=r;for(var n=0;n<8;n++)e=1&e?3988292384^e>>>1:e>>>1;t[r]=e;}return t}();t.exports=function(e,t,r,n){var i=o,s=n+r;e^=-1;for(var a=n;a<s;a++)e=e>>>8^i[255&(e^t[a])];return -1^e};},{}],46:[function(e,t,r){var h,c=e("../utils/common"),u=e("./trees"),d=e("./adler32"),p=e("./crc32"),n=e("./messages"),l=0,f=4,m=0,_=-2,g=-1,b=4,i=2,v=8,y=9,s=286,a=30,o=19,w=2*s+1,k=15,x=3,S=258,z=S+x+1,C=42,E=113,A=1,I=2,O=3,B=4;function R(e,t){return e.msg=n[t],t}function T(e){return (e<<1)-(4<e?9:0)}function D(e){for(var t=e.length;0<=--t;)e[t]=0;}function F(e){var t=e.state,r=t.pending;r>e.avail_out&&(r=e.avail_out),0!==r&&(c.arraySet(e.output,t.pending_buf,t.pending_out,r,e.next_out),e.next_out+=r,t.pending_out+=r,e.total_out+=r,e.avail_out-=r,t.pending-=r,0===t.pending&&(t.pending_out=0));}function N(e,t){u._tr_flush_block(e,0<=e.block_start?e.block_start:-1,e.strstart-e.block_start,t),e.block_start=e.strstart,F(e.strm);}function U(e,t){e.pending_buf[e.pending++]=t;}function P(e,t){e.pending_buf[e.pending++]=t>>>8&255,e.pending_buf[e.pending++]=255&t;}function L(e,t){var r,n,i=e.max_chain_length,s=e.strstart,a=e.prev_length,o=e.nice_match,h=e.strstart>e.w_size-z?e.strstart-(e.w_size-z):0,u=e.window,l=e.w_mask,f=e.prev,c=e.strstart+S,d=u[s+a-1],p=u[s+a];e.prev_length>=e.good_match&&(i>>=2),o>e.lookahead&&(o=e.lookahead);do{if(u[(r=t)+a]===p&&u[r+a-1]===d&&u[r]===u[s]&&u[++r]===u[s+1]){s+=2,r++;do{}while(u[++s]===u[++r]&&u[++s]===u[++r]&&u[++s]===u[++r]&&u[++s]===u[++r]&&u[++s]===u[++r]&&u[++s]===u[++r]&&u[++s]===u[++r]&&u[++s]===u[++r]&&s<c);if(n=S-(c-s),s=c-S,a<n){if(e.match_start=t,o<=(a=n))break;d=u[s+a-1],p=u[s+a];}}}while((t=f[t&l])>h&&0!=--i);return a<=e.lookahead?a:e.lookahead}function j(e){var t,r,n,i,s,a,o,h,u,l,f=e.w_size;do{if(i=e.window_size-e.lookahead-e.strstart,e.strstart>=f+(f-z)){for(c.arraySet(e.window,e.window,f,f,0),e.match_start-=f,e.strstart-=f,e.block_start-=f,t=r=e.hash_size;n=e.head[--t],e.head[t]=f<=n?n-f:0,--r;);for(t=r=f;n=e.prev[--t],e.prev[t]=f<=n?n-f:0,--r;);i+=f;}if(0===e.strm.avail_in)break;if(a=e.strm,o=e.window,h=e.strstart+e.lookahead,u=i,l=void 0,l=a.avail_in,u<l&&(l=u),r=0===l?0:(a.avail_in-=l,c.arraySet(o,a.input,a.next_in,l,h),1===a.state.wrap?a.adler=d(a.adler,o,l,h):2===a.state.wrap&&(a.adler=p(a.adler,o,l,h)),a.next_in+=l,a.total_in+=l,l),e.lookahead+=r,e.lookahead+e.insert>=x)for(s=e.strstart-e.insert,e.ins_h=e.window[s],e.ins_h=(e.ins_h<<e.hash_shift^e.window[s+1])&e.hash_mask;e.insert&&(e.ins_h=(e.ins_h<<e.hash_shift^e.window[s+x-1])&e.hash_mask,e.prev[s&e.w_mask]=e.head[e.ins_h],e.head[e.ins_h]=s,s++,e.insert--,!(e.lookahead+e.insert<x)););}while(e.lookahead<z&&0!==e.strm.avail_in)}function Z(e,t){for(var r,n;;){if(e.lookahead<z){if(j(e),e.lookahead<z&&t===l)return A;if(0===e.lookahead)break}if(r=0,e.lookahead>=x&&(e.ins_h=(e.ins_h<<e.hash_shift^e.window[e.strstart+x-1])&e.hash_mask,r=e.prev[e.strstart&e.w_mask]=e.head[e.ins_h],e.head[e.ins_h]=e.strstart),0!==r&&e.strstart-r<=e.w_size-z&&(e.match_length=L(e,r)),e.match_length>=x)if(n=u._tr_tally(e,e.strstart-e.match_start,e.match_length-x),e.lookahead-=e.match_length,e.match_length<=e.max_lazy_match&&e.lookahead>=x){for(e.match_length--;e.strstart++,e.ins_h=(e.ins_h<<e.hash_shift^e.window[e.strstart+x-1])&e.hash_mask,r=e.prev[e.strstart&e.w_mask]=e.head[e.ins_h],e.head[e.ins_h]=e.strstart,0!=--e.match_length;);e.strstart++;}else e.strstart+=e.match_length,e.match_length=0,e.ins_h=e.window[e.strstart],e.ins_h=(e.ins_h<<e.hash_shift^e.window[e.strstart+1])&e.hash_mask;else n=u._tr_tally(e,0,e.window[e.strstart]),e.lookahead--,e.strstart++;if(n&&(N(e,!1),0===e.strm.avail_out))return A}return e.insert=e.strstart<x-1?e.strstart:x-1,t===f?(N(e,!0),0===e.strm.avail_out?O:B):e.last_lit&&(N(e,!1),0===e.strm.avail_out)?A:I}function W(e,t){for(var r,n,i;;){if(e.lookahead<z){if(j(e),e.lookahead<z&&t===l)return A;if(0===e.lookahead)break}if(r=0,e.lookahead>=x&&(e.ins_h=(e.ins_h<<e.hash_shift^e.window[e.strstart+x-1])&e.hash_mask,r=e.prev[e.strstart&e.w_mask]=e.head[e.ins_h],e.head[e.ins_h]=e.strstart),e.prev_length=e.match_length,e.prev_match=e.match_start,e.match_length=x-1,0!==r&&e.prev_length<e.max_lazy_match&&e.strstart-r<=e.w_size-z&&(e.match_length=L(e,r),e.match_length<=5&&(1===e.strategy||e.match_length===x&&4096<e.strstart-e.match_start)&&(e.match_length=x-1)),e.prev_length>=x&&e.match_length<=e.prev_length){for(i=e.strstart+e.lookahead-x,n=u._tr_tally(e,e.strstart-1-e.prev_match,e.prev_length-x),e.lookahead-=e.prev_length-1,e.prev_length-=2;++e.strstart<=i&&(e.ins_h=(e.ins_h<<e.hash_shift^e.window[e.strstart+x-1])&e.hash_mask,r=e.prev[e.strstart&e.w_mask]=e.head[e.ins_h],e.head[e.ins_h]=e.strstart),0!=--e.prev_length;);if(e.match_available=0,e.match_length=x-1,e.strstart++,n&&(N(e,!1),0===e.strm.avail_out))return A}else if(e.match_available){if((n=u._tr_tally(e,0,e.window[e.strstart-1]))&&N(e,!1),e.strstart++,e.lookahead--,0===e.strm.avail_out)return A}else e.match_available=1,e.strstart++,e.lookahead--;}return e.match_available&&(n=u._tr_tally(e,0,e.window[e.strstart-1]),e.match_available=0),e.insert=e.strstart<x-1?e.strstart:x-1,t===f?(N(e,!0),0===e.strm.avail_out?O:B):e.last_lit&&(N(e,!1),0===e.strm.avail_out)?A:I}function M(e,t,r,n,i){this.good_length=e,this.max_lazy=t,this.nice_length=r,this.max_chain=n,this.func=i;}function H(){this.strm=null,this.status=0,this.pending_buf=null,this.pending_buf_size=0,this.pending_out=0,this.pending=0,this.wrap=0,this.gzhead=null,this.gzindex=0,this.method=v,this.last_flush=-1,this.w_size=0,this.w_bits=0,this.w_mask=0,this.window=null,this.window_size=0,this.prev=null,this.head=null,this.ins_h=0,this.hash_size=0,this.hash_bits=0,this.hash_mask=0,this.hash_shift=0,this.block_start=0,this.match_length=0,this.prev_match=0,this.match_available=0,this.strstart=0,this.match_start=0,this.lookahead=0,this.prev_length=0,this.max_chain_length=0,this.max_lazy_match=0,this.level=0,this.strategy=0,this.good_match=0,this.nice_match=0,this.dyn_ltree=new c.Buf16(2*w),this.dyn_dtree=new c.Buf16(2*(2*a+1)),this.bl_tree=new c.Buf16(2*(2*o+1)),D(this.dyn_ltree),D(this.dyn_dtree),D(this.bl_tree),this.l_desc=null,this.d_desc=null,this.bl_desc=null,this.bl_count=new c.Buf16(k+1),this.heap=new c.Buf16(2*s+1),D(this.heap),this.heap_len=0,this.heap_max=0,this.depth=new c.Buf16(2*s+1),D(this.depth),this.l_buf=0,this.lit_bufsize=0,this.last_lit=0,this.d_buf=0,this.opt_len=0,this.static_len=0,this.matches=0,this.insert=0,this.bi_buf=0,this.bi_valid=0;}function G(e){var t;return e&&e.state?(e.total_in=e.total_out=0,e.data_type=i,(t=e.state).pending=0,t.pending_out=0,t.wrap<0&&(t.wrap=-t.wrap),t.status=t.wrap?C:E,e.adler=2===t.wrap?0:1,t.last_flush=l,u._tr_init(t),m):R(e,_)}function K(e){var t=G(e);return t===m&&function(e){e.window_size=2*e.w_size,D(e.head),e.max_lazy_match=h[e.level].max_lazy,e.good_match=h[e.level].good_length,e.nice_match=h[e.level].nice_length,e.max_chain_length=h[e.level].max_chain,e.strstart=0,e.block_start=0,e.lookahead=0,e.insert=0,e.match_length=e.prev_length=x-1,e.match_available=0,e.ins_h=0;}(e.state),t}function Y(e,t,r,n,i,s){if(!e)return _;var a=1;if(t===g&&(t=6),n<0?(a=0,n=-n):15<n&&(a=2,n-=16),i<1||y<i||r!==v||n<8||15<n||t<0||9<t||s<0||b<s)return R(e,_);8===n&&(n=9);var o=new H;return (e.state=o).strm=e,o.wrap=a,o.gzhead=null,o.w_bits=n,o.w_size=1<<o.w_bits,o.w_mask=o.w_size-1,o.hash_bits=i+7,o.hash_size=1<<o.hash_bits,o.hash_mask=o.hash_size-1,o.hash_shift=~~((o.hash_bits+x-1)/x),o.window=new c.Buf8(2*o.w_size),o.head=new c.Buf16(o.hash_size),o.prev=new c.Buf16(o.w_size),o.lit_bufsize=1<<i+6,o.pending_buf_size=4*o.lit_bufsize,o.pending_buf=new c.Buf8(o.pending_buf_size),o.d_buf=1*o.lit_bufsize,o.l_buf=3*o.lit_bufsize,o.level=t,o.strategy=s,o.method=r,K(e)}h=[new M(0,0,0,0,function(e,t){var r=65535;for(r>e.pending_buf_size-5&&(r=e.pending_buf_size-5);;){if(e.lookahead<=1){if(j(e),0===e.lookahead&&t===l)return A;if(0===e.lookahead)break}e.strstart+=e.lookahead,e.lookahead=0;var n=e.block_start+r;if((0===e.strstart||e.strstart>=n)&&(e.lookahead=e.strstart-n,e.strstart=n,N(e,!1),0===e.strm.avail_out))return A;if(e.strstart-e.block_start>=e.w_size-z&&(N(e,!1),0===e.strm.avail_out))return A}return e.insert=0,t===f?(N(e,!0),0===e.strm.avail_out?O:B):(e.strstart>e.block_start&&(N(e,!1),e.strm.avail_out),A)}),new M(4,4,8,4,Z),new M(4,5,16,8,Z),new M(4,6,32,32,Z),new M(4,4,16,16,W),new M(8,16,32,32,W),new M(8,16,128,128,W),new M(8,32,128,256,W),new M(32,128,258,1024,W),new M(32,258,258,4096,W)],r.deflateInit=function(e,t){return Y(e,t,v,15,8,0)},r.deflateInit2=Y,r.deflateReset=K,r.deflateResetKeep=G,r.deflateSetHeader=function(e,t){return e&&e.state?2!==e.state.wrap?_:(e.state.gzhead=t,m):_},r.deflate=function(e,t){var r,n,i,s;if(!e||!e.state||5<t||t<0)return e?R(e,_):_;if(n=e.state,!e.output||!e.input&&0!==e.avail_in||666===n.status&&t!==f)return R(e,0===e.avail_out?-5:_);if(n.strm=e,r=n.last_flush,n.last_flush=t,n.status===C)if(2===n.wrap)e.adler=0,U(n,31),U(n,139),U(n,8),n.gzhead?(U(n,(n.gzhead.text?1:0)+(n.gzhead.hcrc?2:0)+(n.gzhead.extra?4:0)+(n.gzhead.name?8:0)+(n.gzhead.comment?16:0)),U(n,255&n.gzhead.time),U(n,n.gzhead.time>>8&255),U(n,n.gzhead.time>>16&255),U(n,n.gzhead.time>>24&255),U(n,9===n.level?2:2<=n.strategy||n.level<2?4:0),U(n,255&n.gzhead.os),n.gzhead.extra&&n.gzhead.extra.length&&(U(n,255&n.gzhead.extra.length),U(n,n.gzhead.extra.length>>8&255)),n.gzhead.hcrc&&(e.adler=p(e.adler,n.pending_buf,n.pending,0)),n.gzindex=0,n.status=69):(U(n,0),U(n,0),U(n,0),U(n,0),U(n,0),U(n,9===n.level?2:2<=n.strategy||n.level<2?4:0),U(n,3),n.status=E);else {var a=v+(n.w_bits-8<<4)<<8;a|=(2<=n.strategy||n.level<2?0:n.level<6?1:6===n.level?2:3)<<6,0!==n.strstart&&(a|=32),a+=31-a%31,n.status=E,P(n,a),0!==n.strstart&&(P(n,e.adler>>>16),P(n,65535&e.adler)),e.adler=1;}if(69===n.status)if(n.gzhead.extra){for(i=n.pending;n.gzindex<(65535&n.gzhead.extra.length)&&(n.pending!==n.pending_buf_size||(n.gzhead.hcrc&&n.pending>i&&(e.adler=p(e.adler,n.pending_buf,n.pending-i,i)),F(e),i=n.pending,n.pending!==n.pending_buf_size));)U(n,255&n.gzhead.extra[n.gzindex]),n.gzindex++;n.gzhead.hcrc&&n.pending>i&&(e.adler=p(e.adler,n.pending_buf,n.pending-i,i)),n.gzindex===n.gzhead.extra.length&&(n.gzindex=0,n.status=73);}else n.status=73;if(73===n.status)if(n.gzhead.name){i=n.pending;do{if(n.pending===n.pending_buf_size&&(n.gzhead.hcrc&&n.pending>i&&(e.adler=p(e.adler,n.pending_buf,n.pending-i,i)),F(e),i=n.pending,n.pending===n.pending_buf_size)){s=1;break}s=n.gzindex<n.gzhead.name.length?255&n.gzhead.name.charCodeAt(n.gzindex++):0,U(n,s);}while(0!==s);n.gzhead.hcrc&&n.pending>i&&(e.adler=p(e.adler,n.pending_buf,n.pending-i,i)),0===s&&(n.gzindex=0,n.status=91);}else n.status=91;if(91===n.status)if(n.gzhead.comment){i=n.pending;do{if(n.pending===n.pending_buf_size&&(n.gzhead.hcrc&&n.pending>i&&(e.adler=p(e.adler,n.pending_buf,n.pending-i,i)),F(e),i=n.pending,n.pending===n.pending_buf_size)){s=1;break}s=n.gzindex<n.gzhead.comment.length?255&n.gzhead.comment.charCodeAt(n.gzindex++):0,U(n,s);}while(0!==s);n.gzhead.hcrc&&n.pending>i&&(e.adler=p(e.adler,n.pending_buf,n.pending-i,i)),0===s&&(n.status=103);}else n.status=103;if(103===n.status&&(n.gzhead.hcrc?(n.pending+2>n.pending_buf_size&&F(e),n.pending+2<=n.pending_buf_size&&(U(n,255&e.adler),U(n,e.adler>>8&255),e.adler=0,n.status=E)):n.status=E),0!==n.pending){if(F(e),0===e.avail_out)return n.last_flush=-1,m}else if(0===e.avail_in&&T(t)<=T(r)&&t!==f)return R(e,-5);if(666===n.status&&0!==e.avail_in)return R(e,-5);if(0!==e.avail_in||0!==n.lookahead||t!==l&&666!==n.status){var o=2===n.strategy?function(e,t){for(var r;;){if(0===e.lookahead&&(j(e),0===e.lookahead)){if(t===l)return A;break}if(e.match_length=0,r=u._tr_tally(e,0,e.window[e.strstart]),e.lookahead--,e.strstart++,r&&(N(e,!1),0===e.strm.avail_out))return A}return e.insert=0,t===f?(N(e,!0),0===e.strm.avail_out?O:B):e.last_lit&&(N(e,!1),0===e.strm.avail_out)?A:I}(n,t):3===n.strategy?function(e,t){for(var r,n,i,s,a=e.window;;){if(e.lookahead<=S){if(j(e),e.lookahead<=S&&t===l)return A;if(0===e.lookahead)break}if(e.match_length=0,e.lookahead>=x&&0<e.strstart&&(n=a[i=e.strstart-1])===a[++i]&&n===a[++i]&&n===a[++i]){s=e.strstart+S;do{}while(n===a[++i]&&n===a[++i]&&n===a[++i]&&n===a[++i]&&n===a[++i]&&n===a[++i]&&n===a[++i]&&n===a[++i]&&i<s);e.match_length=S-(s-i),e.match_length>e.lookahead&&(e.match_length=e.lookahead);}if(e.match_length>=x?(r=u._tr_tally(e,1,e.match_length-x),e.lookahead-=e.match_length,e.strstart+=e.match_length,e.match_length=0):(r=u._tr_tally(e,0,e.window[e.strstart]),e.lookahead--,e.strstart++),r&&(N(e,!1),0===e.strm.avail_out))return A}return e.insert=0,t===f?(N(e,!0),0===e.strm.avail_out?O:B):e.last_lit&&(N(e,!1),0===e.strm.avail_out)?A:I}(n,t):h[n.level].func(n,t);if(o!==O&&o!==B||(n.status=666),o===A||o===O)return 0===e.avail_out&&(n.last_flush=-1),m;if(o===I&&(1===t?u._tr_align(n):5!==t&&(u._tr_stored_block(n,0,0,!1),3===t&&(D(n.head),0===n.lookahead&&(n.strstart=0,n.block_start=0,n.insert=0))),F(e),0===e.avail_out))return n.last_flush=-1,m}return t!==f?m:n.wrap<=0?1:(2===n.wrap?(U(n,255&e.adler),U(n,e.adler>>8&255),U(n,e.adler>>16&255),U(n,e.adler>>24&255),U(n,255&e.total_in),U(n,e.total_in>>8&255),U(n,e.total_in>>16&255),U(n,e.total_in>>24&255)):(P(n,e.adler>>>16),P(n,65535&e.adler)),F(e),0<n.wrap&&(n.wrap=-n.wrap),0!==n.pending?m:1)},r.deflateEnd=function(e){var t;return e&&e.state?(t=e.state.status)!==C&&69!==t&&73!==t&&91!==t&&103!==t&&t!==E&&666!==t?R(e,_):(e.state=null,t===E?R(e,-3):m):_},r.deflateSetDictionary=function(e,t){var r,n,i,s,a,o,h,u,l=t.length;if(!e||!e.state)return _;if(2===(s=(r=e.state).wrap)||1===s&&r.status!==C||r.lookahead)return _;for(1===s&&(e.adler=d(e.adler,t,l,0)),r.wrap=0,l>=r.w_size&&(0===s&&(D(r.head),r.strstart=0,r.block_start=0,r.insert=0),u=new c.Buf8(r.w_size),c.arraySet(u,t,l-r.w_size,r.w_size,0),t=u,l=r.w_size),a=e.avail_in,o=e.next_in,h=e.input,e.avail_in=l,e.next_in=0,e.input=t,j(r);r.lookahead>=x;){for(n=r.strstart,i=r.lookahead-(x-1);r.ins_h=(r.ins_h<<r.hash_shift^r.window[n+x-1])&r.hash_mask,r.prev[n&r.w_mask]=r.head[r.ins_h],r.head[r.ins_h]=n,n++,--i;);r.strstart=n,r.lookahead=x-1,j(r);}return r.strstart+=r.lookahead,r.block_start=r.strstart,r.insert=r.lookahead,r.lookahead=0,r.match_length=r.prev_length=x-1,r.match_available=0,e.next_in=o,e.input=h,e.avail_in=a,r.wrap=s,m},r.deflateInfo="pako deflate (from Nodeca project)";},{"../utils/common":41,"./adler32":43,"./crc32":45,"./messages":51,"./trees":52}],47:[function(e,t,r){t.exports=function(){this.text=0,this.time=0,this.xflags=0,this.os=0,this.extra=null,this.extra_len=0,this.name="",this.comment="",this.hcrc=0,this.done=!1;};},{}],48:[function(e,t,r){t.exports=function(e,t){var r,n,i,s,a,o,h,u,l,f,c,d,p,m,_,g,b,v,y,w,k,x,S,z,C;r=e.state,n=e.next_in,z=e.input,i=n+(e.avail_in-5),s=e.next_out,C=e.output,a=s-(t-e.avail_out),o=s+(e.avail_out-257),h=r.dmax,u=r.wsize,l=r.whave,f=r.wnext,c=r.window,d=r.hold,p=r.bits,m=r.lencode,_=r.distcode,g=(1<<r.lenbits)-1,b=(1<<r.distbits)-1;e:do{p<15&&(d+=z[n++]<<p,p+=8,d+=z[n++]<<p,p+=8),v=m[d&g];t:for(;;){if(d>>>=y=v>>>24,p-=y,0===(y=v>>>16&255))C[s++]=65535&v;else {if(!(16&y)){if(0==(64&y)){v=m[(65535&v)+(d&(1<<y)-1)];continue t}if(32&y){r.mode=12;break e}e.msg="invalid literal/length code",r.mode=30;break e}w=65535&v,(y&=15)&&(p<y&&(d+=z[n++]<<p,p+=8),w+=d&(1<<y)-1,d>>>=y,p-=y),p<15&&(d+=z[n++]<<p,p+=8,d+=z[n++]<<p,p+=8),v=_[d&b];r:for(;;){if(d>>>=y=v>>>24,p-=y,!(16&(y=v>>>16&255))){if(0==(64&y)){v=_[(65535&v)+(d&(1<<y)-1)];continue r}e.msg="invalid distance code",r.mode=30;break e}if(k=65535&v,p<(y&=15)&&(d+=z[n++]<<p,(p+=8)<y&&(d+=z[n++]<<p,p+=8)),h<(k+=d&(1<<y)-1)){e.msg="invalid distance too far back",r.mode=30;break e}if(d>>>=y,p-=y,(y=s-a)<k){if(l<(y=k-y)&&r.sane){e.msg="invalid distance too far back",r.mode=30;break e}if(S=c,(x=0)===f){if(x+=u-y,y<w){for(w-=y;C[s++]=c[x++],--y;);x=s-k,S=C;}}else if(f<y){if(x+=u+f-y,(y-=f)<w){for(w-=y;C[s++]=c[x++],--y;);if(x=0,f<w){for(w-=y=f;C[s++]=c[x++],--y;);x=s-k,S=C;}}}else if(x+=f-y,y<w){for(w-=y;C[s++]=c[x++],--y;);x=s-k,S=C;}for(;2<w;)C[s++]=S[x++],C[s++]=S[x++],C[s++]=S[x++],w-=3;w&&(C[s++]=S[x++],1<w&&(C[s++]=S[x++]));}else {for(x=s-k;C[s++]=C[x++],C[s++]=C[x++],C[s++]=C[x++],2<(w-=3););w&&(C[s++]=C[x++],1<w&&(C[s++]=C[x++]));}break}}break}}while(n<i&&s<o);n-=w=p>>3,d&=(1<<(p-=w<<3))-1,e.next_in=n,e.next_out=s,e.avail_in=n<i?i-n+5:5-(n-i),e.avail_out=s<o?o-s+257:257-(s-o),r.hold=d,r.bits=p;};},{}],49:[function(e,t,r){var I=e("../utils/common"),O=e("./adler32"),B=e("./crc32"),R=e("./inffast"),T=e("./inftrees"),D=1,F=2,N=0,U=-2,P=1,n=852,i=592;function L(e){return (e>>>24&255)+(e>>>8&65280)+((65280&e)<<8)+((255&e)<<24)}function s(){this.mode=0,this.last=!1,this.wrap=0,this.havedict=!1,this.flags=0,this.dmax=0,this.check=0,this.total=0,this.head=null,this.wbits=0,this.wsize=0,this.whave=0,this.wnext=0,this.window=null,this.hold=0,this.bits=0,this.length=0,this.offset=0,this.extra=0,this.lencode=null,this.distcode=null,this.lenbits=0,this.distbits=0,this.ncode=0,this.nlen=0,this.ndist=0,this.have=0,this.next=null,this.lens=new I.Buf16(320),this.work=new I.Buf16(288),this.lendyn=null,this.distdyn=null,this.sane=0,this.back=0,this.was=0;}function a(e){var t;return e&&e.state?(t=e.state,e.total_in=e.total_out=t.total=0,e.msg="",t.wrap&&(e.adler=1&t.wrap),t.mode=P,t.last=0,t.havedict=0,t.dmax=32768,t.head=null,t.hold=0,t.bits=0,t.lencode=t.lendyn=new I.Buf32(n),t.distcode=t.distdyn=new I.Buf32(i),t.sane=1,t.back=-1,N):U}function o(e){var t;return e&&e.state?((t=e.state).wsize=0,t.whave=0,t.wnext=0,a(e)):U}function h(e,t){var r,n;return e&&e.state?(n=e.state,t<0?(r=0,t=-t):(r=1+(t>>4),t<48&&(t&=15)),t&&(t<8||15<t)?U:(null!==n.window&&n.wbits!==t&&(n.window=null),n.wrap=r,n.wbits=t,o(e))):U}function u(e,t){var r,n;return e?(n=new s,(e.state=n).window=null,(r=h(e,t))!==N&&(e.state=null),r):U}var l,f,c=!0;function j(e){if(c){var t;for(l=new I.Buf32(512),f=new I.Buf32(32),t=0;t<144;)e.lens[t++]=8;for(;t<256;)e.lens[t++]=9;for(;t<280;)e.lens[t++]=7;for(;t<288;)e.lens[t++]=8;for(T(D,e.lens,0,288,l,0,e.work,{bits:9}),t=0;t<32;)e.lens[t++]=5;T(F,e.lens,0,32,f,0,e.work,{bits:5}),c=!1;}e.lencode=l,e.lenbits=9,e.distcode=f,e.distbits=5;}function Z(e,t,r,n){var i,s=e.state;return null===s.window&&(s.wsize=1<<s.wbits,s.wnext=0,s.whave=0,s.window=new I.Buf8(s.wsize)),n>=s.wsize?(I.arraySet(s.window,t,r-s.wsize,s.wsize,0),s.wnext=0,s.whave=s.wsize):(n<(i=s.wsize-s.wnext)&&(i=n),I.arraySet(s.window,t,r-n,i,s.wnext),(n-=i)?(I.arraySet(s.window,t,r-n,n,0),s.wnext=n,s.whave=s.wsize):(s.wnext+=i,s.wnext===s.wsize&&(s.wnext=0),s.whave<s.wsize&&(s.whave+=i))),0}r.inflateReset=o,r.inflateReset2=h,r.inflateResetKeep=a,r.inflateInit=function(e){return u(e,15)},r.inflateInit2=u,r.inflate=function(e,t){var r,n,i,s,a,o,h,u,l,f,c,d,p,m,_,g,b,v,y,w,k,x,S,z,C=0,E=new I.Buf8(4),A=[16,17,18,0,8,7,9,6,10,5,11,4,12,3,13,2,14,1,15];if(!e||!e.state||!e.output||!e.input&&0!==e.avail_in)return U;12===(r=e.state).mode&&(r.mode=13),a=e.next_out,i=e.output,h=e.avail_out,s=e.next_in,n=e.input,o=e.avail_in,u=r.hold,l=r.bits,f=o,c=h,x=N;e:for(;;)switch(r.mode){case P:if(0===r.wrap){r.mode=13;break}for(;l<16;){if(0===o)break e;o--,u+=n[s++]<<l,l+=8;}if(2&r.wrap&&35615===u){E[r.check=0]=255&u,E[1]=u>>>8&255,r.check=B(r.check,E,2,0),l=u=0,r.mode=2;break}if(r.flags=0,r.head&&(r.head.done=!1),!(1&r.wrap)||(((255&u)<<8)+(u>>8))%31){e.msg="incorrect header check",r.mode=30;break}if(8!=(15&u)){e.msg="unknown compression method",r.mode=30;break}if(l-=4,k=8+(15&(u>>>=4)),0===r.wbits)r.wbits=k;else if(k>r.wbits){e.msg="invalid window size",r.mode=30;break}r.dmax=1<<k,e.adler=r.check=1,r.mode=512&u?10:12,l=u=0;break;case 2:for(;l<16;){if(0===o)break e;o--,u+=n[s++]<<l,l+=8;}if(r.flags=u,8!=(255&r.flags)){e.msg="unknown compression method",r.mode=30;break}if(57344&r.flags){e.msg="unknown header flags set",r.mode=30;break}r.head&&(r.head.text=u>>8&1),512&r.flags&&(E[0]=255&u,E[1]=u>>>8&255,r.check=B(r.check,E,2,0)),l=u=0,r.mode=3;case 3:for(;l<32;){if(0===o)break e;o--,u+=n[s++]<<l,l+=8;}r.head&&(r.head.time=u),512&r.flags&&(E[0]=255&u,E[1]=u>>>8&255,E[2]=u>>>16&255,E[3]=u>>>24&255,r.check=B(r.check,E,4,0)),l=u=0,r.mode=4;case 4:for(;l<16;){if(0===o)break e;o--,u+=n[s++]<<l,l+=8;}r.head&&(r.head.xflags=255&u,r.head.os=u>>8),512&r.flags&&(E[0]=255&u,E[1]=u>>>8&255,r.check=B(r.check,E,2,0)),l=u=0,r.mode=5;case 5:if(1024&r.flags){for(;l<16;){if(0===o)break e;o--,u+=n[s++]<<l,l+=8;}r.length=u,r.head&&(r.head.extra_len=u),512&r.flags&&(E[0]=255&u,E[1]=u>>>8&255,r.check=B(r.check,E,2,0)),l=u=0;}else r.head&&(r.head.extra=null);r.mode=6;case 6:if(1024&r.flags&&(o<(d=r.length)&&(d=o),d&&(r.head&&(k=r.head.extra_len-r.length,r.head.extra||(r.head.extra=new Array(r.head.extra_len)),I.arraySet(r.head.extra,n,s,d,k)),512&r.flags&&(r.check=B(r.check,n,d,s)),o-=d,s+=d,r.length-=d),r.length))break e;r.length=0,r.mode=7;case 7:if(2048&r.flags){if(0===o)break e;for(d=0;k=n[s+d++],r.head&&k&&r.length<65536&&(r.head.name+=String.fromCharCode(k)),k&&d<o;);if(512&r.flags&&(r.check=B(r.check,n,d,s)),o-=d,s+=d,k)break e}else r.head&&(r.head.name=null);r.length=0,r.mode=8;case 8:if(4096&r.flags){if(0===o)break e;for(d=0;k=n[s+d++],r.head&&k&&r.length<65536&&(r.head.comment+=String.fromCharCode(k)),k&&d<o;);if(512&r.flags&&(r.check=B(r.check,n,d,s)),o-=d,s+=d,k)break e}else r.head&&(r.head.comment=null);r.mode=9;case 9:if(512&r.flags){for(;l<16;){if(0===o)break e;o--,u+=n[s++]<<l,l+=8;}if(u!==(65535&r.check)){e.msg="header crc mismatch",r.mode=30;break}l=u=0;}r.head&&(r.head.hcrc=r.flags>>9&1,r.head.done=!0),e.adler=r.check=0,r.mode=12;break;case 10:for(;l<32;){if(0===o)break e;o--,u+=n[s++]<<l,l+=8;}e.adler=r.check=L(u),l=u=0,r.mode=11;case 11:if(0===r.havedict)return e.next_out=a,e.avail_out=h,e.next_in=s,e.avail_in=o,r.hold=u,r.bits=l,2;e.adler=r.check=1,r.mode=12;case 12:if(5===t||6===t)break e;case 13:if(r.last){u>>>=7&l,l-=7&l,r.mode=27;break}for(;l<3;){if(0===o)break e;o--,u+=n[s++]<<l,l+=8;}switch(r.last=1&u,l-=1,3&(u>>>=1)){case 0:r.mode=14;break;case 1:if(j(r),r.mode=20,6!==t)break;u>>>=2,l-=2;break e;case 2:r.mode=17;break;case 3:e.msg="invalid block type",r.mode=30;}u>>>=2,l-=2;break;case 14:for(u>>>=7&l,l-=7&l;l<32;){if(0===o)break e;o--,u+=n[s++]<<l,l+=8;}if((65535&u)!=(u>>>16^65535)){e.msg="invalid stored block lengths",r.mode=30;break}if(r.length=65535&u,l=u=0,r.mode=15,6===t)break e;case 15:r.mode=16;case 16:if(d=r.length){if(o<d&&(d=o),h<d&&(d=h),0===d)break e;I.arraySet(i,n,s,d,a),o-=d,s+=d,h-=d,a+=d,r.length-=d;break}r.mode=12;break;case 17:for(;l<14;){if(0===o)break e;o--,u+=n[s++]<<l,l+=8;}if(r.nlen=257+(31&u),u>>>=5,l-=5,r.ndist=1+(31&u),u>>>=5,l-=5,r.ncode=4+(15&u),u>>>=4,l-=4,286<r.nlen||30<r.ndist){e.msg="too many length or distance symbols",r.mode=30;break}r.have=0,r.mode=18;case 18:for(;r.have<r.ncode;){for(;l<3;){if(0===o)break e;o--,u+=n[s++]<<l,l+=8;}r.lens[A[r.have++]]=7&u,u>>>=3,l-=3;}for(;r.have<19;)r.lens[A[r.have++]]=0;if(r.lencode=r.lendyn,r.lenbits=7,S={bits:r.lenbits},x=T(0,r.lens,0,19,r.lencode,0,r.work,S),r.lenbits=S.bits,x){e.msg="invalid code lengths set",r.mode=30;break}r.have=0,r.mode=19;case 19:for(;r.have<r.nlen+r.ndist;){for(;g=(C=r.lencode[u&(1<<r.lenbits)-1])>>>16&255,b=65535&C,!((_=C>>>24)<=l);){if(0===o)break e;o--,u+=n[s++]<<l,l+=8;}if(b<16)u>>>=_,l-=_,r.lens[r.have++]=b;else {if(16===b){for(z=_+2;l<z;){if(0===o)break e;o--,u+=n[s++]<<l,l+=8;}if(u>>>=_,l-=_,0===r.have){e.msg="invalid bit length repeat",r.mode=30;break}k=r.lens[r.have-1],d=3+(3&u),u>>>=2,l-=2;}else if(17===b){for(z=_+3;l<z;){if(0===o)break e;o--,u+=n[s++]<<l,l+=8;}l-=_,k=0,d=3+(7&(u>>>=_)),u>>>=3,l-=3;}else {for(z=_+7;l<z;){if(0===o)break e;o--,u+=n[s++]<<l,l+=8;}l-=_,k=0,d=11+(127&(u>>>=_)),u>>>=7,l-=7;}if(r.have+d>r.nlen+r.ndist){e.msg="invalid bit length repeat",r.mode=30;break}for(;d--;)r.lens[r.have++]=k;}}if(30===r.mode)break;if(0===r.lens[256]){e.msg="invalid code -- missing end-of-block",r.mode=30;break}if(r.lenbits=9,S={bits:r.lenbits},x=T(D,r.lens,0,r.nlen,r.lencode,0,r.work,S),r.lenbits=S.bits,x){e.msg="invalid literal/lengths set",r.mode=30;break}if(r.distbits=6,r.distcode=r.distdyn,S={bits:r.distbits},x=T(F,r.lens,r.nlen,r.ndist,r.distcode,0,r.work,S),r.distbits=S.bits,x){e.msg="invalid distances set",r.mode=30;break}if(r.mode=20,6===t)break e;case 20:r.mode=21;case 21:if(6<=o&&258<=h){e.next_out=a,e.avail_out=h,e.next_in=s,e.avail_in=o,r.hold=u,r.bits=l,R(e,c),a=e.next_out,i=e.output,h=e.avail_out,s=e.next_in,n=e.input,o=e.avail_in,u=r.hold,l=r.bits,12===r.mode&&(r.back=-1);break}for(r.back=0;g=(C=r.lencode[u&(1<<r.lenbits)-1])>>>16&255,b=65535&C,!((_=C>>>24)<=l);){if(0===o)break e;o--,u+=n[s++]<<l,l+=8;}if(g&&0==(240&g)){for(v=_,y=g,w=b;g=(C=r.lencode[w+((u&(1<<v+y)-1)>>v)])>>>16&255,b=65535&C,!(v+(_=C>>>24)<=l);){if(0===o)break e;o--,u+=n[s++]<<l,l+=8;}u>>>=v,l-=v,r.back+=v;}if(u>>>=_,l-=_,r.back+=_,r.length=b,0===g){r.mode=26;break}if(32&g){r.back=-1,r.mode=12;break}if(64&g){e.msg="invalid literal/length code",r.mode=30;break}r.extra=15&g,r.mode=22;case 22:if(r.extra){for(z=r.extra;l<z;){if(0===o)break e;o--,u+=n[s++]<<l,l+=8;}r.length+=u&(1<<r.extra)-1,u>>>=r.extra,l-=r.extra,r.back+=r.extra;}r.was=r.length,r.mode=23;case 23:for(;g=(C=r.distcode[u&(1<<r.distbits)-1])>>>16&255,b=65535&C,!((_=C>>>24)<=l);){if(0===o)break e;o--,u+=n[s++]<<l,l+=8;}if(0==(240&g)){for(v=_,y=g,w=b;g=(C=r.distcode[w+((u&(1<<v+y)-1)>>v)])>>>16&255,b=65535&C,!(v+(_=C>>>24)<=l);){if(0===o)break e;o--,u+=n[s++]<<l,l+=8;}u>>>=v,l-=v,r.back+=v;}if(u>>>=_,l-=_,r.back+=_,64&g){e.msg="invalid distance code",r.mode=30;break}r.offset=b,r.extra=15&g,r.mode=24;case 24:if(r.extra){for(z=r.extra;l<z;){if(0===o)break e;o--,u+=n[s++]<<l,l+=8;}r.offset+=u&(1<<r.extra)-1,u>>>=r.extra,l-=r.extra,r.back+=r.extra;}if(r.offset>r.dmax){e.msg="invalid distance too far back",r.mode=30;break}r.mode=25;case 25:if(0===h)break e;if(d=c-h,r.offset>d){if((d=r.offset-d)>r.whave&&r.sane){e.msg="invalid distance too far back",r.mode=30;break}p=d>r.wnext?(d-=r.wnext,r.wsize-d):r.wnext-d,d>r.length&&(d=r.length),m=r.window;}else m=i,p=a-r.offset,d=r.length;for(h<d&&(d=h),h-=d,r.length-=d;i[a++]=m[p++],--d;);0===r.length&&(r.mode=21);break;case 26:if(0===h)break e;i[a++]=r.length,h--,r.mode=21;break;case 27:if(r.wrap){for(;l<32;){if(0===o)break e;o--,u|=n[s++]<<l,l+=8;}if(c-=h,e.total_out+=c,r.total+=c,c&&(e.adler=r.check=r.flags?B(r.check,i,c,a-c):O(r.check,i,c,a-c)),c=h,(r.flags?u:L(u))!==r.check){e.msg="incorrect data check",r.mode=30;break}l=u=0;}r.mode=28;case 28:if(r.wrap&&r.flags){for(;l<32;){if(0===o)break e;o--,u+=n[s++]<<l,l+=8;}if(u!==(4294967295&r.total)){e.msg="incorrect length check",r.mode=30;break}l=u=0;}r.mode=29;case 29:x=1;break e;case 30:x=-3;break e;case 31:return -4;case 32:default:return U}return e.next_out=a,e.avail_out=h,e.next_in=s,e.avail_in=o,r.hold=u,r.bits=l,(r.wsize||c!==e.avail_out&&r.mode<30&&(r.mode<27||4!==t))&&Z(e,e.output,e.next_out,c-e.avail_out)?(r.mode=31,-4):(f-=e.avail_in,c-=e.avail_out,e.total_in+=f,e.total_out+=c,r.total+=c,r.wrap&&c&&(e.adler=r.check=r.flags?B(r.check,i,c,e.next_out-c):O(r.check,i,c,e.next_out-c)),e.data_type=r.bits+(r.last?64:0)+(12===r.mode?128:0)+(20===r.mode||15===r.mode?256:0),(0==f&&0===c||4===t)&&x===N&&(x=-5),x)},r.inflateEnd=function(e){if(!e||!e.state)return U;var t=e.state;return t.window&&(t.window=null),e.state=null,N},r.inflateGetHeader=function(e,t){var r;return e&&e.state?0==(2&(r=e.state).wrap)?U:((r.head=t).done=!1,N):U},r.inflateSetDictionary=function(e,t){var r,n=t.length;return e&&e.state?0!==(r=e.state).wrap&&11!==r.mode?U:11===r.mode&&O(1,t,n,0)!==r.check?-3:Z(e,t,n,n)?(r.mode=31,-4):(r.havedict=1,N):U},r.inflateInfo="pako inflate (from Nodeca project)";},{"../utils/common":41,"./adler32":43,"./crc32":45,"./inffast":48,"./inftrees":50}],50:[function(e,t,r){var D=e("../utils/common"),F=[3,4,5,6,7,8,9,10,11,13,15,17,19,23,27,31,35,43,51,59,67,83,99,115,131,163,195,227,258,0,0],N=[16,16,16,16,16,16,16,16,17,17,17,17,18,18,18,18,19,19,19,19,20,20,20,20,21,21,21,21,16,72,78],U=[1,2,3,4,5,7,9,13,17,25,33,49,65,97,129,193,257,385,513,769,1025,1537,2049,3073,4097,6145,8193,12289,16385,24577,0,0],P=[16,16,16,16,17,17,18,18,19,19,20,20,21,21,22,22,23,23,24,24,25,25,26,26,27,27,28,28,29,29,64,64];t.exports=function(e,t,r,n,i,s,a,o){var h,u,l,f,c,d,p,m,_,g=o.bits,b=0,v=0,y=0,w=0,k=0,x=0,S=0,z=0,C=0,E=0,A=null,I=0,O=new D.Buf16(16),B=new D.Buf16(16),R=null,T=0;for(b=0;b<=15;b++)O[b]=0;for(v=0;v<n;v++)O[t[r+v]]++;for(k=g,w=15;1<=w&&0===O[w];w--);if(w<k&&(k=w),0===w)return i[s++]=20971520,i[s++]=20971520,o.bits=1,0;for(y=1;y<w&&0===O[y];y++);for(k<y&&(k=y),b=z=1;b<=15;b++)if(z<<=1,(z-=O[b])<0)return -1;if(0<z&&(0===e||1!==w))return -1;for(B[1]=0,b=1;b<15;b++)B[b+1]=B[b]+O[b];for(v=0;v<n;v++)0!==t[r+v]&&(a[B[t[r+v]]++]=v);if(d=0===e?(A=R=a,19):1===e?(A=F,I-=257,R=N,T-=257,256):(A=U,R=P,-1),b=y,c=s,S=v=E=0,l=-1,f=(C=1<<(x=k))-1,1===e&&852<C||2===e&&592<C)return 1;for(;;){for(p=b-S,_=a[v]<d?(m=0,a[v]):a[v]>d?(m=R[T+a[v]],A[I+a[v]]):(m=96,0),h=1<<b-S,y=u=1<<x;i[c+(E>>S)+(u-=h)]=p<<24|m<<16|_|0,0!==u;);for(h=1<<b-1;E&h;)h>>=1;if(0!==h?(E&=h-1,E+=h):E=0,v++,0==--O[b]){if(b===w)break;b=t[r+a[v]];}if(k<b&&(E&f)!==l){for(0===S&&(S=k),c+=y,z=1<<(x=b-S);x+S<w&&!((z-=O[x+S])<=0);)x++,z<<=1;if(C+=1<<x,1===e&&852<C||2===e&&592<C)return 1;i[l=E&f]=k<<24|x<<16|c-s|0;}}return 0!==E&&(i[c+E]=b-S<<24|64<<16|0),o.bits=k,0};},{"../utils/common":41}],51:[function(e,t,r){t.exports={2:"need dictionary",1:"stream end",0:"","-1":"file error","-2":"stream error","-3":"data error","-4":"insufficient memory","-5":"buffer error","-6":"incompatible version"};},{}],52:[function(e,t,r){var i=e("../utils/common"),o=0,h=1;function n(e){for(var t=e.length;0<=--t;)e[t]=0;}var s=0,a=29,u=256,l=u+1+a,f=30,c=19,_=2*l+1,g=15,d=16,p=7,m=256,b=16,v=17,y=18,w=[0,0,0,0,0,0,0,0,1,1,1,1,2,2,2,2,3,3,3,3,4,4,4,4,5,5,5,5,0],k=[0,0,0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13],x=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,3,7],S=[16,17,18,0,8,7,9,6,10,5,11,4,12,3,13,2,14,1,15],z=new Array(2*(l+2));n(z);var C=new Array(2*f);n(C);var E=new Array(512);n(E);var A=new Array(256);n(A);var I=new Array(a);n(I);var O,B,R,T=new Array(f);function D(e,t,r,n,i){this.static_tree=e,this.extra_bits=t,this.extra_base=r,this.elems=n,this.max_length=i,this.has_stree=e&&e.length;}function F(e,t){this.dyn_tree=e,this.max_code=0,this.stat_desc=t;}function N(e){return e<256?E[e]:E[256+(e>>>7)]}function U(e,t){e.pending_buf[e.pending++]=255&t,e.pending_buf[e.pending++]=t>>>8&255;}function P(e,t,r){e.bi_valid>d-r?(e.bi_buf|=t<<e.bi_valid&65535,U(e,e.bi_buf),e.bi_buf=t>>d-e.bi_valid,e.bi_valid+=r-d):(e.bi_buf|=t<<e.bi_valid&65535,e.bi_valid+=r);}function L(e,t,r){P(e,r[2*t],r[2*t+1]);}function j(e,t){for(var r=0;r|=1&e,e>>>=1,r<<=1,0<--t;);return r>>>1}function Z(e,t,r){var n,i,s=new Array(g+1),a=0;for(n=1;n<=g;n++)s[n]=a=a+r[n-1]<<1;for(i=0;i<=t;i++){var o=e[2*i+1];0!==o&&(e[2*i]=j(s[o]++,o));}}function W(e){var t;for(t=0;t<l;t++)e.dyn_ltree[2*t]=0;for(t=0;t<f;t++)e.dyn_dtree[2*t]=0;for(t=0;t<c;t++)e.bl_tree[2*t]=0;e.dyn_ltree[2*m]=1,e.opt_len=e.static_len=0,e.last_lit=e.matches=0;}function M(e){8<e.bi_valid?U(e,e.bi_buf):0<e.bi_valid&&(e.pending_buf[e.pending++]=e.bi_buf),e.bi_buf=0,e.bi_valid=0;}function H(e,t,r,n){var i=2*t,s=2*r;return e[i]<e[s]||e[i]===e[s]&&n[t]<=n[r]}function G(e,t,r){for(var n=e.heap[r],i=r<<1;i<=e.heap_len&&(i<e.heap_len&&H(t,e.heap[i+1],e.heap[i],e.depth)&&i++,!H(t,n,e.heap[i],e.depth));)e.heap[r]=e.heap[i],r=i,i<<=1;e.heap[r]=n;}function K(e,t,r){var n,i,s,a,o=0;if(0!==e.last_lit)for(;n=e.pending_buf[e.d_buf+2*o]<<8|e.pending_buf[e.d_buf+2*o+1],i=e.pending_buf[e.l_buf+o],o++,0===n?L(e,i,t):(L(e,(s=A[i])+u+1,t),0!==(a=w[s])&&P(e,i-=I[s],a),L(e,s=N(--n),r),0!==(a=k[s])&&P(e,n-=T[s],a)),o<e.last_lit;);L(e,m,t);}function Y(e,t){var r,n,i,s=t.dyn_tree,a=t.stat_desc.static_tree,o=t.stat_desc.has_stree,h=t.stat_desc.elems,u=-1;for(e.heap_len=0,e.heap_max=_,r=0;r<h;r++)0!==s[2*r]?(e.heap[++e.heap_len]=u=r,e.depth[r]=0):s[2*r+1]=0;for(;e.heap_len<2;)s[2*(i=e.heap[++e.heap_len]=u<2?++u:0)]=1,e.depth[i]=0,e.opt_len--,o&&(e.static_len-=a[2*i+1]);for(t.max_code=u,r=e.heap_len>>1;1<=r;r--)G(e,s,r);for(i=h;r=e.heap[1],e.heap[1]=e.heap[e.heap_len--],G(e,s,1),n=e.heap[1],e.heap[--e.heap_max]=r,e.heap[--e.heap_max]=n,s[2*i]=s[2*r]+s[2*n],e.depth[i]=(e.depth[r]>=e.depth[n]?e.depth[r]:e.depth[n])+1,s[2*r+1]=s[2*n+1]=i,e.heap[1]=i++,G(e,s,1),2<=e.heap_len;);e.heap[--e.heap_max]=e.heap[1],function(e,t){var r,n,i,s,a,o,h=t.dyn_tree,u=t.max_code,l=t.stat_desc.static_tree,f=t.stat_desc.has_stree,c=t.stat_desc.extra_bits,d=t.stat_desc.extra_base,p=t.stat_desc.max_length,m=0;for(s=0;s<=g;s++)e.bl_count[s]=0;for(h[2*e.heap[e.heap_max]+1]=0,r=e.heap_max+1;r<_;r++)p<(s=h[2*h[2*(n=e.heap[r])+1]+1]+1)&&(s=p,m++),h[2*n+1]=s,u<n||(e.bl_count[s]++,a=0,d<=n&&(a=c[n-d]),o=h[2*n],e.opt_len+=o*(s+a),f&&(e.static_len+=o*(l[2*n+1]+a)));if(0!==m){do{for(s=p-1;0===e.bl_count[s];)s--;e.bl_count[s]--,e.bl_count[s+1]+=2,e.bl_count[p]--,m-=2;}while(0<m);for(s=p;0!==s;s--)for(n=e.bl_count[s];0!==n;)u<(i=e.heap[--r])||(h[2*i+1]!==s&&(e.opt_len+=(s-h[2*i+1])*h[2*i],h[2*i+1]=s),n--);}}(e,t),Z(s,u,e.bl_count);}function X(e,t,r){var n,i,s=-1,a=t[1],o=0,h=7,u=4;for(0===a&&(h=138,u=3),t[2*(r+1)+1]=65535,n=0;n<=r;n++)i=a,a=t[2*(n+1)+1],++o<h&&i===a||(o<u?e.bl_tree[2*i]+=o:0!==i?(i!==s&&e.bl_tree[2*i]++,e.bl_tree[2*b]++):o<=10?e.bl_tree[2*v]++:e.bl_tree[2*y]++,s=i,u=(o=0)===a?(h=138,3):i===a?(h=6,3):(h=7,4));}function V(e,t,r){var n,i,s=-1,a=t[1],o=0,h=7,u=4;for(0===a&&(h=138,u=3),n=0;n<=r;n++)if(i=a,a=t[2*(n+1)+1],!(++o<h&&i===a)){if(o<u)for(;L(e,i,e.bl_tree),0!=--o;);else 0!==i?(i!==s&&(L(e,i,e.bl_tree),o--),L(e,b,e.bl_tree),P(e,o-3,2)):o<=10?(L(e,v,e.bl_tree),P(e,o-3,3)):(L(e,y,e.bl_tree),P(e,o-11,7));s=i,u=(o=0)===a?(h=138,3):i===a?(h=6,3):(h=7,4);}}n(T);var q=!1;function J(e,t,r,n){P(e,(s<<1)+(n?1:0),3),function(e,t,r,n){M(e),n&&(U(e,r),U(e,~r)),i.arraySet(e.pending_buf,e.window,t,r,e.pending),e.pending+=r;}(e,t,r,!0);}r._tr_init=function(e){q||(function(){var e,t,r,n,i,s=new Array(g+1);for(n=r=0;n<a-1;n++)for(I[n]=r,e=0;e<1<<w[n];e++)A[r++]=n;for(A[r-1]=n,n=i=0;n<16;n++)for(T[n]=i,e=0;e<1<<k[n];e++)E[i++]=n;for(i>>=7;n<f;n++)for(T[n]=i<<7,e=0;e<1<<k[n]-7;e++)E[256+i++]=n;for(t=0;t<=g;t++)s[t]=0;for(e=0;e<=143;)z[2*e+1]=8,e++,s[8]++;for(;e<=255;)z[2*e+1]=9,e++,s[9]++;for(;e<=279;)z[2*e+1]=7,e++,s[7]++;for(;e<=287;)z[2*e+1]=8,e++,s[8]++;for(Z(z,l+1,s),e=0;e<f;e++)C[2*e+1]=5,C[2*e]=j(e,5);O=new D(z,w,u+1,l,g),B=new D(C,k,0,f,g),R=new D(new Array(0),x,0,c,p);}(),q=!0),e.l_desc=new F(e.dyn_ltree,O),e.d_desc=new F(e.dyn_dtree,B),e.bl_desc=new F(e.bl_tree,R),e.bi_buf=0,e.bi_valid=0,W(e);},r._tr_stored_block=J,r._tr_flush_block=function(e,t,r,n){var i,s,a=0;0<e.level?(2===e.strm.data_type&&(e.strm.data_type=function(e){var t,r=4093624447;for(t=0;t<=31;t++,r>>>=1)if(1&r&&0!==e.dyn_ltree[2*t])return o;if(0!==e.dyn_ltree[18]||0!==e.dyn_ltree[20]||0!==e.dyn_ltree[26])return h;for(t=32;t<u;t++)if(0!==e.dyn_ltree[2*t])return h;return o}(e)),Y(e,e.l_desc),Y(e,e.d_desc),a=function(e){var t;for(X(e,e.dyn_ltree,e.l_desc.max_code),X(e,e.dyn_dtree,e.d_desc.max_code),Y(e,e.bl_desc),t=c-1;3<=t&&0===e.bl_tree[2*S[t]+1];t--);return e.opt_len+=3*(t+1)+5+5+4,t}(e),i=e.opt_len+3+7>>>3,(s=e.static_len+3+7>>>3)<=i&&(i=s)):i=s=r+5,r+4<=i&&-1!==t?J(e,t,r,n):4===e.strategy||s===i?(P(e,2+(n?1:0),3),K(e,z,C)):(P(e,4+(n?1:0),3),function(e,t,r,n){var i;for(P(e,t-257,5),P(e,r-1,5),P(e,n-4,4),i=0;i<n;i++)P(e,e.bl_tree[2*S[i]+1],3);V(e,e.dyn_ltree,t-1),V(e,e.dyn_dtree,r-1);}(e,e.l_desc.max_code+1,e.d_desc.max_code+1,a+1),K(e,e.dyn_ltree,e.dyn_dtree)),W(e),n&&M(e);},r._tr_tally=function(e,t,r){return e.pending_buf[e.d_buf+2*e.last_lit]=t>>>8&255,e.pending_buf[e.d_buf+2*e.last_lit+1]=255&t,e.pending_buf[e.l_buf+e.last_lit]=255&r,e.last_lit++,0===t?e.dyn_ltree[2*r]++:(e.matches++,t--,e.dyn_ltree[2*(A[r]+u+1)]++,e.dyn_dtree[2*N(t)]++),e.last_lit===e.lit_bufsize-1},r._tr_align=function(e){P(e,2,3),L(e,m,z),function(e){16===e.bi_valid?(U(e,e.bi_buf),e.bi_buf=0,e.bi_valid=0):8<=e.bi_valid&&(e.pending_buf[e.pending++]=255&e.bi_buf,e.bi_buf>>=8,e.bi_valid-=8);}(e);};},{"../utils/common":41}],53:[function(e,t,r){t.exports=function(){this.input=null,this.next_in=0,this.avail_in=0,this.total_in=0,this.output=null,this.next_out=0,this.avail_out=0,this.total_out=0,this.msg="",this.state=null,this.data_type=2,this.adler=0;};},{}],54:[function(e,t,r){(function(e){!function(r,n){if(!r.setImmediate){var i,s,t,a,o=1,h={},u=!1,l=r.document,e=Object.getPrototypeOf&&Object.getPrototypeOf(r);e=e&&e.setTimeout?e:r,i="[object process]"==={}.toString.call(r.process)?function(e){process.nextTick(function(){c(e);});}:function(){if(r.postMessage&&!r.importScripts){var e=!0,t=r.onmessage;return r.onmessage=function(){e=!1;},r.postMessage("","*"),r.onmessage=t,e}}()?(a="setImmediate$"+Math.random()+"$",r.addEventListener?r.addEventListener("message",d,!1):r.attachEvent("onmessage",d),function(e){r.postMessage(a+e,"*");}):r.MessageChannel?((t=new MessageChannel).port1.onmessage=function(e){c(e.data);},function(e){t.port2.postMessage(e);}):l&&"onreadystatechange"in l.createElement("script")?(s=l.documentElement,function(e){var t=l.createElement("script");t.onreadystatechange=function(){c(e),t.onreadystatechange=null,s.removeChild(t),t=null;},s.appendChild(t);}):function(e){setTimeout(c,0,e);},e.setImmediate=function(e){"function"!=typeof e&&(e=new Function(""+e));for(var t=new Array(arguments.length-1),r=0;r<t.length;r++)t[r]=arguments[r+1];var n={callback:e,args:t};return h[o]=n,i(o),o++},e.clearImmediate=f;}function f(e){delete h[e];}function c(e){if(u)setTimeout(c,0,e);else {var t=h[e];if(t){u=!0;try{!function(e){var t=e.callback,r=e.args;switch(r.length){case 0:t();break;case 1:t(r[0]);break;case 2:t(r[0],r[1]);break;case 3:t(r[0],r[1],r[2]);break;default:t.apply(n,r);}}(t);}finally{f(e),u=!1;}}}}function d(e){e.source===r&&"string"==typeof e.data&&0===e.data.indexOf(a)&&c(+e.data.slice(a.length));}}("undefined"==typeof self?void 0===e?this:e:self);}).call(this,"undefined"!=typeof commonjsGlobal?commonjsGlobal:"undefined"!=typeof self?self:"undefined"!=typeof window?window:{});},{}]},{},[10])(10)}); 
} (jszip_min, jszip_min.exports));

var jszip_minExports = jszip_min.exports;

/**
 * Download a zip file from a url and return the bytes of the file as an ArrayBuffer.
 * @param url String url of the zip file to download.
 * @returns ArrayBuffer of the zip file.
 */
const downloadZipFile = (url) => __awaiter(void 0, void 0, void 0, function* () {
    const fetched = yield obsidian.requestUrl({ url });
    const bytes = fetched.arrayBuffer;
    return bytes;
});
/**
 * Transforms a JSZip file into a File object.
 * @param file JSZip file to transform.
 * @returns File object of the JSZip file.
 */
const getFileFromJSZipFile = (file) => __awaiter(void 0, void 0, void 0, function* () {
    const fileData = yield file.async('blob');
    const filename = file.name.split('/').pop();
    return new File([fileData], filename);
});
/**
 * Read a zip file and return the files inside it.
 * @param bytes ArrayBuffer of the zip file.
 * @param extraPath String path to filter the files inside the zip file. This can be used
 * to set an extra path (like a directory inside the zip file) to filter the files.
 * @returns Array of loaded files inside the zip file.
 */
const readZipFile = (bytes_1, ...args_1) => __awaiter(void 0, [bytes_1, ...args_1], void 0, function* (bytes, extraPath = '') {
    const unzippedFiles = yield jszip_minExports.loadAsync(bytes);
    return Promise.resolve(unzippedFiles).then((unzipped) => {
        if (!Object.keys(unzipped.files).length) {
            return Promise.reject('No file was found');
        }
        const files = [];
        // Regex for retrieving the files inside the zip file or inside the directory of a
        // zip file.
        const regex = new RegExp(extraPath + '(.+)\\.svg', 'g');
        Object.entries(unzippedFiles.files).forEach(([_, v]) => {
            const matched = v.name.match(regex);
            if (!v.dir && matched && matched.length > 0) {
                files.push(v);
            }
        });
        return files;
    });
});

const PLUGIN_NAME = 'iconize';
const TITLE_ICON_CLASS = 'iconize-title-icon';
const INLINE_TITLE_WRAPPER_CLASS = 'iconize-inline-title-wrapper';
/**
 * The name of the attribute that is used to store the icon name in the node.
 * The value of this attributes contains the prefix and the name of the icon.
 */
const ICON_ATTRIBUTE_NAME = 'data-icon';
var config = {
    PLUGIN_NAME,
    TITLE_ICON_CLASS,
    INLINE_TITLE_WRAPPER_CLASS,
    ICON_ATTRIBUTE_NAME,
};

var LoggerPrefix;
(function (LoggerPrefix) {
    LoggerPrefix["Outline"] = "Outline";
})(LoggerPrefix || (LoggerPrefix = {}));
class ConsoleLogger {
    constructor(projectPrefix, enabled = false) {
        this.logLevels = {
            log: { label: 'LOG:' },
            info: { label: 'INFO:' },
            warn: { label: 'WARN:' },
            error: { label: 'ERROR:' },
        };
        this.projectPrefix = projectPrefix;
        this.enabled = enabled;
    }
    formatMessage(level, message, prefix, optionalParams) {
        const timestamp = new Date().toISOString();
        const { label } = this.logLevels[level];
        const prefixAsStr = !prefix ? '' : `/${prefix}`;
        return [
            `${this.projectPrefix}${prefixAsStr}: [${timestamp}] ${label} ${message}`,
            ...optionalParams,
        ];
    }
    log(message, prefix, ...optionalParams) {
        if (this.enabled) {
            console.log(...this.formatMessage('log', message, prefix, optionalParams));
        }
    }
    info(message, prefix, ...optionalParams) {
        if (this.enabled) {
            console.info(...this.formatMessage('info', message, prefix, optionalParams));
        }
    }
    warn(message, prefix, ...optionalParams) {
        if (this.enabled) {
            console.warn(...this.formatMessage('warn', message, prefix, optionalParams));
        }
    }
    error(message, prefix, ...optionalParams) {
        if (this.enabled) {
            console.error(...this.formatMessage('error', message, prefix, optionalParams));
        }
    }
    toggleLogging(enabled) {
        this.enabled = enabled;
    }
}
const logger = new ConsoleLogger(config.PLUGIN_NAME);

const iconPacks$1 = {
    faBrands: {
        name: 'font-awesome-brands',
        displayName: 'FontAwesome Brands',
        path: 'fontawesome-free-6.5.1-web/svgs/brands/',
        downloadLink: 'https://github.com/FortAwesome/Font-Awesome/releases/download/6.5.1/fontawesome-free-6.5.1-web.zip',
    },
    faRegular: {
        name: 'font-awesome-regular',
        displayName: 'FontAwesome Regular',
        path: 'fontawesome-free-6.5.1-web/svgs/regular/',
        downloadLink: 'https://github.com/FortAwesome/Font-Awesome/releases/download/6.5.1/fontawesome-free-6.5.1-web.zip',
    },
    faSolid: {
        name: 'font-awesome-solid',
        displayName: 'FontAwesome Solid',
        path: 'fontawesome-free-6.5.1-web/svgs/solid/',
        downloadLink: 'https://github.com/FortAwesome/Font-Awesome/releases/download/6.5.1/fontawesome-free-6.5.1-web.zip',
    },
    remixIcons: {
        name: 'remix-icons',
        displayName: 'Remix Icons',
        path: '',
        downloadLink: 'https://github.com/Remix-Design/RemixIcon/releases/download/v4.2.0/RemixIcon_Svg_v4.2.0.zip',
    },
    iconBrew: {
        name: 'icon-brew',
        displayName: 'Icon Brew',
        path: '',
        downloadLink: 'https://github.com/FlorianWoelki/obsidian-iconize/raw/main/iconPacks/icon-brew.zip',
    },
    /** @source https://simpleicons.org/ */
    simpleIcons: {
        name: 'simple-icons',
        displayName: 'Simple Icons',
        path: 'simple-icons-11.10.0/icons/',
        downloadLink: 'https://github.com/simple-icons/simple-icons/archive/refs/tags/11.10.0.zip',
    },
    tablerIcons: {
        name: 'tabler-icons',
        displayName: 'Tabler Icons',
        path: 'svg',
        downloadLink: 'https://github.com/tabler/tabler-icons/releases/download/v3.1.0/tabler-icons-3.1.0.zip',
    },
    /** @source https://boxicons.com/ */
    boxicons: {
        name: 'boxicons',
        displayName: 'Boxicons',
        path: 'svg',
        downloadLink: 'https://github.com/FlorianWoelki/obsidian-iconize/raw/main/iconPacks/boxicons.zip',
    },
    /** @source http://nagoshiashumari.github.io/Rpg-Awesome/ */
    rpgAwesome: {
        name: 'rpg-awesome',
        displayName: 'RPG Awesome',
        path: '',
        downloadLink: 'https://github.com/FlorianWoelki/obsidian-iconize/raw/main/iconPacks/rpg-awesome.zip',
    },
    /** @source https://coolicons.cool/ */
    coolicons: {
        name: 'coolicons',
        displayName: 'Coolicons',
        path: 'cooliocns SVG',
        downloadLink: 'https://github.com/krystonschwarze/coolicons/releases/download/v4.1/coolicons.v4.1.zip',
    },
    /** @source https://feathericons.com/ */
    feathericons: {
        name: 'feather-icons',
        displayName: 'Feather Icons',
        path: 'feather-4.29.1/icons/',
        downloadLink: 'https://github.com/feathericons/feather/archive/refs/tags/v4.29.1.zip',
    },
    /** @source https://github.com/primer/octicons */
    octicons: {
        name: 'octicons',
        displayName: 'Octicons',
        path: 'octicons-19.8.0/icons/',
        downloadLink: 'https://github.com/primer/octicons/archive/refs/tags/v19.8.0.zip',
    },
};
/**
 * Returns a possible path to the icon pack.
 * @param name String of the icon pack name.
 * @returns String of the path to the icon pack or undefined if the icon pack does not
 * exist.
 */
const getExtraPath = (iconPackName) => {
    var _a;
    const path = (_a = Object.values(iconPacks$1).find((iconPack) => iconPack.name === iconPackName)) === null || _a === void 0 ? void 0 : _a.path;
    return (path === null || path === void 0 ? void 0 : path.length) === 0 ? undefined : path;
};

const NATIVE_LUCIDE_ICON_PACK_NAME = 'lucide-icons';
let path;
const getPath = () => {
    return path;
};
const setPath = (newPath) => {
    if (newPath === 'plugins/obsidian-icon-folder/icons') {
        newPath = '.obsidian/plugins/obsidian-icon-folder/icons';
        new obsidian.Notice(`[${config.PLUGIN_NAME}] Due to a change in version v1.2.2, the icon pack folder changed. Please change it in the settings to not be directly in /plugins.`, 8000);
    }
    path = newPath;
};
let preloadedIcons = [];
const getPreloadedIcons = () => {
    return preloadedIcons;
};
const resetPreloadedIcons = () => {
    preloadedIcons = [];
};
let iconPacks = [];
const addNativeLucideIcons = () => {
    iconPacks.push({
        name: NATIVE_LUCIDE_ICON_PACK_NAME,
        prefix: 'Li',
        custom: false,
        icons: obsidian.getIconIds()
            .map((iconId) => iconId.replace(/^lucide-/, ''))
            .map((iconId) => {
            const iconEl = obsidian.getIcon(iconId);
            iconEl.removeClass('svg-icon'); // Removes native `svg-icon` class.
            return {
                name: getNormalizedName(iconId),
                filename: iconId,
                prefix: 'Li',
                svgElement: iconEl === null || iconEl === void 0 ? void 0 : iconEl.outerHTML,
                svgContent: iconEl === null || iconEl === void 0 ? void 0 : iconEl.innerHTML,
                svgViewbox: '',
                iconPackName: NATIVE_LUCIDE_ICON_PACK_NAME,
            };
        }),
    });
};
const moveIconPackDirectories = (plugin, from, to) => __awaiter(void 0, void 0, void 0, function* () {
    // Tries to move all icon packs to the new folder.
    for (let i = 0; i < iconPacks.length; i++) {
        const iconPack = iconPacks[i];
        if (yield plugin.app.vault.adapter.exists(`${from}/${iconPack.name}`)) {
            // Tries to create a new directory in the new path.
            const doesDirExist = yield createDirectory(plugin, iconPack.name);
            if (doesDirExist) {
                new obsidian.Notice(`Directory with name ${iconPack.name} already exists.`);
                continue;
            }
        }
        new obsidian.Notice(`Moving ${iconPack.name}...`);
        // Move the zip file.
        if (yield plugin.app.vault.adapter.exists(`${from}/${iconPack.name}.zip`)) {
            yield plugin.app.vault.adapter.copy(`${from}/${iconPack.name}.zip`, `${to}/${iconPack.name}.zip`);
        }
        // Move all other files inside of the iconpack directory.
        const filesInDirectory = yield getFilesInDirectory(plugin, `${from}/${iconPack.name}`);
        for (const file of filesInDirectory) {
            const fileName = file.split('/').pop();
            yield plugin.app.vault.adapter.copy(`${from}/${iconPack.name}/${fileName}`, `${to}/${iconPack.name}/${fileName}`);
        }
        new obsidian.Notice(`...moved ${iconPack.name}`);
    }
    // Removes all the existing icon packs in the `from` directory.
    for (let i = 0; i < iconPacks.length; i++) {
        const iconPack = iconPacks[i];
        if (yield plugin.app.vault.adapter.exists(`${from}/${iconPack.name}`)) {
            yield plugin.app.vault.adapter.rmdir(`${from}/${iconPack.name}`, true);
        }
    }
    // Remove root directory that contains all the icon packs.
    if (!to.startsWith(from)) {
        yield plugin.app.vault.adapter.rmdir(`${from}`, true);
    }
});
const createCustomIconPackDirectory = (plugin, dir) => __awaiter(void 0, void 0, void 0, function* () {
    yield createDirectory(plugin, dir);
    const prefix = createIconPackPrefix(dir);
    iconPacks.push({ name: dir, icons: [], prefix, custom: true });
});
const deleteIconPack = (plugin, dir) => __awaiter(void 0, void 0, void 0, function* () {
    iconPacks = iconPacks.filter((iconPack) => iconPack.name !== dir);
    // Check for the icon pack directory and delete it.
    if (yield plugin.app.vault.adapter.exists(`${path}/${dir}`)) {
        yield plugin.app.vault.adapter.rmdir(`${path}/${dir}`, true);
    }
    // Check for the icon pack zip file and delete it.
    if (yield plugin.app.vault.adapter.exists(`${path}/${dir}.zip`)) {
        yield plugin.app.vault.adapter.remove(`${path}/${dir}.zip`);
    }
});
const doesIconPackExist = (plugin, iconPackName) => {
    return plugin.app.vault.adapter.exists(`${path}/${iconPackName}`);
};
const createDirectory = (plugin, dir) => __awaiter(void 0, void 0, void 0, function* () {
    const doesDirExist = yield plugin.app.vault.adapter.exists(`${path}/${dir}`);
    if (!doesDirExist) {
        yield plugin.app.vault.adapter.mkdir(`${path}/${dir}`);
    }
    return doesDirExist;
});
const getNormalizedName = (s) => {
    return s
        .split(/[ -]|[ _]/g)
        .map((part) => part.charAt(0).toUpperCase() + part.slice(1))
        .join('');
};
// export const normalizeFileName = async (plugin: Plugin, oldPath: string) => {
//   const fileName = oldPath.split('/').pop();
//   const newPath = oldPath.substring(0, oldPath.indexOf(fileName)) + getNormalizedName(fileName);
//   await plugin.app.vault.adapter.rename(oldPath, newPath);
// };
const createZipFile = (plugin, filename, buffer) => __awaiter(void 0, void 0, void 0, function* () {
    yield plugin.app.vault.adapter.writeBinary(`${path}/${filename}`, buffer);
});
const createFile = (plugin, iconPackName, filename, content, absoluteFilename) => __awaiter(void 0, void 0, void 0, function* () {
    const normalizedFilename = getNormalizedName(filename);
    const exists = yield plugin.app.vault.adapter.exists(`${path}/${iconPackName}/${normalizedFilename}`);
    if (exists) {
        const folderSplit = absoluteFilename.split('/');
        if (folderSplit.length >= 2) {
            const folderName = folderSplit[folderSplit.length - 2];
            const newFilename = folderName + normalizedFilename;
            yield plugin.app.vault.adapter.write(`${path}/${iconPackName}/${newFilename}`, content);
            logger.info(`Renamed old file ${normalizedFilename} to ${newFilename} due to duplication`);
            new obsidian.Notice(`[${config.PLUGIN_NAME}] Renamed ${normalizedFilename} to ${newFilename} to avoid duplication.`, 8000);
        }
        else {
            logger.warn(`Could not create icons with duplicated file names (file name: ${normalizedFilename})`);
            new obsidian.Notice(`[${config.PLUGIN_NAME}] Could not create duplicated icon name (${normalizedFilename})`, 8000);
        }
    }
    else {
        yield plugin.app.vault.adapter.write(`${path}/${iconPackName}/${normalizedFilename}`, content);
    }
});
const createDefaultDirectory = (plugin) => __awaiter(void 0, void 0, void 0, function* () {
    yield createDirectory(plugin, '');
});
const getAllIconPacks = () => {
    return iconPacks;
};
const getFilesInDirectory = (plugin, dir) => __awaiter(void 0, void 0, void 0, function* () {
    if (!(yield plugin.app.vault.adapter.exists(dir))) {
        return [];
    }
    return (yield plugin.app.vault.adapter.list(dir)).files;
});
const validIconName = /^[(A-Z)|(0-9)]/;
const svgViewboxRegex = /viewBox="([^"]*)"/g;
const svgContentRegex = /<svg.*>(.*?)<\/svg>/g;
const generateIcon = (iconPackName, iconName, content) => {
    if (content.length === 0) {
        return;
    }
    content = content.replace(/(\r\n|\n|\r)/gm, '');
    content = content.replace(/>\s+</gm, '><');
    const normalizedName = iconName.charAt(0).toUpperCase() + iconName.substring(1);
    if (!validIconName.exec(normalizedName)) {
        logger.info(`Skipping icon with invalid name: ${iconName}`);
        return null;
    }
    const svgViewboxMatch = content.match(svgViewboxRegex);
    let svgViewbox = '';
    if (svgViewboxMatch && svgViewboxMatch.length !== 0) {
        svgViewbox = svgViewboxMatch[0];
    }
    const svgContentMatch = content.match(svgContentRegex);
    if (!svgContentMatch) {
        logger.info(`Skipping icon with invalid svg content: ${iconName}`);
        return null;
    }
    const svgContent = svgContentMatch.map((val) => val.replace(/<\/?svg>/g, '').replace(/<svg.+?>/g, ''))[0];
    const iconPackPrefix = createIconPackPrefix(iconPackName);
    const icon = {
        name: normalizedName.split('.svg')[0],
        prefix: iconPackPrefix,
        iconPackName,
        filename: iconName,
        svgContent,
        svgViewbox,
        svgElement: svg.extract(content),
    };
    return icon;
};
const createIconPackPrefix = (iconPackName) => {
    if (iconPackName.includes('-')) {
        const splitted = iconPackName.split('-');
        let result = splitted[0].charAt(0).toUpperCase();
        for (let i = 1; i < splitted.length; i++) {
            result += splitted[i].charAt(0).toLowerCase();
        }
        return result;
    }
    return (iconPackName.charAt(0).toUpperCase() + iconPackName.charAt(1).toLowerCase());
};
const loadUsedIcons = (plugin, icons) => __awaiter(void 0, void 0, void 0, function* () {
    const iconPacks = [
        ...(yield listPath(plugin)).folders.map((iconPack) => iconPack.split('/').pop()),
        NATIVE_LUCIDE_ICON_PACK_NAME,
    ];
    for (let i = 0; i < icons.length; i++) {
        const entry = icons[i];
        if (!entry) {
            continue;
        }
        yield loadIcon(plugin, iconPacks, entry);
    }
});
const listPath = (plugin, listPath) => {
    return plugin.app.vault.adapter.list(listPath !== null && listPath !== void 0 ? listPath : path);
};
const getIconPackNameByPrefix = (prefix) => {
    var _a;
    return (_a = iconPacks.find((iconPack) => iconPack.prefix === prefix)) === null || _a === void 0 ? void 0 : _a.name;
};
const nextIdentifier = (iconName) => {
    return iconName.substring(1).search(/[(A-Z)|(0-9)]/) + 1;
};
const loadIcon = (plugin, iconPackNames, iconName) => __awaiter(void 0, void 0, void 0, function* () {
    const nextLetter = nextIdentifier(iconName);
    const prefix = iconName.substring(0, nextLetter);
    const name = iconName.substring(nextLetter);
    const iconPack = iconPackNames.find((folder) => {
        const folderPrefix = createIconPackPrefix(folder);
        return prefix === folderPrefix;
    });
    if (!iconPack) {
        // Ignore because background check automatically adds the icons and icon pack
        // directories.
        if (!plugin.getSettings().iconsBackgroundCheckEnabled) {
            new obsidian.Notice(`Seems like you do not have an icon pack installed. (${iconName})`, 5000);
        }
        return;
    }
    if (iconPack === NATIVE_LUCIDE_ICON_PACK_NAME) {
        // Lucide icons already exist for Obsidian.
        const lucideIcons = iconPacks.find((iconPack) => iconPack.name === NATIVE_LUCIDE_ICON_PACK_NAME);
        const icon = lucideIcons.icons.find((icon) => icon.name === name);
        if (!icon) {
            logger.warn(`Icon ${icon} does not exist in the native Lucide icon pack.`);
            return;
        }
        preloadedIcons.push(icon);
        return;
    }
    const fullPath = path + '/' + iconPack + '/' + name + '.svg';
    if (!(yield plugin.app.vault.adapter.exists(fullPath))) {
        logger.info(`Icon with name '${name}' was not found (full path: ${fullPath})`);
        return;
    }
    const content = yield plugin.app.vault.adapter.read(fullPath);
    const icon = generateIcon(iconPack, name, content);
    preloadedIcons.push(icon);
});
const initIconPacks = (plugin) => __awaiter(void 0, void 0, void 0, function* () {
    // Remove the beginning slash because paths which start with `/` are the same as without
    // a slash.
    if (path.startsWith('/')) {
        path = path.slice(1);
    }
    const loadedIconPacks = yield plugin.app.vault.adapter.list(path);
    // Extract all zip files which will be downloaded icon packs.
    const zipFiles = {};
    for (let i = 0; i < loadedIconPacks.files.length; i++) {
        const fileName = loadedIconPacks.files[i];
        if (fileName.endsWith('.zip')) {
            const arrayBuffer = yield plugin.app.vault.adapter.readBinary(fileName);
            const files = yield readZipFile(arrayBuffer);
            const iconPackName = fileName.split('/').pop().split('.zip')[0];
            zipFiles[iconPackName] = files;
        }
    }
    // Check for custom-made icon packs.
    for (let i = 0; i < loadedIconPacks.folders.length; i++) {
        const folderName = loadedIconPacks.folders[i].split('/').pop();
        // Continue if the icon pack does have a zip file.
        if (zipFiles[folderName]) {
            continue;
        }
        const files = yield getFilesInDirectory(plugin, `${path}/${folderName}`);
        const loadedIcons = [];
        // Convert files into loaded svgs.
        for (let j = 0; j < files.length; j++) {
            const iconNameRegex = files[j].match(new RegExp(path + '/' + folderName + '/(.*)'));
            const iconName = getNormalizedName(iconNameRegex[1]);
            const iconContent = yield plugin.app.vault.adapter.read(files[j]);
            const icon = generateIcon(folderName, iconName, iconContent);
            if (icon) {
                loadedIcons.push(icon);
            }
        }
        const prefix = createIconPackPrefix(folderName);
        iconPacks.push({
            name: folderName,
            icons: loadedIcons,
            prefix,
            custom: true,
        });
        logger.info(`Loaded icon pack '${folderName}' (amount of icons: ${loadedIcons.length})`);
    }
    // Extract all files from the zip files.
    for (const zipFile in zipFiles) {
        const files = zipFiles[zipFile];
        const loadedIcons = yield getLoadedIconsFromZipFile(zipFile, files);
        const prefix = createIconPackPrefix(zipFile);
        iconPacks.push({
            name: zipFile,
            icons: loadedIcons,
            prefix,
            custom: false,
        });
        logger.info(`Loaded icon pack '${zipFile}' (amount of icons: ${loadedIcons.length})`);
    }
});
const getLoadedIconsFromZipFile = (iconPackName, files) => __awaiter(void 0, void 0, void 0, function* () {
    const loadedIcons = [];
    const extraPath = getExtraPath(iconPackName);
    for (let j = 0; j < files.length; j++) {
        // Checks if the icon pack has an extra path. Also ignores files which do not start
        // with the extra path.
        if (extraPath && !files[j].name.startsWith(extraPath)) {
            continue;
        }
        const file = yield getFileFromJSZipFile(files[j]);
        const iconContent = yield file.text();
        const iconName = getNormalizedName(file.name);
        const icon = generateIcon(iconPackName, iconName, iconContent);
        if (icon) {
            loadedIcons.push(icon);
        }
    }
    return loadedIcons;
});
const addIconToIconPack = (iconPackName, iconName, iconContent) => {
    // Normalize the icon name to remove `-` or `_` in the name.
    iconName = getNormalizedName(iconName);
    const icon = generateIcon(iconPackName, iconName, iconContent);
    if (!icon) {
        logger.warn(`Icon could not be generated (icon: ${iconName}, content: ${iconContent})`);
        return undefined;
    }
    const iconPack = iconPacks.find((iconPack) => iconPack.name === iconPackName);
    if (!iconPack) {
        logger.warn(`Iconpack with name '${iconPackName}' was not found`);
        return undefined;
    }
    iconPack.icons.push(icon);
    return icon;
};
const removeIconFromIconPackDirectory = (plugin, iconPackName, iconName) => {
    const iconPack = iconPacks.find((iconPack) => iconPack.name === iconPackName);
    // Checks if icon pack is custom-made.
    if (!iconPack.custom) {
        return plugin.app.vault.adapter.rmdir(`${path}/${iconPackName}/${iconName}.svg`, true);
    }
};
const extractIconToIconPack = (plugin, icon, iconContent) => __awaiter(void 0, void 0, void 0, function* () {
    const doesIconPackDirExist = yield plugin.app.vault.adapter.exists(`${path}/${icon.iconPackName}`);
    if (!doesIconPackDirExist) {
        yield plugin.app.vault.adapter.mkdir(`${path}/${icon.iconPackName}`);
    }
    const doesIconFileExists = yield plugin.app.vault.adapter.exists(`${path}/${icon.iconPackName}/${icon.name}.svg`);
    if (!doesIconFileExists) {
        yield createFile(plugin, icon.iconPackName, `${icon.name}.svg`, iconContent);
    }
});
const getAllLoadedIconNames = () => {
    return iconPacks.reduce((total, iconPack) => {
        total.push(...iconPack.icons);
        return total;
    }, []);
};
const registerIconPack = (name, arrayBuffer) => __awaiter(void 0, void 0, void 0, function* () {
    const files = yield readZipFile(arrayBuffer);
    const loadedIcons = yield getLoadedIconsFromZipFile(name, files);
    const prefix = createIconPackPrefix(name);
    iconPacks.push({ name, icons: loadedIcons, prefix, custom: false });
    logger.info(`Loaded icon pack ${name} (amount of icons: ${loadedIcons.length})`);
});
const doesIconExists = (iconName) => {
    const icons = getAllLoadedIconNames();
    return (icons.find((icon) => icon.name === iconName || icon.prefix + icon.name === iconName) !== undefined);
};
const getIconsFromIconPack = (iconPackName) => {
    return iconPacks.find((iconPack) => iconPack.name === iconPackName);
};
const getIconFromIconPack = (iconPackName, iconPrefix, iconName) => {
    const foundIcon = preloadedIcons.find((icon) => icon.prefix.toLowerCase() === iconPrefix.toLowerCase() &&
        icon.name.toLowerCase() === iconName.toLowerCase());
    if (foundIcon) {
        return foundIcon;
    }
    const iconPack = iconPacks.find((iconPack) => iconPack.name === iconPackName);
    if (!iconPack) {
        return undefined;
    }
    return iconPack.icons.find((icon) => getNormalizedName(icon.name) === iconName);
};
const getSvgFromLoadedIcon = (iconPrefix, iconName) => {
    let icon = '';
    let foundIcon = preloadedIcons.find((icon) => icon.prefix.toLowerCase() === iconPrefix.toLowerCase() &&
        icon.name.toLowerCase() === iconName.toLowerCase());
    if (!foundIcon) {
        iconPacks.forEach((iconPack) => {
            const icon = iconPack.icons.find((icon) => {
                return (icon.prefix.toLowerCase() === iconPrefix.toLowerCase() &&
                    getNormalizedName(icon.name).toLowerCase() === iconName.toLowerCase());
            });
            if (icon) {
                foundIcon = icon;
            }
        });
    }
    if (foundIcon) {
        icon = foundIcon.svgElement;
    }
    return icon;
};

/*! Copyright Twitter Inc. and other contributors. Licensed under MIT */
var twemoji=function(){var twemoji={base:"https://cdn.jsdelivr.net/gh/jdecked/twemoji@15.1.0/assets/",ext:".png",size:"72x72",className:"emoji",convert:{fromCodePoint:fromCodePoint,toCodePoint:toCodePoint},onerror:function onerror(){if(this.parentNode){this.parentNode.replaceChild(createText(this.alt,false),this);}},parse:parse,replace:replace,test:test},escaper={"&":"&amp;","<":"&lt;",">":"&gt;","'":"&#39;",'"':"&quot;"},re=/(?:\ud83d\udc68\ud83c\udffb\u200d\u2764\ufe0f\u200d\ud83d\udc8b\u200d\ud83d\udc68\ud83c[\udffb-\udfff]|\ud83d\udc68\ud83c\udffc\u200d\u2764\ufe0f\u200d\ud83d\udc8b\u200d\ud83d\udc68\ud83c[\udffb-\udfff]|\ud83d\udc68\ud83c\udffd\u200d\u2764\ufe0f\u200d\ud83d\udc8b\u200d\ud83d\udc68\ud83c[\udffb-\udfff]|\ud83d\udc68\ud83c\udffe\u200d\u2764\ufe0f\u200d\ud83d\udc8b\u200d\ud83d\udc68\ud83c[\udffb-\udfff]|\ud83d\udc68\ud83c\udfff\u200d\u2764\ufe0f\u200d\ud83d\udc8b\u200d\ud83d\udc68\ud83c[\udffb-\udfff]|\ud83d\udc69\ud83c\udffb\u200d\u2764\ufe0f\u200d\ud83d\udc8b\u200d\ud83d\udc68\ud83c[\udffb-\udfff]|\ud83d\udc69\ud83c\udffb\u200d\u2764\ufe0f\u200d\ud83d\udc8b\u200d\ud83d\udc69\ud83c[\udffb-\udfff]|\ud83d\udc69\ud83c\udffc\u200d\u2764\ufe0f\u200d\ud83d\udc8b\u200d\ud83d\udc68\ud83c[\udffb-\udfff]|\ud83d\udc69\ud83c\udffc\u200d\u2764\ufe0f\u200d\ud83d\udc8b\u200d\ud83d\udc69\ud83c[\udffb-\udfff]|\ud83d\udc69\ud83c\udffd\u200d\u2764\ufe0f\u200d\ud83d\udc8b\u200d\ud83d\udc68\ud83c[\udffb-\udfff]|\ud83d\udc69\ud83c\udffd\u200d\u2764\ufe0f\u200d\ud83d\udc8b\u200d\ud83d\udc69\ud83c[\udffb-\udfff]|\ud83d\udc69\ud83c\udffe\u200d\u2764\ufe0f\u200d\ud83d\udc8b\u200d\ud83d\udc68\ud83c[\udffb-\udfff]|\ud83d\udc69\ud83c\udffe\u200d\u2764\ufe0f\u200d\ud83d\udc8b\u200d\ud83d\udc69\ud83c[\udffb-\udfff]|\ud83d\udc69\ud83c\udfff\u200d\u2764\ufe0f\u200d\ud83d\udc8b\u200d\ud83d\udc68\ud83c[\udffb-\udfff]|\ud83d\udc69\ud83c\udfff\u200d\u2764\ufe0f\u200d\ud83d\udc8b\u200d\ud83d\udc69\ud83c[\udffb-\udfff]|\ud83e\uddd1\ud83c\udffb\u200d\u2764\ufe0f\u200d\ud83d\udc8b\u200d\ud83e\uddd1\ud83c[\udffc-\udfff]|\ud83e\uddd1\ud83c\udffc\u200d\u2764\ufe0f\u200d\ud83d\udc8b\u200d\ud83e\uddd1\ud83c[\udffb\udffd-\udfff]|\ud83e\uddd1\ud83c\udffd\u200d\u2764\ufe0f\u200d\ud83d\udc8b\u200d\ud83e\uddd1\ud83c[\udffb\udffc\udffe\udfff]|\ud83e\uddd1\ud83c\udffe\u200d\u2764\ufe0f\u200d\ud83d\udc8b\u200d\ud83e\uddd1\ud83c[\udffb-\udffd\udfff]|\ud83e\uddd1\ud83c\udfff\u200d\u2764\ufe0f\u200d\ud83d\udc8b\u200d\ud83e\uddd1\ud83c[\udffb-\udffe]|\ud83d\udc68\ud83c\udffb\u200d\u2764\ufe0f\u200d\ud83d\udc68\ud83c[\udffb-\udfff]|\ud83d\udc68\ud83c\udffb\u200d\ud83e\udd1d\u200d\ud83d\udc68\ud83c[\udffc-\udfff]|\ud83d\udc68\ud83c\udffc\u200d\u2764\ufe0f\u200d\ud83d\udc68\ud83c[\udffb-\udfff]|\ud83d\udc68\ud83c\udffc\u200d\ud83e\udd1d\u200d\ud83d\udc68\ud83c[\udffb\udffd-\udfff]|\ud83d\udc68\ud83c\udffd\u200d\u2764\ufe0f\u200d\ud83d\udc68\ud83c[\udffb-\udfff]|\ud83d\udc68\ud83c\udffd\u200d\ud83e\udd1d\u200d\ud83d\udc68\ud83c[\udffb\udffc\udffe\udfff]|\ud83d\udc68\ud83c\udffe\u200d\u2764\ufe0f\u200d\ud83d\udc68\ud83c[\udffb-\udfff]|\ud83d\udc68\ud83c\udffe\u200d\ud83e\udd1d\u200d\ud83d\udc68\ud83c[\udffb-\udffd\udfff]|\ud83d\udc68\ud83c\udfff\u200d\u2764\ufe0f\u200d\ud83d\udc68\ud83c[\udffb-\udfff]|\ud83d\udc68\ud83c\udfff\u200d\ud83e\udd1d\u200d\ud83d\udc68\ud83c[\udffb-\udffe]|\ud83d\udc69\ud83c\udffb\u200d\u2764\ufe0f\u200d\ud83d\udc68\ud83c[\udffb-\udfff]|\ud83d\udc69\ud83c\udffb\u200d\u2764\ufe0f\u200d\ud83d\udc69\ud83c[\udffb-\udfff]|\ud83d\udc69\ud83c\udffb\u200d\ud83e\udd1d\u200d\ud83d\udc68\ud83c[\udffc-\udfff]|\ud83d\udc69\ud83c\udffb\u200d\ud83e\udd1d\u200d\ud83d\udc69\ud83c[\udffc-\udfff]|\ud83d\udc69\ud83c\udffc\u200d\u2764\ufe0f\u200d\ud83d\udc68\ud83c[\udffb-\udfff]|\ud83d\udc69\ud83c\udffc\u200d\u2764\ufe0f\u200d\ud83d\udc69\ud83c[\udffb-\udfff]|\ud83d\udc69\ud83c\udffc\u200d\ud83e\udd1d\u200d\ud83d\udc68\ud83c[\udffb\udffd-\udfff]|\ud83d\udc69\ud83c\udffc\u200d\ud83e\udd1d\u200d\ud83d\udc69\ud83c[\udffb\udffd-\udfff]|\ud83d\udc69\ud83c\udffd\u200d\u2764\ufe0f\u200d\ud83d\udc68\ud83c[\udffb-\udfff]|\ud83d\udc69\ud83c\udffd\u200d\u2764\ufe0f\u200d\ud83d\udc69\ud83c[\udffb-\udfff]|\ud83d\udc69\ud83c\udffd\u200d\ud83e\udd1d\u200d\ud83d\udc68\ud83c[\udffb\udffc\udffe\udfff]|\ud83d\udc69\ud83c\udffd\u200d\ud83e\udd1d\u200d\ud83d\udc69\ud83c[\udffb\udffc\udffe\udfff]|\ud83d\udc69\ud83c\udffe\u200d\u2764\ufe0f\u200d\ud83d\udc68\ud83c[\udffb-\udfff]|\ud83d\udc69\ud83c\udffe\u200d\u2764\ufe0f\u200d\ud83d\udc69\ud83c[\udffb-\udfff]|\ud83d\udc69\ud83c\udffe\u200d\ud83e\udd1d\u200d\ud83d\udc68\ud83c[\udffb-\udffd\udfff]|\ud83d\udc69\ud83c\udffe\u200d\ud83e\udd1d\u200d\ud83d\udc69\ud83c[\udffb-\udffd\udfff]|\ud83d\udc69\ud83c\udfff\u200d\u2764\ufe0f\u200d\ud83d\udc68\ud83c[\udffb-\udfff]|\ud83d\udc69\ud83c\udfff\u200d\u2764\ufe0f\u200d\ud83d\udc69\ud83c[\udffb-\udfff]|\ud83d\udc69\ud83c\udfff\u200d\ud83e\udd1d\u200d\ud83d\udc68\ud83c[\udffb-\udffe]|\ud83d\udc69\ud83c\udfff\u200d\ud83e\udd1d\u200d\ud83d\udc69\ud83c[\udffb-\udffe]|\ud83e\uddd1\ud83c\udffb\u200d\u2764\ufe0f\u200d\ud83e\uddd1\ud83c[\udffc-\udfff]|\ud83e\uddd1\ud83c\udffb\u200d\ud83e\udd1d\u200d\ud83e\uddd1\ud83c[\udffb-\udfff]|\ud83e\uddd1\ud83c\udffc\u200d\u2764\ufe0f\u200d\ud83e\uddd1\ud83c[\udffb\udffd-\udfff]|\ud83e\uddd1\ud83c\udffc\u200d\ud83e\udd1d\u200d\ud83e\uddd1\ud83c[\udffb-\udfff]|\ud83e\uddd1\ud83c\udffd\u200d\u2764\ufe0f\u200d\ud83e\uddd1\ud83c[\udffb\udffc\udffe\udfff]|\ud83e\uddd1\ud83c\udffd\u200d\ud83e\udd1d\u200d\ud83e\uddd1\ud83c[\udffb-\udfff]|\ud83e\uddd1\ud83c\udffe\u200d\u2764\ufe0f\u200d\ud83e\uddd1\ud83c[\udffb-\udffd\udfff]|\ud83e\uddd1\ud83c\udffe\u200d\ud83e\udd1d\u200d\ud83e\uddd1\ud83c[\udffb-\udfff]|\ud83e\uddd1\ud83c\udfff\u200d\u2764\ufe0f\u200d\ud83e\uddd1\ud83c[\udffb-\udffe]|\ud83e\uddd1\ud83c\udfff\u200d\ud83e\udd1d\u200d\ud83e\uddd1\ud83c[\udffb-\udfff]|\ud83d\udc68\u200d\u2764\ufe0f\u200d\ud83d\udc8b\u200d\ud83d\udc68|\ud83d\udc69\u200d\u2764\ufe0f\u200d\ud83d\udc8b\u200d\ud83d[\udc68\udc69]|\ud83e\udef1\ud83c\udffb\u200d\ud83e\udef2\ud83c[\udffc-\udfff]|\ud83e\udef1\ud83c\udffc\u200d\ud83e\udef2\ud83c[\udffb\udffd-\udfff]|\ud83e\udef1\ud83c\udffd\u200d\ud83e\udef2\ud83c[\udffb\udffc\udffe\udfff]|\ud83e\udef1\ud83c\udffe\u200d\ud83e\udef2\ud83c[\udffb-\udffd\udfff]|\ud83e\udef1\ud83c\udfff\u200d\ud83e\udef2\ud83c[\udffb-\udffe]|\ud83d\udc68\u200d\u2764\ufe0f\u200d\ud83d\udc68|\ud83d\udc69\u200d\u2764\ufe0f\u200d\ud83d[\udc68\udc69]|\ud83e\uddd1\u200d\ud83e\udd1d\u200d\ud83e\uddd1|\ud83d\udc6b\ud83c[\udffb-\udfff]|\ud83d\udc6c\ud83c[\udffb-\udfff]|\ud83d\udc6d\ud83c[\udffb-\udfff]|\ud83d\udc8f\ud83c[\udffb-\udfff]|\ud83d\udc91\ud83c[\udffb-\udfff]|\ud83e\udd1d\ud83c[\udffb-\udfff]|\ud83d[\udc6b-\udc6d\udc8f\udc91]|\ud83e\udd1d)|(?:\ud83d[\udc68\udc69]|\ud83e\uddd1)(?:\ud83c[\udffb-\udfff])?\u200d(?:\u2695\ufe0f|\u2696\ufe0f|\u2708\ufe0f|\ud83c[\udf3e\udf73\udf7c\udf84\udf93\udfa4\udfa8\udfeb\udfed]|\ud83d[\udcbb\udcbc\udd27\udd2c\ude80\ude92]|\ud83e[\uddaf-\uddb3\uddbc\uddbd])(?:\u200d\u27a1\ufe0f)?|(?:\ud83c[\udfcb\udfcc]|\ud83d[\udd74\udd75]|\u26f9)((?:\ud83c[\udffb-\udfff]|\ufe0f)\u200d[\u2640\u2642]\ufe0f(?:\u200d\u27a1\ufe0f)?)|(?:\ud83c[\udfc3\udfc4\udfca]|\ud83d[\udc6e\udc70\udc71\udc73\udc77\udc81\udc82\udc86\udc87\ude45-\ude47\ude4b\ude4d\ude4e\udea3\udeb4-\udeb6]|\ud83e[\udd26\udd35\udd37-\udd39\udd3d\udd3e\uddb8\uddb9\uddcd-\uddcf\uddd4\uddd6-\udddd])(?:\ud83c[\udffb-\udfff])?\u200d[\u2640\u2642]\ufe0f(?:\u200d\u27a1\ufe0f)?|(?:\ud83d\udc68\u200d\ud83d\udc68\u200d\ud83d\udc66\u200d\ud83d\udc66|\ud83d\udc68\u200d\ud83d\udc68\u200d\ud83d\udc67\u200d\ud83d[\udc66\udc67]|\ud83d\udc68\u200d\ud83d\udc69\u200d\ud83d\udc66\u200d\ud83d\udc66|\ud83d\udc68\u200d\ud83d\udc69\u200d\ud83d\udc67\u200d\ud83d[\udc66\udc67]|\ud83d\udc69\u200d\ud83d\udc69\u200d\ud83d\udc66\u200d\ud83d\udc66|\ud83d\udc69\u200d\ud83d\udc69\u200d\ud83d\udc67\u200d\ud83d[\udc66\udc67]|\ud83e\uddd1\u200d\ud83e\uddd1\u200d\ud83e\uddd2\u200d\ud83e\uddd2|\ud83d\udc68\u200d\ud83d\udc66\u200d\ud83d\udc66|\ud83d\udc68\u200d\ud83d\udc67\u200d\ud83d[\udc66\udc67]|\ud83d\udc68\u200d\ud83d\udc68\u200d\ud83d[\udc66\udc67]|\ud83d\udc68\u200d\ud83d\udc69\u200d\ud83d[\udc66\udc67]|\ud83d\udc69\u200d\ud83d\udc66\u200d\ud83d\udc66|\ud83d\udc69\u200d\ud83d\udc67\u200d\ud83d[\udc66\udc67]|\ud83d\udc69\u200d\ud83d\udc69\u200d\ud83d[\udc66\udc67]|\ud83e\uddd1\u200d\ud83e\uddd1\u200d\ud83e\uddd2|\ud83e\uddd1\u200d\ud83e\uddd2\u200d\ud83e\uddd2|\ud83c\udff3\ufe0f\u200d\u26a7\ufe0f|\ud83c\udff3\ufe0f\u200d\ud83c\udf08|\ud83d\ude36\u200d\ud83c\udf2b\ufe0f|\u26d3\ufe0f\u200d\ud83d\udca5|\u2764\ufe0f\u200d\ud83d\udd25|\u2764\ufe0f\u200d\ud83e\ude79|\ud83c\udf44\u200d\ud83d\udfeb|\ud83c\udf4b\u200d\ud83d\udfe9|\ud83c\udff4\u200d\u2620\ufe0f|\ud83d\udc15\u200d\ud83e\uddba|\ud83d\udc26\u200d\ud83d\udd25|\ud83d\udc3b\u200d\u2744\ufe0f|\ud83d\udc41\u200d\ud83d\udde8|\ud83d\udc68\u200d\ud83d[\udc66\udc67]|\ud83d\udc69\u200d\ud83d[\udc66\udc67]|\ud83d\udc6f\u200d\u2640\ufe0f|\ud83d\udc6f\u200d\u2642\ufe0f|\ud83d\ude2e\u200d\ud83d\udca8|\ud83d\ude35\u200d\ud83d\udcab|\ud83d\ude42\u200d\u2194\ufe0f|\ud83d\ude42\u200d\u2195\ufe0f|\ud83e\udd3c\u200d\u2640\ufe0f|\ud83e\udd3c\u200d\u2642\ufe0f|\ud83e\uddd1\u200d\ud83e\uddd2|\ud83e\uddde\u200d\u2640\ufe0f|\ud83e\uddde\u200d\u2642\ufe0f|\ud83e\udddf\u200d\u2640\ufe0f|\ud83e\udddf\u200d\u2642\ufe0f|\ud83d\udc08\u200d\u2b1b|\ud83d\udc26\u200d\u2b1b)|[#*0-9]\ufe0f?\u20e3|(?:[©®\u2122\u265f]\ufe0f)|(?:\ud83c[\udc04\udd70\udd71\udd7e\udd7f\ude02\ude1a\ude2f\ude37\udf21\udf24-\udf2c\udf36\udf7d\udf96\udf97\udf99-\udf9b\udf9e\udf9f\udfcd\udfce\udfd4-\udfdf\udff3\udff5\udff7]|\ud83d[\udc3f\udc41\udcfd\udd49\udd4a\udd6f\udd70\udd73\udd76-\udd79\udd87\udd8a-\udd8d\udda5\udda8\uddb1\uddb2\uddbc\uddc2-\uddc4\uddd1-\uddd3\udddc-\uddde\udde1\udde3\udde8\uddef\uddf3\uddfa\udecb\udecd-\udecf\udee0-\udee5\udee9\udef0\udef3]|[\u203c\u2049\u2139\u2194-\u2199\u21a9\u21aa\u231a\u231b\u2328\u23cf\u23ed-\u23ef\u23f1\u23f2\u23f8-\u23fa\u24c2\u25aa\u25ab\u25b6\u25c0\u25fb-\u25fe\u2600-\u2604\u260e\u2611\u2614\u2615\u2618\u2620\u2622\u2623\u2626\u262a\u262e\u262f\u2638-\u263a\u2640\u2642\u2648-\u2653\u2660\u2663\u2665\u2666\u2668\u267b\u267f\u2692-\u2697\u2699\u269b\u269c\u26a0\u26a1\u26a7\u26aa\u26ab\u26b0\u26b1\u26bd\u26be\u26c4\u26c5\u26c8\u26cf\u26d1\u26d3\u26d4\u26e9\u26ea\u26f0-\u26f5\u26f8\u26fa\u26fd\u2702\u2708\u2709\u270f\u2712\u2714\u2716\u271d\u2721\u2733\u2734\u2744\u2747\u2757\u2763\u2764\u27a1\u2934\u2935\u2b05-\u2b07\u2b1b\u2b1c\u2b50\u2b55\u3030\u303d\u3297\u3299])(?:\ufe0f|(?!\ufe0e))|(?:(?:\ud83c[\udfcb\udfcc]|\ud83d[\udd74\udd75\udd90]|\ud83e\udef0|[\u261d\u26f7\u26f9\u270c\u270d])(?:\ufe0f|(?!\ufe0e))|(?:\ud83c\udfc3|\ud83d\udeb6|\ud83e\uddce)(?:\ud83c[\udffb-\udfff])?(?:\u200d\u27a1\ufe0f)?|(?:\ud83c[\udf85\udfc2\udfc4\udfc7\udfca]|\ud83d[\udc42\udc43\udc46-\udc50\udc66-\udc69\udc6e\udc70-\udc78\udc7c\udc81-\udc83\udc85-\udc87\udcaa\udd7a\udd95\udd96\ude45-\ude47\ude4b-\ude4f\udea3\udeb4\udeb5\udec0\udecc]|\ud83e[\udd0c\udd0f\udd18-\udd1c\udd1e\udd1f\udd26\udd30-\udd39\udd3d\udd3e\udd77\uddb5\uddb6\uddb8\uddb9\uddbb\uddcd\uddcf\uddd1-\udddd\udec3-\udec5\udef1-\udef8]|[\u270a\u270b]))(?:\ud83c[\udffb-\udfff])?|(?:\ud83c\udff4\udb40\udc67\udb40\udc62\udb40\udc65\udb40\udc6e\udb40\udc67\udb40\udc7f|\ud83c\udff4\udb40\udc67\udb40\udc62\udb40\udc73\udb40\udc63\udb40\udc74\udb40\udc7f|\ud83c\udff4\udb40\udc67\udb40\udc62\udb40\udc77\udb40\udc6c\udb40\udc73\udb40\udc7f|\ud83c\udde6\ud83c[\udde8-\uddec\uddee\uddf1\uddf2\uddf4\uddf6-\uddfa\uddfc\uddfd\uddff]|\ud83c\udde7\ud83c[\udde6\udde7\udde9-\uddef\uddf1-\uddf4\uddf6-\uddf9\uddfb\uddfc\uddfe\uddff]|\ud83c\udde8\ud83c[\udde6\udde8\udde9\uddeb-\uddee\uddf0-\uddf5\uddf7\uddfa-\uddff]|\ud83c\udde9\ud83c[\uddea\uddec\uddef\uddf0\uddf2\uddf4\uddff]|\ud83c\uddea\ud83c[\udde6\udde8\uddea\uddec\udded\uddf7-\uddfa]|\ud83c\uddeb\ud83c[\uddee-\uddf0\uddf2\uddf4\uddf7]|\ud83c\uddec\ud83c[\udde6\udde7\udde9-\uddee\uddf1-\uddf3\uddf5-\uddfa\uddfc\uddfe]|\ud83c\udded\ud83c[\uddf0\uddf2\uddf3\uddf7\uddf9\uddfa]|\ud83c\uddee\ud83c[\udde8-\uddea\uddf1-\uddf4\uddf6-\uddf9]|\ud83c\uddef\ud83c[\uddea\uddf2\uddf4\uddf5]|\ud83c\uddf0\ud83c[\uddea\uddec-\uddee\uddf2\uddf3\uddf5\uddf7\uddfc\uddfe\uddff]|\ud83c\uddf1\ud83c[\udde6-\udde8\uddee\uddf0\uddf7-\uddfb\uddfe]|\ud83c\uddf2\ud83c[\udde6\udde8-\udded\uddf0-\uddff]|\ud83c\uddf3\ud83c[\udde6\udde8\uddea-\uddec\uddee\uddf1\uddf4\uddf5\uddf7\uddfa\uddff]|\ud83c\uddf4\ud83c\uddf2|\ud83c\uddf5\ud83c[\udde6\uddea-\udded\uddf0-\uddf3\uddf7-\uddf9\uddfc\uddfe]|\ud83c\uddf6\ud83c\udde6|\ud83c\uddf7\ud83c[\uddea\uddf4\uddf8\uddfa\uddfc]|\ud83c\uddf8\ud83c[\udde6-\uddea\uddec-\uddf4\uddf7-\uddf9\uddfb\uddfd-\uddff]|\ud83c\uddf9\ud83c[\udde6\udde8\udde9\uddeb-\udded\uddef-\uddf4\uddf7\uddf9\uddfb\uddfc\uddff]|\ud83c\uddfa\ud83c[\udde6\uddec\uddf2\uddf3\uddf8\uddfe\uddff]|\ud83c\uddfb\ud83c[\udde6\udde8\uddea\uddec\uddee\uddf3\uddfa]|\ud83c\uddfc\ud83c[\uddeb\uddf8]|\ud83c\uddfd\ud83c\uddf0|\ud83c\uddfe\ud83c[\uddea\uddf9]|\ud83c\uddff\ud83c[\udde6\uddf2\uddfc]|\ud83c[\udccf\udd8e\udd91-\udd9a\udde6-\uddff\ude01\ude32-\ude36\ude38-\ude3a\ude50\ude51\udf00-\udf20\udf2d-\udf35\udf37-\udf7c\udf7e-\udf84\udf86-\udf93\udfa0-\udfc1\udfc5\udfc6\udfc8\udfc9\udfcf-\udfd3\udfe0-\udff0\udff4\udff8-\udfff]|\ud83d[\udc00-\udc3e\udc40\udc44\udc45\udc51-\udc65\udc6a\udc6f\udc79-\udc7b\udc7d-\udc80\udc84\udc88-\udc8e\udc90\udc92-\udca9\udcab-\udcfc\udcff-\udd3d\udd4b-\udd4e\udd50-\udd67\udda4\uddfb-\ude44\ude48-\ude4a\ude80-\udea2\udea4-\udeb3\udeb7-\udebf\udec1-\udec5\uded0-\uded2\uded5-\uded7\udedc-\udedf\udeeb\udeec\udef4-\udefc\udfe0-\udfeb\udff0]|\ud83e[\udd0d\udd0e\udd10-\udd17\udd20-\udd25\udd27-\udd2f\udd3a\udd3c\udd3f-\udd45\udd47-\udd76\udd78-\uddb4\uddb7\uddba\uddbc-\uddcc\uddd0\uddde-\uddff\ude70-\ude7c\ude80-\ude88\ude90-\udebd\udebf-\udec2\udece-\udedb\udee0-\udee8]|[\u23e9-\u23ec\u23f0\u23f3\u267e\u26ce\u2705\u2728\u274c\u274e\u2753-\u2755\u2795-\u2797\u27b0\u27bf\ue50a])|\ufe0f/g,UFE0Fg=/\uFE0F/g,U200D=String.fromCharCode(8205),rescaper=/[&<>'"]/g,shouldntBeParsed=/^(?:iframe|noframes|noscript|script|select|style|textarea)$/,fromCharCode=String.fromCharCode;return twemoji;function createText(text,clean){return document.createTextNode(clean?text.replace(UFE0Fg,""):text)}function escapeHTML(s){return s.replace(rescaper,replacer)}function defaultImageSrcGenerator(icon,options){return "".concat(options.base,options.size,"/",icon,options.ext)}function grabAllTextNodes(node,allText){var childNodes=node.childNodes,length=childNodes.length,subnode,nodeType;while(length--){subnode=childNodes[length];nodeType=subnode.nodeType;if(nodeType===3){allText.push(subnode);}else if(nodeType===1&&!("ownerSVGElement"in subnode)&&!shouldntBeParsed.test(subnode.nodeName.toLowerCase())){grabAllTextNodes(subnode,allText);}}return allText}function grabTheRightIcon(rawText){return toCodePoint(rawText.indexOf(U200D)<0?rawText.replace(UFE0Fg,""):rawText)}function parseNode(node,options){var allText=grabAllTextNodes(node,[]),length=allText.length,attrib,attrname,modified,fragment,subnode,text,match,i,index,img,rawText,iconId,src;while(length--){modified=false;fragment=document.createDocumentFragment();subnode=allText[length];text=subnode.nodeValue;i=0;while(match=re.exec(text)){index=match.index;if(index!==i){fragment.appendChild(createText(text.slice(i,index),true));}rawText=match[0];iconId=grabTheRightIcon(rawText);i=index+rawText.length;src=options.callback(iconId,options);if(iconId&&src){img=new Image;img.onerror=options.onerror;img.setAttribute("draggable","false");attrib=options.attributes(rawText,iconId);for(attrname in attrib){if(attrib.hasOwnProperty(attrname)&&attrname.indexOf("on")!==0&&!img.hasAttribute(attrname)){img.setAttribute(attrname,attrib[attrname]);}}img.className=options.className;img.alt=rawText;img.src=src;modified=true;fragment.appendChild(img);}if(!img)fragment.appendChild(createText(rawText,false));img=null;}if(modified){if(i<text.length){fragment.appendChild(createText(text.slice(i),true));}subnode.parentNode.replaceChild(fragment,subnode);}}return node}function parseString(str,options){return replace(str,function(rawText){var ret=rawText,iconId=grabTheRightIcon(rawText),src=options.callback(iconId,options),attrib,attrname;if(iconId&&src){ret="<img ".concat('class="',options.className,'" ','draggable="false" ','alt="',rawText,'"',' src="',src,'"');attrib=options.attributes(rawText,iconId);for(attrname in attrib){if(attrib.hasOwnProperty(attrname)&&attrname.indexOf("on")!==0&&ret.indexOf(" "+attrname+"=")===-1){ret=ret.concat(" ",attrname,'="',escapeHTML(attrib[attrname]),'"');}}ret=ret.concat("/>");}return ret})}function replacer(m){return escaper[m]}function returnNull(){return null}function toSizeSquaredAsset(value){return typeof value==="number"?value+"x"+value:value}function fromCodePoint(codepoint){var code=typeof codepoint==="string"?parseInt(codepoint,16):codepoint;if(code<65536){return fromCharCode(code)}code-=65536;return fromCharCode(55296+(code>>10),56320+(code&1023))}function parse(what,how){if(!how||typeof how==="function"){how={callback:how};}return (typeof what==="string"?parseString:parseNode)(what,{callback:how.callback||defaultImageSrcGenerator,attributes:typeof how.attributes==="function"?how.attributes:returnNull,base:typeof how.base==="string"?how.base:twemoji.base,ext:how.ext||twemoji.ext,size:how.folder||toSizeSquaredAsset(how.size||twemoji.size),className:how.className||twemoji.className,onerror:how.onerror||twemoji.onerror})}function replace(text,callback){return String(text).replace(re,callback)}function test(text){re.lastIndex=0;var result=re.test(text);re.lastIndex=0;return result}function toCodePoint(unicodeSurrogates,sep){var r=[],c=0,p=0,i=0;while(i<unicodeSurrogates.length){c=unicodeSurrogates.charCodeAt(i++);if(p){r.push((65536+(p-55296<<10)+(c-56320)).toString(16));p=0;}else if(55296<=c&&c<=56319){p=c;}else {r.push(c.toString(16));}}return r.join(sep||"-")}}();

const getRegex = () => {
    return new RegExp(/[#*0-9]\uFE0F?\u20E3|[\xA9\xAE\u203C\u2049\u2122\u2139\u2194-\u2199\u21A9\u21AA\u231A\u231B\u2328\u23CF\u23ED-\u23EF\u23F1\u23F2\u23F8-\u23FA\u24C2\u25AA\u25AB\u25B6\u25C0\u25FB\u25FC\u25FE\u2600-\u2604\u260E\u2611\u2614\u2615\u2618\u2620\u2622\u2623\u2626\u262A\u262E\u262F\u2638-\u263A\u2640\u2642\u2648-\u2653\u265F\u2660\u2663\u2665\u2666\u2668\u267B\u267E\u267F\u2692\u2694-\u2697\u2699\u269B\u269C\u26A0\u26A7\u26AA\u26B0\u26B1\u26BD\u26BE\u26C4\u26C8\u26CF\u26D1\u26E9\u26F0-\u26F5\u26F7\u26F8\u26FA\u2702\u2708\u2709\u270F\u2712\u2714\u2716\u271D\u2721\u2733\u2734\u2744\u2747\u2757\u2763\u27A1\u2934\u2935\u2B05-\u2B07\u2B1B\u2B1C\u2B55\u3030\u303D\u3297\u3299]\uFE0F?|[\u261D\u270C\u270D](?:\uFE0F|\uD83C[\uDFFB-\uDFFF])?|[\u270A\u270B](?:\uD83C[\uDFFB-\uDFFF])?|[\u23E9-\u23EC\u23F0\u23F3\u25FD\u2693\u26A1\u26AB\u26C5\u26CE\u26D4\u26EA\u26FD\u2705\u2728\u274C\u274E\u2753-\u2755\u2795-\u2797\u27B0\u27BF\u2B50]|\u26D3\uFE0F?(?:\u200D\uD83D\uDCA5)?|\u26F9(?:\uFE0F|\uD83C[\uDFFB-\uDFFF])?(?:\u200D[\u2640\u2642]\uFE0F?)?|\u2764\uFE0F?(?:\u200D(?:\uD83D\uDD25|\uD83E\uDE79))?|\uD83C(?:[\uDC04\uDD70\uDD71\uDD7E\uDD7F\uDE02\uDE37\uDF21\uDF24-\uDF2C\uDF36\uDF7D\uDF96\uDF97\uDF99-\uDF9B\uDF9E\uDF9F\uDFCD\uDFCE\uDFD4-\uDFDF\uDFF5\uDFF7]\uFE0F?|[\uDF85\uDFC2\uDFC7](?:\uD83C[\uDFFB-\uDFFF])?|[\uDFC4\uDFCA](?:\uD83C[\uDFFB-\uDFFF])?(?:\u200D[\u2640\u2642]\uFE0F?)?|[\uDFCB\uDFCC](?:\uFE0F|\uD83C[\uDFFB-\uDFFF])?(?:\u200D[\u2640\u2642]\uFE0F?)?|[\uDCCF\uDD8E\uDD91-\uDD9A\uDE01\uDE1A\uDE2F\uDE32-\uDE36\uDE38-\uDE3A\uDE50\uDE51\uDF00-\uDF20\uDF2D-\uDF35\uDF37-\uDF43\uDF45-\uDF4A\uDF4C-\uDF7C\uDF7E-\uDF84\uDF86-\uDF93\uDFA0-\uDFC1\uDFC5\uDFC6\uDFC8\uDFC9\uDFCF-\uDFD3\uDFE0-\uDFF0\uDFF8-\uDFFF]|\uDDE6\uD83C[\uDDE8-\uDDEC\uDDEE\uDDF1\uDDF2\uDDF4\uDDF6-\uDDFA\uDDFC\uDDFD\uDDFF]|\uDDE7\uD83C[\uDDE6\uDDE7\uDDE9-\uDDEF\uDDF1-\uDDF4\uDDF6-\uDDF9\uDDFB\uDDFC\uDDFE\uDDFF]|\uDDE8\uD83C[\uDDE6\uDDE8\uDDE9\uDDEB-\uDDEE\uDDF0-\uDDF5\uDDF7\uDDFA-\uDDFF]|\uDDE9\uD83C[\uDDEA\uDDEC\uDDEF\uDDF0\uDDF2\uDDF4\uDDFF]|\uDDEA\uD83C[\uDDE6\uDDE8\uDDEA\uDDEC\uDDED\uDDF7-\uDDFA]|\uDDEB\uD83C[\uDDEE-\uDDF0\uDDF2\uDDF4\uDDF7]|\uDDEC\uD83C[\uDDE6\uDDE7\uDDE9-\uDDEE\uDDF1-\uDDF3\uDDF5-\uDDFA\uDDFC\uDDFE]|\uDDED\uD83C[\uDDF0\uDDF2\uDDF3\uDDF7\uDDF9\uDDFA]|\uDDEE\uD83C[\uDDE8-\uDDEA\uDDF1-\uDDF4\uDDF6-\uDDF9]|\uDDEF\uD83C[\uDDEA\uDDF2\uDDF4\uDDF5]|\uDDF0\uD83C[\uDDEA\uDDEC-\uDDEE\uDDF2\uDDF3\uDDF5\uDDF7\uDDFC\uDDFE\uDDFF]|\uDDF1\uD83C[\uDDE6-\uDDE8\uDDEE\uDDF0\uDDF7-\uDDFB\uDDFE]|\uDDF2\uD83C[\uDDE6\uDDE8-\uDDED\uDDF0-\uDDFF]|\uDDF3\uD83C[\uDDE6\uDDE8\uDDEA-\uDDEC\uDDEE\uDDF1\uDDF4\uDDF5\uDDF7\uDDFA\uDDFF]|\uDDF4\uD83C\uDDF2|\uDDF5\uD83C[\uDDE6\uDDEA-\uDDED\uDDF0-\uDDF3\uDDF7-\uDDF9\uDDFC\uDDFE]|\uDDF6\uD83C\uDDE6|\uDDF7\uD83C[\uDDEA\uDDF4\uDDF8\uDDFA\uDDFC]|\uDDF8\uD83C[\uDDE6-\uDDEA\uDDEC-\uDDF4\uDDF7-\uDDF9\uDDFB\uDDFD-\uDDFF]|\uDDF9\uD83C[\uDDE6\uDDE8\uDDE9\uDDEB-\uDDED\uDDEF-\uDDF4\uDDF7\uDDF9\uDDFB\uDDFC\uDDFF]|\uDDFA\uD83C[\uDDE6\uDDEC\uDDF2\uDDF3\uDDF8\uDDFE\uDDFF]|\uDDFB\uD83C[\uDDE6\uDDE8\uDDEA\uDDEC\uDDEE\uDDF3\uDDFA]|\uDDFC\uD83C[\uDDEB\uDDF8]|\uDDFD\uD83C\uDDF0|\uDDFE\uD83C[\uDDEA\uDDF9]|\uDDFF\uD83C[\uDDE6\uDDF2\uDDFC]|\uDF44(?:\u200D\uD83D\uDFEB)?|\uDF4B(?:\u200D\uD83D\uDFE9)?|\uDFC3(?:\uD83C[\uDFFB-\uDFFF])?(?:\u200D(?:[\u2640\u2642]\uFE0F?(?:\u200D\u27A1\uFE0F?)?|\u27A1\uFE0F?))?|\uDFF3\uFE0F?(?:\u200D(?:\u26A7\uFE0F?|\uD83C\uDF08))?|\uDFF4(?:\u200D\u2620\uFE0F?|\uDB40\uDC67\uDB40\uDC62\uDB40(?:\uDC65\uDB40\uDC6E\uDB40\uDC67|\uDC73\uDB40\uDC63\uDB40\uDC74|\uDC77\uDB40\uDC6C\uDB40\uDC73)\uDB40\uDC7F)?)|\uD83D(?:[\uDC3F\uDCFD\uDD49\uDD4A\uDD6F\uDD70\uDD73\uDD76-\uDD79\uDD87\uDD8A-\uDD8D\uDDA5\uDDA8\uDDB1\uDDB2\uDDBC\uDDC2-\uDDC4\uDDD1-\uDDD3\uDDDC-\uDDDE\uDDE1\uDDE3\uDDE8\uDDEF\uDDF3\uDDFA\uDECB\uDECD-\uDECF\uDEE0-\uDEE5\uDEE9\uDEF0\uDEF3]\uFE0F?|[\uDC42\uDC43\uDC46-\uDC50\uDC66\uDC67\uDC6B-\uDC6D\uDC72\uDC74-\uDC76\uDC78\uDC7C\uDC83\uDC85\uDC8F\uDC91\uDCAA\uDD7A\uDD95\uDD96\uDE4C\uDE4F\uDEC0\uDECC](?:\uD83C[\uDFFB-\uDFFF])?|[\uDC6E\uDC70\uDC71\uDC73\uDC77\uDC81\uDC82\uDC86\uDC87\uDE45-\uDE47\uDE4B\uDE4D\uDE4E\uDEA3\uDEB4\uDEB5](?:\uD83C[\uDFFB-\uDFFF])?(?:\u200D[\u2640\u2642]\uFE0F?)?|[\uDD74\uDD90](?:\uFE0F|\uD83C[\uDFFB-\uDFFF])?|[\uDC00-\uDC07\uDC09-\uDC14\uDC16-\uDC25\uDC27-\uDC3A\uDC3C-\uDC3E\uDC40\uDC44\uDC45\uDC51-\uDC65\uDC6A\uDC79-\uDC7B\uDC7D-\uDC80\uDC84\uDC88-\uDC8E\uDC90\uDC92-\uDCA9\uDCAB-\uDCFC\uDCFF-\uDD3D\uDD4B-\uDD4E\uDD50-\uDD67\uDDA4\uDDFB-\uDE2D\uDE2F-\uDE34\uDE37-\uDE41\uDE43\uDE44\uDE48-\uDE4A\uDE80-\uDEA2\uDEA4-\uDEB3\uDEB7-\uDEBF\uDEC1-\uDEC5\uDED0-\uDED2\uDED5-\uDED7\uDEDC-\uDEDF\uDEEB\uDEEC\uDEF4-\uDEFC\uDFE0-\uDFEB\uDFF0]|\uDC08(?:\u200D\u2B1B)?|\uDC15(?:\u200D\uD83E\uDDBA)?|\uDC26(?:\u200D(?:\u2B1B|\uD83D\uDD25))?|\uDC3B(?:\u200D\u2744\uFE0F?)?|\uDC41\uFE0F?(?:\u200D\uD83D\uDDE8\uFE0F?)?|\uDC68(?:\u200D(?:[\u2695\u2696\u2708]\uFE0F?|\u2764\uFE0F?\u200D\uD83D(?:\uDC8B\u200D\uD83D)?\uDC68|\uD83C[\uDF3E\uDF73\uDF7C\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D(?:[\uDC68\uDC69]\u200D\uD83D(?:\uDC66(?:\u200D\uD83D\uDC66)?|\uDC67(?:\u200D\uD83D[\uDC66\uDC67])?)|[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uDC66(?:\u200D\uD83D\uDC66)?|\uDC67(?:\u200D\uD83D[\uDC66\uDC67])?)|\uD83E(?:[\uDDAF\uDDBC\uDDBD](?:\u200D\u27A1\uFE0F?)?|[\uDDB0-\uDDB3]))|\uD83C(?:\uDFFB(?:\u200D(?:[\u2695\u2696\u2708]\uFE0F?|\u2764\uFE0F?\u200D\uD83D(?:\uDC8B\u200D\uD83D)?\uDC68\uD83C[\uDFFB-\uDFFF]|\uD83C[\uDF3E\uDF73\uDF7C\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E(?:[\uDDAF\uDDBC\uDDBD](?:\u200D\u27A1\uFE0F?)?|[\uDDB0-\uDDB3]|\uDD1D\u200D\uD83D\uDC68\uD83C[\uDFFC-\uDFFF])))?|\uDFFC(?:\u200D(?:[\u2695\u2696\u2708]\uFE0F?|\u2764\uFE0F?\u200D\uD83D(?:\uDC8B\u200D\uD83D)?\uDC68\uD83C[\uDFFB-\uDFFF]|\uD83C[\uDF3E\uDF73\uDF7C\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E(?:[\uDDAF\uDDBC\uDDBD](?:\u200D\u27A1\uFE0F?)?|[\uDDB0-\uDDB3]|\uDD1D\u200D\uD83D\uDC68\uD83C[\uDFFB\uDFFD-\uDFFF])))?|\uDFFD(?:\u200D(?:[\u2695\u2696\u2708]\uFE0F?|\u2764\uFE0F?\u200D\uD83D(?:\uDC8B\u200D\uD83D)?\uDC68\uD83C[\uDFFB-\uDFFF]|\uD83C[\uDF3E\uDF73\uDF7C\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E(?:[\uDDAF\uDDBC\uDDBD](?:\u200D\u27A1\uFE0F?)?|[\uDDB0-\uDDB3]|\uDD1D\u200D\uD83D\uDC68\uD83C[\uDFFB\uDFFC\uDFFE\uDFFF])))?|\uDFFE(?:\u200D(?:[\u2695\u2696\u2708]\uFE0F?|\u2764\uFE0F?\u200D\uD83D(?:\uDC8B\u200D\uD83D)?\uDC68\uD83C[\uDFFB-\uDFFF]|\uD83C[\uDF3E\uDF73\uDF7C\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E(?:[\uDDAF\uDDBC\uDDBD](?:\u200D\u27A1\uFE0F?)?|[\uDDB0-\uDDB3]|\uDD1D\u200D\uD83D\uDC68\uD83C[\uDFFB-\uDFFD\uDFFF])))?|\uDFFF(?:\u200D(?:[\u2695\u2696\u2708]\uFE0F?|\u2764\uFE0F?\u200D\uD83D(?:\uDC8B\u200D\uD83D)?\uDC68\uD83C[\uDFFB-\uDFFF]|\uD83C[\uDF3E\uDF73\uDF7C\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E(?:[\uDDAF\uDDBC\uDDBD](?:\u200D\u27A1\uFE0F?)?|[\uDDB0-\uDDB3]|\uDD1D\u200D\uD83D\uDC68\uD83C[\uDFFB-\uDFFE])))?))?|\uDC69(?:\u200D(?:[\u2695\u2696\u2708]\uFE0F?|\u2764\uFE0F?\u200D\uD83D(?:\uDC8B\u200D\uD83D)?[\uDC68\uDC69]|\uD83C[\uDF3E\uDF73\uDF7C\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D(?:[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uDC66(?:\u200D\uD83D\uDC66)?|\uDC67(?:\u200D\uD83D[\uDC66\uDC67])?|\uDC69\u200D\uD83D(?:\uDC66(?:\u200D\uD83D\uDC66)?|\uDC67(?:\u200D\uD83D[\uDC66\uDC67])?))|\uD83E(?:[\uDDAF\uDDBC\uDDBD](?:\u200D\u27A1\uFE0F?)?|[\uDDB0-\uDDB3]))|\uD83C(?:\uDFFB(?:\u200D(?:[\u2695\u2696\u2708]\uFE0F?|\u2764\uFE0F?\u200D\uD83D(?:[\uDC68\uDC69]|\uDC8B\u200D\uD83D[\uDC68\uDC69])\uD83C[\uDFFB-\uDFFF]|\uD83C[\uDF3E\uDF73\uDF7C\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E(?:[\uDDAF\uDDBC\uDDBD](?:\u200D\u27A1\uFE0F?)?|[\uDDB0-\uDDB3]|\uDD1D\u200D\uD83D[\uDC68\uDC69]\uD83C[\uDFFC-\uDFFF])))?|\uDFFC(?:\u200D(?:[\u2695\u2696\u2708]\uFE0F?|\u2764\uFE0F?\u200D\uD83D(?:[\uDC68\uDC69]|\uDC8B\u200D\uD83D[\uDC68\uDC69])\uD83C[\uDFFB-\uDFFF]|\uD83C[\uDF3E\uDF73\uDF7C\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E(?:[\uDDAF\uDDBC\uDDBD](?:\u200D\u27A1\uFE0F?)?|[\uDDB0-\uDDB3]|\uDD1D\u200D\uD83D[\uDC68\uDC69]\uD83C[\uDFFB\uDFFD-\uDFFF])))?|\uDFFD(?:\u200D(?:[\u2695\u2696\u2708]\uFE0F?|\u2764\uFE0F?\u200D\uD83D(?:[\uDC68\uDC69]|\uDC8B\u200D\uD83D[\uDC68\uDC69])\uD83C[\uDFFB-\uDFFF]|\uD83C[\uDF3E\uDF73\uDF7C\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E(?:[\uDDAF\uDDBC\uDDBD](?:\u200D\u27A1\uFE0F?)?|[\uDDB0-\uDDB3]|\uDD1D\u200D\uD83D[\uDC68\uDC69]\uD83C[\uDFFB\uDFFC\uDFFE\uDFFF])))?|\uDFFE(?:\u200D(?:[\u2695\u2696\u2708]\uFE0F?|\u2764\uFE0F?\u200D\uD83D(?:[\uDC68\uDC69]|\uDC8B\u200D\uD83D[\uDC68\uDC69])\uD83C[\uDFFB-\uDFFF]|\uD83C[\uDF3E\uDF73\uDF7C\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E(?:[\uDDAF\uDDBC\uDDBD](?:\u200D\u27A1\uFE0F?)?|[\uDDB0-\uDDB3]|\uDD1D\u200D\uD83D[\uDC68\uDC69]\uD83C[\uDFFB-\uDFFD\uDFFF])))?|\uDFFF(?:\u200D(?:[\u2695\u2696\u2708]\uFE0F?|\u2764\uFE0F?\u200D\uD83D(?:[\uDC68\uDC69]|\uDC8B\u200D\uD83D[\uDC68\uDC69])\uD83C[\uDFFB-\uDFFF]|\uD83C[\uDF3E\uDF73\uDF7C\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E(?:[\uDDAF\uDDBC\uDDBD](?:\u200D\u27A1\uFE0F?)?|[\uDDB0-\uDDB3]|\uDD1D\u200D\uD83D[\uDC68\uDC69]\uD83C[\uDFFB-\uDFFE])))?))?|\uDC6F(?:\u200D[\u2640\u2642]\uFE0F?)?|\uDD75(?:\uFE0F|\uD83C[\uDFFB-\uDFFF])?(?:\u200D[\u2640\u2642]\uFE0F?)?|\uDE2E(?:\u200D\uD83D\uDCA8)?|\uDE35(?:\u200D\uD83D\uDCAB)?|\uDE36(?:\u200D\uD83C\uDF2B\uFE0F?)?|\uDE42(?:\u200D[\u2194\u2195]\uFE0F?)?|\uDEB6(?:\uD83C[\uDFFB-\uDFFF])?(?:\u200D(?:[\u2640\u2642]\uFE0F?(?:\u200D\u27A1\uFE0F?)?|\u27A1\uFE0F?))?)|\uD83E(?:[\uDD0C\uDD0F\uDD18-\uDD1F\uDD30-\uDD34\uDD36\uDD77\uDDB5\uDDB6\uDDBB\uDDD2\uDDD3\uDDD5\uDEC3-\uDEC5\uDEF0\uDEF2-\uDEF8](?:\uD83C[\uDFFB-\uDFFF])?|[\uDD26\uDD35\uDD37-\uDD39\uDD3D\uDD3E\uDDB8\uDDB9\uDDCD\uDDCF\uDDD4\uDDD6-\uDDDD](?:\uD83C[\uDFFB-\uDFFF])?(?:\u200D[\u2640\u2642]\uFE0F?)?|[\uDDDE\uDDDF](?:\u200D[\u2640\u2642]\uFE0F?)?|[\uDD0D\uDD0E\uDD10-\uDD17\uDD20-\uDD25\uDD27-\uDD2F\uDD3A\uDD3F-\uDD45\uDD47-\uDD76\uDD78-\uDDB4\uDDB7\uDDBA\uDDBC-\uDDCC\uDDD0\uDDE0-\uDDFF\uDE70-\uDE7C\uDE80-\uDE88\uDE90-\uDEBD\uDEBF-\uDEC2\uDECE-\uDEDB\uDEE0-\uDEE8]|\uDD3C(?:\u200D[\u2640\u2642]\uFE0F?|\uD83C[\uDFFB-\uDFFF])?|\uDDCE(?:\uD83C[\uDFFB-\uDFFF])?(?:\u200D(?:[\u2640\u2642]\uFE0F?(?:\u200D\u27A1\uFE0F?)?|\u27A1\uFE0F?))?|\uDDD1(?:\u200D(?:[\u2695\u2696\u2708]\uFE0F?|\uD83C[\uDF3E\uDF73\uDF7C\uDF84\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E(?:[\uDDAF\uDDBC\uDDBD](?:\u200D\u27A1\uFE0F?)?|[\uDDB0-\uDDB3]|\uDD1D\u200D\uD83E\uDDD1|\uDDD1\u200D\uD83E\uDDD2(?:\u200D\uD83E\uDDD2)?|\uDDD2(?:\u200D\uD83E\uDDD2)?))|\uD83C(?:\uDFFB(?:\u200D(?:[\u2695\u2696\u2708]\uFE0F?|\u2764\uFE0F?\u200D(?:\uD83D\uDC8B\u200D)?\uD83E\uDDD1\uD83C[\uDFFC-\uDFFF]|\uD83C[\uDF3E\uDF73\uDF7C\uDF84\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E(?:[\uDDAF\uDDBC\uDDBD](?:\u200D\u27A1\uFE0F?)?|[\uDDB0-\uDDB3]|\uDD1D\u200D\uD83E\uDDD1\uD83C[\uDFFB-\uDFFF])))?|\uDFFC(?:\u200D(?:[\u2695\u2696\u2708]\uFE0F?|\u2764\uFE0F?\u200D(?:\uD83D\uDC8B\u200D)?\uD83E\uDDD1\uD83C[\uDFFB\uDFFD-\uDFFF]|\uD83C[\uDF3E\uDF73\uDF7C\uDF84\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E(?:[\uDDAF\uDDBC\uDDBD](?:\u200D\u27A1\uFE0F?)?|[\uDDB0-\uDDB3]|\uDD1D\u200D\uD83E\uDDD1\uD83C[\uDFFB-\uDFFF])))?|\uDFFD(?:\u200D(?:[\u2695\u2696\u2708]\uFE0F?|\u2764\uFE0F?\u200D(?:\uD83D\uDC8B\u200D)?\uD83E\uDDD1\uD83C[\uDFFB\uDFFC\uDFFE\uDFFF]|\uD83C[\uDF3E\uDF73\uDF7C\uDF84\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E(?:[\uDDAF\uDDBC\uDDBD](?:\u200D\u27A1\uFE0F?)?|[\uDDB0-\uDDB3]|\uDD1D\u200D\uD83E\uDDD1\uD83C[\uDFFB-\uDFFF])))?|\uDFFE(?:\u200D(?:[\u2695\u2696\u2708]\uFE0F?|\u2764\uFE0F?\u200D(?:\uD83D\uDC8B\u200D)?\uD83E\uDDD1\uD83C[\uDFFB-\uDFFD\uDFFF]|\uD83C[\uDF3E\uDF73\uDF7C\uDF84\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E(?:[\uDDAF\uDDBC\uDDBD](?:\u200D\u27A1\uFE0F?)?|[\uDDB0-\uDDB3]|\uDD1D\u200D\uD83E\uDDD1\uD83C[\uDFFB-\uDFFF])))?|\uDFFF(?:\u200D(?:[\u2695\u2696\u2708]\uFE0F?|\u2764\uFE0F?\u200D(?:\uD83D\uDC8B\u200D)?\uD83E\uDDD1\uD83C[\uDFFB-\uDFFE]|\uD83C[\uDF3E\uDF73\uDF7C\uDF84\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E(?:[\uDDAF\uDDBC\uDDBD](?:\u200D\u27A1\uFE0F?)?|[\uDDB0-\uDDB3]|\uDD1D\u200D\uD83E\uDDD1\uD83C[\uDFFB-\uDFFF])))?))?|\uDEF1(?:\uD83C(?:\uDFFB(?:\u200D\uD83E\uDEF2\uD83C[\uDFFC-\uDFFF])?|\uDFFC(?:\u200D\uD83E\uDEF2\uD83C[\uDFFB\uDFFD-\uDFFF])?|\uDFFD(?:\u200D\uD83E\uDEF2\uD83C[\uDFFB\uDFFC\uDFFE\uDFFF])?|\uDFFE(?:\u200D\uD83E\uDEF2\uD83C[\uDFFB-\uDFFD\uDFFF])?|\uDFFF(?:\u200D\uD83E\uDEF2\uD83C[\uDFFB-\uDFFE])?))?)/, 'g');
};
const shortNames = {
    '😀': 'grinning face',
    '😃': 'grinning face with big eyes',
    '😄': 'grinning face with smiling eyes',
    '😁': 'beaming face with smiling eyes',
    '😆': 'grinning squinting face',
    '😅': 'grinning face with sweat',
    '🤣': 'rolling on the floor laughing',
    '😂': 'face with tears of joy',
    '🙂': 'slightly smiling face',
    '🙃': 'upside-down face',
    '🫠': '⊛ melting face',
    '😉': 'winking face',
    '😊': 'smiling face with smiling eyes',
    '😇': 'smiling face with halo',
    '🥰': 'smiling face with hearts',
    '😍': 'smiling face with heart-eyes',
    '🤩': 'star-struck',
    '😘': 'face blowing a kiss',
    '😗': 'kissing face',
    '☺': 'smiling face',
    '😚': 'kissing face with closed eyes',
    '😙': 'kissing face with smiling eyes',
    '🥲': 'smiling face with tear',
    '😋': 'face savoring food',
    '😛': 'face with tongue',
    '😜': 'winking face with tongue',
    '🤪': 'zany face',
    '😝': 'squinting face with tongue',
    '🤑': 'money-mouth face',
    '🤗': 'smiling face with open hands',
    '🤭': 'face with hand over mouth',
    '🫢': '⊛ face with open eyes and hand over mouth',
    '🫣': '⊛ face with peeking eye',
    '🤫': 'shushing face',
    '🤔': 'thinking face',
    '🫡': '⊛ saluting face',
    '🤐': 'zipper-mouth face',
    '🤨': 'face with raised eyebrow',
    '😐': 'neutral face',
    '😑': 'expressionless face',
    '😶': 'face without mouth',
    '🫥': '⊛ dotted line face',
    '😶‍🌫️': 'face in clouds',
    '😏': 'smirking face',
    '😒': 'unamused face',
    '🙄': 'face with rolling eyes',
    '😬': 'grimacing face',
    '😮‍💨': 'face exhaling',
    '🤥': 'lying face',
    '😌': 'relieved face',
    '😔': 'pensive face',
    '😪': 'sleepy face',
    '🤤': 'drooling face',
    '😴': 'sleeping face',
    '😷': 'face with medical mask',
    '🤒': 'face with thermometer',
    '🤕': 'face with head-bandage',
    '🤢': 'nauseated face',
    '🤮': 'face vomiting',
    '🤧': 'sneezing face',
    '🥵': 'hot face',
    '🥶': 'cold face',
    '🥴': 'woozy face',
    '😵': 'face with crossed-out eyes',
    '😵‍💫': 'face with spiral eyes',
    '🤯': 'exploding head',
    '🤠': 'cowboy hat face',
    '🥳': 'partying face',
    '🥸': 'disguised face',
    '😎': 'smiling face with sunglasses',
    '🤓': 'nerd face',
    '🧐': 'face with monocle',
    '😕': 'confused face',
    '🫤': '⊛ face with diagonal mouth',
    '😟': 'worried face',
    '🙁': 'slightly frowning face',
    '☹': 'frowning face',
    '😮': 'face with open mouth',
    '😯': 'hushed face',
    '😲': 'astonished face',
    '😳': 'flushed face',
    '🥺': 'pleading face',
    '🥹': '⊛ face holding back tears',
    '😦': 'frowning face with open mouth',
    '😧': 'anguished face',
    '😨': 'fearful face',
    '😰': 'anxious face with sweat',
    '😥': 'sad but relieved face',
    '😢': 'crying face',
    '😭': 'loudly crying face',
    '😱': 'face screaming in fear',
    '😖': 'confounded face',
    '😣': 'persevering face',
    '😞': 'disappointed face',
    '😓': 'downcast face with sweat',
    '😩': 'weary face',
    '😫': 'tired face',
    '🥱': 'yawning face',
    '😤': 'face with steam from nose',
    '😡': 'pouting face',
    '😠': 'angry face',
    '🤬': 'face with symbols on mouth',
    '😈': 'smiling face with horns',
    '👿': 'angry face with horns',
    '💀': 'skull',
    '☠': 'skull and crossbones',
    '💩': 'pile of poo',
    '🤡': 'clown face',
    '👹': 'ogre',
    '👺': 'goblin',
    '👻': 'ghost',
    '👽': 'alien',
    '👾': 'alien monster',
    '🤖': 'robot',
    '😺': 'grinning cat',
    '😸': 'grinning cat with smiling eyes',
    '😹': 'cat with tears of joy',
    '😻': 'smiling cat with heart-eyes',
    '😼': 'cat with wry smile',
    '😽': 'kissing cat',
    '🙀': 'weary cat',
    '😿': 'crying cat',
    '😾': 'pouting cat',
    '🙈': 'see-no-evil monkey',
    '🙉': 'hear-no-evil monkey',
    '🙊': 'speak-no-evil monkey',
    '💋': 'kiss mark',
    '💌': 'love letter',
    '💘': 'heart with arrow',
    '💝': 'heart with ribbon',
    '💖': 'sparkling heart',
    '💗': 'growing heart',
    '💓': 'beating heart',
    '💞': 'revolving hearts',
    '💕': 'two hearts',
    '💟': 'heart decoration',
    '❣': 'heart exclamation',
    '💔': 'broken heart',
    '❤️‍🔥': 'heart on fire',
    '❤️‍🩹': 'mending heart',
    '❤': 'red heart',
    '🧡': 'orange heart',
    '💛': 'yellow heart',
    '💚': 'green heart',
    '💙': 'blue heart',
    '💜': 'purple heart',
    '🤎': 'brown heart',
    '🖤': 'black heart',
    '🤍': 'white heart',
    '💯': 'hundred points',
    '💢': 'anger symbol',
    '💥': 'collision',
    '💫': 'dizzy',
    '💦': 'sweat droplets',
    '💨': 'dashing away',
    '🕳': 'hole',
    '💣': 'bomb',
    '💬': 'speech balloon',
    '👁️‍🗨️': 'eye in speech bubble',
    '🗨': 'left speech bubble',
    '🗯': 'right anger bubble',
    '💭': 'thought balloon',
    '💤': 'zzz',
    '👋': 'waving hand',
    '🤚': 'raised back of hand',
    '🖐': 'hand with fingers splayed',
    '✋': 'raised hand',
    '🖖': 'vulcan salute',
    '🫱': '⊛ rightwards hand',
    '🫲': '⊛ leftwards hand',
    '🫳': '⊛ palm down hand',
    '🫴': '⊛ palm up hand',
    '👌': 'OK hand',
    '🤌': 'pinched fingers',
    '🤏': 'pinching hand',
    '✌': 'victory hand',
    '🤞': 'crossed fingers',
    '🫰': '⊛ hand with index finger and thumb crossed',
    '🤟': 'love-you gesture',
    '🤘': 'sign of the horns',
    '🤙': 'call me hand',
    '👈': 'backhand index pointing left',
    '👉': 'backhand index pointing right',
    '👆': 'backhand index pointing up',
    '🖕': 'middle finger',
    '👇': 'backhand index pointing down',
    '☝': 'index pointing up',
    '🫵': '⊛ index pointing at the viewer',
    '👍': 'thumbs up',
    '👎': 'thumbs down',
    '✊': 'raised fist',
    '👊': 'oncoming fist',
    '🤛': 'left-facing fist',
    '🤜': 'right-facing fist',
    '👏': 'clapping hands',
    '🙌': 'raising hands',
    '🫶': '⊛ heart hands',
    '👐': 'open hands',
    '🤲': 'palms up together',
    '🤝': 'handshake',
    '🙏': 'folded hands',
    '✍': 'writing hand',
    '💅': 'nail polish',
    '🤳': 'selfie',
    '💪': 'flexed biceps',
    '🦾': 'mechanical arm',
    '🦿': 'mechanical leg',
    '🦵': 'leg',
    '🦶': 'foot',
    '👂': 'ear',
    '🦻': 'ear with hearing aid',
    '👃': 'nose',
    '🧠': 'brain',
    '🫀': 'anatomical heart',
    '🫁': 'lungs',
    '🦷': 'tooth',
    '🦴': 'bone',
    '👀': 'eyes',
    '👁': 'eye',
    '👅': 'tongue',
    '👄': 'mouth',
    '🫦': '⊛ biting lip',
    '👶': 'baby',
    '🧒': 'child',
    '👦': 'boy',
    '👧': 'girl',
    '🧑': 'person',
    '👱': 'person: blond hair',
    '👨': 'man',
    '🧔': 'person: beard',
    '🧔‍♂️': 'man: beard',
    '🧔‍♀️': 'woman: beard',
    '👨‍🦰': 'man: red hair',
    '👨‍🦱': 'man: curly hair',
    '👨‍🦳': 'man: white hair',
    '👨‍🦲': 'man: bald',
    '👩': 'woman',
    '👩‍🦰': 'woman: red hair',
    '🧑‍🦰': 'person: red hair',
    '👩‍🦱': 'woman: curly hair',
    '🧑‍🦱': 'person: curly hair',
    '👩‍🦳': 'woman: white hair',
    '🧑‍🦳': 'person: white hair',
    '👩‍🦲': 'woman: bald',
    '🧑‍🦲': 'person: bald',
    '👱‍♀️': 'woman: blond hair',
    '👱‍♂️': 'man: blond hair',
    '🧓': 'older person',
    '👴': 'old man',
    '👵': 'old woman',
    '🙍': 'person frowning',
    '🙍‍♂️': 'man frowning',
    '🙍‍♀️': 'woman frowning',
    '🙎': 'person pouting',
    '🙎‍♂️': 'man pouting',
    '🙎‍♀️': 'woman pouting',
    '🙅': 'person gesturing NO',
    '🙅‍♂️': 'man gesturing NO',
    '🙅‍♀️': 'woman gesturing NO',
    '🙆': 'person gesturing OK',
    '🙆‍♂️': 'man gesturing OK',
    '🙆‍♀️': 'woman gesturing OK',
    '💁': 'person tipping hand',
    '💁‍♂️': 'man tipping hand',
    '💁‍♀️': 'woman tipping hand',
    '🙋': 'person raising hand',
    '🙋‍♂️': 'man raising hand',
    '🙋‍♀️': 'woman raising hand',
    '🧏': 'deaf person',
    '🧏‍♂️': 'deaf man',
    '🧏‍♀️': 'deaf woman',
    '🙇': 'person bowing',
    '🙇‍♂️': 'man bowing',
    '🙇‍♀️': 'woman bowing',
    '🤦': 'person facepalming',
    '🤦‍♂️': 'man facepalming',
    '🤦‍♀️': 'woman facepalming',
    '🤷': 'person shrugging',
    '🤷‍♂️': 'man shrugging',
    '🤷‍♀️': 'woman shrugging',
    '🧑‍⚕️': 'health worker',
    '👨‍⚕️': 'man health worker',
    '👩‍⚕️': 'woman health worker',
    '🧑‍🎓': 'student',
    '👨‍🎓': 'man student',
    '👩‍🎓': 'woman student',
    '🧑‍🏫': 'teacher',
    '👨‍🏫': 'man teacher',
    '👩‍🏫': 'woman teacher',
    '🧑‍⚖️': 'judge',
    '👨‍⚖️': 'man judge',
    '👩‍⚖️': 'woman judge',
    '🧑‍🌾': 'farmer',
    '👨‍🌾': 'man farmer',
    '👩‍🌾': 'woman farmer',
    '🧑‍🍳': 'cook',
    '👨‍🍳': 'man cook',
    '👩‍🍳': 'woman cook',
    '🧑‍🔧': 'mechanic',
    '👨‍🔧': 'man mechanic',
    '👩‍🔧': 'woman mechanic',
    '🧑‍🏭': 'factory worker',
    '👨‍🏭': 'man factory worker',
    '👩‍🏭': 'woman factory worker',
    '🧑‍💼': 'office worker',
    '👨‍💼': 'man office worker',
    '👩‍💼': 'woman office worker',
    '🧑‍🔬': 'scientist',
    '👨‍🔬': 'man scientist',
    '👩‍🔬': 'woman scientist',
    '🧑‍💻': 'technologist',
    '👨‍💻': 'man technologist',
    '👩‍💻': 'woman technologist',
    '🧑‍🎤': 'singer',
    '👨‍🎤': 'man singer',
    '👩‍🎤': 'woman singer',
    '🧑‍🎨': 'artist',
    '👨‍🎨': 'man artist',
    '👩‍🎨': 'woman artist',
    '🧑‍✈️': 'pilot',
    '👨‍✈️': 'man pilot',
    '👩‍✈️': 'woman pilot',
    '🧑‍🚀': 'astronaut',
    '👨‍🚀': 'man astronaut',
    '👩‍🚀': 'woman astronaut',
    '🧑‍🚒': 'firefighter',
    '👨‍🚒': 'man firefighter',
    '👩‍🚒': 'woman firefighter',
    '👮': 'police officer',
    '👮‍♂️': 'man police officer',
    '👮‍♀️': 'woman police officer',
    '🕵': 'detective',
    '🕵️‍♂️': 'man detective',
    '🕵️‍♀️': 'woman detective',
    '💂': 'guard',
    '💂‍♂️': 'man guard',
    '💂‍♀️': 'woman guard',
    '🥷': 'ninja',
    '👷': 'construction worker',
    '👷‍♂️': 'man construction worker',
    '👷‍♀️': 'woman construction worker',
    '🫅': '⊛ person with crown',
    '🤴': 'prince',
    '👸': 'princess',
    '👳': 'person wearing turban',
    '👳‍♂️': 'man wearing turban',
    '👳‍♀️': 'woman wearing turban',
    '👲': 'person with skullcap',
    '🧕': 'woman with headscarf',
    '🤵': 'person in tuxedo',
    '🤵‍♂️': 'man in tuxedo',
    '🤵‍♀️': 'woman in tuxedo',
    '👰': 'person with veil',
    '👰‍♂️': 'man with veil',
    '👰‍♀️': 'woman with veil',
    '🤰': 'pregnant woman',
    '🫃': '⊛ pregnant man',
    '🫄': '⊛ pregnant person',
    '🤱': 'breast-feeding',
    '👩‍🍼': 'woman feeding baby',
    '👨‍🍼': 'man feeding baby',
    '🧑‍🍼': 'person feeding baby',
    '👼': 'baby angel',
    '🎅': 'Santa Claus',
    '🤶': 'Mrs. Claus',
    '🧑‍🎄': 'mx claus',
    '🦸': 'superhero',
    '🦸‍♂️': 'man superhero',
    '🦸‍♀️': 'woman superhero',
    '🦹': 'supervillain',
    '🦹‍♂️': 'man supervillain',
    '🦹‍♀️': 'woman supervillain',
    '🧙': 'mage',
    '🧙‍♂️': 'man mage',
    '🧙‍♀️': 'woman mage',
    '🧚': 'fairy',
    '🧚‍♂️': 'man fairy',
    '🧚‍♀️': 'woman fairy',
    '🧛': 'vampire',
    '🧛‍♂️': 'man vampire',
    '🧛‍♀️': 'woman vampire',
    '🧜': 'merperson',
    '🧜‍♂️': 'merman',
    '🧜‍♀️': 'mermaid',
    '🧝': 'elf',
    '🧝‍♂️': 'man elf',
    '🧝‍♀️': 'woman elf',
    '🧞': 'genie',
    '🧞‍♂️': 'man genie',
    '🧞‍♀️': 'woman genie',
    '🧟': 'zombie',
    '🧟‍♂️': 'man zombie',
    '🧟‍♀️': 'woman zombie',
    '🧌': '⊛ troll',
    '💆': 'person getting massage',
    '💆‍♂️': 'man getting massage',
    '💆‍♀️': 'woman getting massage',
    '💇': 'person getting haircut',
    '💇‍♂️': 'man getting haircut',
    '💇‍♀️': 'woman getting haircut',
    '🚶': 'person walking',
    '🚶‍♂️': 'man walking',
    '🚶‍♀️': 'woman walking',
    '🧍': 'person standing',
    '🧍‍♂️': 'man standing',
    '🧍‍♀️': 'woman standing',
    '🧎': 'person kneeling',
    '🧎‍♂️': 'man kneeling',
    '🧎‍♀️': 'woman kneeling',
    '🧑‍🦯': 'person with white cane',
    '👨‍🦯': 'man with white cane',
    '👩‍🦯': 'woman with white cane',
    '🧑‍🦼': 'person in motorized wheelchair',
    '👨‍🦼': 'man in motorized wheelchair',
    '👩‍🦼': 'woman in motorized wheelchair',
    '🧑‍🦽': 'person in manual wheelchair',
    '👨‍🦽': 'man in manual wheelchair',
    '👩‍🦽': 'woman in manual wheelchair',
    '🏃': 'person running',
    '🏃‍♂️': 'man running',
    '🏃‍♀️': 'woman running',
    '💃': 'woman dancing',
    '🕺': 'man dancing',
    '🕴': 'person in suit levitating',
    '👯': 'people with bunny ears',
    '👯‍♂️': 'men with bunny ears',
    '👯‍♀️': 'women with bunny ears',
    '🧖': 'person in steamy room',
    '🧖‍♂️': 'man in steamy room',
    '🧖‍♀️': 'woman in steamy room',
    '🧗': 'person climbing',
    '🧗‍♂️': 'man climbing',
    '🧗‍♀️': 'woman climbing',
    '🤺': 'person fencing',
    '🏇': 'horse racing',
    '⛷': 'skier',
    '🏂': 'snowboarder',
    '🏌': 'person golfing',
    '🏌️‍♂️': 'man golfing',
    '🏌️‍♀️': 'woman golfing',
    '🏄': 'person surfing',
    '🏄‍♂️': 'man surfing',
    '🏄‍♀️': 'woman surfing',
    '🚣': 'person rowing boat',
    '🚣‍♂️': 'man rowing boat',
    '🚣‍♀️': 'woman rowing boat',
    '🏊': 'person swimming',
    '🏊‍♂️': 'man swimming',
    '🏊‍♀️': 'woman swimming',
    '⛹': 'person bouncing ball',
    '⛹️‍♂️': 'man bouncing ball',
    '⛹️‍♀️': 'woman bouncing ball',
    '🏋': 'person lifting weights',
    '🏋️‍♂️': 'man lifting weights',
    '🏋️‍♀️': 'woman lifting weights',
    '🚴': 'person biking',
    '🚴‍♂️': 'man biking',
    '🚴‍♀️': 'woman biking',
    '🚵': 'person mountain biking',
    '🚵‍♂️': 'man mountain biking',
    '🚵‍♀️': 'woman mountain biking',
    '🤸': 'person cartwheeling',
    '🤸‍♂️': 'man cartwheeling',
    '🤸‍♀️': 'woman cartwheeling',
    '🤼': 'people wrestling',
    '🤼‍♂️': 'men wrestling',
    '🤼‍♀️': 'women wrestling',
    '🤽': 'person playing water polo',
    '🤽‍♂️': 'man playing water polo',
    '🤽‍♀️': 'woman playing water polo',
    '🤾': 'person playing handball',
    '🤾‍♂️': 'man playing handball',
    '🤾‍♀️': 'woman playing handball',
    '🤹': 'person juggling',
    '🤹‍♂️': 'man juggling',
    '🤹‍♀️': 'woman juggling',
    '🧘': 'person in lotus position',
    '🧘‍♂️': 'man in lotus position',
    '🧘‍♀️': 'woman in lotus position',
    '🛀': 'person taking bath',
    '🛌': 'person in bed',
    '🧑‍🤝‍🧑': 'people holding hands',
    '👭': 'women holding hands',
    '👫': 'woman and man holding hands',
    '👬': 'men holding hands',
    '💏': 'kiss',
    '👩‍❤️‍💋‍👨': 'kiss: woman, man',
    '👨‍❤️‍💋‍👨': 'kiss: man, man',
    '👩‍❤️‍💋‍👩': 'kiss: woman, woman',
    '💑': 'couple with heart',
    '👩‍❤️‍👨': 'couple with heart: woman, man',
    '👨‍❤️‍👨': 'couple with heart: man, man',
    '👩‍❤️‍👩': 'couple with heart: woman, woman',
    '👪': 'family',
    '👨‍👩‍👦': 'family: man, woman, boy',
    '👨‍👩‍👧': 'family: man, woman, girl',
    '👨‍👩‍👧‍👦': 'family: man, woman, girl, boy',
    '👨‍👩‍👦‍👦': 'family: man, woman, boy, boy',
    '👨‍👩‍👧‍👧': 'family: man, woman, girl, girl',
    '👨‍👨‍👦': 'family: man, man, boy',
    '👨‍👨‍👧': 'family: man, man, girl',
    '👨‍👨‍👧‍👦': 'family: man, man, girl, boy',
    '👨‍👨‍👦‍👦': 'family: man, man, boy, boy',
    '👨‍👨‍👧‍👧': 'family: man, man, girl, girl',
    '👩‍👩‍👦': 'family: woman, woman, boy',
    '👩‍👩‍👧': 'family: woman, woman, girl',
    '👩‍👩‍👧‍👦': 'family: woman, woman, girl, boy',
    '👩‍👩‍👦‍👦': 'family: woman, woman, boy, boy',
    '👩‍👩‍👧‍👧': 'family: woman, woman, girl, girl',
    '👨‍👦': 'family: man, boy',
    '👨‍👦‍👦': 'family: man, boy, boy',
    '👨‍👧': 'family: man, girl',
    '👨‍👧‍👦': 'family: man, girl, boy',
    '👨‍👧‍👧': 'family: man, girl, girl',
    '👩‍👦': 'family: woman, boy',
    '👩‍👦‍👦': 'family: woman, boy, boy',
    '👩‍👧': 'family: woman, girl',
    '👩‍👧‍👦': 'family: woman, girl, boy',
    '👩‍👧‍👧': 'family: woman, girl, girl',
    '🗣': 'speaking head',
    '👤': 'bust in silhouette',
    '👥': 'busts in silhouette',
    '🫂': 'people hugging',
    '👣': 'footprints',
    '🦰': 'red hair',
    '🦱': 'curly hair',
    '🦳': 'white hair',
    '🦲': 'bald',
    '🐵': 'monkey face',
    '🐒': 'monkey',
    '🦍': 'gorilla',
    '🦧': 'orangutan',
    '🐶': 'dog face',
    '🐕': 'dog',
    '🦮': 'guide dog',
    '🐕‍🦺': 'service dog',
    '🐩': 'poodle',
    '🐺': 'wolf',
    '🦊': 'fox',
    '🦝': 'raccoon',
    '🐱': 'cat face',
    '🐈': 'cat',
    '🐈‍⬛': 'black cat',
    '🦁': 'lion',
    '🐯': 'tiger face',
    '🐅': 'tiger',
    '🐆': 'leopard',
    '🐴': 'horse face',
    '🐎': 'horse',
    '🦄': 'unicorn',
    '🦓': 'zebra',
    '🦌': 'deer',
    '🦬': 'bison',
    '🐮': 'cow face',
    '🐂': 'ox',
    '🐃': 'water buffalo',
    '🐄': 'cow',
    '🐷': 'pig face',
    '🐖': 'pig',
    '🐗': 'boar',
    '🐽': 'pig nose',
    '🐏': 'ram',
    '🐑': 'ewe',
    '🐐': 'goat',
    '🐪': 'camel',
    '🐫': 'two-hump camel',
    '🦙': 'llama',
    '🦒': 'giraffe',
    '🐘': 'elephant',
    '🦣': 'mammoth',
    '🦏': 'rhinoceros',
    '🦛': 'hippopotamus',
    '🐭': 'mouse face',
    '🐁': 'mouse',
    '🐀': 'rat',
    '🐹': 'hamster',
    '🐰': 'rabbit face',
    '🐇': 'rabbit',
    '🐿': 'chipmunk',
    '🦫': 'beaver',
    '🦔': 'hedgehog',
    '🦇': 'bat',
    '🐻': 'bear',
    '🐻‍❄️': 'polar bear',
    '🐨': 'koala',
    '🐼': 'panda',
    '🦥': 'sloth',
    '🦦': 'otter',
    '🦨': 'skunk',
    '🦘': 'kangaroo',
    '🦡': 'badger',
    '🐾': 'paw prints',
    '🦃': 'turkey',
    '🐔': 'chicken',
    '🐓': 'rooster',
    '🐣': 'hatching chick',
    '🐤': 'baby chick',
    '🐥': 'front-facing baby chick',
    '🐦': 'bird',
    '🐧': 'penguin',
    '🕊': 'dove',
    '🦅': 'eagle',
    '🦆': 'duck',
    '🦢': 'swan',
    '🦉': 'owl',
    '🦤': 'dodo',
    '🪶': 'feather',
    '🦩': 'flamingo',
    '🦚': 'peacock',
    '🦜': 'parrot',
    '🐸': 'frog',
    '🐊': 'crocodile',
    '🐢': 'turtle',
    '🦎': 'lizard',
    '🐍': 'snake',
    '🐲': 'dragon face',
    '🐉': 'dragon',
    '🦕': 'sauropod',
    '🦖': 'T-Rex',
    '🐳': 'spouting whale',
    '🐋': 'whale',
    '🐬': 'dolphin',
    '🦭': 'seal',
    '🐟': 'fish',
    '🐠': 'tropical fish',
    '🐡': 'blowfish',
    '🦈': 'shark',
    '🐙': 'octopus',
    '🐚': 'spiral shell',
    '🪸': '⊛ coral',
    '🐌': 'snail',
    '🦋': 'butterfly',
    '🐛': 'bug',
    '🐜': 'ant',
    '🐝': 'honeybee',
    '🪲': 'beetle',
    '🐞': 'lady beetle',
    '🦗': 'cricket',
    '🪳': 'cockroach',
    '🕷': 'spider',
    '🕸': 'spider web',
    '🦂': 'scorpion',
    '🦟': 'mosquito',
    '🪰': 'fly',
    '🪱': 'worm',
    '🦠': 'microbe',
    '💐': 'bouquet',
    '🌸': 'cherry blossom',
    '💮': 'white flower',
    '🪷': '⊛ lotus',
    '🏵': 'rosette',
    '🌹': 'rose',
    '🥀': 'wilted flower',
    '🌺': 'hibiscus',
    '🌻': 'sunflower',
    '🌼': 'blossom',
    '🌷': 'tulip',
    '🌱': 'seedling',
    '🪴': 'potted plant',
    '🌲': 'evergreen tree',
    '🌳': 'deciduous tree',
    '🌴': 'palm tree',
    '🌵': 'cactus',
    '🌾': 'sheaf of rice',
    '🌿': 'herb',
    '☘': 'shamrock',
    '🍀': 'four leaf clover',
    '🍁': 'maple leaf',
    '🍂': 'fallen leaf',
    '🍃': 'leaf fluttering in wind',
    '🪹': '⊛ empty nest',
    '🪺': '⊛ nest with eggs',
    '🍇': 'grapes',
    '🍈': 'melon',
    '🍉': 'watermelon',
    '🍊': 'tangerine',
    '🍋': 'lemon',
    '🍌': 'banana',
    '🍍': 'pineapple',
    '🥭': 'mango',
    '🍎': 'red apple',
    '🍏': 'green apple',
    '🍐': 'pear',
    '🍑': 'peach',
    '🍒': 'cherries',
    '🍓': 'strawberry',
    '🫐': 'blueberries',
    '🥝': 'kiwi fruit',
    '🍅': 'tomato',
    '🫒': 'olive',
    '🥥': 'coconut',
    '🥑': 'avocado',
    '🍆': 'eggplant',
    '🥔': 'potato',
    '🥕': 'carrot',
    '🌽': 'ear of corn',
    '🌶': 'hot pepper',
    '🫑': 'bell pepper',
    '🥒': 'cucumber',
    '🥬': 'leafy green',
    '🥦': 'broccoli',
    '🧄': 'garlic',
    '🧅': 'onion',
    '🍄': 'mushroom',
    '🥜': 'peanuts',
    '🫘': '⊛ beans',
    '🌰': 'chestnut',
    '🍞': 'bread',
    '🥐': 'croissant',
    '🥖': 'baguette bread',
    '🫓': 'flatbread',
    '🥨': 'pretzel',
    '🥯': 'bagel',
    '🥞': 'pancakes',
    '🧇': 'waffle',
    '🧀': 'cheese wedge',
    '🍖': 'meat on bone',
    '🍗': 'poultry leg',
    '🥩': 'cut of meat',
    '🥓': 'bacon',
    '🍔': 'hamburger',
    '🍟': 'french fries',
    '🍕': 'pizza',
    '🌭': 'hot dog',
    '🥪': 'sandwich',
    '🌮': 'taco',
    '🌯': 'burrito',
    '🫔': 'tamale',
    '🥙': 'stuffed flatbread',
    '🧆': 'falafel',
    '🥚': 'egg',
    '🍳': 'cooking',
    '🥘': 'shallow pan of food',
    '🍲': 'pot of food',
    '🫕': 'fondue',
    '🥣': 'bowl with spoon',
    '🥗': 'green salad',
    '🍿': 'popcorn',
    '🧈': 'butter',
    '🧂': 'salt',
    '🥫': 'canned food',
    '🍱': 'bento box',
    '🍘': 'rice cracker',
    '🍙': 'rice ball',
    '🍚': 'cooked rice',
    '🍛': 'curry rice',
    '🍜': 'steaming bowl',
    '🍝': 'spaghetti',
    '🍠': 'roasted sweet potato',
    '🍢': 'oden',
    '🍣': 'sushi',
    '🍤': 'fried shrimp',
    '🍥': 'fish cake with swirl',
    '🥮': 'moon cake',
    '🍡': 'dango',
    '🥟': 'dumpling',
    '🥠': 'fortune cookie',
    '🥡': 'takeout box',
    '🦀': 'crab',
    '🦞': 'lobster',
    '🦐': 'shrimp',
    '🦑': 'squid',
    '🦪': 'oyster',
    '🍦': 'soft ice cream',
    '🍧': 'shaved ice',
    '🍨': 'ice cream',
    '🍩': 'doughnut',
    '🍪': 'cookie',
    '🎂': 'birthday cake',
    '🍰': 'shortcake',
    '🧁': 'cupcake',
    '🥧': 'pie',
    '🍫': 'chocolate bar',
    '🍬': 'candy',
    '🍭': 'lollipop',
    '🍮': 'custard',
    '🍯': 'honey pot',
    '🍼': 'baby bottle',
    '🥛': 'glass of milk',
    '☕': 'hot beverage',
    '🫖': 'teapot',
    '🍵': 'teacup without handle',
    '🍶': 'sake',
    '🍾': 'bottle with popping cork',
    '🍷': 'wine glass',
    '🍸': 'cocktail glass',
    '🍹': 'tropical drink',
    '🍺': 'beer mug',
    '🍻': 'clinking beer mugs',
    '🥂': 'clinking glasses',
    '🥃': 'tumbler glass',
    '🫗': '⊛ pouring liquid',
    '🥤': 'cup with straw',
    '🧋': 'bubble tea',
    '🧃': 'beverage box',
    '🧉': 'mate',
    '🧊': 'ice',
    '🥢': 'chopsticks',
    '🍽': 'fork and knife with plate',
    '🍴': 'fork and knife',
    '🥄': 'spoon',
    '🔪': 'kitchen knife',
    '🫙': '⊛ jar',
    '🏺': 'amphora',
    '🌍': 'globe showing Europe-Africa',
    '🌎': 'globe showing Americas',
    '🌏': 'globe showing Asia-Australia',
    '🌐': 'globe with meridians',
    '🗺': 'world map',
    '🗾': 'map of Japan',
    '🧭': 'compass',
    '🏔': 'snow-capped mountain',
    '⛰': 'mountain',
    '🌋': 'volcano',
    '🗻': 'mount fuji',
    '🏕': 'camping',
    '🏖': 'beach with umbrella',
    '🏜': 'desert',
    '🏝': 'desert island',
    '🏞': 'national park',
    '🏟': 'stadium',
    '🏛': 'classical building',
    '🏗': 'building construction',
    '🧱': 'brick',
    '🪨': 'rock',
    '🪵': 'wood',
    '🛖': 'hut',
    '🏘': 'houses',
    '🏚': 'derelict house',
    '🏠': 'house',
    '🏡': 'house with garden',
    '🏢': 'office building',
    '🏣': 'Japanese post office',
    '🏤': 'post office',
    '🏥': 'hospital',
    '🏦': 'bank',
    '🏨': 'hotel',
    '🏩': 'love hotel',
    '🏪': 'convenience store',
    '🏫': 'school',
    '🏬': 'department store',
    '🏭': 'factory',
    '🏯': 'Japanese castle',
    '🏰': 'castle',
    '💒': 'wedding',
    '🗼': 'Tokyo tower',
    '🗽': 'Statue of Liberty',
    '⛪': 'church',
    '🕌': 'mosque',
    '🛕': 'hindu temple',
    '🕍': 'synagogue',
    '⛩': 'shinto shrine',
    '🕋': 'kaaba',
    '⛲': 'fountain',
    '⛺': 'tent',
    '🌁': 'foggy',
    '🌃': 'night with stars',
    '🏙': 'cityscape',
    '🌄': 'sunrise over mountains',
    '🌅': 'sunrise',
    '🌆': 'cityscape at dusk',
    '🌇': 'sunset',
    '🌉': 'bridge at night',
    '♨': 'hot springs',
    '🎠': 'carousel horse',
    '🛝': '⊛ playground slide',
    '🎡': 'ferris wheel',
    '🎢': 'roller coaster',
    '💈': 'barber pole',
    '🎪': 'circus tent',
    '🚂': 'locomotive',
    '🚃': 'railway car',
    '🚄': 'high-speed train',
    '🚅': 'bullet train',
    '🚆': 'train',
    '🚇': 'metro',
    '🚈': 'light rail',
    '🚉': 'station',
    '🚊': 'tram',
    '🚝': 'monorail',
    '🚞': 'mountain railway',
    '🚋': 'tram car',
    '🚌': 'bus',
    '🚍': 'oncoming bus',
    '🚎': 'trolleybus',
    '🚐': 'minibus',
    '🚑': 'ambulance',
    '🚒': 'fire engine',
    '🚓': 'police car',
    '🚔': 'oncoming police car',
    '🚕': 'taxi',
    '🚖': 'oncoming taxi',
    '🚗': 'automobile',
    '🚘': 'oncoming automobile',
    '🚙': 'sport utility vehicle',
    '🛻': 'pickup truck',
    '🚚': 'delivery truck',
    '🚛': 'articulated lorry',
    '🚜': 'tractor',
    '🏎': 'racing car',
    '🏍': 'motorcycle',
    '🛵': 'motor scooter',
    '🦽': 'manual wheelchair',
    '🦼': 'motorized wheelchair',
    '🛺': 'auto rickshaw',
    '🚲': 'bicycle',
    '🛴': 'kick scooter',
    '🛹': 'skateboard',
    '🛼': 'roller skate',
    '🚏': 'bus stop',
    '🛣': 'motorway',
    '🛤': 'railway track',
    '🛢': 'oil drum',
    '⛽': 'fuel pump',
    '🛞': '⊛ wheel',
    '🚨': 'police car light',
    '🚥': 'horizontal traffic light',
    '🚦': 'vertical traffic light',
    '🛑': 'stop sign',
    '🚧': 'construction',
    '⚓': 'anchor',
    '🛟': '⊛ ring buoy',
    '⛵': 'sailboat',
    '🛶': 'canoe',
    '🚤': 'speedboat',
    '🛳': 'passenger ship',
    '⛴': 'ferry',
    '🛥': 'motor boat',
    '🚢': 'ship',
    '✈': 'airplane',
    '🛩': 'small airplane',
    '🛫': 'airplane departure',
    '🛬': 'airplane arrival',
    '🪂': 'parachute',
    '💺': 'seat',
    '🚁': 'helicopter',
    '🚟': 'suspension railway',
    '🚠': 'mountain cableway',
    '🚡': 'aerial tramway',
    '🛰': 'satellite',
    '🚀': 'rocket',
    '🛸': 'flying saucer',
    '🛎': 'bellhop bell',
    '🧳': 'luggage',
    '⌛': 'hourglass done',
    '⏳': 'hourglass not done',
    '⌚': 'watch',
    '⏰': 'alarm clock',
    '⏱': 'stopwatch',
    '⏲': 'timer clock',
    '🕰': 'mantelpiece clock',
    '🕛': 'twelve o’clock',
    '🕧': 'twelve-thirty',
    '🕐': 'one o’clock',
    '🕜': 'one-thirty',
    '🕑': 'two o’clock',
    '🕝': 'two-thirty',
    '🕒': 'three o’clock',
    '🕞': 'three-thirty',
    '🕓': 'four o’clock',
    '🕟': 'four-thirty',
    '🕔': 'five o’clock',
    '🕠': 'five-thirty',
    '🕕': 'six o’clock',
    '🕡': 'six-thirty',
    '🕖': 'seven o’clock',
    '🕢': 'seven-thirty',
    '🕗': 'eight o’clock',
    '🕣': 'eight-thirty',
    '🕘': 'nine o’clock',
    '🕤': 'nine-thirty',
    '🕙': 'ten o’clock',
    '🕥': 'ten-thirty',
    '🕚': 'eleven o’clock',
    '🕦': 'eleven-thirty',
    '🌑': 'new moon',
    '🌒': 'waxing crescent moon',
    '🌓': 'first quarter moon',
    '🌔': 'waxing gibbous moon',
    '🌕': 'full moon',
    '🌖': 'waning gibbous moon',
    '🌗': 'last quarter moon',
    '🌘': 'waning crescent moon',
    '🌙': 'crescent moon',
    '🌚': 'new moon face',
    '🌛': 'first quarter moon face',
    '🌜': 'last quarter moon face',
    '🌡': 'thermometer',
    '☀': 'sun',
    '🌝': 'full moon face',
    '🌞': 'sun with face',
    '🪐': 'ringed planet',
    '⭐': 'star',
    '🌟': 'glowing star',
    '🌠': 'shooting star',
    '🌌': 'milky way',
    '☁': 'cloud',
    '⛅': 'sun behind cloud',
    '⛈': 'cloud with lightning and rain',
    '🌤': 'sun behind small cloud',
    '🌥': 'sun behind large cloud',
    '🌦': 'sun behind rain cloud',
    '🌧': 'cloud with rain',
    '🌨': 'cloud with snow',
    '🌩': 'cloud with lightning',
    '🌪': 'tornado',
    '🌫': 'fog',
    '🌬': 'wind face',
    '🌀': 'cyclone',
    '🌈': 'rainbow',
    '🌂': 'closed umbrella',
    '☂': 'umbrella',
    '☔': 'umbrella with rain drops',
    '⛱': 'umbrella on ground',
    '⚡': 'high voltage',
    '❄': 'snowflake',
    '☃': 'snowman',
    '⛄': 'snowman without snow',
    '☄': 'comet',
    '🔥': 'fire',
    '💧': 'droplet',
    '🌊': 'water wave',
    '🎃': 'jack-o-lantern',
    '🎄': 'Christmas tree',
    '🎆': 'fireworks',
    '🎇': 'sparkler',
    '🧨': 'firecracker',
    '✨': 'sparkles',
    '🎈': 'balloon',
    '🎉': 'party popper',
    '🎊': 'confetti ball',
    '🎋': 'tanabata tree',
    '🎍': 'pine decoration',
    '🎎': 'Japanese dolls',
    '🎏': 'carp streamer',
    '🎐': 'wind chime',
    '🎑': 'moon viewing ceremony',
    '🧧': 'red envelope',
    '🎀': 'ribbon',
    '🎁': 'wrapped gift',
    '🎗': 'reminder ribbon',
    '🎟': 'admission tickets',
    '🎫': 'ticket',
    '🎖': 'military medal',
    '🏆': 'trophy',
    '🏅': 'sports medal',
    '🥇': '1st place medal',
    '🥈': '2nd place medal',
    '🥉': '3rd place medal',
    '⚽': 'soccer ball',
    '⚾': 'baseball',
    '🥎': 'softball',
    '🏀': 'basketball',
    '🏐': 'volleyball',
    '🏈': 'american football',
    '🏉': 'rugby football',
    '🎾': 'tennis',
    '🥏': 'flying disc',
    '🎳': 'bowling',
    '🏏': 'cricket game',
    '🏑': 'field hockey',
    '🏒': 'ice hockey',
    '🥍': 'lacrosse',
    '🏓': 'ping pong',
    '🏸': 'badminton',
    '🥊': 'boxing glove',
    '🥋': 'martial arts uniform',
    '🥅': 'goal net',
    '⛳': 'flag in hole',
    '⛸': 'ice skate',
    '🎣': 'fishing pole',
    '🤿': 'diving mask',
    '🎽': 'running shirt',
    '🎿': 'skis',
    '🛷': 'sled',
    '🥌': 'curling stone',
    '🎯': 'bullseye',
    '🪀': 'yo-yo',
    '🪁': 'kite',
    '🎱': 'pool 8 ball',
    '🔮': 'crystal ball',
    '🪄': 'magic wand',
    '🧿': 'nazar amulet',
    '🪬': '⊛ hamsa',
    '🎮': 'video game',
    '🕹': 'joystick',
    '🎰': 'slot machine',
    '🎲': 'game die',
    '🧩': 'puzzle piece',
    '🧸': 'teddy bear',
    '🪅': 'piñata',
    '🪩': '⊛ mirror ball',
    '🪆': 'nesting dolls',
    '♠': 'spade suit',
    '♥': 'heart suit',
    '♦': 'diamond suit',
    '♣': 'club suit',
    '♟': 'chess pawn',
    '🃏': 'joker',
    '🀄': 'mahjong red dragon',
    '🎴': 'flower playing cards',
    '🎭': 'performing arts',
    '🖼': 'framed picture',
    '🎨': 'artist palette',
    '🧵': 'thread',
    '🪡': 'sewing needle',
    '🧶': 'yarn',
    '🪢': 'knot',
    '👓': 'glasses',
    '🕶': 'sunglasses',
    '🥽': 'goggles',
    '🥼': 'lab coat',
    '🦺': 'safety vest',
    '👔': 'necktie',
    '👕': 't-shirt',
    '👖': 'jeans',
    '🧣': 'scarf',
    '🧤': 'gloves',
    '🧥': 'coat',
    '🧦': 'socks',
    '👗': 'dress',
    '👘': 'kimono',
    '🥻': 'sari',
    '🩱': 'one-piece swimsuit',
    '🩲': 'briefs',
    '🩳': 'shorts',
    '👙': 'bikini',
    '👚': 'woman’s clothes',
    '👛': 'purse',
    '👜': 'handbag',
    '👝': 'clutch bag',
    '🛍': 'shopping bags',
    '🎒': 'backpack',
    '🩴': 'thong sandal',
    '👞': 'man’s shoe',
    '👟': 'running shoe',
    '🥾': 'hiking boot',
    '🥿': 'flat shoe',
    '👠': 'high-heeled shoe',
    '👡': 'woman’s sandal',
    '🩰': 'ballet shoes',
    '👢': 'woman’s boot',
    '👑': 'crown',
    '👒': 'woman’s hat',
    '🎩': 'top hat',
    '🎓': 'graduation cap',
    '🧢': 'billed cap',
    '🪖': 'military helmet',
    '⛑': 'rescue worker’s helmet',
    '📿': 'prayer beads',
    '💄': 'lipstick',
    '💍': 'ring',
    '💎': 'gem stone',
    '🔇': 'muted speaker',
    '🔈': 'speaker low volume',
    '🔉': 'speaker medium volume',
    '🔊': 'speaker high volume',
    '📢': 'loudspeaker',
    '📣': 'megaphone',
    '📯': 'postal horn',
    '🔔': 'bell',
    '🔕': 'bell with slash',
    '🎼': 'musical score',
    '🎵': 'musical note',
    '🎶': 'musical notes',
    '🎙': 'studio microphone',
    '🎚': 'level slider',
    '🎛': 'control knobs',
    '🎤': 'microphone',
    '🎧': 'headphone',
    '📻': 'radio',
    '🎷': 'saxophone',
    '🪗': 'accordion',
    '🎸': 'guitar',
    '🎹': 'musical keyboard',
    '🎺': 'trumpet',
    '🎻': 'violin',
    '🪕': 'banjo',
    '🥁': 'drum',
    '🪘': 'long drum',
    '📱': 'mobile phone',
    '📲': 'mobile phone with arrow',
    '☎': 'telephone',
    '📞': 'telephone receiver',
    '📟': 'pager',
    '📠': 'fax machine',
    '🔋': 'battery',
    '🪫': '⊛ low battery',
    '🔌': 'electric plug',
    '💻': 'laptop',
    '🖥': 'desktop computer',
    '🖨': 'printer',
    '⌨': 'keyboard',
    '🖱': 'computer mouse',
    '🖲': 'trackball',
    '💽': 'computer disk',
    '💾': 'floppy disk',
    '💿': 'optical disk',
    '📀': 'dvd',
    '🧮': 'abacus',
    '🎥': 'movie camera',
    '🎞': 'film frames',
    '📽': 'film projector',
    '🎬': 'clapper board',
    '📺': 'television',
    '📷': 'camera',
    '📸': 'camera with flash',
    '📹': 'video camera',
    '📼': 'videocassette',
    '🔍': 'magnifying glass tilted left',
    '🔎': 'magnifying glass tilted right',
    '🕯': 'candle',
    '💡': 'light bulb',
    '🔦': 'flashlight',
    '🏮': 'red paper lantern',
    '🪔': 'diya lamp',
    '📔': 'notebook with decorative cover',
    '📕': 'closed book',
    '📖': 'open book',
    '📗': 'green book',
    '📘': 'blue book',
    '📙': 'orange book',
    '📚': 'books',
    '📓': 'notebook',
    '📒': 'ledger',
    '📃': 'page with curl',
    '📜': 'scroll',
    '📄': 'page facing up',
    '📰': 'newspaper',
    '🗞': 'rolled-up newspaper',
    '📑': 'bookmark tabs',
    '🔖': 'bookmark',
    '🏷': 'label',
    '💰': 'money bag',
    '🪙': 'coin',
    '💴': 'yen banknote',
    '💵': 'dollar banknote',
    '💶': 'euro banknote',
    '💷': 'pound banknote',
    '💸': 'money with wings',
    '💳': 'credit card',
    '🧾': 'receipt',
    '💹': 'chart increasing with yen',
    '✉': 'envelope',
    '📧': 'e-mail',
    '📨': 'incoming envelope',
    '📩': 'envelope with arrow',
    '📤': 'outbox tray',
    '📥': 'inbox tray',
    '📦': 'package',
    '📫': 'closed mailbox with raised flag',
    '📪': 'closed mailbox with lowered flag',
    '📬': 'open mailbox with raised flag',
    '📭': 'open mailbox with lowered flag',
    '📮': 'postbox',
    '🗳': 'ballot box with ballot',
    '✏': 'pencil',
    '✒': 'black nib',
    '🖋': 'fountain pen',
    '🖊': 'pen',
    '🖌': 'paintbrush',
    '🖍': 'crayon',
    '📝': 'memo',
    '💼': 'briefcase',
    '📁': 'file folder',
    '📂': 'open file folder',
    '🗂': 'card index dividers',
    '📅': 'calendar',
    '📆': 'tear-off calendar',
    '🗒': 'spiral notepad',
    '🗓': 'spiral calendar',
    '📇': 'card index',
    '📈': 'chart increasing',
    '📉': 'chart decreasing',
    '📊': 'bar chart',
    '📋': 'clipboard',
    '📌': 'pushpin',
    '📍': 'round pushpin',
    '📎': 'paperclip',
    '🖇': 'linked paperclips',
    '📏': 'straight ruler',
    '📐': 'triangular ruler',
    '✂': 'scissors',
    '🗃': 'card file box',
    '🗄': 'file cabinet',
    '🗑': 'wastebasket',
    '🔒': 'locked',
    '🔓': 'unlocked',
    '🔏': 'locked with pen',
    '🔐': 'locked with key',
    '🔑': 'key',
    '🗝': 'old key',
    '🔨': 'hammer',
    '🪓': 'axe',
    '⛏': 'pick',
    '⚒': 'hammer and pick',
    '🛠': 'hammer and wrench',
    '🗡': 'dagger',
    '⚔': 'crossed swords',
    '🔫': 'water pistol',
    '🪃': 'boomerang',
    '🏹': 'bow and arrow',
    '🛡': 'shield',
    '🪚': 'carpentry saw',
    '🔧': 'wrench',
    '🪛': 'screwdriver',
    '🔩': 'nut and bolt',
    '⚙': 'gear',
    '🗜': 'clamp',
    '⚖': 'balance scale',
    '🦯': 'white cane',
    '🔗': 'link',
    '⛓': 'chains',
    '🪝': 'hook',
    '🧰': 'toolbox',
    '🧲': 'magnet',
    '🪜': 'ladder',
    '⚗': 'alembic',
    '🧪': 'test tube',
    '🧫': 'petri dish',
    '🧬': 'dna',
    '🔬': 'microscope',
    '🔭': 'telescope',
    '📡': 'satellite antenna',
    '💉': 'syringe',
    '🩸': 'drop of blood',
    '💊': 'pill',
    '🩹': 'adhesive bandage',
    '🩼': '⊛ crutch',
    '🩺': 'stethoscope',
    '🩻': '⊛ x-ray',
    '🚪': 'door',
    '🛗': 'elevator',
    '🪞': 'mirror',
    '🪟': 'window',
    '🛏': 'bed',
    '🛋': 'couch and lamp',
    '🪑': 'chair',
    '🚽': 'toilet',
    '🪠': 'plunger',
    '🚿': 'shower',
    '🛁': 'bathtub',
    '🪤': 'mouse trap',
    '🪒': 'razor',
    '🧴': 'lotion bottle',
    '🧷': 'safety pin',
    '🧹': 'broom',
    '🧺': 'basket',
    '🧻': 'roll of paper',
    '🪣': 'bucket',
    '🧼': 'soap',
    '🫧': '⊛ bubbles',
    '🪥': 'toothbrush',
    '🧽': 'sponge',
    '🧯': 'fire extinguisher',
    '🛒': 'shopping cart',
    '🚬': 'cigarette',
    '⚰': 'coffin',
    '🪦': 'headstone',
    '⚱': 'funeral urn',
    '🗿': 'moai',
    '🪧': 'placard',
    '🪪': '⊛ identification card',
    '🏧': 'ATM sign',
    '🚮': 'litter in bin sign',
    '🚰': 'potable water',
    '♿': 'wheelchair symbol',
    '🚹': 'men’s room',
    '🚺': 'women’s room',
    '🚻': 'restroom',
    '🚼': 'baby symbol',
    '🚾': 'water closet',
    '🛂': 'passport control',
    '🛃': 'customs',
    '🛄': 'baggage claim',
    '🛅': 'left luggage',
    '⚠': 'warning',
    '🚸': 'children crossing',
    '⛔': 'no entry',
    '🚫': 'prohibited',
    '🚳': 'no bicycles',
    '🚭': 'no smoking',
    '🚯': 'no littering',
    '🚱': 'non-potable water',
    '🚷': 'no pedestrians',
    '📵': 'no mobile phones',
    '🔞': 'no one under eighteen',
    '☢': 'radioactive',
    '☣': 'biohazard',
    '⬆': 'up arrow',
    '↗': 'up-right arrow',
    '➡': 'right arrow',
    '↘': 'down-right arrow',
    '⬇': 'down arrow',
    '↙': 'down-left arrow',
    '⬅': 'left arrow',
    '↖': 'up-left arrow',
    '↕': 'up-down arrow',
    '↔': 'left-right arrow',
    '↩': 'right arrow curving left',
    '↪': 'left arrow curving right',
    '⤴': 'right arrow curving up',
    '⤵': 'right arrow curving down',
    '🔃': 'clockwise vertical arrows',
    '🔄': 'counterclockwise arrows button',
    '🔙': 'BACK arrow',
    '🔚': 'END arrow',
    '🔛': 'ON! arrow',
    '🔜': 'SOON arrow',
    '🔝': 'TOP arrow',
    '🛐': 'place of worship',
    '⚛': 'atom symbol',
    '🕉': 'om',
    '✡': 'star of David',
    '☸': 'wheel of dharma',
    '☯': 'yin yang',
    '✝': 'latin cross',
    '☦': 'orthodox cross',
    '☪': 'star and crescent',
    '☮': 'peace symbol',
    '🕎': 'menorah',
    '🔯': 'dotted six-pointed star',
    '♈': 'Aries',
    '♉': 'Taurus',
    '♊': 'Gemini',
    '♋': 'Cancer',
    '♌': 'Leo',
    '♍': 'Virgo',
    '♎': 'Libra',
    '♏': 'Scorpio',
    '♐': 'Sagittarius',
    '♑': 'Capricorn',
    '♒': 'Aquarius',
    '♓': 'Pisces',
    '⛎': 'Ophiuchus',
    '🔀': 'shuffle tracks button',
    '🔁': 'repeat button',
    '🔂': 'repeat single button',
    '▶': 'play button',
    '⏩': 'fast-forward button',
    '⏭': 'next track button',
    '⏯': 'play or pause button',
    '◀': 'reverse button',
    '⏪': 'fast reverse button',
    '⏮': 'last track button',
    '🔼': 'upwards button',
    '⏫': 'fast up button',
    '🔽': 'downwards button',
    '⏬': 'fast down button',
    '⏸': 'pause button',
    '⏹': 'stop button',
    '⏺': 'record button',
    '⏏': 'eject button',
    '🎦': 'cinema',
    '🔅': 'dim button',
    '🔆': 'bright button',
    '📶': 'antenna bars',
    '📳': 'vibration mode',
    '📴': 'mobile phone off',
    '♀': 'female sign',
    '♂': 'male sign',
    '⚧': 'transgender symbol',
    '✖': 'multiply',
    '➕': 'plus',
    '➖': 'minus',
    '➗': 'divide',
    '🟰': '⊛ heavy equals sign',
    '♾': 'infinity',
    '‼': 'double exclamation mark',
    '⁉': 'exclamation question mark',
    '❓': 'red question mark',
    '❔': 'white question mark',
    '❕': 'white exclamation mark',
    '❗': 'red exclamation mark',
    '〰': 'wavy dash',
    '💱': 'currency exchange',
    '💲': 'heavy dollar sign',
    '⚕': 'medical symbol',
    '♻': 'recycling symbol',
    '⚜': 'fleur-de-lis',
    '🔱': 'trident emblem',
    '📛': 'name badge',
    '🔰': 'Japanese symbol for beginner',
    '⭕': 'hollow red circle',
    '✅': 'check mark button',
    '☑': 'check box with check',
    '✔': 'check mark',
    '❌': 'cross mark',
    '❎': 'cross mark button',
    '➰': 'curly loop',
    '➿': 'double curly loop',
    '〽': 'part alternation mark',
    '✳': 'eight-spoked asterisk',
    '✴': 'eight-pointed star',
    '❇': 'sparkle',
    '©': 'copyright',
    '®': 'registered',
    '™': 'trade mark',
    '#️⃣': 'keycap: #',
    '*️⃣': 'keycap: *',
    '0️⃣': 'keycap: 0',
    '1️⃣': 'keycap: 1',
    '2️⃣': 'keycap: 2',
    '3️⃣': 'keycap: 3',
    '4️⃣': 'keycap: 4',
    '5️⃣': 'keycap: 5',
    '6️⃣': 'keycap: 6',
    '7️⃣': 'keycap: 7',
    '8️⃣': 'keycap: 8',
    '9️⃣': 'keycap: 9',
    '🔟': 'keycap: 10',
    '🔠': 'input latin uppercase',
    '🔡': 'input latin lowercase',
    '🔢': 'input numbers',
    '🔣': 'input symbols',
    '🔤': 'input latin letters',
    '🅰': 'A button (blood type)',
    '🆎': 'AB button (blood type)',
    '🅱': 'B button (blood type)',
    '🆑': 'CL button',
    '🆒': 'COOL button',
    '🆓': 'FREE button',
    ℹ: 'information',
    '🆔': 'ID button',
    'Ⓜ': 'circled M',
    '🆕': 'NEW button',
    '🆖': 'NG button',
    '🅾': 'O button (blood type)',
    '🆗': 'OK button',
    '🅿': 'P button',
    '🆘': 'SOS button',
    '🆙': 'UP! button',
    '🆚': 'VS button',
    '🈁': 'Japanese “here” button',
    '🈂': 'Japanese “service charge” button',
    '🈷': 'Japanese “monthly amount” button',
    '🈶': 'Japanese “not free of charge” button',
    '🈯': 'Japanese “reserved” button',
    '🉐': 'Japanese “bargain” button',
    '🈹': 'Japanese “discount” button',
    '🈚': 'Japanese “free of charge” button',
    '🈲': 'Japanese “prohibited” button',
    '🉑': 'Japanese “acceptable” button',
    '🈸': 'Japanese “application” button',
    '🈴': 'Japanese “passing grade” button',
    '🈳': 'Japanese “vacancy” button',
    '㊗': 'Japanese “congratulations” button',
    '㊙': 'Japanese “secret” button',
    '🈺': 'Japanese “open for business” button',
    '🈵': 'Japanese “no vacancy” button',
    '🔴': 'red circle',
    '🟠': 'orange circle',
    '🟡': 'yellow circle',
    '🟢': 'green circle',
    '🔵': 'blue circle',
    '🟣': 'purple circle',
    '🟤': 'brown circle',
    '⚫': 'black circle',
    '⚪': 'white circle',
    '🟥': 'red square',
    '🟧': 'orange square',
    '🟨': 'yellow square',
    '🟩': 'green square',
    '🟦': 'blue square',
    '🟪': 'purple square',
    '🟫': 'brown square',
    '⬛': 'black large square',
    '⬜': 'white large square',
    '◼': 'black medium square',
    '◻': 'white medium square',
    '◾': 'black medium-small square',
    '◽': 'white medium-small square',
    '▪': 'black small square',
    '▫': 'white small square',
    '🔶': 'large orange diamond',
    '🔷': 'large blue diamond',
    '🔸': 'small orange diamond',
    '🔹': 'small blue diamond',
    '🔺': 'red triangle pointed up',
    '🔻': 'red triangle pointed down',
    '💠': 'diamond with a dot',
    '🔘': 'radio button',
    '🔳': 'white square button',
    '🔲': 'black square button',
    '🏁': 'chequered flag',
    '🚩': 'triangular flag',
    '🎌': 'crossed flags',
    '🏴': 'black flag',
    '🏳': 'white flag',
    '🏳️‍🌈': 'rainbow flag',
    '🏳️‍⚧️': 'transgender flag',
    '🏴‍☠️': 'pirate flag',
    '🇦🇨': 'flag: Ascension Island',
    '🇦🇩': 'flag: Andorra',
    '🇦🇪': 'flag: United Arab Emirates',
    '🇦🇫': 'flag: Afghanistan',
    '🇦🇬': 'flag: Antigua & Barbuda',
    '🇦🇮': 'flag: Anguilla',
    '🇦🇱': 'flag: Albania',
    '🇦🇲': 'flag: Armenia',
    '🇦🇴': 'flag: Angola',
    '🇦🇶': 'flag: Antarctica',
    '🇦🇷': 'flag: Argentina',
    '🇦🇸': 'flag: American Samoa',
    '🇦🇹': 'flag: Austria',
    '🇦🇺': 'flag: Australia',
    '🇦🇼': 'flag: Aruba',
    '🇦🇽': 'flag: Åland Islands',
    '🇦🇿': 'flag: Azerbaijan',
    '🇧🇦': 'flag: Bosnia & Herzegovina',
    '🇧🇧': 'flag: Barbados',
    '🇧🇩': 'flag: Bangladesh',
    '🇧🇪': 'flag: Belgium',
    '🇧🇫': 'flag: Burkina Faso',
    '🇧🇬': 'flag: Bulgaria',
    '🇧🇭': 'flag: Bahrain',
    '🇧🇮': 'flag: Burundi',
    '🇧🇯': 'flag: Benin',
    '🇧🇱': 'flag: St. Barthélemy',
    '🇧🇲': 'flag: Bermuda',
    '🇧🇳': 'flag: Brunei',
    '🇧🇴': 'flag: Bolivia',
    '🇧🇶': 'flag: Caribbean Netherlands',
    '🇧🇷': 'flag: Brazil',
    '🇧🇸': 'flag: Bahamas',
    '🇧🇹': 'flag: Bhutan',
    '🇧🇻': 'flag: Bouvet Island',
    '🇧🇼': 'flag: Botswana',
    '🇧🇾': 'flag: Belarus',
    '🇧🇿': 'flag: Belize',
    '🇨🇦': 'flag: Canada',
    '🇨🇨': 'flag: Cocos (Keeling) Islands',
    '🇨🇩': 'flag: Congo - Kinshasa',
    '🇨🇫': 'flag: Central African Republic',
    '🇨🇬': 'flag: Congo - Brazzaville',
    '🇨🇭': 'flag: Switzerland',
    '🇨🇮': 'flag: Côte d’Ivoire',
    '🇨🇰': 'flag: Cook Islands',
    '🇨🇱': 'flag: Chile',
    '🇨🇲': 'flag: Cameroon',
    '🇨🇳': 'flag: China',
    '🇨🇴': 'flag: Colombia',
    '🇨🇵': 'flag: Clipperton Island',
    '🇨🇷': 'flag: Costa Rica',
    '🇨🇺': 'flag: Cuba',
    '🇨🇻': 'flag: Cape Verde',
    '🇨🇼': 'flag: Curaçao',
    '🇨🇽': 'flag: Christmas Island',
    '🇨🇾': 'flag: Cyprus',
    '🇨🇿': 'flag: Czechia',
    '🇩🇪': 'flag: Germany',
    '🇩🇬': 'flag: Diego Garcia',
    '🇩🇯': 'flag: Djibouti',
    '🇩🇰': 'flag: Denmark',
    '🇩🇲': 'flag: Dominica',
    '🇩🇴': 'flag: Dominican Republic',
    '🇩🇿': 'flag: Algeria',
    '🇪🇦': 'flag: Ceuta & Melilla',
    '🇪🇨': 'flag: Ecuador',
    '🇪🇪': 'flag: Estonia',
    '🇪🇬': 'flag: Egypt',
    '🇪🇭': 'flag: Western Sahara',
    '🇪🇷': 'flag: Eritrea',
    '🇪🇸': 'flag: Spain',
    '🇪🇹': 'flag: Ethiopia',
    '🇪🇺': 'flag: European Union',
    '🇫🇮': 'flag: Finland',
    '🇫🇯': 'flag: Fiji',
    '🇫🇰': 'flag: Falkland Islands',
    '🇫🇲': 'flag: Micronesia',
    '🇫🇴': 'flag: Faroe Islands',
    '🇫🇷': 'flag: France',
    '🇬🇦': 'flag: Gabon',
    '🇬🇧': 'flag: United Kingdom',
    '🇬🇩': 'flag: Grenada',
    '🇬🇪': 'flag: Georgia',
    '🇬🇫': 'flag: French Guiana',
    '🇬🇬': 'flag: Guernsey',
    '🇬🇭': 'flag: Ghana',
    '🇬🇮': 'flag: Gibraltar',
    '🇬🇱': 'flag: Greenland',
    '🇬🇲': 'flag: Gambia',
    '🇬🇳': 'flag: Guinea',
    '🇬🇵': 'flag: Guadeloupe',
    '🇬🇶': 'flag: Equatorial Guinea',
    '🇬🇷': 'flag: Greece',
    '🇬🇸': 'flag: South Georgia & South Sandwich Islands',
    '🇬🇹': 'flag: Guatemala',
    '🇬🇺': 'flag: Guam',
    '🇬🇼': 'flag: Guinea-Bissau',
    '🇬🇾': 'flag: Guyana',
    '🇭🇰': 'flag: Hong Kong SAR China',
    '🇭🇲': 'flag: Heard & McDonald Islands',
    '🇭🇳': 'flag: Honduras',
    '🇭🇷': 'flag: Croatia',
    '🇭🇹': 'flag: Haiti',
    '🇭🇺': 'flag: Hungary',
    '🇮🇨': 'flag: Canary Islands',
    '🇮🇩': 'flag: Indonesia',
    '🇮🇪': 'flag: Ireland',
    '🇮🇱': 'flag: Israel',
    '🇮🇲': 'flag: Isle of Man',
    '🇮🇳': 'flag: India',
    '🇮🇴': 'flag: British Indian Ocean Territory',
    '🇮🇶': 'flag: Iraq',
    '🇮🇷': 'flag: Iran',
    '🇮🇸': 'flag: Iceland',
    '🇮🇹': 'flag: Italy',
    '🇯🇪': 'flag: Jersey',
    '🇯🇲': 'flag: Jamaica',
    '🇯🇴': 'flag: Jordan',
    '🇯🇵': 'flag: Japan',
    '🇰🇪': 'flag: Kenya',
    '🇰🇬': 'flag: Kyrgyzstan',
    '🇰🇭': 'flag: Cambodia',
    '🇰🇮': 'flag: Kiribati',
    '🇰🇲': 'flag: Comoros',
    '🇰🇳': 'flag: St. Kitts & Nevis',
    '🇰🇵': 'flag: North Korea',
    '🇰🇷': 'flag: South Korea',
    '🇰🇼': 'flag: Kuwait',
    '🇰🇾': 'flag: Cayman Islands',
    '🇰🇿': 'flag: Kazakhstan',
    '🇱🇦': 'flag: Laos',
    '🇱🇧': 'flag: Lebanon',
    '🇱🇨': 'flag: St. Lucia',
    '🇱🇮': 'flag: Liechtenstein',
    '🇱🇰': 'flag: Sri Lanka',
    '🇱🇷': 'flag: Liberia',
    '🇱🇸': 'flag: Lesotho',
    '🇱🇹': 'flag: Lithuania',
    '🇱🇺': 'flag: Luxembourg',
    '🇱🇻': 'flag: Latvia',
    '🇱🇾': 'flag: Libya',
    '🇲🇦': 'flag: Morocco',
    '🇲🇨': 'flag: Monaco',
    '🇲🇩': 'flag: Moldova',
    '🇲🇪': 'flag: Montenegro',
    '🇲🇫': 'flag: St. Martin',
    '🇲🇬': 'flag: Madagascar',
    '🇲🇭': 'flag: Marshall Islands',
    '🇲🇰': 'flag: North Macedonia',
    '🇲🇱': 'flag: Mali',
    '🇲🇲': 'flag: Myanmar (Burma)',
    '🇲🇳': 'flag: Mongolia',
    '🇲🇴': 'flag: Macao SAR China',
    '🇲🇵': 'flag: Northern Mariana Islands',
    '🇲🇶': 'flag: Martinique',
    '🇲🇷': 'flag: Mauritania',
    '🇲🇸': 'flag: Montserrat',
    '🇲🇹': 'flag: Malta',
    '🇲🇺': 'flag: Mauritius',
    '🇲🇻': 'flag: Maldives',
    '🇲🇼': 'flag: Malawi',
    '🇲🇽': 'flag: Mexico',
    '🇲🇾': 'flag: Malaysia',
    '🇲🇿': 'flag: Mozambique',
    '🇳🇦': 'flag: Namibia',
    '🇳🇨': 'flag: New Caledonia',
    '🇳🇪': 'flag: Niger',
    '🇳🇫': 'flag: Norfolk Island',
    '🇳🇬': 'flag: Nigeria',
    '🇳🇮': 'flag: Nicaragua',
    '🇳🇱': 'flag: Netherlands',
    '🇳🇴': 'flag: Norway',
    '🇳🇵': 'flag: Nepal',
    '🇳🇷': 'flag: Nauru',
    '🇳🇺': 'flag: Niue',
    '🇳🇿': 'flag: New Zealand',
    '🇴🇲': 'flag: Oman',
    '🇵🇦': 'flag: Panama',
    '🇵🇪': 'flag: Peru',
    '🇵🇫': 'flag: French Polynesia',
    '🇵🇬': 'flag: Papua New Guinea',
    '🇵🇭': 'flag: Philippines',
    '🇵🇰': 'flag: Pakistan',
    '🇵🇱': 'flag: Poland',
    '🇵🇲': 'flag: St. Pierre & Miquelon',
    '🇵🇳': 'flag: Pitcairn Islands',
    '🇵🇷': 'flag: Puerto Rico',
    '🇵🇸': 'flag: Palestinian Territories',
    '🇵🇹': 'flag: Portugal',
    '🇵🇼': 'flag: Palau',
    '🇵🇾': 'flag: Paraguay',
    '🇶🇦': 'flag: Qatar',
    '🇷🇪': 'flag: Réunion',
    '🇷🇴': 'flag: Romania',
    '🇷🇸': 'flag: Serbia',
    '🇷🇺': 'flag: Russia',
    '🇷🇼': 'flag: Rwanda',
    '🇸🇦': 'flag: Saudi Arabia',
    '🇸🇧': 'flag: Solomon Islands',
    '🇸🇨': 'flag: Seychelles',
    '🇸🇩': 'flag: Sudan',
    '🇸🇪': 'flag: Sweden',
    '🇸🇬': 'flag: Singapore',
    '🇸🇭': 'flag: St. Helena',
    '🇸🇮': 'flag: Slovenia',
    '🇸🇯': 'flag: Svalbard & Jan Mayen',
    '🇸🇰': 'flag: Slovakia',
    '🇸🇱': 'flag: Sierra Leone',
    '🇸🇲': 'flag: San Marino',
    '🇸🇳': 'flag: Senegal',
    '🇸🇴': 'flag: Somalia',
    '🇸🇷': 'flag: Suriname',
    '🇸🇸': 'flag: South Sudan',
    '🇸🇹': 'flag: São Tomé & Príncipe',
    '🇸🇻': 'flag: El Salvador',
    '🇸🇽': 'flag: Sint Maarten',
    '🇸🇾': 'flag: Syria',
    '🇸🇿': 'flag: Eswatini',
    '🇹🇦': 'flag: Tristan da Cunha',
    '🇹🇨': 'flag: Turks & Caicos Islands',
    '🇹🇩': 'flag: Chad',
    '🇹🇫': 'flag: French Southern Territories',
    '🇹🇬': 'flag: Togo',
    '🇹🇭': 'flag: Thailand',
    '🇹🇯': 'flag: Tajikistan',
    '🇹🇰': 'flag: Tokelau',
    '🇹🇱': 'flag: Timor-Leste',
    '🇹🇲': 'flag: Turkmenistan',
    '🇹🇳': 'flag: Tunisia',
    '🇹🇴': 'flag: Tonga',
    '🇹🇷': 'flag: Turkey',
    '🇹🇹': 'flag: Trinidad & Tobago',
    '🇹🇻': 'flag: Tuvalu',
    '🇹🇼': 'flag: Taiwan',
    '🇹🇿': 'flag: Tanzania',
    '🇺🇦': 'flag: Ukraine',
    '🇺🇬': 'flag: Uganda',
    '🇺🇲': 'flag: U.S. Outlying Islands',
    '🇺🇳': 'flag: United Nations',
    '🇺🇸': 'flag: United States',
    '🇺🇾': 'flag: Uruguay',
    '🇺🇿': 'flag: Uzbekistan',
    '🇻🇦': 'flag: Vatican City',
    '🇻🇨': 'flag: St. Vincent & Grenadines',
    '🇻🇪': 'flag: Venezuela',
    '🇻🇬': 'flag: British Virgin Islands',
    '🇻🇮': 'flag: U.S. Virgin Islands',
    '🇻🇳': 'flag: Vietnam',
    '🇻🇺': 'flag: Vanuatu',
    '🇼🇫': 'flag: Wallis & Futuna',
    '🇼🇸': 'flag: Samoa',
    '🇽🇰': 'flag: Kosovo',
    '🇾🇪': 'flag: Yemen',
    '🇾🇹': 'flag: Mayotte',
    '🇿🇦': 'flag: South Africa',
    '🇿🇲': 'flag: Zambia',
    '🇿🇼': 'flag: Zimbabwe',
    '🏴󠁧󠁢󠁥󠁮󠁧󠁿': 'flag: England',
    '🏴󠁧󠁢󠁳󠁣󠁴󠁿': 'flag: Scotland',
    '🏴󠁧󠁢󠁷󠁬󠁳󠁿': 'flag: Wales',
};
const isEmoji = (str) => {
    const regex = getRegex();
    const emojiMatches = str.match(regex);
    const emojiString = emojiMatches ? emojiMatches.join('') : '';
    return !/\d/.test(str) && emojiString === str;
};
const parseEmoji = (style, str, size = 16) => {
    switch (style) {
        case 'twemoji':
            return twemoji.parse(str, {
                folder: 'svg',
                ext: '.svg',
                attributes: () => ({
                    width: `${size}px`,
                    height: `${size}px`,
                }),
            });
        case 'native':
            return str;
        default:
            return null;
    }
};
/**
 * Gets the shortcode for a given emoji by the name of the emoji. This function replaces
 * spaces with underscores and removes colons.
 * @param key String to replace with shortcode.
 * @returns String with shortcode, or `undefined` if no shortcode exists.
 */
const getShortcode = (key) => {
    var _a;
    // Removable of colons is necessary for the flag shortcodes.
    return (_a = shortNames[key]) === null || _a === void 0 ? void 0 : _a.replace(/\s/g, '_').replace(/:/g, '').toLowerCase();
};
var emoji = {
    shortNames,
    isEmoji,
    getShortcode,
    parseEmoji,
    getRegex,
};

// Default obsidian file icon.
const DEFAULT_FILE_ICON = '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="svg-icon lucide-file"><path d="M14.5 2H6a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V7.5L14.5 2z"></path><polyline points="14 2 14 8 20 8"></polyline></svg>';
// Default obsidian folder icon.
const DEFAULT_FOLDER_ICON = '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="svg-icon lucide-folder"><path d="M4 20h16a2 2 0 0 0 2-2V8a2 2 0 0 0-2-2h-7.93a2 2 0 0 1-1.66-.9l-.82-1.2A2 2 0 0 0 7.93 3H4a2 2 0 0 0-2 2v13c0 1.1.9 2 2 2Z"></path></svg>';
/**
 * Tries to read the file synchronously.
 * @param file File that will be read.
 * @returns A promise that will resolve to a string which is the content of the file.
 */
const readFileSync = (file) => __awaiter(void 0, void 0, void 0, function* () {
    const content = yield new Promise((resolve) => {
        const reader = new FileReader();
        reader.readAsText(file, 'UTF-8');
        reader.onload = (readerEvent) => resolve(readerEvent.target.result);
    });
    return content;
});
/**
 * Gets all the currently opened files by getting the markdown leaves and then checking
 * for the `file` property in the view. This also returns the leaf of the file.
 * @param plugin Instance of the IconizePlugin.
 * @returns An array of {@link FileWithLeaf} objects.
 */
const getAllOpenedFiles = (plugin) => {
    return plugin.app.workspace
        .getLeavesOfType('markdown')
        .reduce((prev, curr) => {
        const file = curr.view.file;
        if (file) {
            prev.push(Object.assign(Object.assign({}, file), { leaf: curr, pinned: false }));
        }
        return prev;
    }, []);
};
/**
 * Gets the file item title element by either accessing `titleEl` or `selfEl`.
 * @param fileItem FileItem which will be used to retrieve the title element from.
 * @returns HTMLElement which is the title element.
 */
const getFileItemTitleEl = (fileItem) => {
    var _a;
    return (_a = fileItem.titleEl) !== null && _a !== void 0 ? _a : fileItem.selfEl;
};
/**
 * Gets the file item inner title element by either accessing `titleInnerEl` or `innerEl`.
 * @param fileItem FileItem which will be used to retrieve the inner title element from.
 * @returns HTMLElement which is the inner title element.
 */
const getFileItemInnerTitleEl = (fileItem) => {
    var _a;
    return (_a = fileItem.titleInnerEl) !== null && _a !== void 0 ? _a : fileItem.innerEl;
};
/**
 * A utility function which will add the icon to the icon pack and then extract the icon
 * to the icon pack.
 * @param plugin IconizePlugin that will be used for extracting the icon.
 * @param iconNameWithPrefix String that will be used to add the icon to the icon pack.
 */
const saveIconToIconPack = (plugin, iconNameWithPrefix) => {
    const iconNextIdentifier = nextIdentifier(iconNameWithPrefix);
    const iconName = iconNameWithPrefix.substring(iconNextIdentifier);
    const iconPrefix = iconNameWithPrefix.substring(0, iconNextIdentifier);
    const possibleIcon = getSvgFromLoadedIcon(iconPrefix, iconName);
    if (!possibleIcon) {
        throw new Error(`Icon ${iconNameWithPrefix} could not be found.`);
    }
    const iconPackName = getIconPackNameByPrefix(iconPrefix);
    if (iconPackName === NATIVE_LUCIDE_ICON_PACK_NAME) {
        return;
    }
    const icon = getIconFromIconPack(iconPackName, iconPrefix, iconName);
    extractIconToIconPack(plugin, icon, possibleIcon);
};
/**
 * A utility function which will remove the icon from the icon pack by removing the icon
 * file from the icon pack directory.
 * @param plugin IconizePlugin that will be used for removing the icon.
 * @param iconNameWithPrefix String that will be used to remove the icon from the icon pack.
 */
const removeIconFromIconPack = (plugin, iconNameWithPrefix) => {
    const identifier = nextIdentifier(iconNameWithPrefix);
    const prefix = iconNameWithPrefix.substring(0, identifier);
    const iconName = iconNameWithPrefix.substring(identifier);
    const iconPackName = getIconPackNameByPrefix(prefix);
    const duplicatedIcon = plugin.getDataPathByValue(iconNameWithPrefix);
    if (!duplicatedIcon) {
        removeIconFromIconPackDirectory(plugin, iconPackName, iconName);
    }
};
/**
 * A utility function which will convert a string to a hexadecimal color.
 * @param str String that will be converted to a hexadecimal color.
 * @returns A string which is the hexadecimal color.
 */
const stringToHex = (str) => {
    const validHex = str.replace(/[^0-9a-fA-F]/g, '');
    const hex = validHex.padStart(6, '0').substring(0, 6);
    return `#${hex}`;
};
/**
 * A utility function which will check if a string is a hexadecimal color.
 * @param str String that will be checked if it is a hexadecimal color.
 * @param includeHash Boolean which will include the hash in the check.
 * @returns A boolean which is true if the string is a hexadecimal color.
 */
const isHexadecimal = (str, includeHash = false) => {
    const regex = new RegExp(`^${includeHash ? '#' : ''}[0-9A-Fa-f]{1,6}$`);
    return regex.test(str);
};

// This library file does not include any other dependency and is a standalone file that
/**
 * Sets the margin for a specific node.
 * @param el Node where the margin will be set.
 * @param margin Margin that will be applied to the node.
 * @returns The modified node with the applied margin.
 */
const setMargin = (el, margin) => {
    el.style.margin = `${margin.top}px ${margin.right}px ${margin.bottom}px ${margin.left}px`;
    return el;
};
/**
 * Applies all stylings to the specified svg icon string and applies styling to the node
 * (container). The styling to the specified element is only modified when it is an emoji
 * or extra margin is defined in the settings.
 * @param plugin Instance of the IconizePlugin.
 * @param iconString SVG that will be used to apply the svg styles to.
 * @param el Node for manipulating the style.
 * @returns Icon svg string with the manipulate style attributes.
 */
const applyAll = (plugin, iconString, container) => {
    iconString = svg.setFontSize(iconString, plugin.getSettings().fontSize);
    container.style.color = plugin.getSettings().iconColor;
    iconString = svg.colorize(iconString, plugin.getSettings().iconColor);
    // Sets the margin of an element.
    const margin = plugin.getSettings().extraMargin;
    const normalizedMargin = {
        top: margin.top !== undefined ? margin.top : 4,
        right: margin.right !== undefined ? margin.right : 4,
        left: margin.left !== undefined ? margin.left : 4,
        bottom: margin.bottom !== undefined ? margin.bottom : 4,
    };
    if (plugin.getSettings().extraMargin) {
        setMargin(container, normalizedMargin);
    }
    if (emoji.isEmoji(iconString)) {
        container.style.fontSize = `${plugin.getSettings().fontSize}px`;
        container.style.lineHeight = `${plugin.getSettings().fontSize}px`;
    }
    return iconString;
};
/**
 * Refreshes all the styles of all the applied icons where a `.iconize-icon`
 * class is defined. This function only modifies the styling of the node.
 * @param plugin Instance of the IconizePlugin.
 * @param applyStyles Function that is getting called when the icon node is found and
 * typically applies all the styles to the icon.
 */
const refreshIconNodes = (plugin, applyStyles = applyAll) => {
    const fileExplorers = plugin.app.workspace.getLeavesOfType('file-explorer');
    for (const fileExplorer of fileExplorers) {
        Object.keys(plugin.getData()).forEach((path) => {
            const fileItem = fileExplorer.view.fileItems[path];
            if (fileItem) {
                const titleEl = getFileItemTitleEl(fileItem);
                const iconNode = titleEl.querySelector('.iconize-icon');
                if (iconNode) {
                    const pathValue = plugin.getData()[path];
                    const hasIndividualColor = typeof pathValue === 'object' && pathValue.iconColor;
                    iconNode.innerHTML = applyStyles(plugin, iconNode.innerHTML, iconNode);
                    if (hasIndividualColor) {
                        iconNode.style.color = pathValue.iconColor;
                        const colorizedInnerHtml = svg.colorize(iconNode.innerHTML, pathValue.iconColor);
                        iconNode.innerHTML = colorizedInnerHtml;
                    }
                }
            }
        });
    }
};
var style = {
    applyAll,
    setMargin,
    refreshIconNodes,
};

/**
 * Removes the `iconize-icon` icon node from the provided HTMLElement.
 * @param el HTMLElement from which the icon node will be removed.
 */
const removeIconInNode = (el) => {
    const iconNode = el.querySelector('.iconize-icon');
    if (!iconNode) {
        return;
    }
    iconNode.remove();
};
/**
 * Removes the 'iconize-icon' icon node from the HTMLElement corresponding
 * to the specified file path.
 * @param path File path for which the icon node will be removed.
 */
const removeIconInPath = (path, options) => {
    var _a;
    const node = (_a = options === null || options === void 0 ? void 0 : options.container) !== null && _a !== void 0 ? _a : document.querySelector(`[data-path="${path}"]`);
    if (!node) {
        logger.warn(`Element with data path not found (path: ${path})`);
        return;
    }
    removeIconInNode(node);
};
/**
 * Sets an icon or emoji for an HTMLElement based on the specified icon name and color.
 * The function manipulates the specified node inline.
 * @param plugin Instance of the IconizePlugin.
 * @param iconName Name of the icon or emoji to add.
 * @param node HTMLElement to which the icon or emoji will be added.
 * @param color Optional color of the icon to add.
 */
const setIconForNode = (plugin, iconName, node, color) => {
    var _a;
    // Gets the possible icon based on the icon name.
    const iconNextIdentifier = nextIdentifier(iconName);
    const possibleIcon = getSvgFromLoadedIcon(iconName.substring(0, iconNextIdentifier), iconName.substring(iconNextIdentifier));
    if (possibleIcon) {
        // The icon is possibly not an emoji.
        let iconContent = style.applyAll(plugin, possibleIcon, node);
        if (color) {
            node.style.color = color;
            iconContent = svg.colorize(iconContent, color);
        }
        node.innerHTML = iconContent;
    }
    else {
        const parsedEmoji = (_a = emoji.parseEmoji(plugin.getSettings().emojiStyle, iconName)) !== null && _a !== void 0 ? _a : iconName;
        node.innerHTML = style.applyAll(plugin, parsedEmoji, node);
    }
    node.setAttribute('title', iconName);
};
/**
 * Creates an icon node for the specified path and inserts it to the DOM.
 * @param plugin Instance of the IconizePlugin.
 * @param path Path for which the icon node will be created.
 * @param iconName Name of the icon or emoji to add.
 * @param color Optional color of the icon to add.
 */
const createIconNode = (plugin, path, iconName, options) => {
    var _a;
    // Get the container from the provided options or try to find the node that has the
    // path from the document itself.
    const node = (_a = options === null || options === void 0 ? void 0 : options.container) !== null && _a !== void 0 ? _a : document.querySelector(`[data-path="${path}"]`);
    if (!node) {
        logger.warn(`Element with data path not found (path: ${path})`);
        return;
    }
    // Get the folder or file title node.
    let titleNode = node.querySelector('.nav-folder-title-content');
    if (!titleNode) {
        titleNode = node.querySelector('.nav-file-title-content');
        if (!titleNode) {
            logger.warn(`Element with title node not found (path: ${path})`);
            return;
        }
    }
    let iconNode = node.querySelector('.iconize-icon');
    // If the icon is already set in the path, we do not need to create a new div element.
    if (iconNode) {
        setIconForNode(plugin, iconName, iconNode, options === null || options === void 0 ? void 0 : options.color);
    }
    else {
        // Creates a new icon node and inserts it to the DOM.
        iconNode = document.createElement('div');
        iconNode.setAttribute(config.ICON_ATTRIBUTE_NAME, iconName);
        iconNode.classList.add('iconize-icon');
        setIconForNode(plugin, iconName, iconNode, options === null || options === void 0 ? void 0 : options.color);
        node.insertBefore(iconNode, titleNode);
    }
};
/**
 * Checks if the element has an icon node by checking if the element has a child with the
 * class `iconize-icon`.
 * @param element HTMLElement which will be checked if it has an icon.
 * @returns Boolean whether the element has an icon node or not.
 */
const doesElementHasIconNode = (element) => {
    return element.querySelector('.iconize-icon') !== null;
};
/**
 * Gets the icon name of the element if it has an icon node.
 * @param element HTMLElement parent which includes a node with the icon.
 * @returns String with the icon name if the element has an icon, `undefined` otherwise.
 */
const getIconFromElement = (element) => {
    const iconNode = element.querySelector('.iconize-icon');
    const existingIcon = iconNode === null || iconNode === void 0 ? void 0 : iconNode.getAttribute(config.ICON_ATTRIBUTE_NAME);
    return existingIcon;
};
const getIconNodeFromPath = (path) => {
    var _a;
    return (_a = document
        .querySelector(`[data-path="${path}"]`)) === null || _a === void 0 ? void 0 : _a.querySelector('[data-icon]');
};
var dom = {
    setIconForNode,
    createIconNode,
    doesElementHasIconNode,
    getIconFromElement,
    getIconNodeFromPath,
    removeIconInNode,
    removeIconInPath,
};

class IconsPickerModal extends obsidian.FuzzySuggestModal {
    constructor(app, plugin, path) {
        super(app);
        this.renderIndex = 0;
        this.plugin = plugin;
        this.path = path;
        this.limit = 150;
        const pluginRecentltyUsedItems = [
            ...plugin.getSettings().recentlyUsedIcons,
        ];
        this.recentlyUsedItems = new Set(pluginRecentltyUsedItems.reverse().filter((iconName) => {
            return doesIconExists(iconName) || emoji.isEmoji(iconName);
        }));
        this.resultContainerEl.classList.add('iconize-modal');
    }
    onOpen() {
        super.onOpen();
    }
    onClose() {
        const { contentEl } = this;
        contentEl.empty();
    }
    getItemText(item) {
        return `${item.name} (${item.prefix})`;
    }
    getItems() {
        const iconKeys = [];
        if (this.inputEl.value.length === 0) {
            this.renderIndex = 0;
            this.recentlyUsedItems.forEach((iconName) => {
                if (emoji.isEmoji(iconName)) {
                    iconKeys.push({
                        name: emoji.shortNames[iconName],
                        prefix: 'Emoji',
                        displayName: iconName,
                        iconPackName: null,
                    });
                    return;
                }
                const nextLetter = nextIdentifier(iconName);
                const iconPrefix = iconName.substring(0, nextLetter);
                const iconPackName = getIconPackNameByPrefix(iconPrefix);
                iconKeys.push({
                    name: iconName.substring(nextLetter),
                    prefix: iconPrefix,
                    displayName: iconName,
                    iconPackName: iconPackName,
                });
            });
        }
        for (const icon of getAllLoadedIconNames()) {
            iconKeys.push({
                name: icon.name,
                prefix: icon.prefix,
                displayName: icon.prefix + icon.name,
                iconPackName: icon.iconPackName,
            });
        }
        Object.entries(emoji.shortNames).forEach(([unicode, shortName]) => {
            iconKeys.push({
                name: shortName,
                prefix: 'Emoji',
                displayName: unicode,
                iconPackName: null,
            });
            iconKeys.push({
                name: unicode,
                prefix: 'Emoji',
                displayName: unicode,
                iconPackName: null,
            });
        });
        return iconKeys;
    }
    onChooseItem(item) {
        var _a;
        const iconNameWithPrefix = typeof item === 'object' ? item.displayName : item;
        dom.createIconNode(this.plugin, this.path, iconNameWithPrefix);
        (_a = this.onSelect) === null || _a === void 0 ? void 0 : _a.call(this, iconNameWithPrefix);
        this.plugin.addFolderIcon(this.path, item);
        // Extracts the icon file to the icon pack.
        if (typeof item === 'object' && !emoji.isEmoji(iconNameWithPrefix)) {
            saveIconToIconPack(this.plugin, iconNameWithPrefix);
        }
        this.plugin.notifyPlugins();
    }
    renderSuggestion(item, el) {
        super.renderSuggestion(item, el);
        // if (getAllIconPacks().length === 0) {
        //   this.resultContainerEl.style.display = 'block';
        //   this.resultContainerEl.innerHTML = '<div class="suggestion-empty">You need to create an icon pack.</div>';
        //   return;
        // }
        // Render subheadlines for modal.
        if (this.recentlyUsedItems.size !== 0 && this.inputEl.value.length === 0) {
            if (this.renderIndex === 0) {
                const subheadline = this.resultContainerEl.createDiv();
                subheadline.classList.add('iconize-subheadline');
                subheadline.innerText = 'Recently used Icons:';
                this.resultContainerEl.prepend(subheadline);
            }
            else if (this.renderIndex === this.recentlyUsedItems.size - 1) {
                const subheadline = this.resultContainerEl.createDiv();
                subheadline.classList.add('iconize-subheadline');
                subheadline.innerText = 'All Icons:';
                this.resultContainerEl.append(subheadline);
            }
        }
        if (item.item.name !== 'default') {
            if (item.item.prefix === 'Emoji') {
                const displayName = emoji.parseEmoji(this.plugin.getSettings().emojiStyle, item.item.displayName);
                if (!displayName) {
                    return;
                }
                el.innerHTML = `<div>${el.innerHTML}</div><div class="iconize-icon-preview">${displayName}</div>`;
            }
            else {
                el.innerHTML = `<div>${el.innerHTML}</div><div class="iconize-icon-preview">${getSvgFromLoadedIcon(item.item.prefix, item.item.name)}</div>`;
            }
        }
        this.renderIndex++;
    }
}

var IconInTitlePosition;
(function (IconInTitlePosition) {
    IconInTitlePosition["Above"] = "above";
    IconInTitlePosition["Inline"] = "inline";
})(IconInTitlePosition || (IconInTitlePosition = {}));
const DEFAULT_SETTINGS = {
    migrated: 2,
    iconPacksPath: '.obsidian/icons',
    fontSize: 16,
    emojiStyle: 'native',
    iconColor: null,
    recentlyUsedIcons: [],
    recentlyUsedIconsSize: 5,
    rules: [],
    extraMargin: {
        top: 0,
        right: 4,
        bottom: 0,
        left: 0,
    },
    iconInTabsEnabled: false,
    iconInTitleEnabled: false,
    iconInTitlePosition: IconInTitlePosition.Above,
    iconInFrontmatterEnabled: false,
    iconInFrontmatterFieldName: 'icon',
    iconColorInFrontmatterFieldName: 'iconColor',
    iconsBackgroundCheckEnabled: false,
    iconsInNotesEnabled: true,
    iconsInLinksEnabled: true,
    iconIdentifier: ':',
    debugMode: false,
};

function migrate$5(plugin) {
    return __awaiter(this, void 0, void 0, function* () {
        // Migration for new syncing mechanism.
        if (plugin.getSettings().migrated === 1) {
            new obsidian.Notice('Please delete your old icon packs and redownload your icon packs to use the new syncing mechanism.', 20000);
            plugin.getSettings().migrated++;
        }
    });
}

function migrate$4(plugin) {
    return __awaiter(this, void 0, void 0, function* () {
        // Migration for new order functionality of custom rules.
        if (plugin.getSettings().migrated === 2) {
            // Sorting alphabetically was the default behavior before.
            plugin
                .getSettings()
                .rules.sort((a, b) => a.rule.localeCompare(b.rule))
                .forEach((rule, i) => {
                rule.order = i;
            });
            plugin.getSettings().migrated++;
        }
    });
}

class IconCache {
    constructor() {
        this.cache = new Map();
        this.set = (path, result) => {
            this.cache.set(path, result);
        };
        this.invalidate = (path) => {
            this.cache.delete(path);
        };
        this.clear = () => {
            this.cache.clear();
        };
        this.get = (path) => {
            var _a;
            return (_a = this.cache.get(path)) !== null && _a !== void 0 ? _a : null;
        };
        this.doesRecordExist = (path) => {
            return this.get(path) !== null;
        };
        if (IconCache.instance) {
            throw new Error('Error: Instantiation failed: Use `IconCache.getInstance()` instead of new.');
        }
        IconCache.instance = this;
    }
}
IconCache.instance = new IconCache();
IconCache.getInstance = () => {
    return IconCache.instance;
};

/**
 * Checks if the file type is equal to the `for` property of the custom rule.
 * @param rule CustomRule that will be checked.
 * @param fileType CustomRuleFileType that will be checked. Can be either `file` or `folder`.
 * @returns Boolean whether the custom rule `for` matches the file type or not.
 */
const doesMatchFileType = (rule, fileType) => {
    return (rule.for === 'everything' ||
        (rule.for === 'files' && fileType === 'file') ||
        (rule.for === 'folders' && fileType === 'folder'));
};
/**
 * Determines whether a given file or folder matches a specified custom rule.
 * @param plugin Plugin instance.
 * @param rule CustomRule to check against the file or folder.
 * @param file TAbstractFile to check against the custom rule.
 * @returns Promise that resolves to `true` if the file matches the rule, `false` otherwise.
 */
const isApplicable = (plugin, rule, file) => __awaiter(void 0, void 0, void 0, function* () {
    const metadata = yield plugin.app.vault.adapter.stat(file.path);
    if (!metadata) {
        return false;
    }
    const fileType = metadata.type;
    const doesMatch = doesMatchFileType(rule, fileType);
    if (!doesMatch) {
        return false;
    }
    return doesMatchPath(rule, file.path);
});
/**
 * Removes the icon from the custom rule from all the files and folders, if applicable.
 * @param plugin IconizePlugin instance.
 * @param rule CustomRule where the icons will be removed based on this rule.
 */
const removeFromAllFiles = (plugin, rule) => __awaiter(void 0, void 0, void 0, function* () {
    const nodesWithIcon = document.querySelectorAll(`[${config.ICON_ATTRIBUTE_NAME}="${rule.icon}"]`);
    for (let i = 0; i < nodesWithIcon.length; i++) {
        const node = nodesWithIcon[i];
        // Parent element is the node which contains the data path.
        const parent = node.parentElement;
        if (!parent) {
            continue;
        }
        const dataPath = parent.getAttribute('data-path');
        if (!dataPath) {
            continue;
        }
        const fileType = (yield plugin.app.vault.adapter.stat(dataPath)).type;
        if (doesMatchPath(rule, dataPath) && doesMatchFileType(rule, fileType)) {
            dom.removeIconInNode(parent);
            IconCache.getInstance().invalidate(dataPath);
        }
    }
});
/**
 * Gets all the custom rules sorted by their order property in ascending order.
 * @param plugin IconizePlugin instance.
 * @returns CustomRule array sorted by their order property in ascending order.
 */
const getSortedRules = (plugin) => {
    return plugin.getSettings().rules.sort((a, b) => a.order - b.order);
};
/**
 * Tries to add all specific custom rule icons to all registered files and directories.
 * It does that by calling the {@link add} function. Custom rules should have the lowest
 * priority and will get ignored if an icon already exists in the file or directory.
 * @param plugin IconizePlugin instance.
 * @param rule CustomRule that will be applied, if applicable, to all files and folders.
 */
const addToAllFiles = (plugin, rule) => __awaiter(void 0, void 0, void 0, function* () {
    const fileItems = yield getFileItems(plugin, rule);
    for (const fileItem of fileItems) {
        yield add$2(plugin, rule, fileItem.file, getFileItemTitleEl(fileItem));
    }
});
/**
 * Tries to add the icon of the custom rule to a file or folder. This function also checks
 * if the file type matches the `for` property of the custom rule.
 * @param plugin IconizePlugin instance.
 * @param rule CustomRule that will be used to check if the rule is applicable to the file
 * or directory.
 * @param file TAbstractFile that will be used to possibly create the icon for.
 * @param container HTMLElement where the icon will be added if the custom rules matches.
 * @returns A promise that resolves to `true` if the icon was added, `false` otherwise.
 */
const add$2 = (plugin, rule, file, container) => __awaiter(void 0, void 0, void 0, function* () {
    if (container && dom.doesElementHasIconNode(container)) {
        return false;
    }
    // Checks if the file or directory already has an icon.
    const hasIcon = plugin.getIconNameFromPath(file.path);
    if (hasIcon) {
        return false;
    }
    const doesMatch = yield isApplicable(plugin, rule, file);
    if (doesMatch) {
        IconCache.getInstance().set(file.path, {
            iconNameWithPrefix: rule.icon,
            inCustomRule: true,
        });
        dom.createIconNode(plugin, file.path, rule.icon, {
            color: rule.color,
            container,
        });
        return true;
    }
    return false;
});
/**
 * Determines whether a given rule exists in a given path.
 * @param rule Rule to check for.
 * @param path Path to check in.
 * @returns True if the rule exists in the path, false otherwise.
 */
const doesMatchPath = (rule, path) => {
    const toMatch = rule.useFilePath ? path : path.split('/').pop();
    try {
        // Rule is in some sort of regex.
        const regex = new RegExp(rule.rule);
        if (toMatch.match(regex)) {
            return true;
        }
    }
    catch (_a) {
        // Rule is not in some sort of regex, check for basic string match.
        return toMatch.includes(rule.rule);
    }
    return false;
};
/**
 * Gets all the file items that can be applied to the specific custom rule.
 * @param plugin Instance of IconizePlugin.
 * @param rule Custom rule that will be checked for.
 * @returns A promise that resolves to an array of file items that match the custom rule.
 */
const getFileItems = (plugin, rule) => __awaiter(void 0, void 0, void 0, function* () {
    const result = [];
    for (const fileExplorer of plugin.getRegisteredFileExplorers()) {
        const files = Object.values(fileExplorer.fileItems);
        for (const fileItem of files) {
            if (yield isApplicable(plugin, rule, fileItem.file)) {
                result.push(fileItem);
            }
        }
    }
    return result;
});
var customRule = {
    getFileItems,
    doesMatchPath,
    doesMatchFileType,
    getSortedRules,
    removeFromAllFiles,
    add: add$2,
    addToAllFiles,
    isApplicable,
};

function migrate$3(plugin) {
    return __awaiter(this, void 0, void 0, function* () {
        // Migration for inheritance to custom rule.
        if (plugin.getSettings().migrated === 3) {
            let hasRemovedInheritance = false;
            for (const [key, value] of Object.entries(plugin.getData())) {
                if (key === 'settings' || typeof value !== 'object') {
                    continue;
                }
                const folderData = value;
                const inheritanceIcon = folderData.inheritanceIcon;
                if (!inheritanceIcon) {
                    continue;
                }
                const folderIconName = folderData.iconName;
                // Clean up old data.
                if (folderData.iconColor && folderIconName) {
                    delete folderData.inheritanceIcon;
                }
                else if (folderIconName) {
                    delete plugin.getData()[key];
                    plugin.getData()[key] = folderIconName;
                }
                else if (!folderIconName) {
                    delete plugin.getData()[key];
                }
                const folderPath = key + '\\/[\\w\\d\\s]+';
                const newRule = {
                    icon: inheritanceIcon,
                    rule: `${folderPath}\\.(?:\\w+\\.)*\\w+`,
                    for: 'files',
                    order: 0,
                    useFilePath: true,
                };
                // Reorder existing custom rules so that the new inheritance custom rule
                // is at the top.
                plugin.getSettings().rules.map((rule) => {
                    rule.order++;
                });
                plugin.getSettings().rules.unshift(newRule);
                // Apply the custom rule.
                yield customRule.addToAllFiles(plugin, newRule);
                hasRemovedInheritance = true;
            }
            if (hasRemovedInheritance) {
                new obsidian.Notice(`[${config.PLUGIN_NAME}] Inheritance has been removed and replaced with custom rules.`);
            }
            plugin.getSettings().migrated++;
        }
    });
}

function migrate$2(plugin) {
    return __awaiter(this, void 0, void 0, function* () {
        if (plugin.getSettings().migrated === 4) {
            if (plugin.getSettings().emojiStyle === 'none') {
                plugin.getSettings().emojiStyle = 'native';
            }
            plugin.getSettings().migrated++;
        }
    });
}

function migrate$1(plugin) {
    return __awaiter(this, void 0, void 0, function* () {
        if (plugin.getSettings().migrated === 5) {
            yield deleteIconPack(plugin, NATIVE_LUCIDE_ICON_PACK_NAME);
            plugin.getSettings().migrated++;
        }
    });
}

const migrate = (plugin) => __awaiter(void 0, void 0, void 0, function* () {
    // eslint-disable-next-line
    // @ts-ignore - Required because an older version of the plugin saved the `migrated`
    // property as a boolean instead of a number.
    if (plugin.getSettings().migrated === true) {
        plugin.getSettings().migrated = 1;
    }
    yield migrate$5(plugin);
    yield migrate$4(plugin);
    yield migrate$3(plugin);
    yield migrate$2(plugin);
    yield migrate$1(plugin);
    yield plugin.saveIconFolderData();
});

class IconFolderSetting {
    constructor(plugin, containerEl) {
        this.plugin = plugin;
        this.containerEl = containerEl;
    }
}

class CustomIconPackSetting extends IconFolderSetting {
    constructor(plugin, containerEl, refreshDisplay) {
        super(plugin, containerEl);
        this.refreshDisplay = refreshDisplay;
        this.dragOverElement = document.createElement('div');
        this.dragOverElement.addClass('iconize-dragover-el');
        this.dragOverElement.style.display = 'hidden';
        this.dragOverElement.innerHTML = '<p>Drop to add icon.</p>';
    }
    normalizeIconPackName(value) {
        return value.toLowerCase().replace(/\s/g, '-');
    }
    preventDefaults(event) {
        event.preventDefault();
        event.stopPropagation();
    }
    highlight(el) {
        clearTimeout(this.closeTimer);
        if (!this.dragTargetElement) {
            el.appendChild(this.dragOverElement);
            el.classList.add('iconize-dragover');
            this.dragTargetElement = el;
        }
    }
    unhighlight(target, el) {
        if (this.dragTargetElement && this.dragTargetElement !== target) {
            this.dragTargetElement.removeChild(this.dragOverElement);
            this.dragTargetElement.classList.remove('iconize-dragover');
            this.dragTargetElement = undefined;
        }
        clearTimeout(this.closeTimer);
        this.closeTimer = setTimeout(() => {
            if (this.dragTargetElement) {
                el.removeChild(this.dragOverElement);
                el.classList.remove('iconize-dragover');
                this.dragTargetElement = undefined;
            }
        }, 100);
    }
    display() {
        new obsidian.Setting(this.containerEl)
            .setName('Add custom icon pack')
            .setDesc('Add a custom icon pack.')
            .addText((text) => {
            text.setPlaceholder('Your icon pack name');
            this.textComponent = text;
        })
            .addButton((btn) => {
            btn.setButtonText('Add icon pack');
            btn.onClick(() => __awaiter(this, void 0, void 0, function* () {
                const name = this.textComponent.getValue();
                if (name.length === 0) {
                    return;
                }
                const normalizedName = this.normalizeIconPackName(this.textComponent.getValue());
                if (yield doesIconPackExist(this.plugin, normalizedName)) {
                    new obsidian.Notice('Icon pack already exists.');
                    return;
                }
                yield createCustomIconPackDirectory(this.plugin, normalizedName);
                this.textComponent.setValue('');
                this.refreshDisplay();
                new obsidian.Notice('Icon pack successfully created.');
            }));
        });
        getAllIconPacks().forEach((iconPack) => {
            const iconPackSetting = new obsidian.Setting(this.containerEl)
                .setName(`${iconPack.name} (${iconPack.prefix})`)
                .setDesc(`Total icons: ${iconPack.icons.length}`);
            // iconPackSetting.addButton((btn) => {
            //   btn.setIcon('broken-link');
            //   btn.setTooltip('Try to fix icon pack');
            //   btn.onClick(async () => {
            //     new Notice('Try to fix icon pack...');
            //     getIconPack(iconPack.name).icons = [];
            //     const icons = await getFilesInDirectory(this.plugin, `${getPath()}/${iconPack.name}`);
            //     for (let i = 0; i < icons.length; i++) {
            //       const filePath = icons[i];
            //       const fileName = filePath.split('/').pop();
            //       const file = await this.plugin.app.vault.adapter.read(filePath);
            //       const iconContent = file
            //         .replace(/stroke="#fff"/g, 'stroke="currentColor"')
            //         .replace(/fill="#fff"/g, 'fill="currentColor"');
            //       await this.plugin.app.vault.adapter.write(filePath, iconContent);
            //       await normalizeFileName(this.plugin, filePath);
            //       addIconToIconPack(iconPack.name, fileName, iconContent);
            //     }
            //     new Notice('...tried to fix icon pack');
            //     // Refreshes the DOM.
            //     Object.entries(this.plugin.getData()).forEach(async ([k, v]) => {
            //       const doesPathExist = await this.plugin.app.vault.adapter.exists(k, true);
            //       if (doesPathExist && typeof v === 'string') {
            //         // dom.removeIconInPath(k);
            //         dom.createIconNode(this.plugin, k, v);
            //       }
            //     });
            //   });
            // });
            if (iconPack.name === NATIVE_LUCIDE_ICON_PACK_NAME) {
                return;
            }
            iconPackSetting.addButton((btn) => {
                btn.setIcon('plus');
                btn.setTooltip('Add an icon');
                btn.onClick(() => __awaiter(this, void 0, void 0, function* () {
                    const fileSelector = document.createElement('input');
                    fileSelector.setAttribute('type', 'file');
                    fileSelector.setAttribute('multiple', 'multiple');
                    fileSelector.setAttribute('accept', '.svg');
                    fileSelector.click();
                    fileSelector.onchange = (e) => __awaiter(this, void 0, void 0, function* () {
                        const target = e.target;
                        for (let i = 0; i < target.files.length; i++) {
                            const file = target.files[i];
                            const content = yield readFileSync(file);
                            yield createFile(this.plugin, iconPack.name, file.name, content);
                            addIconToIconPack(iconPack.name, file.name, content);
                            iconPackSetting.setDesc(`Total icons: ${iconPack.icons.length} (added: ${file.name})`);
                        }
                        new obsidian.Notice('Icons successfully added.');
                    });
                }));
            });
            iconPackSetting.addButton((btn) => {
                btn.setIcon('trash');
                btn.setTooltip('Remove the icon pack');
                btn.onClick(() => __awaiter(this, void 0, void 0, function* () {
                    yield deleteIconPack(this.plugin, iconPack.name);
                    this.refreshDisplay();
                    new obsidian.Notice('Icon pack successfully deleted.');
                }));
            });
            ['dragenter', 'dragover', 'dragleave', 'drop'].forEach((event) => {
                iconPackSetting.settingEl.addEventListener(event, this.preventDefaults, false);
            });
            ['dragenter', 'dragover'].forEach((event) => {
                iconPackSetting.settingEl.addEventListener(event, () => this.highlight(iconPackSetting.settingEl), false);
            });
            ['dragleave', 'drop'].forEach((event) => {
                iconPackSetting.settingEl.addEventListener(event, (event) => this.unhighlight(event.currentTarget, iconPackSetting.settingEl), false);
            });
            iconPackSetting.settingEl.addEventListener('drop', (event) => __awaiter(this, void 0, void 0, function* () {
                const files = event.dataTransfer.files;
                let successful = false;
                for (let i = 0; i < files.length; i++) {
                    const file = files[i];
                    if (file.type !== 'image/svg+xml') {
                        new obsidian.Notice(`File ${file.name} is not a SVG file.`);
                        continue;
                    }
                    successful = true;
                    const content = yield readFileSync(file);
                    yield createFile(this.plugin, iconPack.name, file.name, content);
                    addIconToIconPack(iconPack.name, file.name, content);
                    iconPackSetting.setDesc(`Total icons: ${iconPack.icons.length} (added: ${file.name})`);
                }
                if (successful) {
                    new obsidian.Notice('Icons successfully added.');
                }
            }), false);
        });
    }
}

/**
 * Gets the tab leaves of a specific file path by looping through all opened files and
 * checking if the file path matches.
 * @param plugin IconizePlugin instance.
 * @param path String of the file path to get the tab leaf of.
 * @returns TabHeaderLeaf array that includes all tab leaves of the file path.
 */
const getTabLeavesOfFilePath = (plugin, path) => {
    const openedFiles = getAllOpenedFiles(plugin);
    const openedFile = openedFiles.filter((openedFile) => openedFile.path === path);
    const leaves = openedFile.map((openedFile) => openedFile.leaf);
    return leaves;
};
/**
 * Adds an icon to the tab and its container. This function respects the
 * custom rules and individually icon set.
 * @param plugin IconizePlugin instance.
 * @param file TFile instance of the file to add the icon to.
 * @param iconContainer HTMLElement where the icon will be added to.
 * @param options AddOptions for the add function which can optionally be used.
 */
const add$1 = (plugin, file, iconContainer, options) => __awaiter(void 0, void 0, void 0, function* () {
    var _a;
    const iconColor = (_a = options === null || options === void 0 ? void 0 : options.iconColor) !== null && _a !== void 0 ? _a : plugin.getSettings().iconColor;
    const data = Object.entries(plugin.getData());
    // Removes the `display: none` from the obsidian styling.
    iconContainer.style.display = 'flex';
    // Only add the icon name manually when it is defined in the options.
    if (options === null || options === void 0 ? void 0 : options.iconName) {
        dom.setIconForNode(plugin, options.iconName, iconContainer, iconColor);
        // TODO: Refactor to include option to `insertIconToNode` function.
        iconContainer.style.margin = null;
        return;
    }
    // Add icons to tabs if a custom rule is applicable.
    for (const rule of customRule.getSortedRules(plugin)) {
        const isApplicable = yield customRule.isApplicable(plugin, rule, file);
        if (isApplicable) {
            dom.setIconForNode(plugin, rule.icon, iconContainer, rule.color);
            // TODO: Refactor to include option to `insertIconToNode` function.
            iconContainer.style.margin = null;
            break;
        }
    }
    // Add icons to tabs if there is an icon set.
    const iconData = data.find(([dataPath]) => dataPath === file.path);
    if (!iconData) {
        return;
    }
    const value = iconData[1];
    if (typeof value !== 'string' && typeof value !== 'object') {
        return;
    }
    let iconName;
    if (typeof value === 'object') {
        const v = value;
        if (v.iconName === null) {
            return;
        }
        iconName = v.iconName;
    }
    else {
        iconName = value;
    }
    dom.setIconForNode(plugin, iconName, iconContainer, iconColor);
    // TODO: Refactor to include option to `insertIconToNode` function.
    iconContainer.style.margin = null;
});
/**
 * Updates the icon in the tab and container by setting calling the `setIconForNode`
 * function and removing the margin from the icon container.
 * @param plugin IconizePlugin instance.
 * @param iconName String of the icon name to update to.
 * @param iconContainer HTMLElement where the icon is located and will be updated.
 */
const update = (plugin, iconName, iconContainer) => {
    dom.setIconForNode(plugin, iconName, iconContainer);
    // TODO: Refactor to include option to `insertIconToNode` function.
    iconContainer.style.margin = null;
};
/**
 * Removes the icon from the tab and container by setting the `display` style property
 * to `none`. Optionally, the icon can be replaced with the default obsidian icon.
 * @param iconContainer HTMLElement where the icon is located and will be removed from.
 * @param options RemoveOptions for the remove function which can optionally be used.
 */
const remove$1 = (iconContainer, options) => {
    if (!(options === null || options === void 0 ? void 0 : options.replaceWithDefaultIcon)) {
        // Removes the display of the icon container to remove the icons from the tabs.
        iconContainer.style.display = 'none';
    }
    else {
        iconContainer.innerHTML = DEFAULT_FILE_ICON;
    }
};
var iconTabs = {
    add: add$1,
    update,
    remove: remove$1,
    getTabLeavesOfFilePath,
};

class CustomIconRuleSetting extends IconFolderSetting {
    constructor(plugin, containerEl, app, refreshDisplay) {
        super(plugin, containerEl);
        this.app = app;
        this.refreshDisplay = refreshDisplay;
    }
    /**
     * Updates all the open files based on the custom rule that was specified.
     * @param rule Rule that will be used to update all the icons for all opened files.
     * @param remove Whether to remove the icons that are applicable to the rule or not.
     */
    updateIconTabs(rule_1, remove_1) {
        return __awaiter(this, arguments, void 0, function* (rule, remove, cachedPaths = []) {
            if (this.plugin.getSettings().iconInTabsEnabled) {
                for (const openedFile of getAllOpenedFiles(this.plugin)) {
                    if (cachedPaths.includes(openedFile.path)) {
                        continue;
                    }
                    const applicable = yield customRule.isApplicable(this.plugin, rule, openedFile);
                    if (!applicable) {
                        continue;
                    }
                    const leaf = openedFile.leaf;
                    if (remove) {
                        iconTabs.remove(leaf.tabHeaderInnerIconEl, {
                            replaceWithDefaultIcon: true,
                        });
                    }
                    else {
                        iconTabs.add(this.plugin, openedFile, leaf.tabHeaderInnerIconEl, {
                            iconName: rule.icon,
                            iconColor: rule.color,
                        });
                    }
                }
            }
        });
    }
    createDescriptionEl(container, text) {
        const description = container.createEl('p', {
            text,
            cls: 'setting-item-description',
        });
        description.style.marginBottom = 'var(--size-2-2)';
    }
    display() {
        new obsidian.Setting(this.containerEl)
            .setName('Add icon rule')
            .setDesc('Will add the icon based on the defined rule (as a plain string or in regex format).')
            .addText((text) => {
            text.onChange((value) => {
                this.chooseIconBtn.setDisabled(value.length === 0);
                this.chooseIconBtn.buttonEl.style.cursor =
                    value.length === 0 ? 'not-allowed' : 'default';
                this.chooseIconBtn.buttonEl.style.opacity =
                    value.length === 0 ? '50%' : '100%';
            });
            text.setPlaceholder('regex or simple string');
            this.textComponent = text;
        })
            .addButton((btn) => {
            btn.setDisabled(true);
            btn.setButtonText('Choose icon');
            btn.onClick(() => __awaiter(this, void 0, void 0, function* () {
                if (this.textComponent.getValue().length === 0) {
                    return;
                }
                const modal = new IconsPickerModal(this.app, this.plugin, '');
                modal.onChooseItem = (item) => __awaiter(this, void 0, void 0, function* () {
                    const icon = getNormalizedName(typeof item === 'object' ? item.displayName : item);
                    const rule = {
                        rule: this.textComponent.getValue(),
                        icon,
                        for: 'everything',
                        order: this.plugin.getSettings().rules.length,
                    };
                    this.plugin.getSettings().rules = [
                        ...this.plugin.getSettings().rules,
                        rule,
                    ];
                    yield this.plugin.saveIconFolderData();
                    this.refreshDisplay();
                    new obsidian.Notice('Icon rule added.');
                    this.textComponent.setValue('');
                    saveIconToIconPack(this.plugin, rule.icon);
                    yield customRule.addToAllFiles(this.plugin, rule);
                    this.updateIconTabs(rule, false);
                });
                modal.open();
            }));
            this.chooseIconBtn = btn;
        });
        this.plugin.getSettings().rules.forEach((rule) => {
            // Keeping track of the old rule so that we can get a reference to it for old values.
            const oldRule = Object.assign({}, rule);
            const settingRuleEl = new obsidian.Setting(this.containerEl)
                .setName(rule.rule)
                .setDesc(`Icon: ${rule.icon}`);
            const currentOrder = rule.order;
            /**
             * Re-orders the custom rule based on the value that is passed in.
             * @param valueForReorder Number that will be used to determine whether to swap the
             * custom rule with the next rule or the previous rule.
             */
            const orderCustomRules = (valueForReorder) => __awaiter(this, void 0, void 0, function* () {
                const otherRule = this.plugin.getSettings().rules[currentOrder + valueForReorder];
                // Swap the current rule with the next rule.
                otherRule.order = otherRule.order - valueForReorder;
                rule.order = currentOrder + valueForReorder;
                // Refreshes the DOM.
                yield customRule.removeFromAllFiles(this.plugin, oldRule);
                yield this.plugin.saveIconFolderData();
                const addedPaths = [];
                for (const fileExplorer of this.plugin.getRegisteredFileExplorers()) {
                    const files = Object.values(fileExplorer.fileItems);
                    for (const rule of customRule.getSortedRules(this.plugin)) {
                        // Removes the icon tabs from all opened files.
                        this.updateIconTabs(rule, true, addedPaths);
                        // Adds the icon tabs to all opened files.
                        this.updateIconTabs(rule, false, addedPaths);
                        for (const fileItem of files) {
                            if (addedPaths.includes(fileItem.file.path)) {
                                continue;
                            }
                            const added = yield customRule.add(this.plugin, rule, fileItem.file, getFileItemTitleEl(fileItem));
                            if (added) {
                                addedPaths.push(fileItem.file.path);
                            }
                        }
                    }
                }
                this.refreshDisplay();
            });
            // Add the move down custom rule button to re-order the custom rule.
            settingRuleEl.addExtraButton((btn) => {
                const isFirstOrder = currentOrder === 0;
                btn.setDisabled(isFirstOrder);
                btn.extraSettingsEl.style.cursor = isFirstOrder
                    ? 'not-allowed'
                    : 'default';
                btn.extraSettingsEl.style.opacity = isFirstOrder ? '50%' : '100%';
                btn.setIcon('arrow-up');
                btn.setTooltip('Prioritize the custom rule');
                btn.onClick(() => __awaiter(this, void 0, void 0, function* () {
                    yield orderCustomRules(-1);
                }));
            });
            // Add the move up custom rule button to re-order the custom rule.
            settingRuleEl.addExtraButton((btn) => {
                const isLastOrder = currentOrder === this.plugin.getSettings().rules.length - 1;
                btn.setDisabled(isLastOrder);
                btn.extraSettingsEl.style.cursor = isLastOrder
                    ? 'not-allowed'
                    : 'default';
                btn.extraSettingsEl.style.opacity = isLastOrder ? '50%' : '100%';
                btn.setIcon('arrow-down');
                btn.setTooltip('Deprioritize the custom rule');
                btn.onClick(() => __awaiter(this, void 0, void 0, function* () {
                    yield orderCustomRules(1);
                }));
            });
            // Add the edit custom rule button.
            settingRuleEl.addButton((btn) => {
                btn.setIcon('pencil');
                btn.setTooltip('Edit the custom rule');
                btn.onClick(() => {
                    var _a, _b;
                    // Create modal and its children elements.
                    const modal = new obsidian.Modal(this.plugin.app);
                    modal.contentEl.style.display = 'block';
                    modal.modalEl.classList.add('iconize-custom-modal');
                    modal.titleEl.setText('Edit custom rule');
                    // Create the input for the rule.
                    this.createDescriptionEl(modal.contentEl, 'Regex or simple string');
                    const input = new obsidian.TextComponent(modal.contentEl);
                    input.setValue(rule.rule);
                    input.onChange((value) => __awaiter(this, void 0, void 0, function* () {
                        rule.rule = value;
                    }));
                    const useFilePathContainer = modal.contentEl.createDiv();
                    useFilePathContainer.style.display = 'flex';
                    useFilePathContainer.style.alignItems = 'center';
                    useFilePathContainer.style.justifyContent = 'space-between';
                    useFilePathContainer.style.marginTop = 'var(--size-4-5)';
                    const useFilePathDescription = useFilePathContainer.createEl('p', {
                        text: 'Include folders and files that are part of the path.',
                        cls: 'setting-item-description',
                    });
                    useFilePathDescription.style.margin = '0';
                    useFilePathDescription.style.marginBottom = 'var(--size-2-2)';
                    new obsidian.ToggleComponent(useFilePathContainer)
                        .setValue(rule.useFilePath === true)
                        .onChange((value) => {
                        rule.useFilePath = value;
                    });
                    // Create the toggle for changing the rule type.
                    const ruleTypeContainer = modal.contentEl.createDiv();
                    ruleTypeContainer.style.display = 'flex';
                    ruleTypeContainer.style.alignItems = 'center';
                    ruleTypeContainer.style.justifyContent = 'space-between';
                    ruleTypeContainer.style.marginTop = 'var(--size-4-5)';
                    const ruleTypeDescription = ruleTypeContainer.createEl('p', {
                        text: 'Where the custom rule gets applied to.',
                        cls: 'setting-item-description',
                    });
                    ruleTypeDescription.style.margin = '0';
                    ruleTypeDescription.style.marginBottom = 'var(--size-2-2)';
                    const ruleTypeButton = new obsidian.ButtonComponent(ruleTypeContainer);
                    const setButtonContent = (isFor) => {
                        if (isFor === 'folders') {
                            ruleTypeButton.setIcon('folder');
                        }
                        else if (isFor === 'files') {
                            ruleTypeButton.setIcon('document');
                        }
                        else {
                            ruleTypeButton.setIcon('documents');
                        }
                        ruleTypeButton.setTooltip(`Icon applicable to: ${isFor}`);
                    };
                    setButtonContent((_a = rule.for) !== null && _a !== void 0 ? _a : 'everything');
                    ruleTypeButton.onClick(() => __awaiter(this, void 0, void 0, function* () {
                        var _c;
                        const isFor = (_c = rule.for) !== null && _c !== void 0 ? _c : 'everything';
                        this.updateIconTabs(rule, true);
                        yield customRule.removeFromAllFiles(this.plugin, Object.assign(Object.assign({}, rule), { for: isFor }));
                        if (isFor === 'folders') {
                            rule.for = 'everything';
                        }
                        else if (isFor === 'files') {
                            rule.for = 'folders';
                        }
                        else {
                            rule.for = 'files';
                        }
                        setButtonContent(rule.for);
                    }));
                    // Create the change icon button with icon preview.
                    this.createDescriptionEl(modal.contentEl, 'Custom rule icon');
                    const iconContainer = modal.contentEl.createDiv();
                    iconContainer.style.display = 'flex';
                    iconContainer.style.alignItems = 'center';
                    iconContainer.style.justifyContent = 'space-between';
                    const iconEl = iconContainer.createDiv();
                    const iconPreviewEl = iconEl.createDiv();
                    dom.setIconForNode(this.plugin, rule.icon, iconPreviewEl);
                    iconEl.style.display = 'flex';
                    iconEl.style.alignItems = 'center';
                    iconEl.style.justifyContent = 'space-between';
                    iconEl.style.margin = null;
                    iconPreviewEl.innerHTML = svg.setFontSize(iconPreviewEl.innerHTML, 20);
                    const iconNameEl = iconEl.createEl('div', {
                        cls: 'setting-item-description',
                    });
                    iconNameEl.style.paddingTop = '0';
                    iconNameEl.style.marginLeft = 'var(--size-2-2)';
                    iconNameEl.innerText = rule.icon;
                    const changeIconBtn = new obsidian.ButtonComponent(iconContainer);
                    changeIconBtn.setButtonText('Change icon');
                    changeIconBtn.onClick(() => __awaiter(this, void 0, void 0, function* () {
                        const modal = new IconsPickerModal(this.app, this.plugin, rule.icon);
                        modal.onChooseItem = (item) => __awaiter(this, void 0, void 0, function* () {
                            const icon = typeof item === 'object' ? item.displayName : item;
                            rule.icon = icon;
                            dom.setIconForNode(this.plugin, rule.icon, iconPreviewEl);
                            iconPreviewEl.innerHTML = svg.setFontSize(iconPreviewEl.innerHTML, 20);
                            iconNameEl.innerText = getNormalizedName(rule.icon);
                        });
                        modal.open();
                    }));
                    // Create the color picker for the rule.
                    this.createDescriptionEl(modal.contentEl, 'Color of the icon');
                    const colorContainer = modal.contentEl.createDiv();
                    colorContainer.style.display = 'flex';
                    colorContainer.style.alignItems = 'center';
                    colorContainer.style.justifyContent = 'space-between';
                    const colorPicker = new obsidian.ColorComponent(colorContainer)
                        .setValue((_b = rule.color) !== null && _b !== void 0 ? _b : '#000000')
                        .onChange((value) => {
                        rule.color = value;
                    });
                    const defaultColorButton = new obsidian.ButtonComponent(colorContainer);
                    defaultColorButton.setTooltip('Set color to the default one');
                    defaultColorButton.setButtonText('Default');
                    defaultColorButton.onClick(() => {
                        colorPicker.setValue('#000000');
                        rule.color = undefined;
                    });
                    // Create the save button.
                    const button = new obsidian.ButtonComponent(modal.contentEl);
                    button.buttonEl.style.marginTop = 'var(--size-4-4)';
                    button.buttonEl.style.float = 'right';
                    button.setButtonText('Save Changes');
                    button.onClick(() => __awaiter(this, void 0, void 0, function* () {
                        if (!emoji.isEmoji(oldRule.icon)) {
                            // Tries to remove the previously used icon from the icon pack.
                            removeIconFromIconPack(this.plugin, oldRule.icon);
                        }
                        if (!emoji.isEmoji(rule.icon)) {
                            // Tries to add the newly used icon to the icon pack.
                            saveIconToIconPack(this.plugin, rule.icon);
                            rule.icon = getNormalizedName(rule.icon);
                        }
                        this.refreshDisplay();
                        new obsidian.Notice('Custom rule updated.');
                        // Refresh the DOM.
                        yield customRule.removeFromAllFiles(this.plugin, oldRule);
                        this.updateIconTabs(rule, true);
                        this.plugin.getSettings().rules.forEach((rule) => __awaiter(this, void 0, void 0, function* () {
                            yield customRule.addToAllFiles(this.plugin, rule);
                            this.updateIconTabs(rule, false);
                        }));
                        yield this.plugin.saveIconFolderData();
                        modal.close();
                    }));
                    modal.open();
                });
            });
            // Add the delete custom rule button.
            settingRuleEl.addButton((btn) => {
                btn.setIcon('trash');
                btn.setTooltip('Remove the custom rule');
                btn.onClick(() => __awaiter(this, void 0, void 0, function* () {
                    const newRules = this.plugin
                        .getSettings()
                        .rules.filter((r) => rule.rule !== r.rule ||
                        rule.color !== r.color ||
                        rule.icon !== r.icon ||
                        rule.for !== r.for);
                    this.plugin.getSettings().rules = newRules;
                    yield this.plugin.saveIconFolderData();
                    this.refreshDisplay();
                    new obsidian.Notice('Custom rule deleted.');
                    yield customRule.removeFromAllFiles(this.plugin, rule);
                    removeIconFromIconPack(this.plugin, rule.icon);
                    this.updateIconTabs(rule, true);
                    const previousRules = this.plugin
                        .getSettings()
                        .rules.filter((r) => rule.for === r.for);
                    previousRules.forEach((previousRule) => __awaiter(this, void 0, void 0, function* () {
                        yield customRule.addToAllFiles(this.plugin, previousRule);
                        this.updateIconTabs(previousRule, false);
                    }));
                }));
            });
        });
    }
}

const getTitleIcon = (leaf) => {
    return leaf.querySelector(`.${config.TITLE_ICON_CLASS}`);
};
const add = (plugin, inlineTitleEl, svgElement, options) => {
    var _a;
    if (!inlineTitleEl.parentElement) {
        return;
    }
    if (options === null || options === void 0 ? void 0 : options.fontSize) {
        svgElement = svg.setFontSize(svgElement, options.fontSize);
    }
    let titleIcon = getTitleIcon(inlineTitleEl.parentElement);
    if (!titleIcon) {
        titleIcon = document.createElement('div');
    }
    const isInline = plugin.getSettings().iconInTitlePosition === IconInTitlePosition.Inline;
    if (isInline) {
        titleIcon.style.display = 'inline-block';
        titleIcon.style.removeProperty('margin-inline');
        titleIcon.style.removeProperty('width');
    }
    else {
        titleIcon.style.display = 'block';
        titleIcon.style.width = 'var(--line-width)';
        titleIcon.style.marginInline = '0';
    }
    titleIcon.classList.add(config.TITLE_ICON_CLASS);
    // Checks if the passed element is an emoji.
    if (emoji.isEmoji(svgElement) && options.fontSize) {
        svgElement =
            (_a = emoji.parseEmoji(plugin.getSettings().emojiStyle, svgElement, options.fontSize)) !== null && _a !== void 0 ? _a : svgElement;
        titleIcon.style.fontSize = `${options.fontSize}px`;
    }
    titleIcon.innerHTML = svgElement;
    let wrapperElement = inlineTitleEl.parentElement;
    // Checks the parent and selects the correct wrapper element.
    // This should only happen in the beginning.
    if (wrapperElement &&
        !wrapperElement.classList.contains(config.INLINE_TITLE_WRAPPER_CLASS)) {
        wrapperElement = wrapperElement.querySelector(`.${config.INLINE_TITLE_WRAPPER_CLASS}`);
    }
    // Whenever there is no correct wrapper element, we create one.
    if (!wrapperElement) {
        wrapperElement = inlineTitleEl.parentElement.createDiv();
        wrapperElement.classList.add(config.INLINE_TITLE_WRAPPER_CLASS);
    }
    // Avoiding adding the same nodes together when changing the title.
    if (wrapperElement !== inlineTitleEl.parentElement) {
        inlineTitleEl.parentElement.prepend(wrapperElement);
    }
    if (isInline) {
        wrapperElement.style.display = 'flex';
        wrapperElement.style.alignItems = 'flex-start';
        const inlineTitlePaddingTop = getComputedStyle(inlineTitleEl, null).getPropertyValue('padding-top');
        titleIcon.style.paddingTop = inlineTitlePaddingTop;
        if (emoji.isEmoji(svgElement)) {
            titleIcon.style.transform = 'translateY(-9%)';
        }
        else {
            titleIcon.style.transform = 'translateY(9%)';
        }
    }
    else {
        wrapperElement.style.display = 'block';
        titleIcon.style.transform = 'translateY(9%)';
    }
    wrapperElement.append(titleIcon);
    wrapperElement.append(inlineTitleEl);
};
const updateStyle = (inlineTitleEl, options) => {
    if (!inlineTitleEl.parentElement) {
        return;
    }
    const titleIcon = getTitleIcon(inlineTitleEl.parentElement);
    if (!titleIcon) {
        return;
    }
    if (options.fontSize) {
        if (!emoji.isEmoji(titleIcon.innerHTML)) {
            titleIcon.innerHTML = svg.setFontSize(titleIcon.innerHTML, options.fontSize);
        }
        else {
            titleIcon.style.fontSize = `${options.fontSize}px`;
        }
    }
};
/**
 * Hides the title icon from the provided HTMLElement.
 * @param contentEl HTMLElement to hide the title icon from.
 */
const hide = (inlineTitleEl) => {
    if (!inlineTitleEl.parentElement) {
        return;
    }
    const titleIconContainer = getTitleIcon(inlineTitleEl.parentElement);
    if (!titleIconContainer) {
        return;
    }
    titleIconContainer.style.display = 'none';
};
const remove = (inlineTitleEl) => {
    if (!inlineTitleEl.parentElement) {
        return;
    }
    const titleIconContainer = getTitleIcon(inlineTitleEl.parentElement);
    if (!titleIconContainer) {
        return;
    }
    titleIconContainer.remove();
};
var titleIcon = {
    add,
    updateStyle,
    hide,
    remove,
};

const calculateFontTextSize = () => {
    var _a;
    let fontSize = parseFloat((_a = getComputedStyle(document.body).getPropertyValue('--font-text-size')) !== null && _a !== void 0 ? _a : '0');
    if (!fontSize) {
        fontSize = parseFloat(getComputedStyle(document.documentElement).fontSize);
    }
    return fontSize;
};
const calculateInlineTitleSize = () => {
    const fontSize = calculateFontTextSize();
    const inlineTitleSizeValue = getComputedStyle(document.body).getPropertyValue('--inline-title-size');
    const unit = inlineTitleSizeValue.replace(/[\d.]/g, '');
    let inlineTitleSize = parseFloat(inlineTitleSizeValue);
    if (unit === 'px') {
        inlineTitleSize /= 16;
    }
    return fontSize * inlineTitleSize;
};
const isHeader = (value) => {
    return /^h[1-6]$/.test(value);
};
const getHTMLHeaderByToken = (header) => {
    for (let i = 1; i <= 6; i++) {
        if (header === `header-${i}`) {
            return `h${i}`;
        }
    }
    return null;
};
const calculateHeaderSize = (header) => {
    var _a;
    const fontSize = calculateFontTextSize();
    const htmlHeader = (_a = getHTMLHeaderByToken(header)) !== null && _a !== void 0 ? _a : header;
    const headerSize = parseFloat(getComputedStyle(document.body).getPropertyValue(`--${htmlHeader}-size`));
    return fontSize * headerSize;
};

class EmojiStyleSetting extends IconFolderSetting {
    display() {
        const emojiStyle = new obsidian.Setting(this.containerEl)
            .setName('Emoji style')
            .setDesc('Change the style of your emojis.');
        emojiStyle.addDropdown((dropdown) => {
            dropdown.addOption('native', 'Native');
            dropdown.addOption('twemoji', 'Twemoji');
            dropdown.setValue(this.plugin.getSettings().emojiStyle);
            dropdown.onChange((value) => __awaiter(this, void 0, void 0, function* () {
                this.plugin.getSettings().emojiStyle = value;
                this.updateDOM();
                yield this.plugin.saveIconFolderData();
            }));
        });
    }
    updateDOM() {
        for (const fileExplorer of this.plugin.getRegisteredFileExplorers()) {
            const fileItems = Object.entries(fileExplorer.fileItems);
            for (const [path, _] of fileItems) {
                let iconName = this.plugin.getData()[path];
                if (!iconName) {
                    continue;
                }
                const data = this.plugin.getData()[path];
                if (typeof data === 'object') {
                    const data = this.plugin.getData()[path];
                    if (data.iconName) {
                        iconName = data.iconName;
                    }
                }
                if (emoji.isEmoji(iconName)) {
                    dom.createIconNode(this.plugin, path, iconName);
                    if (this.plugin.getSettings().iconInTabsEnabled) {
                        const tabLeaves = iconTabs.getTabLeavesOfFilePath(this.plugin, path);
                        for (const tabLeaf of tabLeaves) {
                            iconTabs.update(this.plugin, iconName, tabLeaf.tabHeaderInnerIconEl);
                        }
                    }
                    if (this.plugin.getSettings().iconInTitleEnabled) {
                        for (const openedFile of getAllOpenedFiles(this.plugin)) {
                            const activeView = openedFile.leaf.view;
                            if (activeView instanceof obsidian.MarkdownView &&
                                openedFile.path === path) {
                                titleIcon.add(this.plugin, activeView.inlineTitleEl, iconName, {
                                    fontSize: calculateInlineTitleSize(),
                                });
                            }
                        }
                    }
                }
            }
        }
        for (const rule of customRule.getSortedRules(this.plugin)) {
            customRule.addToAllFiles(this.plugin, rule);
        }
    }
}

/**
 * Helper function that refreshes the style of all the icons that are defined
 * or in a custom rule involved.
 * @param plugin Instance of the IconizePlugin.
 */
const refreshStyleOfIcons = (plugin) => __awaiter(void 0, void 0, void 0, function* () {
    // Refreshes the icon style for all normally added icons.
    style.refreshIconNodes(plugin);
    // Refreshes the icon style for all custom icon rules, when the color of the rule is
    // not defined.
    for (const rule of customRule.getSortedRules(plugin)) {
        const fileItems = yield customRule.getFileItems(plugin, rule);
        for (const fileItem of fileItems) {
            const titleEl = getFileItemTitleEl(fileItem);
            const iconNode = titleEl.querySelector('.iconize-icon');
            let iconContent = iconNode.innerHTML;
            iconContent = style.applyAll(plugin, iconContent, iconNode);
            if (rule.color) {
                iconContent = svg.colorize(iconContent, rule.color);
                iconNode.style.color = rule.color;
            }
            iconNode.innerHTML = iconContent;
        }
    }
});
var helper = {
    refreshStyleOfIcons,
};

class ExtraMarginSetting extends IconFolderSetting {
    display() {
        var _a, _b;
        const extraMarginSetting = new obsidian.Setting(this.containerEl)
            .setName('Extra margin (in pixels)')
            .setDesc('Change the margin of the icons.')
            .setClass('iconize-setting');
        const extraMarginDropdown = new obsidian.DropdownComponent(extraMarginSetting.controlEl).addOptions({
            top: 'Top',
            right: 'Right',
            bottom: 'Bottom',
            left: 'Left',
        });
        const extraMarginSlider = new obsidian.SliderComponent(extraMarginSetting.controlEl)
            .setLimits(-24, 24, 1)
            .setDynamicTooltip()
            .setValue((_b = (_a = this.plugin.getSettings().extraMargin) === null || _a === void 0 ? void 0 : _a.top) !== null && _b !== void 0 ? _b : 2)
            .onChange((val) => __awaiter(this, void 0, void 0, function* () {
            const dropdownValue = extraMarginDropdown.getValue();
            if (this.plugin.getSettings().extraMargin) {
                this.plugin.getSettings().extraMargin[dropdownValue] = val;
            }
            else {
                this.plugin.getSettings().extraMargin = {
                    [dropdownValue]: val,
                };
            }
            yield this.plugin.saveIconFolderData();
            helper.refreshStyleOfIcons(this.plugin);
        }));
        extraMarginDropdown.onChange((val) => {
            var _a;
            if (this.plugin.getSettings().extraMargin) {
                extraMarginSlider.setValue((_a = this.plugin.getSettings().extraMargin[val]) !== null && _a !== void 0 ? _a : 2);
            }
            else {
                extraMarginSlider.setValue(2);
            }
        });
        extraMarginSetting.components.push(extraMarginDropdown, extraMarginSlider);
    }
}

class ResetButtonComponent extends obsidian.ButtonComponent {
    constructor(contentEl) {
        super(contentEl);
        this.contentEl = contentEl;
        this.setTooltip('Restore default');
        this.setIcon('rotate-ccw');
        this.render();
    }
    render() {
        this.buttonEl.classList.add('clickable-icon');
        this.buttonEl.classList.add('extra-setting-button');
    }
}

const DEFAULT_VALUE = DEFAULT_SETTINGS.iconColor;
class IconColorSetting extends IconFolderSetting {
    display() {
        var _a;
        const setting = new obsidian.Setting(this.containerEl)
            .setName('Icon color')
            .setDesc('Change the color of the displayed icons.');
        new ResetButtonComponent(setting.controlEl).onClick(() => __awaiter(this, void 0, void 0, function* () {
            colorPicker.setValue(DEFAULT_VALUE);
            this.plugin.getSettings().iconColor = null;
            // Custom saving to not save the color black in the data.
            yield this.plugin.saveIconFolderData();
            helper.refreshStyleOfIcons(this.plugin);
        }));
        const colorPicker = new obsidian.ColorComponent(setting.controlEl)
            .setValue((_a = this.plugin.getSettings().iconColor) !== null && _a !== void 0 ? _a : DEFAULT_VALUE)
            .onChange((value) => __awaiter(this, void 0, void 0, function* () {
            this.plugin.getSettings().iconColor = value;
            yield this.plugin.saveIconFolderData();
            helper.refreshStyleOfIcons(this.plugin);
        }));
    }
}

const values = {
    min: 10,
    max: 64,
    default: DEFAULT_SETTINGS.fontSize,
    step: 1,
};
class IconFontSizeSetting extends IconFolderSetting {
    display() {
        const setting = new obsidian.Setting(this.containerEl)
            .setName('Icon font size (in pixels)')
            .setDesc('Change the font size of the displayed icons.');
        new ResetButtonComponent(setting.controlEl).onClick(() => {
            this.slider.setValue(values.default);
        });
        setting.addSlider((slider) => {
            var _a;
            this.slider = slider;
            slider
                .setLimits(values.min, values.max, values.step)
                .setDynamicTooltip()
                .setValue((_a = this.plugin.getSettings().fontSize) !== null && _a !== void 0 ? _a : DEFAULT_SETTINGS.fontSize)
                .onChange((val) => __awaiter(this, void 0, void 0, function* () {
                this.plugin.getSettings().fontSize = val;
                yield this.plugin.saveIconFolderData();
                helper.refreshStyleOfIcons(this.plugin);
            }));
        });
    }
}

class IconPacksPathSetting extends IconFolderSetting {
    display() {
        const iconPacksPathSetting = new obsidian.Setting(this.containerEl)
            .setName('Icon packs folder path')
            .setDesc('Change the default icon packs folder path.');
        iconPacksPathSetting.addText((text) => {
            this.iconPacksSettingTextComp = text;
            text.setValue(this.plugin.getSettings().iconPacksPath);
        });
        iconPacksPathSetting.addButton((btn) => {
            btn.setButtonText('Save');
            btn.onClick(() => __awaiter(this, void 0, void 0, function* () {
                const newPath = this.iconPacksSettingTextComp.getValue();
                const oldPath = this.plugin.getSettings().iconPacksPath;
                if (oldPath === this.iconPacksSettingTextComp.getValue()) {
                    return;
                }
                new obsidian.Notice('Saving in progress...');
                setPath(newPath);
                yield createDefaultDirectory(this.plugin);
                yield moveIconPackDirectories(this.plugin, oldPath, newPath);
                this.plugin.getSettings().iconPacksPath = newPath;
                yield this.plugin.saveIconFolderData();
                new obsidian.Notice('...saved successfully');
            }));
        });
    }
}

class IconPacksBackgroundChecker extends IconFolderSetting {
    display() {
        new obsidian.Setting(this.containerEl)
            .setName('Icons background check')
            .setDesc('Check in the background on every load of Obsidian, if icons are missing and it will try to add them to the specific icon pack.')
            .addToggle((toggle) => {
            toggle
                .setValue(this.plugin.getSettings().iconsBackgroundCheckEnabled)
                .onChange((enabled) => __awaiter(this, void 0, void 0, function* () {
                this.plugin.getSettings().iconsBackgroundCheckEnabled = enabled;
                yield this.plugin.saveIconFolderData();
                if (enabled) {
                    new obsidian.Notice('You need to reload Obsidian for this to take effect.', 10000);
                }
            }));
        });
    }
}

class IconPackBrowserModal extends obsidian.FuzzySuggestModal {
    constructor(app, plugin) {
        super(app);
        this.plugin = plugin;
        this.resultContainerEl.classList.add('iconize-browse-modal');
        this.inputEl.placeholder = 'Select to download icon pack';
    }
    // eslint-disable-next-line
    onAddedIconPack() { }
    onOpen() {
        super.onOpen();
    }
    onClose() {
        this.contentEl.empty();
    }
    getItemText(item) {
        const prefix = createIconPackPrefix(item.name);
        return `${item.displayName} (${prefix})`;
    }
    getItems() {
        const predefinedIconPacks = Object.values(iconPacks$1);
        const allIconPacks = getAllIconPacks();
        return predefinedIconPacks.filter((iconPack) => allIconPacks.find((ip) => iconPack.name === ip.name) === undefined);
    }
    onChooseItem(item, _event) {
        return __awaiter(this, void 0, void 0, function* () {
            new obsidian.Notice(`Adding ${item.displayName}...`);
            const arrayBuffer = yield downloadZipFile(item.downloadLink);
            yield createZipFile(this.plugin, `${item.name}.zip`, arrayBuffer);
            yield registerIconPack(item.name, arrayBuffer);
            new obsidian.Notice(`...${item.displayName} added`);
            this.onAddedIconPack();
        });
    }
    renderSuggestion(item, el) {
        super.renderSuggestion(item, el);
        el.innerHTML = `<div>${el.innerHTML}</div>`;
    }
}

class PredefinedIconPacksSetting extends IconFolderSetting {
    constructor(plugin, containerEl, app, refreshDisplay) {
        super(plugin, containerEl);
        this.app = app;
        this.refreshDisplay = refreshDisplay;
    }
    display() {
        new obsidian.Setting(this.containerEl)
            .setName('Add predefined icon pack')
            .setDesc('Add a predefined icon pack that is officially supported.')
            .addButton((btn) => {
            btn.setButtonText('Browse icon packs');
            btn.onClick(() => {
                const modal = new IconPackBrowserModal(this.app, this.plugin);
                modal.onAddedIconPack = () => {
                    this.refreshDisplay();
                };
                modal.open();
            });
        });
    }
}

class RecentlyUsedIconsSetting extends IconFolderSetting {
    display() {
        new obsidian.Setting(this.containerEl)
            .setName('Recently used icons limit')
            .setDesc('Change the limit for the recently used icons displayed in the icon selection modal.')
            .addSlider((slider) => {
            var _a;
            slider
                .setLimits(1, 25, 1)
                .setDynamicTooltip()
                .setValue((_a = this.plugin.getSettings().recentlyUsedIconsSize) !== null && _a !== void 0 ? _a : DEFAULT_SETTINGS.recentlyUsedIconsSize)
                .onChange((val) => __awaiter(this, void 0, void 0, function* () {
                this.plugin.getSettings().recentlyUsedIconsSize = val;
                yield this.plugin.checkRecentlyUsedIcons();
                yield this.plugin.saveIconFolderData();
            }));
        });
    }
}

class ToggleIconInTabs extends IconFolderSetting {
    display() {
        new obsidian.Setting(this.containerEl)
            .setName('Toggle icon in tabs')
            .setDesc('Toggles the visibility of an icon for a file in the tab bar.')
            .addToggle((toggle) => {
            toggle
                .setValue(this.plugin.getSettings().iconInTabsEnabled)
                .onChange((enabled) => __awaiter(this, void 0, void 0, function* () {
                this.plugin.getSettings().iconInTabsEnabled = enabled;
                yield this.plugin.saveIconFolderData();
                // Updates the already opened files.
                this.plugin.app.workspace
                    .getLeavesOfType('markdown')
                    .forEach((leaf) => {
                    const file = leaf.view.file;
                    if (file) {
                        const tabHeaderLeaf = leaf;
                        if (enabled) {
                            // Adds the icons to already opened files.
                            iconTabs.add(this.plugin, file, tabHeaderLeaf.tabHeaderInnerIconEl);
                        }
                        else {
                            // Removes the icons from already opened files.
                            iconTabs.remove(tabHeaderLeaf.tabHeaderInnerIconEl);
                        }
                    }
                });
            }));
        });
    }
}

const checkMissingIcons = (plugin, data) => __awaiter(void 0, void 0, void 0, function* () {
    const missingIcons = new Set();
    const allIcons = new Map();
    const getMissingIcon = (iconNameWithPrefix) => __awaiter(void 0, void 0, void 0, function* () {
        const iconNextIdentifier = nextIdentifier(iconNameWithPrefix);
        const iconName = iconNameWithPrefix.substring(iconNextIdentifier);
        const iconPrefix = iconNameWithPrefix.substring(0, iconNextIdentifier);
        const iconPackName = getIconPackNameByPrefix(iconPrefix);
        if (iconPackName === NATIVE_LUCIDE_ICON_PACK_NAME) {
            return;
        }
        const icon = getIconFromIconPack(iconPackName, iconPrefix, iconName);
        if (!icon) {
            logger.error(`Icon file with name ${iconNameWithPrefix} could not be found`);
            return null;
        }
        const doesIconFileExists = yield plugin.app.vault.adapter.exists(`${getPath()}/${iconPackName}/${iconName}.svg`);
        if (!doesIconFileExists) {
            const possibleIcon = getSvgFromLoadedIcon(iconPrefix, iconName);
            if (!possibleIcon) {
                logger.error(`Icon SVG with name ${iconNameWithPrefix} could not be found`);
                return null;
            }
            yield extractIconToIconPack(plugin, icon, possibleIcon);
            return icon;
        }
        return null;
    });
    for (const rule of plugin.getSettings().rules) {
        if (!emoji.isEmoji(rule.icon)) {
            allIcons.set(rule.icon, true);
            const icon = yield getMissingIcon(rule.icon);
            if (icon) {
                missingIcons.add(icon);
            }
        }
    }
    for (const [_, value] of data) {
        // Check for missing icon names.
        let iconNameWithPrefix = value;
        if (typeof value === 'object') {
            iconNameWithPrefix = value.iconName;
        }
        if (iconNameWithPrefix && !emoji.isEmoji(iconNameWithPrefix)) {
            allIcons.set(iconNameWithPrefix, true);
            const icon = yield getMissingIcon(iconNameWithPrefix);
            if (icon) {
                missingIcons.add(icon);
            }
        }
    }
    // Show notice that background check is running.
    if (missingIcons.size !== 0) {
        new obsidian.Notice(`[${config.PLUGIN_NAME}] Background Check: found missing icons. Adding missing icons...`, 10000);
    }
    // Iterates over all the missing icons with its path and adds the icon to the node.
    for (const icon of missingIcons) {
        const normalizedName = getNormalizedName(icon.prefix + icon.name);
        const nodesWithIcon = document.querySelectorAll(`[${config.ICON_ATTRIBUTE_NAME}="${normalizedName}"]`);
        nodesWithIcon.forEach((node) => {
            dom.setIconForNode(plugin, normalizedName, node);
        });
    }
    // Show notice that background check was finished.
    if (missingIcons.size !== 0) {
        new obsidian.Notice(`[${config.PLUGIN_NAME}] Background Check: added missing icons`, 10000);
    }
    // Remove all icon files that can not be found in the data.
    for (const iconPack of getAllIconPacks()) {
        // Checks if the icon pack exists.
        const doesIconPackExist = yield plugin.app.vault.adapter.exists(`${getPath()}/${iconPack.name}`);
        if (!doesIconPackExist) {
            continue;
        }
        const iconFiles = yield plugin.app.vault.adapter.list(`${getPath()}/${iconPack.name}`);
        for (const iconFilePath of iconFiles.files) {
            const iconNameWithExtension = iconFilePath.split('/').pop();
            // Removes the file extension.
            const iconName = iconNameWithExtension === null || iconNameWithExtension === void 0 ? void 0 : iconNameWithExtension.substring(0, iconNameWithExtension.length - 4);
            const iconNameWithPrefix = iconPack.prefix + iconName;
            const doesIconExist = allIcons.get(iconNameWithPrefix);
            if (!doesIconExist) {
                const path = `${getPath()}/${iconPack.name}/${iconName}.svg`;
                const doesPathExist = yield plugin.app.vault.adapter.exists(path);
                if (doesPathExist) {
                    logger.info(`Removing icon with path '${path}' because it is not used anymore`);
                    // Removes the icon file.
                    yield plugin.app.vault.adapter.remove(`${getPath()}/${iconPack.name}/${iconName}.svg`);
                }
            }
        }
    }
});
/**
 * This function adds all the possible icons to the corresponding nodes. It
 * adds the icons, that are defined in the data as a basic string to the nodes
 * and the custom rule icons.
 * @param plugin Instance of IconizePlugin.
 * @param data Data that will be used to add all the icons to the nodes.
 * @param registeredFileExplorers A WeakSet of file explorers that are being used as a
 * cache for already handled file explorers.
 * @param callback Callback is being called whenever the icons are added to one file
 * explorer.
 */
const addAll = (plugin, data, registeredFileExplorers, callback) => {
    const fileExplorers = plugin.app.workspace.getLeavesOfType('file-explorer');
    for (const fileExplorer of fileExplorers) {
        if (registeredFileExplorers.has(fileExplorer.view)) {
            continue;
        }
        registeredFileExplorers.add(fileExplorer.view);
        // Adds icons to already open file tabs.
        if (plugin.getSettings().iconInTabsEnabled) {
            for (const leaf of plugin.app.workspace.getLeavesOfType('markdown')) {
                const file = leaf.view.file;
                if (file) {
                    const tabHeaderLeaf = leaf;
                    const iconColor = plugin.getIconColor(file.path);
                    iconTabs.add(plugin, file, tabHeaderLeaf.tabHeaderInnerIconEl, {
                        iconColor,
                    });
                }
            }
        }
        for (const [dataPath, value] of data) {
            const fileItem = fileExplorer.view.fileItems[dataPath];
            if (fileItem) {
                const titleEl = getFileItemTitleEl(fileItem);
                const titleInnerEl = getFileItemInnerTitleEl(fileItem);
                // Need to check this because refreshing the plugin will duplicate all the icons.
                if (titleEl.children.length === 2 || titleEl.children.length === 1) {
                    const iconName = typeof value === 'string' ? value : value.iconName;
                    const iconColor = typeof value === 'string' ? undefined : value.iconColor;
                    if (iconName) {
                        // Removes a possible existing icon.
                        const existingIcon = titleEl.querySelector('.iconize-icon');
                        if (existingIcon) {
                            existingIcon.remove();
                        }
                        // Creates the new node with the icon inside.
                        const iconNode = titleEl.createDiv();
                        iconNode.setAttribute(config.ICON_ATTRIBUTE_NAME, iconName);
                        iconNode.classList.add('iconize-icon');
                        IconCache.getInstance().set(dataPath, {
                            iconNameWithPrefix: iconName,
                        });
                        dom.setIconForNode(plugin, iconName, iconNode, iconColor);
                        titleEl.insertBefore(iconNode, titleInnerEl);
                    }
                }
            }
        }
        // Callback function to register other events to this file explorer.
        callback === null || callback === void 0 ? void 0 : callback();
    }
    // Handles the custom rules.
    for (const rule of customRule.getSortedRules(plugin)) {
        customRule.addToAllFiles(plugin, rule);
    }
};
/**
 * Gets the icon of a given path. This function returns the first occurrence of an icon.
 * @param plugin Instance of the IconizePlugin.
 * @param path Path to get the icon of.
 * @returns The icon of the path if it exists, undefined otherwise.
 */
const getByPath = (plugin, path) => {
    if (path === 'settings' || path === 'migrated') {
        return undefined;
    }
    const value = plugin.getData()[path];
    if (typeof value === 'string') {
        // If the value is a plain icon name, return it.
        return value;
    }
    else if (typeof value === 'object') {
        const v = value;
        if (v.iconName !== null) {
            return v.iconName;
        }
    }
    // Tries to get the custom rule for the path and returns its icon if it exists.
    const rule = customRule.getSortedRules(plugin).find((rule) => {
        return customRule.doesMatchPath(rule, path);
    });
    if (rule) {
        return rule.icon;
    }
    return undefined;
};
/**
 * Gets all the icons with their paths as an object.
 * @param plugin Instance of the IconizePlugin.
 * @returns An object that consists of the path and the icon name for the data
 * or custom rule.
 */
const getAllWithPath = (plugin) => {
    const result = [];
    Object.keys(plugin.getData()).forEach((path) => {
        if (path === 'settings' || path === 'migrated') {
            return;
        }
        const icon = getByPath(plugin, path);
        if (icon && !emoji.isEmoji(icon)) {
            result.push({ path, icon });
        }
    });
    // Add all icons for the custom rules with the rule as the path.
    for (const rule of plugin.getSettings().rules) {
        if (!emoji.isEmoji(rule.icon)) {
            result.push({ path: rule.rule, icon: rule.icon });
        }
    }
    return result;
};
/**
 * Returns the {@link Icon} for the given icon name. It is important, that the icon name
 * contains the icon pack prefix.
 * @param iconNameWithPrefix String that contains the icon pack prefix combined with the
 * icon name.
 * @returns Icon if it exists, `null` otherwise.
 */
const getIconByName = (iconNameWithPrefix) => {
    const iconNextIdentifier = nextIdentifier(iconNameWithPrefix);
    const iconName = iconNameWithPrefix.substring(iconNextIdentifier);
    const iconPrefix = iconNameWithPrefix.substring(0, iconNextIdentifier);
    const iconPackName = getIconPackNameByPrefix(iconPrefix);
    const icon = getIconFromIconPack(iconPackName, iconPrefix, iconName);
    if (!icon) {
        return null;
    }
    return icon;
};
/**
 * Returns the {@link Icon} for the given path.
 * @param plugin IconizePlugin instance.
 * @param path String which is the path to get the icon of.
 * @returns Icon or Emoji as string if it exists, `null` otherwise.
 */
const getIconByPath = (plugin, path) => {
    const iconNameWithPrefix = getByPath(plugin, path);
    if (!iconNameWithPrefix) {
        return null;
    }
    if (emoji.isEmoji(iconNameWithPrefix)) {
        return iconNameWithPrefix;
    }
    return getIconByName(iconNameWithPrefix);
};
var icon = {
    addAll,
    getByPath,
    getAllWithPath,
    getIconByPath,
    getIconByName,
    checkMissingIcons,
};

class ToggleIconInTitle extends IconFolderSetting {
    updateLeaves(options) {
        this.plugin.app.workspace.getLeavesOfType('markdown').forEach((leaf) => {
            const view = leaf.view;
            if (view instanceof obsidian.MarkdownView) {
                const foundIcon = icon.getIconByPath(this.plugin, view.file.path);
                if (foundIcon && options.enabled) {
                    if (options.removeBeforeReAdd) {
                        // Remove the icon before re-adding it. This is needed to update the DOM because
                        // the icon node will be inserted in the beginning inline title node.
                        titleIcon.remove(view.contentEl);
                    }
                    const content = typeof foundIcon === 'string' ? foundIcon : foundIcon.svgElement;
                    titleIcon.add(this.plugin, view.inlineTitleEl, content, {
                        fontSize: calculateInlineTitleSize(),
                    });
                }
                else {
                    titleIcon.remove(view.contentEl);
                }
            }
        });
    }
    display() {
        new obsidian.Setting(this.containerEl)
            .setName('Toggle icon in title')
            .setDesc('Toggles the visibility of an icon above the title of a file.')
            .addDropdown((dropdown) => {
            this.dropdown = dropdown;
            dropdown.setDisabled(!this.plugin.getSettings().iconInTitleEnabled);
            dropdown.addOptions({
                above: 'Above title',
                inline: 'Next to title',
            });
            dropdown.setValue(this.plugin.getSettings().iconInTitlePosition);
            dropdown.onChange((value) => __awaiter(this, void 0, void 0, function* () {
                this.plugin.getSettings().iconInTitlePosition =
                    value;
                yield this.plugin.saveIconFolderData();
                this.updateLeaves({ enabled: true, removeBeforeReAdd: true });
            }));
        })
            .addToggle((toggle) => {
            toggle
                .setValue(this.plugin.getSettings().iconInTitleEnabled)
                .onChange((enabled) => __awaiter(this, void 0, void 0, function* () {
                if (this.dropdown) {
                    this.dropdown.setDisabled(!enabled);
                }
                this.plugin.getSettings().iconInTitleEnabled = enabled;
                yield this.plugin.saveIconFolderData();
                this.updateLeaves({ enabled });
            }));
        });
    }
}

class FrontmatterOptions extends IconFolderSetting {
    display() {
        new obsidian.Setting(this.containerEl)
            .setName('Use icon in frontmatter')
            .setDesc('Toggles whether to set the icon based on the frontmatter property `icon`.')
            .addToggle((toggle) => {
            toggle
                .setValue(this.plugin.getSettings().iconInFrontmatterEnabled)
                .onChange((enabled) => __awaiter(this, void 0, void 0, function* () {
                this.plugin.getSettings().iconInFrontmatterEnabled = enabled;
                yield this.plugin.saveIconFolderData();
            }));
        });
        new obsidian.Setting(this.containerEl)
            .setName('Frontmatter icon field name')
            .setDesc('Sets the name of the frontmatter field which contains the icon.')
            .addText((text) => {
            this.iconFieldNameTextComp = text;
            text.setValue(this.plugin.getSettings().iconInFrontmatterFieldName);
        })
            .addButton((button) => {
            button.setButtonText('Save');
            button.onClick(() => __awaiter(this, void 0, void 0, function* () {
                const newValue = this.iconFieldNameTextComp.getValue();
                const oldValue = this.plugin.getSettings().iconInFrontmatterFieldName;
                if (newValue === oldValue) {
                    return;
                }
                this.plugin.getSettings().iconInFrontmatterFieldName = newValue;
                yield this.plugin.saveIconFolderData();
                new obsidian.Notice('...saved successfully');
            }));
        });
        new obsidian.Setting(this.containerEl)
            .setName('Frontmatter icon color field name')
            .setDesc('Sets the name of the frontmatter field which contains the icon color.')
            .addText((text) => {
            this.iconColorFieldNameTextComp = text;
            text.setValue(this.plugin.getSettings().iconColorInFrontmatterFieldName);
        })
            .addButton((button) => {
            button.setButtonText('Save');
            button.onClick(() => __awaiter(this, void 0, void 0, function* () {
                const newValue = this.iconColorFieldNameTextComp.getValue();
                const oldValue = this.plugin.getSettings().iconColorInFrontmatterFieldName;
                if (newValue === oldValue) {
                    return;
                }
                this.plugin.getSettings().iconColorInFrontmatterFieldName = newValue;
                yield this.plugin.saveIconFolderData();
                new obsidian.Notice('...saved successfully');
            }));
        });
        new obsidian.Setting(this.containerEl)
            .setName('Refresh icons from frontmatter')
            .setDesc('Sets the icon and color for each note in the vault based on the frontmatter properties. WARNING: This will change any manually set icons to the one defined in the frontmatter. IF A NOTE HAS NO FRONTMATTER, THE CURRENT ICON WILL BE REMOVED. Please restart Obsidian after this completes to see the changes.')
            .addButton((btn) => {
            btn.setButtonText('Refresh').onClick(() => __awaiter(this, void 0, void 0, function* () {
                var _a, _b;
                if (!this.plugin.getSettings().iconInFrontmatterEnabled) {
                    new obsidian.Notice(`[${config.PLUGIN_NAME}] Please enable "Use icon in frontmatter".`);
                    return;
                }
                new obsidian.Notice(`[${config.PLUGIN_NAME}] Refreshing icons from frontmatter, please wait...`);
                const files = this.plugin.app.vault.getMarkdownFiles();
                for (const file of files) {
                    const fileCache = this.plugin.app.metadataCache.getFileCache(file);
                    const frontmatterIconKey = this.plugin.getSettings().iconInFrontmatterFieldName;
                    const frontmatterIconColorKey = this.plugin.getSettings().iconColorInFrontmatterFieldName;
                    const iconName = (_a = fileCache.frontmatter) === null || _a === void 0 ? void 0 : _a[frontmatterIconKey];
                    let iconColor = (_b = fileCache.frontmatter) === null || _b === void 0 ? void 0 : _b[frontmatterIconColorKey];
                    if (!iconName) {
                        yield this.plugin.removeFolderIcon(file.path);
                        continue;
                    }
                    if (typeof iconName !== 'string') {
                        const message = `${file.path}\nFrontmatter property type \`${frontmatterIconKey}\` has to be of type \`text\`.`;
                        logger.warn(message);
                        new obsidian.Notice(`[${config.PLUGIN_NAME}]\n${message}`);
                        continue;
                    }
                    this.plugin.addFolderIcon(file.path, iconName);
                    if (!iconColor) {
                        yield this.plugin.removeIconColor(file.path);
                        continue;
                    }
                    if (typeof iconColor !== 'string') {
                        const message = `${file.path}\nFrontmatter property type \`${frontmatterIconColorKey}\` has to be of type \`text\`.`;
                        logger.warn(message);
                        new obsidian.Notice(`[${config.PLUGIN_NAME}]\n${message}`);
                        continue;
                    }
                    iconColor = isHexadecimal(iconColor)
                        ? stringToHex(iconColor)
                        : iconColor;
                    this.plugin.addIconColor(file.path, iconColor);
                }
                new obsidian.Notice(`[${config.PLUGIN_NAME}] Refreshed icons from frontmatter. Please restart Obsidian to see the changes.`);
            }));
        });
    }
}

class ToggleIconsInEditor extends IconFolderSetting {
    display() {
        new obsidian.Setting(this.containerEl)
            .setName('Toggle icons while editing notes')
            .setDesc('Toggles whether you are able to add and see icons in your notes and editor (e.g., ability to have :LiSofa: as an icon in your notes).')
            .addToggle((toggle) => {
            toggle
                .setValue(this.plugin.getSettings().iconsInNotesEnabled)
                .onChange((enabled) => __awaiter(this, void 0, void 0, function* () {
                this.plugin.getSettings().iconsInNotesEnabled = enabled;
                yield this.plugin.saveIconFolderData();
                new obsidian.Notice(`[${config.PLUGIN_NAME}] Obsidian has to be restarted for this change to take effect.`);
            }));
        });
    }
}

class ToggleIconsInLinks extends IconFolderSetting {
    display() {
        new obsidian.Setting(this.containerEl)
            .setName('Toggle icons in links')
            .setDesc('Toggles whether you are able to see icons in the links to other notes')
            .addToggle((toggle) => {
            toggle
                .setValue(this.plugin.getSettings().iconsInLinksEnabled)
                .onChange((enabled) => __awaiter(this, void 0, void 0, function* () {
                this.plugin.getSettings().iconsInLinksEnabled = enabled;
                yield this.plugin.saveIconFolderData();
                new obsidian.Notice(`[${config.PLUGIN_NAME}] Obsidian has to be restarted for this change to take effect.`);
            }));
        });
    }
}

class IconIdentifierSetting extends IconFolderSetting {
    display() {
        const setting = new obsidian.Setting(this.containerEl)
            .setName('Icon identifier')
            .setDesc('Change the icon identifier used in notes.')
            .setClass('iconize-setting');
        setting.addText((text) => {
            this.textComp = text;
            text.setValue(this.plugin.getSettings().iconIdentifier);
        });
        setting.addButton((btn) => {
            btn.setButtonText('Save');
            btn.onClick(() => __awaiter(this, void 0, void 0, function* () {
                const newIdentifier = this.textComp.getValue();
                const oldIdentifier = this.plugin.getSettings().iconIdentifier;
                if (newIdentifier === oldIdentifier) {
                    return;
                }
                this.plugin.getSettings().iconIdentifier = newIdentifier;
                yield this.plugin.saveIconFolderData();
                new obsidian.Notice('...saved successfully');
            }));
        });
    }
}

class DebugMode extends IconFolderSetting {
    display() {
        new obsidian.Setting(this.containerEl)
            .setName('Toggle Debug Mode')
            .setDesc('Toggle debug mode to see more detailed logs in the console. Do not touch this unless you know what you are doing.')
            .addToggle((toggle) => {
            toggle
                .setValue(this.plugin.getSettings().debugMode)
                .onChange((enabled) => __awaiter(this, void 0, void 0, function* () {
                this.plugin.getSettings().debugMode = enabled;
                yield this.plugin.saveIconFolderData();
            }));
        });
    }
}

class IconFolderSettings extends obsidian.PluginSettingTab {
    constructor(app, plugin) {
        super(app, plugin);
        this.plugin = plugin;
    }
    display() {
        const { plugin, containerEl, app } = this;
        containerEl.empty();
        containerEl.createEl('h1', { text: 'General' });
        new RecentlyUsedIconsSetting(plugin, containerEl).display();
        new IconPacksPathSetting(plugin, containerEl).display();
        new IconPacksBackgroundChecker(plugin, containerEl).display();
        new EmojiStyleSetting(plugin, containerEl).display();
        new IconIdentifierSetting(plugin, containerEl).display();
        new DebugMode(plugin, containerEl).display();
        containerEl.createEl('h3', { text: 'Visibility of icons' });
        new ToggleIconInTabs(plugin, containerEl).display();
        new ToggleIconInTitle(plugin, containerEl).display();
        new FrontmatterOptions(plugin, containerEl).display();
        new ToggleIconsInEditor(plugin, containerEl).display();
        new ToggleIconsInLinks(plugin, containerEl).display();
        containerEl.createEl('h1', {
            text: 'Icon customization for files/folders',
        });
        new IconFontSizeSetting(plugin, containerEl).display();
        new IconColorSetting(plugin, containerEl).display();
        new ExtraMarginSetting(plugin, containerEl).display();
        containerEl.createEl('h1', { text: 'Custom icon rules' });
        new CustomIconRuleSetting(plugin, containerEl, app, () => this.display()).display();
        containerEl.createEl('h1', { text: 'Icon packs' });
        new PredefinedIconPacksSetting(plugin, containerEl, app, () => this.display()).display();
        new CustomIconPackSetting(plugin, containerEl, () => this.display()).display();
    }
}

function around(obj, factories) {
    const removers = Object.keys(factories).map(key => around1(obj, key, factories[key]));
    return removers.length === 1 ? removers[0] : function () { removers.forEach(r => r()); };
}
function around1(obj, method, createWrapper) {
    const original = obj[method], hadOwn = obj.hasOwnProperty(method);
    let current = createWrapper(original);
    // Let our wrapper inherit static props from the wrapping method,
    // and the wrapping method, props from the original method
    if (original)
        Object.setPrototypeOf(current, original);
    Object.setPrototypeOf(wrapper, current);
    obj[method] = wrapper;
    // Return a callback to allow safe removal
    return remove;
    function wrapper(...args) {
        // If we have been deactivated and are no longer wrapped, remove ourselves
        if (current === original && obj[method] === wrapper)
            remove();
        return current.apply(this, args);
    }
    function remove() {
        // If no other patches, just do a direct removal
        if (obj[method] === wrapper) {
            if (hadOwn)
                obj[method] = original;
            else
                delete obj[method];
        }
        if (current === original)
            return;
        // Else pass future calls through, and remove wrapper from the prototype chain
        current = original;
        Object.setPrototypeOf(wrapper, original || Function);
    }
}

class InternalPluginInjector {
    constructor(plugin) {
        this.plugin = plugin;
    }
    get fileExplorers() {
        return this.plugin.app.workspace.getLeavesOfType('file-explorer');
    }
    onMount() { }
}

/**
 * @deprecated After obsidian 1.2.6 in favor of the bookmarks plugin.
 */
class StarredInternalPlugin extends InternalPluginInjector {
    constructor(plugin) {
        super(plugin);
    }
    get starred() {
        return this.plugin.app.internalPlugins.getPluginById('starred');
    }
    get enabled() {
        return this.plugin.app.internalPlugins.getPluginById('starred').enabled;
    }
    get leaf() {
        const leaf = this.plugin.app.workspace.getLeavesOfType('starred');
        if (!leaf) {
            return undefined;
        }
        if (leaf.length === 1) {
            return leaf[0].view;
        }
        return undefined;
    }
    setIcon(filePath, node) {
        const iconName = icon.getByPath(this.plugin, filePath);
        const iconNode = node.querySelector('.nav-file-icon');
        if (!iconNode || !iconName) {
            return;
        }
        dom.setIconForNode(this.plugin, iconName, iconNode);
    }
    computeNodesWithPath(callback) {
        const { itemLookup, containerEl } = this.leaf;
        const navFileEls = containerEl.querySelectorAll('.nav-file');
        navFileEls.forEach((navFileEl) => {
            const lookupFile = itemLookup.get(navFileEl);
            if (!lookupFile) {
                return;
            }
            callback(navFileEl, lookupFile.path);
        });
    }
    onMount() {
        const nodesWithPath = {};
        this.computeNodesWithPath((node, filePath) => {
            nodesWithPath[filePath] = node;
        });
        Object.entries(nodesWithPath).forEach(([filePath, node]) => this.setIcon(filePath, node));
    }
    register() {
        if (!this.plugin.app.internalPlugins.getPluginById('file-explorer').enabled) {
            console.info(`[${config.PLUGIN_NAME}/Starred] Skipping starred internal plugin registration because file-explorer is not enabled.`);
            return;
        }
        if (!this.enabled) {
            console.info(`[${config.PLUGIN_NAME}/Starred] Skipping starred internal plugin registration because it's not enabled.`);
            return;
        }
        // eslint-disable-next-line
        const self = this;
        this.plugin.register(around(this.starred.instance, {
            addItem: function (next) {
                return function (file) {
                    next.call(this, file);
                    self.onMount();
                };
            },
            removeItem: function (next) {
                return function (file) {
                    next.call(this, file);
                    self.onMount();
                };
            },
        }));
    }
}

class BookmarkInternalPlugin extends InternalPluginInjector {
    constructor(plugin) {
        super(plugin);
    }
    get bookmark() {
        return this.plugin.app.internalPlugins.getPluginById('bookmarks');
    }
    get enabled() {
        return this.plugin.app.internalPlugins.getPluginById('bookmarks').enabled;
    }
    get leaf() {
        const leaf = this.plugin.app.workspace.getLeavesOfType('bookmarks');
        if (!leaf) {
            return undefined;
        }
        if (leaf.length === 1) {
            return leaf[0].view;
        }
        return undefined;
    }
    setIconOrRemove(filePath, node) {
        var _a;
        const iconName = icon.getByPath(this.plugin, filePath);
        let iconNode = node.querySelector('.tree-item-icon');
        if (!iconName) {
            if (iconNode) {
                // Reset the icon to the default obsidian icon.
                const items = this.bookmark.instance.items;
                const item = items.find((item) => item.path === filePath);
                if ((item === null || item === void 0 ? void 0 : item.type) === 'file') {
                    iconNode.innerHTML = DEFAULT_FILE_ICON;
                }
                else if ((item === null || item === void 0 ? void 0 : item.type) === 'folder') {
                    iconNode.innerHTML = DEFAULT_FOLDER_ICON;
                }
            }
            return;
        }
        // If the icon node is not defined, then we need to recreate it.
        if (!iconNode) {
            // Get the tree-item-self element where the original icon is set.
            const treeItemSelf = node.querySelector('.tree-item-self');
            if (!treeItemSelf) {
                return;
            }
            iconNode = node.createDiv({ cls: 'tree-item-icon' });
            // Prepends the icon to the tree-item-self element as a first child.
            treeItemSelf.prepend(iconNode);
        }
        const defaultMargin = iconNode.style.margin;
        const iconColor = (_a = this.plugin.getIconColor(filePath)) !== null && _a !== void 0 ? _a : this.plugin.getSettings().iconColor;
        dom.setIconForNode(this.plugin, iconName, iconNode, iconColor);
        // Reset the margin to the default value to prevent overlapping with the text.
        iconNode.style.margin = defaultMargin;
    }
    computeNodesWithPath(callback) {
        if (!this.leaf) {
            return;
        }
        /**
         * Retrieves the lookup item from the bookmark plugin and calls the callback with the
         * element and the path of the item.
         * @param item BookmarkItem object which can be a folder or a file.
         * @param itemDoms WeakMap of the bookmark plugin which contains the lookup item.
         */
        const retrieveLookupItem = (item, itemDoms) => {
            const lookupItem = itemDoms.get(item);
            if (!lookupItem) {
                return;
            }
            if (item.items) {
                // If the item is a folder, then we need to retrieve all the items inside it.
                for (const subItem of item.items) {
                    retrieveLookupItem(subItem, itemDoms);
                }
            }
            // If the item is a `file` or a `folder` (not of type `group`), then we can call the callback.
            if (item.type === 'file' || item.type === 'folder') {
                callback(lookupItem.el, item.path);
            }
        };
        const { itemDoms } = this.leaf;
        // Retrieves all the items of the bookmark plugin which areo objects.
        const items = this.bookmark.instance.items;
        items.forEach((item) => {
            retrieveLookupItem(item, itemDoms);
        });
    }
    onMount() {
        const nodesWithPath = {};
        this.computeNodesWithPath((node, filePath) => {
            nodesWithPath[filePath] = node;
        });
        Object.entries(nodesWithPath).forEach(([filePath, node]) => this.setIconOrRemove(filePath, node));
    }
    register() {
        if (!this.plugin.app.internalPlugins.getPluginById('file-explorer').enabled) {
            console.info(`[${config.PLUGIN_NAME}/Bookmarks] Skipping bookmark internal plugin registration because file-explorer is not enabled.`);
            return;
        }
        if (!this.enabled) {
            console.info(`[${config.PLUGIN_NAME}/Bookmarks] Skipping bookmark internal plugin registration because it's not enabled.`);
            return;
        }
        // eslint-disable-next-line
        const self = this;
        this.plugin.register(around(this.bookmark.instance, {
            addItem: function (next) {
                return function (...args) {
                    next.call(this, ...args);
                    // TODO: Remove in the future, I could not think of a better way to do this.
                    setTimeout(() => {
                        self.onMount();
                    }, 1000);
                };
            },
            removeItem: function (next) {
                return function (...args) {
                    next.call(this, ...args);
                    self.onMount();
                };
            },
        }));
    }
}

// TODO: Optimize the code to reduce the number of iterations and improve the
const createIconShortcodeRegex = (plugin) => {
    return new RegExp(`(${plugin.getSettings().iconIdentifier})((\\w{1,64}:\\d{17,18})|(\\w{1,64}))(${plugin.getSettings().iconIdentifier})`, 'g');
};
const createTreeWalker = (plugin, root) => {
    return document.createTreeWalker(root, NodeFilter.SHOW_ALL, {
        acceptNode: function (node) {
            if (node.nodeName === 'CODE') {
                return NodeFilter.FILTER_REJECT;
            }
            else if (node.nodeName === '#text') {
                if (node.nodeValue &&
                    (emoji.getRegex().test(node.nodeValue) ||
                        createIconShortcodeRegex(plugin).test(node.nodeValue))) {
                    return NodeFilter.FILTER_ACCEPT;
                }
                else {
                    return NodeFilter.FILTER_REJECT;
                }
            }
            return NodeFilter.FILTER_SKIP;
        },
    });
};
const checkForTextNodes = (treeWalker, match, cb) => {
    let currentNode = treeWalker.currentNode;
    while (currentNode) {
        if (currentNode.nodeType === Node.TEXT_NODE) {
            const text = currentNode;
            const textNodes = [...Array.from(text.parentElement.childNodes)].filter((n) => n instanceof Text);
            for (const text of textNodes) {
                for (const code of [...text.wholeText.matchAll(match)]
                    .sort((a, b) => b.index - a.index)
                    .map((arr) => ({ text: arr[0], index: arr.index }))) {
                    if (!text.textContent) {
                        continue;
                    }
                    cb(text, code);
                }
            }
        }
        currentNode = treeWalker.nextNode();
    }
};
const processIconInTextMarkdown = (plugin, element) => {
    // Ignore if codeblock
    const codeElement = element.querySelector('pre > code');
    if (codeElement) {
        return;
    }
    const iconTreeWalker = createTreeWalker(plugin, element);
    const iconShortcodeRegex = createIconShortcodeRegex(plugin);
    const iconIdentifierLength = plugin.getSettings().iconIdentifier.length;
    checkForTextNodes(iconTreeWalker, iconShortcodeRegex, (text, code) => {
        var _a, _b, _c, _d;
        const shortcode = code.text;
        const iconName = shortcode.slice(iconIdentifierLength, shortcode.length - iconIdentifierLength);
        const iconObject = icon.getIconByName(iconName);
        if (iconObject) {
            const toReplace = text.splitText(code.index);
            const rootSpan = createSpan({
                cls: 'cm-iconize-icon',
                attr: {
                    'aria-label': iconName,
                    'data-icon': iconName,
                    'aria-hidden': 'true',
                },
            });
            rootSpan.style.display = 'inline-flex';
            rootSpan.style.transform = 'translateY(13%)';
            const tagName = (_c = (_b = (_a = toReplace.parentElement) === null || _a === void 0 ? void 0 : _a.tagName) === null || _b === void 0 ? void 0 : _b.toLowerCase()) !== null && _c !== void 0 ? _c : '';
            let fontSize = calculateFontTextSize();
            if (isHeader(tagName)) {
                fontSize = calculateHeaderSize(tagName);
                const svgElement = svg.setFontSize(iconObject.svgElement, fontSize);
                rootSpan.innerHTML = svgElement;
            }
            else {
                const svgElement = svg.setFontSize(iconObject.svgElement, fontSize);
                rootSpan.innerHTML = svgElement;
            }
            (_d = toReplace.parentElement) === null || _d === void 0 ? void 0 : _d.insertBefore(rootSpan, toReplace);
            toReplace.textContent = toReplace.wholeText.substring(code.text.length);
        }
    });
    const emojiTreeWalker = createTreeWalker(plugin, element);
    checkForTextNodes(emojiTreeWalker, emoji.getRegex(), (text, code) => {
        var _a, _b, _c, _d;
        if (!emoji.isEmoji(code.text)) {
            return;
        }
        if (plugin.getSettings().emojiStyle === 'twemoji') {
            const toReplace = text.splitText(code.index);
            const tagName = (_c = (_b = (_a = toReplace.parentElement) === null || _a === void 0 ? void 0 : _a.tagName) === null || _b === void 0 ? void 0 : _b.toLowerCase()) !== null && _c !== void 0 ? _c : '';
            let fontSize = calculateFontTextSize();
            if (isHeader(tagName)) {
                fontSize = calculateHeaderSize(tagName);
            }
            const emojiValue = emoji.parseEmoji(plugin.getSettings().emojiStyle, code.text, fontSize);
            if (!emojiValue) {
                return;
            }
            const emojiNode = createSpan();
            emojiNode.innerHTML = emojiValue;
            (_d = toReplace.parentElement) === null || _d === void 0 ? void 0 : _d.insertBefore(emojiNode, toReplace);
            toReplace.textContent = toReplace.wholeText.substring(code.text.length);
        }
    });
};

const processIconInLinkMarkdown = (plugin, element, ctx) => {
    const linkElements = element.querySelectorAll('a');
    if (!linkElements || linkElements.length === 0) {
        return;
    }
    linkElements.forEach((linkElement) => {
        var _a, _b, _c, _d, _e;
        // Skip if the link element e.g., is a tag.
        if (!linkElement.hasAttribute('data-href')) {
            return;
        }
        const linkHref = linkElement.getAttribute('href');
        if (!linkHref) {
            logger.warn('Link element does not have an `href` attribute');
            return;
        }
        const file = plugin.app.metadataCache.getFirstLinkpathDest(linkHref, ctx.sourcePath);
        if (!file) {
            logger.warn('Link element does not have a linkpath to a file');
            return;
        }
        const path = file.path;
        const iconValue = icon.getIconByPath(plugin, path);
        if (!iconValue) {
            return;
        }
        let fontSize = calculateFontTextSize();
        const tagName = (_c = (_b = (_a = linkElement.parentElement) === null || _a === void 0 ? void 0 : _a.tagName) === null || _b === void 0 ? void 0 : _b.toLowerCase()) !== null && _c !== void 0 ? _c : '';
        if (isHeader(tagName)) {
            fontSize = calculateHeaderSize(tagName);
        }
        const iconName = typeof iconValue === 'string'
            ? iconValue
            : iconValue.prefix + iconValue.name;
        const rootSpan = createSpan({
            cls: 'iconize-icon-in-link',
            attr: {
                title: iconName,
                'aria-label': iconName,
                'data-icon': iconName,
                'aria-hidden': 'true',
            },
        });
        rootSpan.style.color =
            (_d = plugin.getIconColor(path)) !== null && _d !== void 0 ? _d : plugin.getSettings().iconColor;
        if (emoji.isEmoji(iconName)) {
            const parsedEmoji = (_e = emoji.parseEmoji(plugin.getSettings().emojiStyle, iconName, fontSize)) !== null && _e !== void 0 ? _e : iconName;
            rootSpan.style.transform = 'translateY(0)';
            rootSpan.innerHTML = parsedEmoji;
        }
        else {
            let svgEl = icon.getIconByName(iconName).svgElement;
            svgEl = svg.setFontSize(svgEl, fontSize);
            if (svgEl) {
                rootSpan.style.transform = 'translateY(20%)';
                rootSpan.innerHTML = svgEl;
            }
        }
        linkElement.prepend(rootSpan);
    });
};

const TREE_ITEM_CLASS = 'tree-item-self';
const TREE_ITEM_INNER = 'tree-item-inner';
class OutlineInternalPlugin extends InternalPluginInjector {
    constructor(plugin) {
        super(plugin);
    }
    register() {
        if (!this.enabled) {
            logger.info('Skipping internal plugin registration because it is not enabled.', LoggerPrefix.Outline);
            return;
        }
        const updateTreeItems = () => {
            var _a;
            const treeItems = Array.from(this.leaf.tree.containerEl.querySelectorAll(`.${TREE_ITEM_CLASS}`));
            for (const treeItem of treeItems) {
                const treeItemInner = treeItem.querySelector(`.${TREE_ITEM_INNER}`);
                let text = treeItemInner === null || treeItemInner === void 0 ? void 0 : treeItemInner.getText();
                if (!text) {
                    continue;
                }
                const iconShortcodeRegex = createIconShortcodeRegex(this.plugin);
                const iconIdentifierLength = this.plugin.getSettings().iconIdentifier.length;
                let trimmedLength = 0;
                for (const code of [...text.matchAll(iconShortcodeRegex)]
                    .sort((a, b) => a.index - b.index)
                    .map((arr) => ({ text: arr[0], index: arr.index }))) {
                    const shortcode = code.text;
                    const iconName = shortcode.slice(iconIdentifierLength, shortcode.length - iconIdentifierLength);
                    const iconObject = icon.getIconByName(iconName);
                    if (iconObject) {
                        const startIndex = code.index - trimmedLength;
                        const endIndex = code.index + code.text.length - trimmedLength;
                        const str = text.substring(0, startIndex) + text.substring(endIndex);
                        const iconSpan = createSpan({
                            cls: 'cm-iconize-icon',
                            attr: {
                                'aria-label': iconName,
                                'data-icon': iconName,
                                'aria-hidden': 'true',
                            },
                        });
                        const fontSize = parseFloat((_a = getComputedStyle(document.body).getPropertyValue('--nav-item-size')) !== null && _a !== void 0 ? _a : '16');
                        const svgElement = svg.setFontSize(iconObject.svgElement, fontSize);
                        iconSpan.style.display = 'inline-flex';
                        iconSpan.style.transform = 'translateY(13%)';
                        iconSpan.innerHTML = svgElement;
                        treeItemInner.innerHTML = treeItemInner.innerHTML.replace(shortcode, iconSpan.outerHTML);
                        text = str;
                        trimmedLength += code.text.length;
                    }
                }
            }
        };
        this.plugin.getEventEmitter().once('allIconsLoaded', () => {
            updateTreeItems();
            const callback = (mutations) => {
                mutations.forEach((mutation) => {
                    if (mutation.type !== 'childList') {
                        return;
                    }
                    const addedNodes = mutation.addedNodes;
                    if (addedNodes.length === 0) {
                        return;
                    }
                    updateTreeItems();
                });
                if (!this.enabled) {
                    observer.disconnect();
                }
            };
            const observer = new MutationObserver(callback);
            observer.observe(this.leaf.tree.containerEl, {
                childList: true,
                subtree: true,
            });
        });
    }
    get leaf() {
        const leaf = this.plugin.app.workspace.getLeavesOfType('outline');
        if (!leaf) {
            logger.log('`leaf` in outline is undefined', LoggerPrefix.Outline);
            return undefined;
        }
        if (leaf.length === 0) {
            logger.log('`leaf` length in outline is 0', LoggerPrefix.Outline);
            return undefined;
        }
        return leaf[0].view;
    }
    get outline() {
        return this.plugin.app.internalPlugins.getPluginById('outline');
    }
    get enabled() {
        return this.plugin.app.internalPlugins.getPluginById('outline').enabled;
    }
}

class SuggestionIcon extends obsidian.EditorSuggest {
    constructor(app, plugin) {
        super(app);
        this.plugin = plugin;
    }
    onTrigger(cursor, editor) {
        // Isolate shortcode starting position closest to the cursor.
        const shortcodeStart = editor
            .getLine(cursor.line)
            .substring(0, cursor.ch)
            .lastIndexOf(this.plugin.getSettings().iconIdentifier);
        // `onTrigger` needs to return `null` as soon as possible to save processing performance.
        if (shortcodeStart === -1) {
            return null;
        }
        // Regex for checking if the shortcode is not done yet.
        const regex = new RegExp(`^(${this.plugin.getSettings().iconIdentifier})\\w+$`, 'g');
        const regexOngoingShortcode = editor
            .getLine(cursor.line)
            .substring(shortcodeStart, cursor.ch)
            .match(regex);
        if (regexOngoingShortcode === null) {
            return null;
        }
        const startingIndex = editor
            .getLine(cursor.line)
            .indexOf(regexOngoingShortcode[0]);
        return {
            start: {
                line: cursor.line,
                ch: startingIndex,
            },
            end: {
                line: cursor.line,
                ch: startingIndex + regexOngoingShortcode[0].length,
            },
            query: regexOngoingShortcode[0],
        };
    }
    getSuggestions(context) {
        const queryLowerCase = context.query
            .substring(this.plugin.getSettings().iconIdentifier.length)
            .toLowerCase();
        // Store all icons corresponding to the current query.
        const iconsNameArray = getAllLoadedIconNames()
            .filter((iconObject) => {
            const name = iconObject.prefix.toLowerCase() + iconObject.name.toLowerCase();
            return name.toLowerCase().includes(queryLowerCase);
        })
            .map((iconObject) => iconObject.prefix + iconObject.name);
        // Store all emojis correspoding to the current query - parsing whitespaces and
        // colons for shortcodes compatibility.
        const emojisNameArray = Object.keys(emoji.shortNames).filter((e) => { var _a; return (_a = emoji.getShortcode(e)) === null || _a === void 0 ? void 0 : _a.includes(queryLowerCase); });
        return [...iconsNameArray, ...emojisNameArray];
    }
    renderSuggestion(value, el) {
        const iconObject = icon.getIconByName(value);
        el.style.display = 'flex';
        el.style.alignItems = 'center';
        el.style.gap = '0.25rem';
        if (iconObject) {
            // Suggest an icon.
            el.innerHTML = `${iconObject.svgElement} <span>${value}</span>`;
        }
        else {
            // Suggest an emoji - display its shortcode version.
            const shortcode = emoji.getShortcode(value);
            if (shortcode) {
                el.innerHTML = `<span>${value}</span> <span>${shortcode}</span>`;
            }
        }
    }
    selectSuggestion(value) {
        const isEmoji = emoji.isEmoji(value.replace(/_/g, ' '));
        if (!isEmoji) {
            saveIconToIconPack(this.plugin, value);
        }
        // Replace query with iconNameWithPrefix or emoji unicode directly.
        const updatedValue = isEmoji
            ? value
            : `${this.plugin.getSettings().iconIdentifier}${value}${this.plugin.getSettings().iconIdentifier}`;
        this.context.editor.replaceRange(updatedValue, this.context.start, this.context.end);
    }
}

class IconInTextWidget extends view.WidgetType {
    constructor(plugin, id) {
        super();
        this.plugin = plugin;
        this.id = id;
        this.start = -1;
        this.end = -1;
    }
    setPosition(start, end) {
        this.start = start;
        this.end = end;
    }
    eq(other) {
        return other instanceof IconInTextWidget && other.id === this.id;
    }
    getSize(view) {
        let fontSize = calculateFontTextSize();
        const line = view.state.doc.lineAt(this.end);
        const headerMatch = line.text.match(/^#{1,6}\s/);
        if (headerMatch && headerMatch[0].trim()) {
            const mapping = {
                '#': 'h1',
                '##': 'h2',
                '###': 'h3',
                '####': 'h4',
                '#####': 'h5',
                '######': 'h6',
            };
            const header = mapping[headerMatch[0].trim()];
            fontSize = calculateHeaderSize(header);
        }
        return fontSize;
    }
    toDOM(view) {
        const wrap = createSpan({
            cls: 'cm-iconize-icon',
            attr: {
                'aria-label': this.id,
                'data-icon': this.id,
                'aria-hidden': 'true',
            },
        });
        const foundIcon = icon.getIconByName(this.id);
        const fontSize = this.getSize(view);
        if (foundIcon) {
            const svgElement = svg.setFontSize(foundIcon.svgElement, fontSize);
            wrap.style.display = 'inline-flex';
            wrap.style.transform = 'translateY(13%)';
            wrap.innerHTML = svgElement;
        }
        else if (emoji.isEmoji(this.id)) {
            wrap.innerHTML = emoji.parseEmoji(this.plugin.getSettings().emojiStyle, this.id, fontSize);
        }
        else {
            wrap.append(`${this.plugin.getSettings().iconIdentifier}${this.id}${this.plugin.getSettings().iconIdentifier}`);
        }
        return wrap;
    }
    ignoreEvent() {
        return false;
    }
}

class IconInLinkWidget extends view.WidgetType {
    constructor(plugin, iconData, path, headerType) {
        super();
        this.plugin = plugin;
        this.iconData = iconData;
        this.path = path;
        this.headerType = headerType;
    }
    toDOM() {
        var _a;
        const iconNode = document.createElement('span');
        const iconName = typeof this.iconData === 'string'
            ? this.iconData
            : this.iconData.prefix + this.iconData.name;
        iconNode.style.color =
            (_a = this.plugin.getIconColor(this.path)) !== null && _a !== void 0 ? _a : this.plugin.getSettings().iconColor;
        iconNode.setAttribute('title', iconName);
        iconNode.classList.add('iconize-icon-in-link');
        if (typeof this.iconData === 'string') {
            iconNode.style.transform = 'translateY(0)';
        }
        let innerHTML = typeof this.iconData === 'string'
            ? this.iconData
            : this.iconData.svgElement;
        let fontSize = calculateFontTextSize();
        if (this.headerType) {
            fontSize = calculateHeaderSize(this.headerType);
        }
        if (emoji.isEmoji(innerHTML)) {
            innerHTML = emoji.parseEmoji(this.plugin.getSettings().emojiStyle, innerHTML, fontSize);
        }
        else {
            innerHTML = svg.setFontSize(innerHTML, fontSize);
        }
        iconNode.innerHTML = innerHTML;
        return iconNode;
    }
    ignoreEvent() {
        return true;
    }
}

const buildLinkDecorations = (view$1, plugin) => {
    const builder = new state.RangeSetBuilder();
    const mdView = view$1.state.field(obsidian.editorInfoField);
    for (const { from, to } of view$1.visibleRanges) {
        language.syntaxTree(view$1.state).iterate({
            from,
            to,
            enter: (node) => {
                const tokenProps = node.type.prop(language.tokenClassNodeProp);
                if (tokenProps) {
                    const props = new Set(tokenProps.split(' '));
                    const isLink = props.has('hmd-internal-link');
                    const headerType = [
                        'header-1',
                        'header-2',
                        'header-3',
                        'header-4',
                        'header-5',
                        'header-6',
                    ].find((header) => props.has(header));
                    if (isLink) {
                        let linkText = view$1.state.doc.sliceString(node.from, node.to);
                        linkText = linkText.split('#')[0];
                        const file = plugin.app.metadataCache.getFirstLinkpathDest(linkText, mdView.file.basename);
                        if (file) {
                            const possibleIcon = icon.getIconByPath(plugin, file.path);
                            if (possibleIcon) {
                                const iconDecoration = view.Decoration.widget({
                                    widget: new IconInLinkWidget(plugin, possibleIcon, file.path, headerType),
                                });
                                builder.add(node.from, node.from, iconDecoration);
                            }
                        }
                    }
                }
            },
        });
    }
    return builder.finish();
};

const buildTextDecorations = (view$1, plugin) => {
    const ranges = [];
    const iconInfo = view$1.state.field(plugin.positionField);
    for (const { from, to } of view$1.visibleRanges) {
        iconInfo.between(from - 1, to + 1, (from, to, { iconId }) => {
            ranges.push([iconId, from, to]);
        });
    }
    return view.Decoration.set(ranges.map(([code, from, to]) => {
        const widget = new IconInTextWidget(plugin, code);
        widget.setPosition(from, to);
        if (view$1.state.field(obsidian.editorLivePreviewField)) {
            return view.Decoration.replace({
                widget,
                side: -1,
            }).range(from, to);
        }
        return view.Decoration.widget({
            widget,
            side: -1,
        }).range(to);
    }), true);
};

const buildIconInTextPlugin = (plugin) => {
    return view.ViewPlugin.fromClass(class IconPlugin {
        constructor(view) {
            this.plugin = plugin;
            this.decorations = buildTextDecorations(view, plugin);
        }
        update(update) {
            this.decorations = buildTextDecorations(update.view, this.plugin);
        }
    }, {
        decorations: (v) => v.decorations,
        provide: (plugin) => view.EditorView.atomicRanges.of((view$1) => {
            const value = view$1.plugin(plugin);
            return value ? value.decorations : view.Decoration.none;
        }),
    });
};

const buildIconInLinksPlugin = (plugin) => {
    return view.ViewPlugin.fromClass(class {
        constructor(view) {
            this.plugin = plugin;
            this.decorations = buildLinkDecorations(view, plugin);
        }
        destroy() { }
        update(update) {
            if (update.docChanged || update.viewportChanged) {
                this.decorations = buildLinkDecorations(update.view, this.plugin);
            }
        }
    }, {
        decorations: (v) => v.decorations,
    });
};

// TODO: Optimize the code to reduce the number of iterations and improve the
function checkForSourceMode(plugin) {
    let isSourceMode = false;
    // Iterate over all leaves to check if any is in source mode
    plugin.app.workspace.iterateAllLeaves((leaf) => {
        var _a;
        if (!isSourceMode && leaf.view.getViewType() === 'markdown') {
            if ((_a = leaf.getViewState().state) === null || _a === void 0 ? void 0 : _a.source) {
                isSourceMode = true;
            }
        }
    });
    return isSourceMode;
}
class IconPosition extends state.RangeValue {
    constructor(text) {
        super();
        this.text = text;
    }
    get iconId() {
        return this.text;
    }
    eq(other) {
        return other instanceof IconPosition && other.text === this.text;
    }
}
/**
 * Builds a position field for the editor state. This field will track the
 * positions of the icons in the document.
 **/
const buildPositionField = (plugin) => {
    /**
     * Checks the ranges of the icons in the document. If the range is not
     * excluded, the range is added to the range set. If the range is excluded,
     * the range is removed from the range set.
     * @param state EditorState to get the ranges from.
     * @param excludeFrom Number to exclude from the ranges.
     * @param excludeTo Number to exclude to the ranges.
     * @param updateRange Function callback to update the range.
     */
    const checkRanges = (state, excludeFrom, excludeTo, updateRange) => {
        const isSourceMode = checkForSourceMode(plugin);
        const text = state.doc.sliceString(0, state.doc.length);
        const identifier = plugin.getSettings().iconIdentifier;
        const regex = new RegExp(`(${identifier})((\\w{1,64}:\\d{17,18})|(\\w{1,64}))(${identifier})`, 'g');
        for (const { 0: rawCode, index: offset } of text.matchAll(regex)) {
            const iconName = rawCode.substring(identifier.length, rawCode.length - identifier.length);
            if (!icon.getIconByName(iconName)) {
                continue;
            }
            const from = offset;
            const to = offset + rawCode.length;
            if (!isNodeInRangeAccepted(state, from, to)) {
                continue;
            }
            if (offset < excludeFrom || offset > excludeTo) {
                updateRange(from, to, new IconPosition(iconName), isSourceMode);
                continue;
            }
            updateRange(from, to, new IconPosition(iconName), true);
        }
        for (const { 0: emojiName, index: offset } of text.matchAll(emoji.getRegex())) {
            if (!emoji.isEmoji(emojiName)) {
                continue;
            }
            const from = offset;
            const to = offset + emojiName.length;
            if (!isNodeInRangeAccepted(state, from, to)) {
                continue;
            }
            if (offset < excludeFrom || offset > excludeTo) {
                updateRange(from, to, new IconPosition(emojiName), isSourceMode);
                continue;
            }
            updateRange(from, to, new IconPosition(emojiName), true);
        }
    };
    const isNodeInRangeAccepted = (state, from, to) => {
        let isRangeAccepted = true;
        language.syntaxTree(state).iterate({
            from,
            to,
            enter: ({ type }) => {
                var _a;
                if (type.name === 'Document') {
                    return;
                }
                const allowedNodeTypes = [
                    'header',
                    'strong',
                    'em',
                    'quote',
                    'link',
                    'list-1',
                    'list-2',
                    'list-3',
                    'highlight',
                    'footref',
                    'comment',
                    'link-alias',
                ];
                const excludedNodeTypes = [
                    'formatting',
                    'hmd-codeblock',
                    'inline-code',
                    'hr',
                ];
                const nodeProps = (_a = type.prop(language.tokenClassNodeProp)) !== null && _a !== void 0 ? _a : '';
                const s = new Set(nodeProps.split(' '));
                if (excludedNodeTypes.some((t) => s.has(t)) &&
                    allowedNodeTypes.every((t) => !s.has(t))) {
                    isRangeAccepted = false;
                }
            },
        });
        return isRangeAccepted;
    };
    return state.StateField.define({
        create: (state$1) => {
            const rangeSet = new state.RangeSetBuilder();
            const changedLines = [];
            checkRanges(state$1, -1, -1, (from, to, iconPosition) => {
                changedLines.push({ from, to, iconPosition });
            });
            changedLines.sort((a, b) => a.from - b.from);
            for (const { from, to, iconPosition } of changedLines) {
                rangeSet.add(from, to, iconPosition);
            }
            return rangeSet.finish();
        },
        update: (rangeSet, transaction) => {
            const newRanges = [];
            if (!transaction.docChanged) {
                if (transaction.selection) {
                    const from = transaction.selection.ranges[0].from;
                    const to = transaction.selection.ranges[0].to;
                    const lineEnd = transaction.state.doc.lineAt(to).length;
                    const lineStart = transaction.state.doc.lineAt(from).from;
                    // Checks the ranges of the icons in the document except for the
                    // excluded line start and end.
                    checkRanges(transaction.state, lineStart, lineStart + lineEnd, (from, to, value, removed) => {
                        rangeSet = rangeSet.update({
                            filterFrom: from,
                            filterTo: to,
                            filter: () => false,
                        });
                        if (!removed) {
                            newRanges.push(value.range(from, to));
                        }
                    });
                }
                else {
                    checkRanges(transaction.state, -1, -1, (from, to, value, removed) => {
                        rangeSet = rangeSet.update({
                            filterFrom: from,
                            filterTo: to,
                            filter: () => false,
                        });
                        if (!removed) {
                            newRanges.push(value.range(from, to));
                        }
                    });
                }
                newRanges.sort((a, b) => a.from - b.from);
                rangeSet = rangeSet.update({ add: newRanges });
                return rangeSet;
            }
            rangeSet = rangeSet.map(transaction.changes);
            const changedLines = [];
            transaction.changes.iterChangedRanges((_f, _t, from, to) => {
                changedLines.push([
                    transaction.state.doc.lineAt(from).number,
                    transaction.state.doc.lineAt(to).number,
                ]);
            });
            for (const [start, end] of changedLines) {
                const from = transaction.state.doc.line(start).from;
                const to = transaction.state.doc.line(end).to;
                rangeSet = rangeSet.update({
                    filterFrom: from,
                    filterTo: to,
                    filter: () => false,
                });
                const lineEnd = transaction.state.doc.line(end).length;
                const lineStart = transaction.state.doc.line(end).from;
                // Checks the ranges of the icons in the document except for the excluded
                // line start and end.
                checkRanges(transaction.state, lineStart, lineStart + lineEnd, (from, to, value, removed) => {
                    if (!removed) {
                        newRanges.push(value.range(from, to));
                    }
                });
            }
            newRanges.sort((a, b) => a.from - b.from);
            rangeSet = rangeSet.update({ add: newRanges });
            return rangeSet;
        },
    });
};

class ChangeColorModal extends obsidian.Modal {
    constructor(app, plugin, path) {
        var _a;
        super(app);
        this.plugin = plugin;
        this.path = path;
        this.usedColor = this.plugin.getIconColor(this.path);
        this.contentEl.style.display = 'block';
        this.modalEl.classList.add('iconize-custom-modal');
        this.titleEl.setText('Change color');
        const description = this.contentEl.createEl('p', {
            text: 'Select a color for this icon',
            cls: 'setting-item-description',
        });
        description.style.marginBottom = 'var(--size-2-2)';
        const colorContainer = this.contentEl.createDiv();
        colorContainer.style.display = 'flex';
        colorContainer.style.alignItems = 'center';
        colorContainer.style.justifyContent = 'space-between';
        const colorPicker = new obsidian.ColorComponent(colorContainer)
            .setValue((_a = this.usedColor) !== null && _a !== void 0 ? _a : '#000000')
            .onChange((value) => {
            this.usedColor = value;
        });
        const defaultColorButton = new obsidian.ButtonComponent(colorContainer);
        defaultColorButton.setTooltip('Set color to the default one');
        defaultColorButton.setButtonText('Reset');
        defaultColorButton.onClick(() => {
            colorPicker.setValue('#000000');
            this.usedColor = undefined;
        });
        // Save button.
        const button = new obsidian.ButtonComponent(this.contentEl);
        button.buttonEl.style.marginTop = 'var(--size-4-4)';
        button.buttonEl.style.float = 'right';
        button.setButtonText('Save Changes');
        button.onClick(() => __awaiter(this, void 0, void 0, function* () {
            var _b;
            new obsidian.Notice('Color of icon changed.');
            if (this.usedColor) {
                this.plugin.addIconColor(this.path, this.usedColor);
            }
            else {
                this.plugin.removeIconColor(this.path);
            }
            // Refresh the DOM.
            const iconNode = dom.getIconNodeFromPath(this.path);
            iconNode.style.color = (_b = this.usedColor) !== null && _b !== void 0 ? _b : null;
            const colorizedInnerHtml = svg.colorize(iconNode.innerHTML, this.usedColor);
            iconNode.innerHTML = colorizedInnerHtml;
            this.close();
        }));
    }
    onOpen() {
        super.onOpen();
    }
    onClose() {
        const { contentEl } = this;
        contentEl.empty();
    }
}

class EventEmitter {
    constructor() {
        this.listeners = {};
    }
    on(type, listener, priority = 0) {
        var _a, _b;
        var _c;
        (_a = (_c = this.listeners)[type]) !== null && _a !== void 0 ? _a : (_c[type] = []);
        (_b = this.listeners[type]) === null || _b === void 0 ? void 0 : _b.push({ listener, once: false, priority });
        this.sortListeners(type);
    }
    once(type, listener, priority = 0) {
        var _a, _b;
        var _c;
        (_a = (_c = this.listeners)[type]) !== null && _a !== void 0 ? _a : (_c[type] = []);
        (_b = this.listeners[type]) === null || _b === void 0 ? void 0 : _b.push({ listener, once: true, priority });
        this.sortListeners(type);
    }
    off(type, listener) {
        var _a;
        if (!this.listeners[type]) {
            return;
        }
        this.listeners[type] = (_a = this.listeners[type]) === null || _a === void 0 ? void 0 : _a.filter((entry) => entry.listener !== listener);
    }
    emit(type, payload) {
        const listeners = this.listeners[type];
        if (!listeners) {
            return;
        }
        const event = { payload };
        listeners.slice().forEach((entry) => {
            entry.listener(event);
            if (entry.once) {
                this.off(type, entry.listener);
            }
        });
    }
    sortListeners(type) {
        var _a;
        if (this.listeners[type]) {
            (_a = this.listeners[type]) === null || _a === void 0 ? void 0 : _a.sort((a, b) => b.priority - a.priority);
        }
    }
}

function getApi(plugin) {
    return {
        getEventEmitter: () => plugin.getEventEmitter(),
        getIconByName: (iconNameWithPrefix) => icon.getIconByName(iconNameWithPrefix),
        setIconForNode: (iconName, node, color) => dom.setIconForNode(plugin, iconName, node, color),
        saveIconToIconPack: (iconNameWithPrefix) => saveIconToIconPack(plugin, iconNameWithPrefix),
        removeIconFromIconPack: (iconNameWithPrefix) => removeIconFromIconPack(plugin, iconNameWithPrefix),
        getIconsFromIconPack: getIconsFromIconPack,
        getAllIconPacks: getAllIconPacks,
        doesElementHasIconNode: dom.doesElementHasIconNode,
        getIconFromElement: dom.getIconFromElement,
        removeIconInNode: dom.removeIconInNode,
        removeIconInPath: dom.removeIconInPath,
        util: {
            dom,
            svg,
        },
        version: {
            get current() {
                return plugin.manifest.version;
            },
        },
    };
}

class IconizePlugin extends obsidian.Plugin {
    constructor() {
        super(...arguments);
        this.registeredFileExplorers = new Set();
        this.modifiedInternalPlugins = [];
        this.positionField = buildPositionField(this);
        this.frontmatterCache = new Set();
        this.eventEmitter = new EventEmitter();
        this.api = getApi(this);
    }
    onload() {
        return __awaiter(this, void 0, void 0, function* () {
            console.log(`loading ${config.PLUGIN_NAME}`);
            // Registers all modified internal plugins.
            // Only adds star plugin for obsidian under v0.12.6.
            if (!obsidian.requireApiVersion('0.12.6')) {
                this.modifiedInternalPlugins.push(new StarredInternalPlugin(this));
            }
            else if (obsidian.requireApiVersion('1.2.0')) {
                this.modifiedInternalPlugins.push(new BookmarkInternalPlugin(this));
            }
            this.modifiedInternalPlugins.push(new OutlineInternalPlugin(this));
            yield this.loadIconFolderData();
            logger.toggleLogging(this.getSettings().debugMode);
            setPath(this.getSettings().iconPacksPath);
            yield createDefaultDirectory(this);
            yield this.checkRecentlyUsedIcons();
            yield migrate(this);
            const usedIconNames = icon.getAllWithPath(this).map((value) => value.icon);
            addNativeLucideIcons();
            yield loadUsedIcons(this, usedIconNames);
            this.app.workspace.onLayoutReady(() => this.handleChangeLayout());
            this.addCommand({
                id: 'iconize:set-icon-for-file',
                name: 'Set icon for file',
                hotkeys: [
                    {
                        modifiers: ['Mod', 'Shift'],
                        key: 'j',
                    },
                ],
                editorCallback: (editor) => __awaiter(this, void 0, void 0, function* () {
                    var _a;
                    const file = (_a = editor.editorComponent) === null || _a === void 0 ? void 0 : _a.file;
                    if (!file) {
                        logger.warn(`'editor.editorComponent?.file' is undefined for file: ${file}`);
                        return;
                    }
                    const modal = new IconsPickerModal(this.app, this, file.path);
                    modal.open();
                    modal.onSelect = (iconName) => {
                        IconCache.getInstance().set(file.path, {
                            iconNameWithPrefix: iconName,
                        });
                        // Update icon in tab when setting is enabled.
                        if (this.getSettings().iconInTabsEnabled) {
                            const tabLeaves = iconTabs.getTabLeavesOfFilePath(this, file.path);
                            for (const tabLeaf of tabLeaves) {
                                iconTabs.update(this, iconName, tabLeaf.tabHeaderInnerIconEl);
                            }
                        }
                        // Update icon in title when setting is enabled.
                        if (this.getSettings().iconInTitleEnabled) {
                            this.addIconInTitle(iconName);
                        }
                    };
                }),
            });
            this.registerEvent(
            // Registering file menu event for listening to file pinning and unpinning.
            this.app.workspace.on('file-menu', (menu, file) => {
                // I've researched other ways of doing this. However, there is no other way to listen to file pinning and unpinning.
                menu.onHide(() => {
                    const path = file.path;
                    if (this.getSettings().iconInTabsEnabled) {
                        for (const openedFile of getAllOpenedFiles(this)) {
                            if (openedFile.path === path) {
                                const possibleIcon = IconCache.getInstance().get(path);
                                if (!possibleIcon) {
                                    return;
                                }
                                const tabLeaves = iconTabs.getTabLeavesOfFilePath(this, file.path);
                                for (const tabLeaf of tabLeaves) {
                                    // Add timeout to ensure that the default icon is already set.
                                    setTimeout(() => {
                                        iconTabs.add(this, file, tabLeaf.tabHeaderInnerIconEl);
                                    }, 5);
                                }
                            }
                        }
                    }
                });
            }));
            this.registerEvent(this.app.workspace.on('layout-change', () => this.handleChangeLayout()));
            this.registerEvent(this.app.workspace.on('file-menu', (menu, file) => {
                const addIconMenuItem = (item) => {
                    item.setTitle('Change icon');
                    item.setIcon('hashtag');
                    item.onClick(() => {
                        const modal = new IconsPickerModal(this.app, this, file.path);
                        modal.open();
                        modal.onSelect = (iconName) => {
                            IconCache.getInstance().set(file.path, {
                                iconNameWithPrefix: iconName,
                            });
                            // Update icon in tab when setting is enabled.
                            if (this.getSettings().iconInTabsEnabled) {
                                const tabLeaves = iconTabs.getTabLeavesOfFilePath(this, file.path);
                                for (const tabLeaf of tabLeaves) {
                                    iconTabs.update(this, iconName, tabLeaf.tabHeaderInnerIconEl);
                                }
                            }
                            // Update icon in title when setting is enabled.
                            if (this.getSettings().iconInTitleEnabled) {
                                this.addIconInTitle(iconName);
                            }
                        };
                    });
                };
                const removeIconMenuItem = (item) => {
                    item.setTitle('Remove icon');
                    item.setIcon('trash');
                    item.onClick(() => __awaiter(this, void 0, void 0, function* () {
                        yield this.removeSingleIcon(file);
                    }));
                };
                const changeColorOfIcon = (item) => {
                    item.setTitle('Change color of icon');
                    item.setIcon('palette');
                    item.onClick(() => {
                        const modal = new ChangeColorModal(this.app, this, file.path);
                        modal.open();
                    });
                };
                menu.addItem(addIconMenuItem);
                const filePathData = this.getData()[file.path];
                const hasNestedIcon = typeof filePathData === 'object' &&
                    filePathData.iconName !== null;
                // Only add remove icon menu item when the file path exists in the data.
                // We do not want to show this menu item for e.g. custom rules.
                if (filePathData &&
                    (typeof filePathData === 'string' || hasNestedIcon)) {
                    const icon = typeof filePathData === 'string'
                        ? filePathData
                        : filePathData.iconName;
                    if (!emoji.isEmoji(icon)) {
                        menu.addItem(changeColorOfIcon);
                    }
                    menu.addItem(removeIconMenuItem);
                }
            }));
            // deleting event
            this.registerEvent(this.app.vault.on('delete', (file) => {
                const path = file.path;
                this.removeFolderIcon(path);
            }));
            // renaming event
            this.registerEvent(this.app.vault.on('rename', (file, oldPath) => {
                // Check if the file was moved and had an icon before.
                const dataPoint = this.data[oldPath];
                if (dataPoint && oldPath !== 'settings') {
                    const iconNameWithPrefix = typeof dataPoint === 'object'
                        ? dataPoint.iconName
                        : dataPoint;
                    dom.createIconNode(this, file.path, iconNameWithPrefix);
                }
                this.renameFolder(file.path, oldPath);
            }));
            if (this.getSettings().iconsInNotesEnabled) {
                this.registerMarkdownPostProcessor((el) => processIconInTextMarkdown(this, el));
                this.registerEditorSuggest(new SuggestionIcon(this.app, this));
                this.registerEditorExtension([
                    this.positionField,
                    buildIconInTextPlugin(this),
                ]);
            }
            if (this.getSettings().iconsInLinksEnabled) {
                this.registerMarkdownPostProcessor((el, ctx) => processIconInLinkMarkdown(this, el, ctx));
                this.registerEditorExtension([
                    this.positionField,
                    buildIconInLinksPlugin(this),
                ]);
            }
            this.addSettingTab(new IconFolderSettings(this.app, this));
        });
    }
    notifyPlugins() {
        this.modifiedInternalPlugins.forEach((internalPlugin) => {
            if (internalPlugin.enabled) {
                internalPlugin.onMount();
            }
        });
    }
    removeSingleIcon(file) {
        return __awaiter(this, void 0, void 0, function* () {
            this.removeFolderIcon(file.path);
            dom.removeIconInPath(file.path);
            IconCache.getInstance().invalidate(file.path);
            this.notifyPlugins();
            let didUpdate = false;
            // Refreshes the icon tab and title icon for custom rules.
            for (const rule of customRule.getSortedRules(this)) {
                const applicable = yield customRule.isApplicable(this, rule, file);
                if (applicable) {
                    customRule.add(this, rule, file);
                    this.addIconInTitle(rule.icon);
                    const tabLeaves = iconTabs.getTabLeavesOfFilePath(this, file.path);
                    for (const tabLeaf of tabLeaves) {
                        iconTabs.add(this, file, tabLeaf.tabHeaderInnerIconEl, {
                            iconName: rule.icon,
                        });
                    }
                    didUpdate = true;
                    break;
                }
            }
            // Only remove icon above titles and icon in tabs if no custom rule was found.
            if (!didUpdate) {
                // Refreshes icons above title and icons in tabs.
                for (const openedFile of getAllOpenedFiles(this)) {
                    if (this.getSettings().iconInTitleEnabled) {
                        titleIcon.remove(openedFile.leaf.view.inlineTitleEl);
                    }
                    if (this.getSettings().iconInTabsEnabled) {
                        const leaf = openedFile.leaf;
                        iconTabs.remove(leaf.tabHeaderInnerIconEl, {
                            replaceWithDefaultIcon: true,
                        });
                    }
                }
            }
        });
    }
    handleChangeLayout() {
        // Transform data that are objects to single strings.
        const data = Object.entries(this.data);
        this.modifiedInternalPlugins.forEach((internalPlugin) => {
            if (internalPlugin.enabled) {
                internalPlugin.onMount();
                internalPlugin.register();
            }
        });
        icon.addAll(this, data, this.registeredFileExplorers, () => {
            // After initialization of the icon packs, checks the vault for missing icons and
            // adds them.
            initIconPacks(this).then(() => __awaiter(this, void 0, void 0, function* () {
                if (this.getSettings().iconsBackgroundCheckEnabled) {
                    const data = Object.entries(this.data);
                    yield icon.checkMissingIcons(this, data);
                    resetPreloadedIcons();
                }
                this.eventEmitter.emit('allIconsLoaded');
            }));
            if (this.getSettings().iconInFrontmatterEnabled) {
                const activeFile = this.app.workspace.getActiveFile();
                if (activeFile) {
                    this.frontmatterCache.add(activeFile.path);
                }
            }
            // Adds the title icon to the active leaf view.
            if (this.getSettings().iconInTitleEnabled) {
                for (const openedFile of getAllOpenedFiles(this)) {
                    const iconName = icon.getByPath(this, openedFile.path);
                    const activeView = openedFile.leaf.view;
                    if (activeView instanceof obsidian.MarkdownView && iconName) {
                        let possibleIcon = iconName;
                        if (!emoji.isEmoji(iconName)) {
                            const iconNextIdentifier = nextIdentifier(iconName);
                            possibleIcon = getSvgFromLoadedIcon(iconName.substring(0, iconNextIdentifier), iconName.substring(iconNextIdentifier));
                        }
                        if (possibleIcon) {
                            titleIcon.add(this, activeView.inlineTitleEl, possibleIcon, {
                                fontSize: calculateInlineTitleSize(),
                            });
                        }
                    }
                }
            }
            // Register rename event for adding icons with custom rules to the DOM
            // when file was moved to another directory.
            this.registerEvent(this.app.vault.on('rename', (file, oldPath) => __awaiter(this, void 0, void 0, function* () {
                const sortedRules = customRule.getSortedRules(this);
                // Removes possible icons from the renamed file.
                sortedRules.forEach((rule) => {
                    if (customRule.doesMatchPath(rule, oldPath)) {
                        dom.removeIconInPath(file.path);
                    }
                });
                // Adds possible icons to the renamed file.
                sortedRules.forEach((rule) => {
                    if (customRule.doesMatchPath(rule, oldPath)) {
                        return;
                    }
                    customRule.add(this, rule, file, undefined);
                });
                // Updates icon tabs for the renamed file.
                for (const rule of customRule.getSortedRules(this)) {
                    const applicable = yield customRule.isApplicable(this, rule, file);
                    if (!applicable) {
                        continue;
                    }
                    const openedFiles = getAllOpenedFiles(this);
                    const openedFile = openedFiles.find((openedFile) => openedFile.path === file.path);
                    if (openedFile) {
                        const leaf = openedFile.leaf;
                        iconTabs.update(this, rule.icon, leaf.tabHeaderInnerIconEl);
                    }
                    break;
                }
            })));
            // Register `layout-change` event for adding icons to tabs when moving a pane or
            // enabling reading mode.
            this.registerEvent(this.app.workspace.on('layout-change', () => {
                var _a, _b;
                if (this.getSettings().iconInTitleEnabled) {
                    const activeView = this.app.workspace.getActiveViewOfType(obsidian.MarkdownView);
                    if (activeView) {
                        const file = activeView.file;
                        const view = activeView.leaf.view.currentMode
                            .view;
                        const iconNameWithPrefix = icon.getByPath(this, file.path);
                        if (!iconNameWithPrefix) {
                            titleIcon.hide(view.inlineTitleEl);
                            return;
                        }
                        let foundIcon = iconNameWithPrefix;
                        if (!emoji.isEmoji(foundIcon)) {
                            foundIcon = (_a = icon.getIconByName(iconNameWithPrefix)) === null || _a === void 0 ? void 0 : _a.svgElement;
                            // Check for preloaded icons if no icon was found when the start up was faster
                            // than the loading of the icons.
                            if (!foundIcon && getPreloadedIcons().length > 0) {
                                foundIcon = (_b = getPreloadedIcons().find((icon) => icon.prefix + icon.name === iconNameWithPrefix)) === null || _b === void 0 ? void 0 : _b.svgElement;
                            }
                        }
                        if (foundIcon) {
                            // Removes the node because the editor markdown content is being rerendered
                            // when the content mode changes back to editing.
                            titleIcon.remove(view.inlineTitleEl);
                            titleIcon.add(this, view.inlineTitleEl, foundIcon, {
                                fontSize: calculateInlineTitleSize(),
                            });
                        }
                    }
                }
                if (!this.getSettings().iconInTabsEnabled) {
                    return;
                }
                for (const openedFile of getAllOpenedFiles(this)) {
                    const leaf = openedFile.leaf;
                    const iconColor = this.getIconColor(leaf.view.file.path);
                    iconTabs.add(this, openedFile, leaf.tabHeaderInnerIconEl, {
                        iconColor,
                    });
                }
            }));
            // Register `file-open` event for adding icon to title.
            this.registerEvent(this.app.workspace.on('file-open', (file) => {
                var _a, _b;
                if (!this.getSettings().iconInTitleEnabled) {
                    return;
                }
                for (const openedFile of getAllOpenedFiles(this)) {
                    if (openedFile.path !== file.path) {
                        continue;
                    }
                    const leaf = openedFile.leaf.view;
                    const iconNameWithPrefix = icon.getByPath(this, file.path);
                    if (!iconNameWithPrefix) {
                        titleIcon.hide(leaf.inlineTitleEl);
                        return;
                    }
                    let foundIcon = iconNameWithPrefix;
                    if (!emoji.isEmoji(foundIcon)) {
                        foundIcon = (_a = icon.getIconByName(iconNameWithPrefix)) === null || _a === void 0 ? void 0 : _a.svgElement;
                        // Check for preloaded icons if no icon was found when the start up was faster
                        // than the loading of the icons.
                        if (!foundIcon && getPreloadedIcons().length > 0) {
                            foundIcon = (_b = getPreloadedIcons().find((icon) => icon.prefix + icon.name === iconNameWithPrefix)) === null || _b === void 0 ? void 0 : _b.svgElement;
                        }
                    }
                    if (foundIcon) {
                        titleIcon.add(this, leaf.inlineTitleEl, foundIcon, {
                            fontSize: calculateInlineTitleSize(),
                        });
                    }
                    else {
                        titleIcon.hide(leaf.inlineTitleEl);
                    }
                }
            }));
            // Register event for frontmatter icon registration.
            this.registerEvent(this.app.metadataCache.on('resolve', (file) => __awaiter(this, void 0, void 0, function* () {
                if (!this.getSettings().iconInFrontmatterEnabled) {
                    return;
                }
                const fileCache = this.app.metadataCache.getFileCache(file);
                const iconFrontmatterName = this.getSettings().iconInFrontmatterFieldName;
                const iconColorFrontmatterName = this.getSettings().iconColorInFrontmatterFieldName;
                if (fileCache === null || fileCache === void 0 ? void 0 : fileCache.frontmatter) {
                    const { [iconFrontmatterName]: newIconName, [iconColorFrontmatterName]: newIconColor, } = fileCache.frontmatter;
                    // If `icon` property is empty, we will remove it from the data and remove the icon.
                    if (!newIconName) {
                        if (this.frontmatterCache.has(file.path)) {
                            yield this.removeSingleIcon(file);
                            this.frontmatterCache.delete(file.path);
                        }
                        return;
                    }
                    if (typeof newIconName !== 'string') {
                        new obsidian.Notice(`[${config.PLUGIN_NAME}] Frontmatter property type \`icon\` has to be of type \`text\`.`);
                        return;
                    }
                    if (newIconColor && typeof newIconColor !== 'string') {
                        new obsidian.Notice(`[${config.PLUGIN_NAME}] Frontmatter property type \`iconColor\` has to be of type \`text\`.`);
                        return;
                    }
                    let iconColor = newIconColor;
                    if (isHexadecimal(iconColor)) {
                        iconColor = stringToHex(iconColor);
                    }
                    const cachedIcon = IconCache.getInstance().get(file.path);
                    if (newIconName === (cachedIcon === null || cachedIcon === void 0 ? void 0 : cachedIcon.iconNameWithPrefix) &&
                        iconColor === (cachedIcon === null || cachedIcon === void 0 ? void 0 : cachedIcon.iconColor)) {
                        return;
                    }
                    this.frontmatterCache.add(file.path);
                    try {
                        if (!emoji.isEmoji(newIconName)) {
                            saveIconToIconPack(this, newIconName);
                        }
                    }
                    catch (e) {
                        logger.warn(`Something went wrong while saving icon to icon pack (error: ${e})`);
                        new obsidian.Notice(e.message);
                        return;
                    }
                    dom.createIconNode(this, file.path, newIconName, {
                        color: iconColor,
                    });
                    this.addFolderIcon(file.path, newIconName);
                    this.addIconColor(file.path, iconColor);
                    IconCache.getInstance().set(file.path, {
                        iconNameWithPrefix: newIconName,
                        iconColor,
                    });
                    // Update icon in tab when setting is enabled.
                    if (this.getSettings().iconInTabsEnabled) {
                        const tabLeaves = iconTabs.getTabLeavesOfFilePath(this, file.path);
                        for (const tabLeaf of tabLeaves) {
                            iconTabs.update(this, newIconName, tabLeaf.tabHeaderInnerIconEl);
                        }
                    }
                    // Update icon in title when setting is enabled.
                    if (this.getSettings().iconInTitleEnabled) {
                        this.addIconInTitle(newIconName);
                    }
                }
            })));
            // Register active leaf change event for adding icon of file to tab.
            this.registerEvent(this.app.workspace.on('active-leaf-change', (leaf) => {
                if (!this.getSettings().iconInTabsEnabled) {
                    return;
                }
                // TODO: Maybe change in the future to a more optimal solution.
                // Fixes a problem when the file was clicked twice in the same tab.
                // See https://github.com/FlorianWoelki/obsidian-iconize/issues/208.
                if (leaf.view.getViewType() === 'file-explorer') {
                    for (const openedFile of getAllOpenedFiles(this)) {
                        const leaf = openedFile.leaf;
                        const iconColor = this.getIconColor(leaf.view.file.path);
                        iconTabs.add(this, openedFile, leaf.tabHeaderInnerIconEl, {
                            iconColor,
                        });
                    }
                    return;
                }
                if (leaf.view.getViewType() !== 'markdown') {
                    return;
                }
                const tabHeaderLeaf = leaf;
                if (tabHeaderLeaf.view.file) {
                    const iconColor = this.getIconColor(tabHeaderLeaf.view.file.path);
                    iconTabs.add(this, tabHeaderLeaf.view.file, tabHeaderLeaf.tabHeaderInnerIconEl, {
                        iconColor,
                    });
                }
            }));
            this.registerEvent(this.app.workspace.on('css-change', () => {
                for (const openedFile of getAllOpenedFiles(this)) {
                    const activeView = openedFile.leaf.view;
                    if (activeView instanceof obsidian.MarkdownView) {
                        titleIcon.updateStyle(activeView.inlineTitleEl, {
                            fontSize: calculateInlineTitleSize(),
                        });
                    }
                }
            }));
        });
    }
    addIconInTitle(iconName) {
        var _a;
        for (const openedFile of getAllOpenedFiles(this)) {
            const activeView = openedFile.leaf.view;
            if (activeView instanceof obsidian.MarkdownView) {
                let possibleIcon = iconName;
                if (!emoji.isEmoji(iconName)) {
                    possibleIcon = (_a = icon.getIconByName(iconName)) === null || _a === void 0 ? void 0 : _a.svgElement;
                }
                if (possibleIcon) {
                    titleIcon.add(this, activeView.inlineTitleEl, possibleIcon, {
                        fontSize: calculateInlineTitleSize(),
                    });
                }
            }
        }
    }
    onunload() {
        console.log('unloading obsidian-icon-folder');
    }
    renameFolder(newPath, oldPath) {
        if (!this.data[oldPath] || newPath === oldPath) {
            return;
        }
        Object.defineProperty(this.data, newPath, Object.getOwnPropertyDescriptor(this.data, oldPath));
        delete this.data[oldPath];
        this.saveIconFolderData();
    }
    addIconColor(path, iconColor) {
        const pathData = this.getData()[path];
        if (typeof pathData === 'string') {
            this.getData()[path] = {
                iconName: pathData,
                iconColor,
            };
        }
        else {
            pathData.iconColor = iconColor;
        }
        this.saveIconFolderData();
    }
    getIconColor(path) {
        const pathData = this.getData()[path];
        if (!pathData) {
            return undefined;
        }
        if (typeof pathData === 'string') {
            return undefined;
        }
        return pathData.iconColor;
    }
    removeIconColor(path) {
        const pathData = this.getData()[path];
        if (typeof pathData === 'string') {
            return;
        }
        const currentValue = pathData;
        this.getData()[path] = currentValue.iconName;
        this.saveIconFolderData();
    }
    removeFolderIcon(path) {
        if (!this.data[path]) {
            return;
        }
        // Saves the icon name with prefix to remove it from the icon pack directory later.
        const iconData = this.data[path];
        delete this.data[path];
        // Removes the icon from the icon pack directory if it is not used as an icon somewhere
        // else.
        if (iconData) {
            let iconNameWithPrefix = iconData;
            if (typeof iconData === 'object') {
                iconNameWithPrefix = iconData.iconName;
            }
            else {
                iconNameWithPrefix = iconData;
            }
            if (!emoji.isEmoji(iconNameWithPrefix)) {
                removeIconFromIconPack(this, iconNameWithPrefix);
            }
        }
        //this.addIconsToSearch();
        this.saveIconFolderData();
    }
    addFolderIcon(path, icon) {
        const iconName = getNormalizedName(typeof icon === 'object' ? icon.displayName : icon);
        this.data[path] = iconName;
        // Update recently used icons.
        if (!this.getSettings().recentlyUsedIcons.includes(iconName)) {
            if (this.getSettings().recentlyUsedIcons.length >=
                this.getSettings().recentlyUsedIconsSize) {
                this.getSettings().recentlyUsedIcons =
                    this.getSettings().recentlyUsedIcons.slice(0, this.getSettings().recentlyUsedIconsSize - 1);
            }
            this.getSettings().recentlyUsedIcons.unshift(iconName);
            this.checkRecentlyUsedIcons();
        }
        //this.addIconsToSearch();
        this.saveIconFolderData();
    }
    getSettings() {
        return this.data.settings;
    }
    loadIconFolderData() {
        return __awaiter(this, void 0, void 0, function* () {
            const data = yield this.loadData();
            if (data) {
                Object.entries(DEFAULT_SETTINGS).forEach(([k, v]) => {
                    if (data.settings[k] === undefined) {
                        data.settings[k] = v;
                    }
                });
            }
            this.data = Object.assign({ settings: Object.assign({}, DEFAULT_SETTINGS) }, {}, data);
        });
    }
    saveIconFolderData() {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.saveData(this.data);
        });
    }
    checkRecentlyUsedIcons() {
        return __awaiter(this, void 0, void 0, function* () {
            if (this.getSettings().recentlyUsedIcons.length >
                this.getSettings().recentlyUsedIconsSize) {
                this.getSettings().recentlyUsedIcons =
                    this.getSettings().recentlyUsedIcons.slice(0, this.getSettings().recentlyUsedIconsSize);
                yield this.saveIconFolderData();
            }
        });
    }
    getEventEmitter() {
        return this.eventEmitter;
    }
    getData() {
        return this.data;
    }
    getIconNameFromPath(path) {
        if (typeof this.getData()[path] === 'object') {
            return this.getData()[path].iconName;
        }
        return this.getData()[path];
    }
    getRegisteredFileExplorers() {
        return this.registeredFileExplorers;
    }
    /**
     * Returns a possible data path by the given value. This function checks for
     * direct icon and custom rules.
     * @param value String that will be used to find the data path.
     * @returns String that is the data path or `undefined` if no data path was found.
     */
    getDataPathByValue(value) {
        return Object.entries(this.data).find(([k, v]) => {
            if (typeof v === 'string') {
                if (value === v) {
                    return k;
                }
            }
            else if (typeof v === 'object') {
                // Check for custom rules.
                if (k === 'settings') {
                    // `rules` are defined in the settings object.
                    const rules = v.rules;
                    return rules.find((rule) => rule.icon === value);
                }
                v = v;
                if (value === v.iconName) {
                    return k;
                }
            }
        });
    }
}

module.exports = IconizePlugin;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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
